/*
 * Decompiled with CFR 0.152.
 */
package scorer;

import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.mysql.DatabaseManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import jiffiloop.PdbFileAnalyzer;
import jiffiloop.ProteinGap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scorer {
    static final DecimalFormat df = new DecimalFormat("0.000");
    PdbFileAnalyzer analyzer;
    DatabaseManager dm;

    public static void main(String[] stringArray) {
        ArrayList arrayList = Scorer.parseArgs(stringArray);
        if (arrayList.size() < 1) {
            System.out.println("Not enough arguments: you must have an input pdb!");
        } else {
            File file = new File((String)arrayList.get(0));
            if (file.isDirectory()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    if (!file2.isFile()) continue;
                    Scorer scorer = new Scorer(new File(file2.getAbsolutePath()));
                }
            } else {
                Scorer scorer = new Scorer(new File(file.getAbsolutePath()));
            }
        }
    }

    public static ArrayList parseArgs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) {
                if (string.equals("-h") || string.equals("-help")) {
                    System.err.println("Help not available. Sorry!");
                    System.exit(0);
                    continue;
                }
                System.err.println("*** Unrecognized option: " + string);
                continue;
            }
            if (string.matches("[0-9]*-[0-9]*")) continue;
            System.out.println(string);
            arrayList.add(string);
        }
        return arrayList;
    }

    public Scorer(File file) {
        long l = System.currentTimeMillis();
        String string = file.getName();
        this.analyzer = new PdbFileAnalyzer(file);
        this.createAllGaps(5);
        Map<String, ArrayList<ProteinGap>> map = this.analyzer.getGaps();
        this.dm = new DatabaseManager();
        this.dm.connectToDatabase("//quality.biochem.duke.edu/vbc3");
        for (String string2 : map.keySet()) {
            ArrayList<ProteinGap> arrayList = map.get(string2);
            System.out.print(string + "," + string2 + "," + arrayList.size());
            int n = this.countDb(arrayList);
            System.out.println("," + n);
        }
        this.dm.close();
        System.err.println("Scorer took " + (System.currentTimeMillis() - l) / 1000L + " seconds");
    }

    public void createAllGaps(int n) {
        CoordinateFile coordinateFile = this.analyzer.getCoordFile();
        for (Model model : coordinateFile.getModels()) {
            Set set = model.getChainIDs();
            for (String string : set) {
                Set set2 = model.getChain(string);
                for (Residue residue : set2) {
                    int n2 = residue.getSequenceInteger();
                    this.analyzer.simulateGap(n2, n + n2, false);
                }
            }
        }
    }

    public int countDb(Collection<ProteinGap> collection) {
        long l = 0L;
        String string = "none?";
        int n = 0;
        int n2 = 1;
        for (ProteinGap proteinGap : collection) {
            long l2 = System.currentTimeMillis();
            ArrayList<Double> arrayList = proteinGap.getParameters();
            int n3 = proteinGap.getSize();
            int n4 = proteinGap.getOneNum();
            while (n2 < n4) {
                System.out.print(",");
                ++n2;
            }
            String string2 = "SELECT count(*) FROM parameters5200frag_length_5 ";
            double d = arrayList.get(0);
            string2 = string2.concat("WHERE (distance BETWEEN " + df.format(arrayList.get(0) - 1.0) + " AND " + df.format(arrayList.get(0) + 1.0));
            string2 = string2.concat(") \n");
            double d2 = arrayList.get(1);
            string2 = string2.concat(this.createWhereQuery(d2, "start_angle") + " \n");
            double d3 = arrayList.get(2);
            string2 = string2.concat(this.createWhereQuery(d3, "end_angle") + " \n");
            double d4 = arrayList.get(3);
            string2 = string2.concat(this.createWhereQuery(d4, "start_dihedral") + " \n");
            double d5 = arrayList.get(4);
            string2 = string2.concat(this.createWhereQuery(d5, "middle_dihedral") + " \n");
            double d6 = arrayList.get(5);
            string2 = string2.concat(this.createWhereQuery(d6, "end_dihedral") + " \n");
            string2 = string2.concat("AND max_B_factor <= 35;");
            System.err.print(".");
            this.dm.select(string2);
            while (this.dm.next()) {
                String string3 = this.dm.getString(1);
                n += Integer.parseInt(string3);
                System.out.print("," + string3);
                ++n2;
            }
            long l3 = System.currentTimeMillis() - l2;
            if (l3 < l) continue;
            l = l3;
            string = string2;
        }
        System.err.println();
        System.err.println("Longest Time was " + l + " milliseconds");
        System.err.println(string);
        return n;
    }

    public String createWhereQuery(double d, String string) {
        if (d > 155.0) {
            return "AND (" + string + " >= " + Double.toString(d - 25.0) + " OR " + string + " <= " + Double.toString(-335.0 + d) + ")";
        }
        if (d < -155.0) {
            return "AND (" + string + " <= " + Double.toString(d + 25.0) + " OR " + string + " >= " + Double.toString(d + 360.0 - 25.0) + ")";
        }
        return "AND (" + string + " BETWEEN " + Double.toString(d - 25.0) + " AND " + Double.toString(d + 25.0) + ")";
    }

    public String createOldWhereQuery(double d, String string) {
        if (d > 155.0) {
            return "AND (" + string + " >= " + Double.toString(d - 25.0) + " OR " + string + " <= " + Double.toString(-335.0 + d) + ")";
        }
        if (d < -155.0) {
            return "AND (" + string + " <= " + Double.toString(d + 25.0) + " OR " + string + " >= " + Double.toString(d + 360.0 - 25.0) + ")";
        }
        return "AND (" + string + " <= " + Double.toString(d + 25.0) + " AND " + string + " >= " + Double.toString(d - 25.0) + ")";
    }

    public CoordinateFile readFile(File file) {
        try {
            InputStream inputStream = new FileInputStream(file);
            inputStream = new BufferedInputStream(inputStream);
            inputStream.mark(10);
            if (inputStream.read() == 31 && inputStream.read() == 139) {
                inputStream.reset();
                inputStream = new GZIPInputStream(inputStream);
            } else {
                inputStream.reset();
            }
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
            PdbReader pdbReader = new PdbReader();
            pdbReader.setUseSegID(false);
            CoordinateFile coordinateFile = pdbReader.read(lineNumberReader);
            System.out.println(coordinateFile.getIdCode() + " has been read");
            lineNumberReader.close();
            return coordinateFile;
        }
        catch (IOException iOException) {
            System.err.println("IO Exception thrown " + iOException.getMessage());
            return null;
        }
    }
}

