/*
 * Decompiled with CFR 0.152.
 */
package hless;

import hless.Atom;
import hless.Model;
import hless.Triple;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class Residue {
    public String name = "         ";
    public Residue next = null;
    public Residue prev = null;
    public float phi = Float.NaN;
    public float psi = Float.NaN;
    public float chi1 = Float.NaN;
    public float chi2 = Float.NaN;
    public float chi3 = Float.NaN;
    public float chi4 = Float.NaN;
    public float cbDistance = Float.NaN;
    public float cbDirection = 0.0f;
    Model parent;
    LinkedHashMap atomMap;

    public Residue(Model model) {
        this.parent = model;
        this.atomMap = new LinkedHashMap(23);
    }

    public Residue(Model model, String string) {
        this.parent = model;
        this.atomMap = new LinkedHashMap(23);
        this.name = string;
    }

    public Atom getAtom(String string) {
        if (this.atomMap.containsKey(string)) {
            return (Atom)this.atomMap.get(string);
        }
        Atom atom = new Atom(this, string);
        this.atomMap.put(atom.name, atom);
        return atom;
    }

    public Atom findAtom(String string) {
        return (Atom)this.atomMap.get(string);
    }

    public double[] getPhiPsi() {
        if (this.next == null || this.prev == null) {
            return null;
        }
        Atom atom = this.prev.findAtom(" C  ");
        Atom atom2 = this.findAtom(" N  ");
        Atom atom3 = this.findAtom(" CA ");
        Atom atom4 = this.findAtom(" C  ");
        Atom atom5 = this.next.findAtom(" N  ");
        if (atom == null || atom2 == null || atom3 == null || atom4 == null || atom5 == null) {
            return null;
        }
        if (atom2.distance(atom) > 2.0 || atom4.distance(atom5) > 2.0) {
            return null;
        }
        double[] dArray = new double[]{Triple.dihedral(atom, atom2, atom3, atom4), Triple.dihedral(atom2, atom3, atom4, atom5)};
        return dArray;
    }

    public boolean isPrepro() {
        if (this.next == null) {
            return false;
        }
        if (this.next.name.endsWith("PRO")) {
            Atom atom = this.findAtom(" C  ");
            Atom atom2 = this.next.findAtom(" N  ");
            return atom2 != null && atom != null && atom.distance(atom2) < 2.0;
        }
        return false;
    }

    public void rotateSC(Atom atom, Atom atom2, double d) {
    }

    public Iterator atomIterator() {
        return this.atomMap.values().iterator();
    }
}

