/*
 * Decompiled with CFR 0.152.
 */
package hless;

import boundrotamers.NDFloatTable;
import hless.Atom;
import hless.Model;
import hless.PdbReader;
import hless.Props;
import hless.Residue;
import hless.Str;
import hless.Triple;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Rotamer {
    DecimalFormat df1 = new DecimalFormat("0.0");
    static final Object MODE_RAW = new Object();
    static final Object MODE_TEXT = new Object();
    static final Object MODE_HTML = new Object();
    static final Object MODE_PREKIN = new Object();
    Props geometry = null;
    HashMap tables = null;
    String cmdFilename = "-";
    int cmdLimit = 10;
    double cmdCutoff = 2.0;
    Object cmdMode = MODE_TEXT;
    String toScore = null;
    private static LineNumberReader SYSTEM_IN_READER = null;
    private static PrintWriter SYSTEM_OUT_WRITER = null;

    public void loadTablesFromJar() {
        try {
            this.tables = new HashMap(30);
            this.tables.put("ser", this.loadTable("/rc/rota/ser.ndft"));
            this.tables.put("thr", this.loadTable("/rc/rota/thr.ndft"));
            this.tables.put("cys", this.loadTable("/rc/rota/cys.ndft"));
            this.tables.put("val", this.loadTable("/rc/rota/val.ndft"));
            this.tables.put("pro", this.loadTable("/rc/rota/pro.ndft"));
            this.tables.put("leu", this.loadTable("/rc/rota/leu.ndft"));
            this.tables.put("ile", this.loadTable("/rc/rota/ile.ndft"));
            this.tables.put("trp", this.loadTable("/rc/rota/trp.ndft"));
            this.tables.put("asp", this.loadTable("/rc/rota/asp.ndft"));
            this.tables.put("asn", this.loadTable("/rc/rota/asn.ndft"));
            this.tables.put("his", this.loadTable("/rc/rota/his.ndft"));
            NDFloatTable nDFloatTable = this.loadTable("/rc/rota/phetyr.ndft");
            this.tables.put("phe", nDFloatTable);
            this.tables.put("tyr", nDFloatTable);
            nDFloatTable = this.loadTable("/rc/rota/met.ndft");
            this.tables.put("met", nDFloatTable);
            this.tables.put("mse", nDFloatTable);
            this.tables.put("glu", this.loadTable("/rc/rota/glu.ndft"));
            this.tables.put("gln", this.loadTable("/rc/rota/gln.ndft"));
            this.tables.put("lys", this.loadTable("/rc/rota/lys.ndft"));
            this.tables.put("arg", this.loadTable("/rc/rota/arg.ndft"));
        }
        catch (IOException iOException) {
            System.err.println("*** Rotamer: couldn't load some NDFTs from JAR file");
            this.tables = null;
        }
    }

    private NDFloatTable loadTable(String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Missing resource");
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        return new NDFloatTable(dataInputStream);
    }

    public void loadGeometry(Props props) {
        this.geometry = props;
    }

    public void loadGeometryFromJar() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/rc/rota/sidechain-chi.props");
            if (inputStream != null) {
                Props props = new Props();
                props.load(inputStream);
                this.loadGeometry(props);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("*** Rotamer: couldn't find sidechain chi defs in JAR file");
        }
    }

    public float[] getChis(Residue residue) {
        int n;
        if (this.geometry == null) {
            throw new RuntimeException("Geometry must be specified before evaluating residues");
        }
        String string = this.geometry.getString(residue.name.substring(6, 9).toLowerCase() + ".chi", null);
        if (string == null) {
            return null;
        }
        float[] fArray = new float[string.length() / 4 - 3];
        Atom[] atomArray = new Atom[fArray.length + 3];
        for (n = 0; n < atomArray.length; ++n) {
            atomArray[n] = residue.findAtom(string.substring(n * 4, (n + 1) * 4));
            if (atomArray[n] != null) continue;
            return null;
        }
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = (float)Triple.dihedral(atomArray[n], atomArray[n + 1], atomArray[n + 2], atomArray[n + 3]);
        }
        return fArray;
    }

    public double evaluate(Residue residue) {
        String string = residue.name.substring(6, 9).toLowerCase();
        if (this.tables == null) {
            throw new RuntimeException("Tables must be loaded before evaluating residues");
        }
        if (!this.tables.containsKey(string)) {
            return 2.0;
        }
        NDFloatTable nDFloatTable = (NDFloatTable)this.tables.get(string);
        float[] fArray = this.getChis(residue);
        if (fArray == null) {
            return 2.0;
        }
        return nDFloatTable.valueAt(fArray);
    }

    public double evalString(String string) {
        String string2;
        int n = 0;
        float[] fArray = new float[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,;:");
        try {
            string2 = stringTokenizer.nextToken().toLowerCase();
            do {
                fArray[n++] = Float.parseFloat(stringTokenizer.nextToken());
            } while (stringTokenizer.hasMoreTokens() && n < 4);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("score: not enough tokens");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("score: misformatted number");
        }
        NDFloatTable nDFloatTable = null;
        String string3 = string2.equals("phe") || string2.equals("tyr") ? "/rc/rota/phetyr.ndft" : "/rc/rota/" + string2 + ".ndft";
        try {
            nDFloatTable = this.loadTable(string3);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("score: table for res '" + string2 + "' not found");
        }
        if (n < nDFloatTable.getDimensions()) {
            throw new IllegalArgumentException("score: not enough tokens");
        }
        return nDFloatTable.valueAt(fArray);
    }

    public void textRaw(Model model, OutputStream outputStream) {
        this.textRaw(model, new OutputStreamWriter(outputStream));
    }

    public void textRaw(Model model, Writer writer) {
        boolean bl = false;
        ArrayList arrayList = new ArrayList(101);
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("#residue:score%:chi1:chi2:chi3:chi4");
        Iterator iterator = model.residueIterator();
        while (iterator.hasNext()) {
            Residue residue = (Residue)iterator.next();
            double d = this.evaluate(residue);
            if (!(d <= 1.0)) continue;
            printWriter.println(residue.name + ":" + this.df1.format(d * 100.0) + this.printChisRaw(residue));
        }
        printWriter.flush();
    }

    String printChisRaw(Residue residue) {
        float[] fArray = this.getChis(residue);
        if (fArray == null) {
            return "::::";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(":");
            if (i >= fArray.length) continue;
            stringBuffer.append(this.df1.format(fArray[i]));
        }
        return stringBuffer.toString();
    }

    public void textTopN(Model model, OutputStream outputStream, int n, double d) {
        this.textTopN(model, new OutputStreamWriter(outputStream), n, d);
    }

    public void textTopN(Model model, Writer writer, int n, double d) {
        int n2 = 0;
        ArrayList<Score> arrayList = new ArrayList<Score>(101);
        Object object = model.residueIterator();
        while (object.hasNext()) {
            Residue residue = (Residue)object.next();
            double d2 = this.evaluate(residue);
            if (d2 <= 1.0) {
                ++n2;
            }
            if (!(d2 < d)) continue;
            arrayList.add(new Score(residue, d2));
        }
        Collections.sort(arrayList, new SortScoreByNumericValue());
        object = new PrintWriter(writer);
        ((PrintWriter)object).println();
        ((PrintWriter)object).println("  WORST       % worse than this");
        ((PrintWriter)object).println("OFFENDERS    in high-quality data\t  x1  \t  x2  \t  x3  \t  x4  ");
        ((PrintWriter)object).println("=========    ====================\t======\t======\t======\t======");
        Iterator iterator = arrayList.iterator();
        for (int i = 0; iterator.hasNext() && i < n; ++i) {
            Score score = (Score)iterator.next();
            ((PrintWriter)object).println(score.r.name + "    " + this.df1.format(score.score * 100.0) + "                 \t" + this.printChis(score.r));
        }
        ((PrintWriter)object).println();
        ((PrintWriter)object).println(arrayList.size() + " of " + n2 + " rotamers (" + this.df1.format(100.0 * (double)arrayList.size() / (double)n2) + "%) were < " + this.df1.format(d * 100.0) + "%");
        ((PrintWriter)object).println();
        ((PrintWriter)object).flush();
    }

    String printChis(Residue residue) {
        float[] fArray = this.getChis(residue);
        if (fArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < fArray.length; ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\t");
            }
            stringBuffer.append(Str.padRight(this.df1.format(fArray[i]), 6));
        }
        return stringBuffer.toString();
    }

    public void htmlTopN(Model model, OutputStream outputStream, int n, double d) {
        this.htmlTopN(model, new OutputStreamWriter(outputStream), n, d);
    }

    public void htmlTopN(Model model, Writer writer, int n, double d) {
        int n2 = 0;
        ArrayList<Score> arrayList = new ArrayList<Score>(101);
        Object object = model.residueIterator();
        while (object.hasNext()) {
            Residue residue = (Residue)object.next();
            double d2 = this.evaluate(residue);
            if (d2 <= 1.0) {
                ++n2;
            }
            if (!(d2 < d)) continue;
            arrayList.add(new Score(residue, d2));
        }
        Collections.sort(arrayList, new SortScoreByNumericValue());
        object = new PrintWriter(writer);
        ((PrintWriter)object).println("<table border=0 cellspacing=5 cellpadding=2>");
        ((PrintWriter)object).println("<tr align=center bgcolor=#999999>");
        ((PrintWriter)object).println("<td><b>Worst<br>Offenders</b></td>");
        ((PrintWriter)object).println("<td><b>% worse than this<br>in high-quality data</b></td>");
        ((PrintWriter)object).println("<td><b>x1</b></td>");
        ((PrintWriter)object).println("<td><b>x2</b></td>");
        ((PrintWriter)object).println("<td><b>x3</b></td>");
        ((PrintWriter)object).println("<td><b>x4</b></td>");
        ((PrintWriter)object).println("</tr>");
        Iterator iterator = arrayList.iterator();
        for (int i = 0; iterator.hasNext() && i < n; ++i) {
            Score score = (Score)iterator.next();
            ((PrintWriter)object).println("<tr align=right>");
            ((PrintWriter)object).println("<td>" + score.r.name + "</td>");
            ((PrintWriter)object).println("<td align=center>" + this.df1.format(score.score * 100.0) + "</td>");
            ((PrintWriter)object).println(this.printChisHTML(score.r));
            ((PrintWriter)object).println("</tr>");
        }
        ((PrintWriter)object).println("<tr align=center bgcolor=#999999>");
        ((PrintWriter)object).println("<td colspan=6><b>" + arrayList.size() + " of " + n2 + " rotamers (" + this.df1.format(100.0 * (double)arrayList.size() / (double)n2) + "%) were < " + this.df1.format(d * 100.0) + "%</b></td>");
        ((PrintWriter)object).println("</tr>");
        ((PrintWriter)object).println("</table>");
        ((PrintWriter)object).flush();
    }

    String printChisHTML(Residue residue) {
        float[] fArray = this.getChis(residue);
        if (fArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fArray.length; ++i) {
            stringBuffer.append("<td>" + this.df1.format(fArray[i]) + "</td>");
        }
        return stringBuffer.toString();
    }

    public void prekinTopN(Model model, OutputStream outputStream, int n, double d) {
        this.prekinTopN(model, new OutputStreamWriter(outputStream), n, d);
    }

    public void prekinTopN(Model model, Writer writer, int n, double d) {
        int n2 = 0;
        List<Score> list = new ArrayList(101);
        Iterator iterator = model.residueIterator();
        while (iterator.hasNext()) {
            Residue residue = (Residue)iterator.next();
            double d2 = this.evaluate(residue);
            if (d2 <= 1.0) {
                ++n2;
            }
            if (!(d2 < d)) continue;
            list.add(new Score(residue, d2));
        }
        Collections.sort(list, new SortScoreByNumericValue());
        if (n < list.size()) {
            list = list.subList(0, n);
        }
        Collections.sort(list, new SortScoreByResidueName());
        PrintWriter printWriter = new PrintWriter(writer);
        boolean bl = true;
        boolean bl2 = true;
        char c = '\u0000';
        iterator = list.iterator();
        while (iterator.hasNext()) {
            Score score = (Score)iterator.next();
            if (score.r.name.charAt(0) != c) {
                if (bl) {
                    bl = false;
                } else {
                    printWriter.println("\"");
                }
                c = score.r.name.charAt(0);
                if (c == ' ') {
                    printWriter.print("-chainid _ -range \"");
                } else {
                    printWriter.print("-chainid " + c + " -range \"");
                }
                bl2 = true;
            }
            if (bl2) {
                bl2 = false;
            } else {
                printWriter.print(",");
            }
            printWriter.print(score.r.name.substring(1, 6).trim() + "-" + score.r.name.substring(1, 6).trim());
        }
        if (!bl) {
            printWriter.println("\"");
        }
        printWriter.flush();
    }

    public void Main() {
        this.loadGeometryFromJar();
        if (this.toScore != null) {
            DecimalFormat decimalFormat = new DecimalFormat("0.#####");
            double d = this.evalString(this.toScore);
            System.out.println(decimalFormat.format(d));
        } else {
            this.loadTablesFromJar();
            Model model = new Model();
            PdbReader pdbReader = new PdbReader(model);
            try {
                pdbReader.read(this.getReader(this.cmdFilename));
            }
            catch (IOException iOException) {
                System.err.println("*** Couldn't read in PDB file. (I/O)");
                System.exit(1);
            }
            if (this.cmdMode == MODE_RAW) {
                this.textRaw(model, System.out);
            } else if (this.cmdMode == MODE_TEXT) {
                this.textTopN(model, System.out, this.cmdLimit, this.cmdCutoff / 100.0);
            } else if (this.cmdMode == MODE_HTML) {
                this.htmlTopN(model, System.out, this.cmdLimit, this.cmdCutoff / 100.0);
            } else if (this.cmdMode == MODE_PREKIN) {
                this.prekinTopN(model, System.out, this.cmdLimit, this.cmdCutoff / 100.0);
            } else {
                System.err.println("*** Unrecognized mode.");
            }
        }
    }

    public static void main(String[] stringArray) {
        Rotamer rotamer = new Rotamer();
        try {
            rotamer.parseArguments(stringArray);
            rotamer.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            rotamer.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--")) {
                bl = false;
                linkedList.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("-") && bl) {
                int n = stringArray[i].indexOf(61);
                if (n != -1) {
                    linkedList.add(stringArray[i].substring(0, n));
                    linkedList.add(stringArray[i].substring(n + 1));
                    continue;
                }
                linkedList.add(stringArray[i]);
                continue;
            }
            linkedList.add(stringArray[i]);
        }
        ListIterator listIterator = linkedList.listIterator();
        try {
            this.interpretArguments(listIterator);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("'" + listIterator.previous() + "' expected an argument");
        }
    }

    int getInt(Iterator iterator) {
        String string = iterator.next().toString();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'" + string + "' is not an integer");
        }
    }

    double getDouble(Iterator iterator) {
        String string = iterator.next().toString();
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'" + string + "' is not a real number");
        }
    }

    LineNumberReader getReader(String string) {
        LineNumberReader lineNumberReader = null;
        if (string.equals("-")) {
            if (SYSTEM_IN_READER == null) {
                SYSTEM_IN_READER = new LineNumberReader(new InputStreamReader(System.in));
            }
            lineNumberReader = SYSTEM_IN_READER;
        } else {
            try {
                lineNumberReader = new LineNumberReader(new FileReader(string));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("'" + string + "' is not a readable file or stream.");
            }
        }
        return lineNumberReader;
    }

    PrintWriter getWriter(String string) {
        PrintWriter printWriter = null;
        if (string.equals("-")) {
            if (SYSTEM_OUT_WRITER == null) {
                SYSTEM_OUT_WRITER = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
            }
            printWriter = SYSTEM_OUT_WRITER;
        } else {
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("'" + string + "' is not a writable file or stream.");
            }
        }
        return printWriter;
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("/rc/Rotamer.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in '/rc/Rotamer.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("hless.Rotamer, version 0.47 (build 0_0)");
        System.err.println("Copyright (C) 2002-2003 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArguments(Iterator iterator) {
        boolean bl = true;
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (!string.startsWith("-") || !bl || string.equals("-")) {
                if (!this.cmdFilename.equals("-")) continue;
                this.cmdFilename = string;
                continue;
            }
            if (string.equals("--")) {
                bl = false;
                continue;
            }
            if (string.equals("-help") || string.equals("-h")) {
                this.showHelp(true);
                System.exit(0);
                continue;
            }
            if (string.equals("-raw")) {
                this.cmdMode = MODE_RAW;
                continue;
            }
            if (string.equals("-html")) {
                this.cmdMode = MODE_HTML;
                continue;
            }
            if (string.equals("-limit")) {
                this.cmdLimit = this.getInt(iterator);
                continue;
            }
            if (string.equals("-cutoff")) {
                this.cmdCutoff = this.getDouble(iterator);
                continue;
            }
            if (string.equals("-prekin")) {
                this.cmdMode = MODE_PREKIN;
                continue;
            }
            if (string.equals("-score")) {
                this.toScore = iterator.next().toString();
                continue;
            }
            if (string.equals("-dummy_option")) continue;
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid argument.");
        }
    }

    class SortScoreByResidueName
    implements Comparator {
        SortScoreByResidueName() {
        }

        public int compare(Object object, Object object2) {
            Score score = (Score)object;
            Score score2 = (Score)object2;
            return score.r.name.compareTo(score2.r.name);
        }
    }

    class SortScoreByNumericValue
    implements Comparator {
        SortScoreByNumericValue() {
        }

        public int compare(Object object, Object object2) {
            Score score = (Score)object;
            Score score2 = (Score)object2;
            if (score.score < score2.score) {
                return -1;
            }
            if (score.score > score2.score) {
                return 1;
            }
            return 0;
        }
    }

    class Score {
        Residue r;
        double score;

        public Score(Residue residue, double d) {
            this.r = residue;
            this.score = d;
        }
    }
}

