/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.actions;

import java.util.Optional;
import org.asamk.signal.manager.actions.HandleAction;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.signal.libsignal.metadata.ProtocolException;
import org.signal.libsignal.metadata.protocol.UnidentifiedSenderMessageContent;
import org.signal.libsignal.protocol.message.DecryptionErrorMessage;
import org.whispersystems.signalservice.api.messages.SignalServiceEnvelope;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.internal.push.Envelope;

public class SendRetryMessageRequestAction
implements HandleAction {
    private final RecipientId recipientId;
    private final ServiceId serviceId;
    private final ProtocolException protocolException;
    private final SignalServiceEnvelope envelope;
    private final ServiceId accountId;

    public SendRetryMessageRequestAction(RecipientId recipientId, ServiceId serviceId, ProtocolException protocolException, SignalServiceEnvelope envelope, ServiceId accountId) {
        this.recipientId = recipientId;
        this.serviceId = serviceId;
        this.protocolException = protocolException;
        this.envelope = envelope;
        this.accountId = accountId;
    }

    @Override
    public void execute(Context context) throws Throwable {
        int envelopeType;
        byte[] originalContent;
        Optional<GroupId> groupId;
        context.getAccount().getAccountData(this.accountId).getSessionStore().archiveSessions(this.serviceId);
        int senderDevice = this.protocolException.getSenderDevice();
        Optional<GroupId> optional = groupId = this.protocolException.getGroupId().isPresent() ? Optional.of(GroupId.unknownVersion((byte[])this.protocolException.getGroupId().get())) : Optional.empty();
        if (this.protocolException.getUnidentifiedSenderMessageContent().isPresent()) {
            UnidentifiedSenderMessageContent messageContent = (UnidentifiedSenderMessageContent)this.protocolException.getUnidentifiedSenderMessageContent().get();
            originalContent = messageContent.getContent();
            envelopeType = messageContent.getType();
        } else {
            originalContent = this.envelope.getContent();
            envelopeType = this.envelope.getType() == null ? 2 : SendRetryMessageRequestAction.envelopeTypeToCiphertextMessageType(this.envelope.getType());
        }
        DecryptionErrorMessage decryptionErrorMessage = DecryptionErrorMessage.forOriginalMessage((byte[])originalContent, (int)envelopeType, (long)this.envelope.getTimestamp(), (int)senderDevice);
        context.getSendHelper().sendRetryReceipt(decryptionErrorMessage, this.recipientId, groupId);
    }

    private static int envelopeTypeToCiphertextMessageType(int envelopeType) {
        Envelope.Type type = Envelope.Type.fromValue((int)envelopeType);
        if (type == null) {
            return 2;
        }
        return switch (type) {
            case Envelope.Type.PREKEY_BUNDLE -> 3;
            case Envelope.Type.UNIDENTIFIED_SENDER -> 7;
            case Envelope.Type.PLAINTEXT_CONTENT -> 8;
            default -> 2;
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendRetryMessageRequestAction that = (SendRetryMessageRequestAction)o;
        if (!this.recipientId.equals(that.recipientId)) {
            return false;
        }
        if (!this.protocolException.equals(that.protocolException)) {
            return false;
        }
        return this.envelope.equals(that.envelope);
    }

    public int hashCode() {
        int result = this.recipientId.hashCode();
        result = 31 * result + this.protocolException.hashCode();
        result = 31 * result + this.envelope.hashCode();
        return result;
    }
}

