/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.internal;

import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalWebSocket;
import org.whispersystems.signalservice.api.util.Preconditions;
import org.whispersystems.signalservice.api.util.SleepTimer;
import org.whispersystems.signalservice.api.websocket.HealthMonitor;
import org.whispersystems.signalservice.api.websocket.WebSocketConnectionState;

final class SignalWebSocketHealthMonitor
implements HealthMonitor {
    private static final Logger logger = LoggerFactory.getLogger(SignalWebSocketHealthMonitor.class);
    private static final long KEEP_ALIVE_SEND_CADENCE = TimeUnit.SECONDS.toMillis(30L);
    private static final long MAX_TIME_SINCE_SUCCESSFUL_KEEP_ALIVE = KEEP_ALIVE_SEND_CADENCE * 3L;
    private SignalWebSocket signalWebSocket;
    private final SleepTimer sleepTimer;
    private volatile KeepAliveSender keepAliveSender;
    private final HealthState identified = new HealthState();
    private final HealthState unidentified = new HealthState();

    public SignalWebSocketHealthMonitor(SleepTimer sleepTimer) {
        this.sleepTimer = sleepTimer;
    }

    public void monitor(SignalWebSocket signalWebSocket) {
        Preconditions.checkNotNull((Object)signalWebSocket);
        Preconditions.checkArgument((this.signalWebSocket == null ? 1 : 0) != 0, (String)"monitor can only be called once");
        this.signalWebSocket = signalWebSocket;
        signalWebSocket.getWebSocketState().subscribeOn(Schedulers.computation()).observeOn(Schedulers.computation()).distinctUntilChanged().subscribe(s -> this.onStateChange((WebSocketConnectionState)s, this.identified));
        signalWebSocket.getUnidentifiedWebSocketState().subscribeOn(Schedulers.computation()).observeOn(Schedulers.computation()).distinctUntilChanged().subscribe(s -> this.onStateChange((WebSocketConnectionState)s, this.unidentified));
    }

    private synchronized void onStateChange(WebSocketConnectionState connectionState, HealthState healthState) {
        switch (connectionState) {
            case CONNECTED: {
                logger.debug("WebSocket is now connected");
                break;
            }
            case AUTHENTICATION_FAILED: {
                logger.debug("WebSocket authentication failed");
                break;
            }
            case FAILED: {
                logger.debug("WebSocket connection failed");
            }
        }
        boolean bl = healthState.needsKeepAlive = connectionState == WebSocketConnectionState.CONNECTED;
        if (this.keepAliveSender == null && this.isKeepAliveNecessary()) {
            this.keepAliveSender = new KeepAliveSender();
            this.keepAliveSender.start();
        } else if (this.keepAliveSender != null && !this.isKeepAliveNecessary()) {
            this.keepAliveSender.shutdown();
            this.keepAliveSender = null;
        }
    }

    public void onKeepAliveResponse(long sentTimestamp, boolean isIdentifiedWebSocket) {
        if (isIdentifiedWebSocket) {
            this.identified.lastKeepAliveReceived = System.currentTimeMillis();
        } else {
            this.unidentified.lastKeepAliveReceived = System.currentTimeMillis();
        }
    }

    public void onMessageError(int status, boolean isIdentifiedWebSocket) {
        if (status == 409) {
            HealthState healthState;
            HealthState healthState2 = healthState = isIdentifiedWebSocket ? this.identified : this.unidentified;
            if (healthState.mismatchErrorTracker.addSample(System.currentTimeMillis())) {
                logger.warn("Received too many mismatch device errors, forcing new websockets.");
                this.signalWebSocket.forceNewWebSockets();
                this.signalWebSocket.connect();
            }
        }
    }

    private boolean isKeepAliveNecessary() {
        return this.identified.needsKeepAlive || this.unidentified.needsKeepAlive;
    }

    private static class HealthState {
        private final HttpErrorTracker mismatchErrorTracker = new HttpErrorTracker(5, TimeUnit.MINUTES.toMillis(1L));
        private volatile boolean needsKeepAlive;
        private volatile long lastKeepAliveReceived;

        private HealthState() {
        }
    }

    private class KeepAliveSender
    extends Thread {
        private volatile boolean shouldKeepRunning = true;

        private KeepAliveSender() {
        }

        @Override
        public void run() {
            SignalWebSocketHealthMonitor.this.identified.lastKeepAliveReceived = System.currentTimeMillis();
            SignalWebSocketHealthMonitor.this.unidentified.lastKeepAliveReceived = System.currentTimeMillis();
            while (this.shouldKeepRunning && SignalWebSocketHealthMonitor.this.isKeepAliveNecessary()) {
                try {
                    SignalWebSocketHealthMonitor.this.sleepTimer.sleep(KEEP_ALIVE_SEND_CADENCE);
                    if (!this.shouldKeepRunning || !SignalWebSocketHealthMonitor.this.isKeepAliveNecessary()) continue;
                    long keepAliveRequiredSinceTime = System.currentTimeMillis() - MAX_TIME_SINCE_SUCCESSFUL_KEEP_ALIVE;
                    if (SignalWebSocketHealthMonitor.this.identified.lastKeepAliveReceived < keepAliveRequiredSinceTime || SignalWebSocketHealthMonitor.this.unidentified.lastKeepAliveReceived < keepAliveRequiredSinceTime) {
                        logger.warn("Missed keep alives, identified last: " + SignalWebSocketHealthMonitor.this.identified.lastKeepAliveReceived + " unidentified last: " + SignalWebSocketHealthMonitor.this.unidentified.lastKeepAliveReceived + " needed by: " + keepAliveRequiredSinceTime);
                        SignalWebSocketHealthMonitor.this.signalWebSocket.forceNewWebSockets();
                        SignalWebSocketHealthMonitor.this.signalWebSocket.connect();
                        continue;
                    }
                    SignalWebSocketHealthMonitor.this.signalWebSocket.sendKeepAlive();
                }
                catch (Throwable e) {
                    logger.warn("Error occurred in KeepAliveSender, ignoring ...", e);
                }
            }
        }

        public void shutdown() {
            this.shouldKeepRunning = false;
        }
    }

    private static final class HttpErrorTracker {
        private final long[] timestamps;
        private final long errorTimeRange;

        public HttpErrorTracker(int samples, long errorTimeRange) {
            this.timestamps = new long[samples];
            this.errorTimeRange = errorTimeRange;
        }

        public synchronized boolean addSample(long now) {
            long errorsMustBeAfter = now - this.errorTimeRange;
            int count = 1;
            int minIndex = 0;
            for (int i = 0; i < this.timestamps.length; ++i) {
                if (this.timestamps[i] < errorsMustBeAfter) {
                    this.timestamps[i] = 0L;
                } else if (this.timestamps[i] != 0L) {
                    ++count;
                }
                if (this.timestamps[i] >= this.timestamps[minIndex]) continue;
                minIndex = i;
            }
            this.timestamps[minIndex] = now;
            if (count >= this.timestamps.length) {
                Arrays.fill(this.timestamps, 0L);
                return true;
            }
            return false;
        }
    }
}

