/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.asamk.signal.manager.api.Contact;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.internal.JobExecutor;
import org.asamk.signal.manager.jobs.DownloadProfileJob;
import org.asamk.signal.manager.jobs.RefreshRecipientsJob;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.Recipient;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.syncStorage.DefaultStorageRecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageRecordUpdate;
import org.asamk.signal.manager.syncStorage.StorageSyncModels;
import org.asamk.signal.manager.util.KeyUtils;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.storage.SignalContactRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.util.OptionalUtil;
import org.whispersystems.signalservice.internal.storage.protos.ContactRecord;

public class ContactRecordProcessor
extends DefaultStorageRecordProcessor<SignalContactRecord> {
    private static final Logger logger = LoggerFactory.getLogger(ContactRecordProcessor.class);
    private static final Pattern E164_PATTERN = Pattern.compile("^\\+[1-9]\\d{0,18}$");
    private final ServiceId.ACI selfAci;
    private final ServiceId.PNI selfPni;
    private final String selfNumber;
    private final SignalAccount account;
    private final Connection connection;
    private final JobExecutor jobExecutor;

    public ContactRecordProcessor(SignalAccount account, Connection connection, JobExecutor jobExecutor) {
        this.account = account;
        this.connection = connection;
        this.jobExecutor = jobExecutor;
        this.selfAci = account.getAci();
        this.selfPni = account.getPni();
        this.selfNumber = account.getNumber();
    }

    @Override
    protected boolean isInvalid(SignalContactRecord remote) {
        boolean hasPni;
        boolean hasAci = remote.getAci().isPresent() && ((ServiceId.ACI)remote.getAci().get()).isValid();
        boolean bl = hasPni = remote.getPni().isPresent() && ((ServiceId.PNI)remote.getPni().get()).isValid();
        if (!hasAci && !hasPni) {
            logger.debug("Found a ContactRecord with neither an ACI nor a PNI -- marking as invalid.");
            return true;
        }
        if (this.selfAci != null && this.selfAci.equals(remote.getAci().orElse(null)) || this.selfPni != null && this.selfPni.equals(remote.getPni().orElse(null)) || this.selfNumber != null && this.selfNumber.equals(remote.getNumber().orElse(null))) {
            logger.debug("Found a ContactRecord for ourselves -- marking as invalid.");
            return true;
        }
        if (remote.getNumber().isPresent() && !ContactRecordProcessor.isValidE164((String)remote.getNumber().get())) {
            logger.debug("Found a record with an invalid E164. Marking as invalid.");
            return true;
        }
        return false;
    }

    @Override
    protected Optional<SignalContactRecord> getMatching(SignalContactRecord remote) throws SQLException {
        RecipientAddress address = ContactRecordProcessor.getRecipientAddress(remote);
        RecipientId recipientId = this.account.getRecipientStore().resolveRecipient(this.connection, address);
        Recipient recipient = this.account.getRecipientStore().getRecipient(this.connection, recipientId);
        String identifier = recipient.getAddress().getIdentifier();
        IdentityInfo identity = this.account.getIdentityKeyStore().getIdentityInfo(this.connection, identifier);
        StorageId storageId = this.account.getRecipientStore().getStorageId(this.connection, recipientId);
        return Optional.of((SignalContactRecord)StorageSyncModels.localToRemoteRecord(recipient, identity, storageId.getRaw()).getContact().get());
    }

    @Override
    protected SignalContactRecord merge(SignalContactRecord remote, SignalContactRecord local) {
        String e164;
        ServiceId.PNI pni;
        boolean pnisMatchButE164sDont;
        byte[] identityKey;
        ContactRecord.IdentityState identityState;
        String profileFamilyName;
        String profileGivenName;
        if (remote.getProfileGivenName().isPresent() || remote.getProfileFamilyName().isPresent()) {
            profileGivenName = remote.getProfileGivenName().orElse("");
            profileFamilyName = remote.getProfileFamilyName().orElse("");
        } else {
            profileGivenName = local.getProfileGivenName().orElse("");
            profileFamilyName = local.getProfileFamilyName().orElse("");
        }
        if (remote.getIdentityKey().isPresent() && (remote.getIdentityState() != local.getIdentityState() || local.getIdentityKey().isEmpty() || !this.account.isPrimaryDevice())) {
            identityState = remote.getIdentityState();
            identityKey = (byte[])remote.getIdentityKey().get();
        } else {
            identityState = local.getIdentityState();
            identityKey = local.getIdentityKey().orElse(null);
        }
        if (local.getAci().isPresent() && local.getIdentityKey().isPresent() && remote.getIdentityKey().isPresent() && !Arrays.equals((byte[])local.getIdentityKey().get(), (byte[])remote.getIdentityKey().get())) {
            logger.debug("The local and remote identity keys do not match for {}. Enqueueing a profile fetch.", local.getAci().orElse(null));
            RecipientAddress address = ContactRecordProcessor.getRecipientAddress(local);
            this.jobExecutor.enqueueJob(new DownloadProfileJob(address));
        }
        boolean e164sMatchButPnisDont = local.getNumber().isPresent() && ((String)local.getNumber().get()).equals(remote.getNumber().orElse(null)) && local.getPni().isPresent() && remote.getPni().isPresent() && !((ServiceId.PNI)local.getPni().get()).equals(remote.getPni().get());
        boolean bl = pnisMatchButE164sDont = local.getPni().isPresent() && ((ServiceId.PNI)local.getPni().get()).equals(remote.getPni().orElse(null)) && local.getNumber().isPresent() && remote.getNumber().isPresent() && !((String)local.getNumber().get()).equals(remote.getNumber().get());
        if (!this.account.isPrimaryDevice() && (e164sMatchButPnisDont || pnisMatchButE164sDont)) {
            if (e164sMatchButPnisDont) {
                logger.debug("Matching E164s, but the PNIs differ! Trusting our local pair.");
            } else if (pnisMatchButE164sDont) {
                logger.debug("Matching PNIs, but the E164s differ! Trusting our local pair.");
            }
            this.jobExecutor.enqueueJob(new RefreshRecipientsJob());
            pni = (ServiceId.PNI)local.getPni().get();
            e164 = (String)local.getNumber().get();
        } else {
            pni = OptionalUtil.or((Optional[])new Optional[]{remote.getPni(), local.getPni()}).orElse(null);
            e164 = OptionalUtil.or((Optional[])new Optional[]{remote.getNumber(), local.getNumber()}).orElse(null);
        }
        byte[] unknownFields = remote.serializeUnknownFields();
        ServiceId.ACI aci = local.getAci().isEmpty() ? (ServiceId.ACI)remote.getAci().orElse(null) : (ServiceId.ACI)local.getAci().get();
        byte[] profileKey = OptionalUtil.or((Optional[])new Optional[]{remote.getProfileKey(), local.getProfileKey()}).orElse(null);
        String username = OptionalUtil.or((Optional[])new Optional[]{remote.getUsername(), local.getUsername()}).orElse("");
        boolean blocked = remote.isBlocked();
        boolean profileSharing = remote.isProfileSharingEnabled();
        boolean archived = remote.isArchived();
        boolean forcedUnread = remote.isForcedUnread();
        long muteUntil = remote.getMuteUntil();
        boolean hideStory = remote.shouldHideStory();
        long unregisteredTimestamp = remote.getUnregisteredTimestamp();
        boolean hidden = remote.isHidden();
        String systemGivenName = this.account.isPrimaryDevice() ? local.getSystemGivenName().orElse("") : remote.getSystemGivenName().orElse("");
        String systemFamilyName = this.account.isPrimaryDevice() ? local.getSystemFamilyName().orElse("") : remote.getSystemFamilyName().orElse("");
        String systemNickname = remote.getSystemNickname().orElse("");
        String nicknameGivenName = remote.getNicknameGivenName().orElse("");
        String nicknameFamilyName = remote.getNicknameFamilyName().orElse("");
        boolean pniSignatureVerified = remote.isPniSignatureVerified() || local.isPniSignatureVerified();
        String note = remote.getNote().or(() -> ((SignalContactRecord)local).getNote()).orElse("");
        SignalContactRecord.Builder mergedBuilder = new SignalContactRecord.Builder(remote.getId().getRaw(), aci, unknownFields).setE164(e164).setPni(pni).setProfileGivenName(profileGivenName).setProfileFamilyName(profileFamilyName).setSystemGivenName(systemGivenName).setSystemFamilyName(systemFamilyName).setSystemNickname(systemNickname).setProfileKey(profileKey).setUsername(username).setIdentityState(identityState).setIdentityKey(identityKey).setBlocked(blocked).setProfileSharingEnabled(profileSharing).setArchived(archived).setForcedUnread(forcedUnread).setMuteUntil(muteUntil).setHideStory(hideStory).setUnregisteredTimestamp(unregisteredTimestamp).setHidden(hidden).setPniSignatureVerified(pniSignatureVerified).setNicknameGivenName(nicknameGivenName).setNicknameFamilyName(nicknameFamilyName).setNote(note);
        SignalContactRecord merged = mergedBuilder.build();
        boolean matchesRemote = ContactRecordProcessor.doProtosMatch(merged, remote);
        if (matchesRemote) {
            return remote;
        }
        boolean matchesLocal = ContactRecordProcessor.doProtosMatch(merged, local);
        if (matchesLocal) {
            return local;
        }
        return mergedBuilder.setId(KeyUtils.createRawStorageId()).build();
    }

    @Override
    protected void insertLocal(SignalContactRecord record) throws SQLException {
        StorageRecordUpdate<SignalContactRecord> update = new StorageRecordUpdate<SignalContactRecord>(null, record);
        this.updateLocal(update);
    }

    @Override
    protected void updateLocal(StorageRecordUpdate<SignalContactRecord> update) throws SQLException {
        String profileFamilyName;
        Profile profile;
        String contactNote;
        SignalContactRecord contactRecord = update.newRecord();
        RecipientAddress address = ContactRecordProcessor.getRecipientAddress(contactRecord);
        RecipientId recipientId = this.account.getRecipientStore().resolveRecipientTrusted(this.connection, address);
        Recipient recipient = this.account.getRecipientStore().getRecipient(this.connection, recipientId);
        Contact contact = recipient.getContact();
        boolean blocked = contact != null && contact.isBlocked();
        boolean profileShared = contact != null && contact.isProfileSharingEnabled();
        boolean archived = contact != null && contact.isArchived();
        boolean hidden = contact != null && contact.isHidden();
        boolean hideStory = contact != null && contact.hideStory();
        long muteUntil = contact == null ? 0L : contact.muteUntil();
        long unregisteredTimestamp = contact == null || contact.unregisteredTimestamp() == null ? 0L : contact.unregisteredTimestamp();
        String contactGivenName = contact == null ? null : contact.givenName();
        String contactFamilyName = contact == null ? null : contact.familyName();
        String contactNickName = contact == null ? null : contact.nickName();
        String contactNickGivenName = contact == null ? null : contact.nickNameGivenName();
        String contactNickFamilyName = contact == null ? null : contact.nickNameFamilyName();
        String string = contactNote = contact == null ? null : contact.note();
        if (!(blocked == contactRecord.isBlocked() && profileShared == contactRecord.isProfileSharingEnabled() && archived == contactRecord.isArchived() && hidden == contactRecord.isHidden() && hideStory == contactRecord.shouldHideStory() && muteUntil == contactRecord.getMuteUntil() && unregisteredTimestamp == contactRecord.getUnregisteredTimestamp() && Objects.equals(contactRecord.getSystemGivenName().orElse(null), contactGivenName) && Objects.equals(contactRecord.getSystemFamilyName().orElse(null), contactFamilyName) && Objects.equals(contactRecord.getSystemNickname().orElse(null), contactNickName) && Objects.equals(contactRecord.getNicknameGivenName().orElse(null), contactNickGivenName) && Objects.equals(contactRecord.getNicknameFamilyName().orElse(null), contactNickFamilyName) && Objects.equals(contactRecord.getNote().orElse(null), contactNote))) {
            logger.debug("Storing new or updated contact {}", (Object)recipientId);
            Contact.Builder contactBuilder = contact == null ? Contact.newBuilder() : Contact.newBuilder(contact);
            Contact.Builder newContact = contactBuilder.withIsBlocked(contactRecord.isBlocked()).withIsProfileSharingEnabled(contactRecord.isProfileSharingEnabled()).withIsArchived(contactRecord.isArchived()).withIsHidden(contactRecord.isHidden()).withMuteUntil(contactRecord.getMuteUntil()).withHideStory(contactRecord.shouldHideStory()).withGivenName(contactRecord.getSystemGivenName().orElse(null)).withFamilyName(contactRecord.getSystemFamilyName().orElse(null)).withNickName(contactRecord.getSystemNickname().orElse(null)).withNickNameGivenName(contactRecord.getNicknameGivenName().orElse(null)).withNickNameFamilyName(contactRecord.getNicknameFamilyName().orElse(null)).withNote(contactRecord.getNote().orElse(null)).withUnregisteredTimestamp(contactRecord.getUnregisteredTimestamp() == 0L ? null : Long.valueOf(contactRecord.getUnregisteredTimestamp()));
            this.account.getRecipientStore().storeContact(this.connection, recipientId, newContact.build());
        }
        String profileGivenName = (profile = recipient.getProfile()) == null ? null : profile.getGivenName();
        String string2 = profileFamilyName = profile == null ? null : profile.getFamilyName();
        if (!Objects.equals(contactRecord.getProfileGivenName().orElse(null), profileGivenName) || !Objects.equals(contactRecord.getProfileFamilyName().orElse(null), profileFamilyName)) {
            Profile.Builder profileBuilder = profile == null ? Profile.newBuilder() : Profile.newBuilder(profile);
            Profile newProfile = profileBuilder.withGivenName(contactRecord.getProfileGivenName().orElse(null)).withFamilyName(contactRecord.getProfileFamilyName().orElse(null)).build();
            this.account.getRecipientStore().storeProfile(this.connection, recipientId, newProfile);
        }
        if (contactRecord.getProfileKey().isPresent()) {
            try {
                logger.trace("Storing profile key {}", (Object)recipientId);
                ProfileKey profileKey = new ProfileKey((byte[])contactRecord.getProfileKey().get());
                this.account.getRecipientStore().storeProfileKey(this.connection, recipientId, profileKey);
            }
            catch (InvalidInputException e) {
                logger.warn("Received invalid contact profile key from storage");
            }
        }
        if (contactRecord.getIdentityKey().isPresent() && contactRecord.getAci().isPresent()) {
            try {
                logger.trace("Storing identity key {}", (Object)recipientId);
                IdentityKey identityKey = new IdentityKey((byte[])contactRecord.getIdentityKey().get());
                this.account.getIdentityKeyStore().saveIdentity(this.connection, (ServiceId)contactRecord.getAci().orElse(null), identityKey);
                TrustLevel trustLevel = StorageSyncModels.remoteToLocal(contactRecord.getIdentityState());
                if (trustLevel != null) {
                    this.account.getIdentityKeyStore().setIdentityTrustLevel(this.connection, contactRecord.getAci().orElse(null), identityKey, trustLevel);
                }
            }
            catch (InvalidKeyException e) {
                logger.warn("Received invalid contact identity key from storage");
            }
        }
        this.account.getRecipientStore().storeStorageRecord(this.connection, recipientId, contactRecord.getId(), contactRecord.toProto().encode());
    }

    private static RecipientAddress getRecipientAddress(SignalContactRecord contactRecord) {
        return new RecipientAddress(contactRecord.getAci().orElse(null), contactRecord.getPni().orElse(null), contactRecord.getNumber().orElse(null), contactRecord.getUsername().orElse(null));
    }

    @Override
    public int compare(SignalContactRecord lhs, SignalContactRecord rhs) {
        if (lhs.getAci().isPresent() && Objects.equals(lhs.getAci(), rhs.getAci()) || lhs.getNumber().isPresent() && Objects.equals(lhs.getNumber(), rhs.getNumber()) || lhs.getPni().isPresent() && Objects.equals(lhs.getPni(), rhs.getPni())) {
            return 0;
        }
        return 1;
    }

    private static boolean isValidE164(String value) {
        return E164_PATTERN.matcher(value).matches();
    }

    private static boolean doProtosMatch(SignalContactRecord merged, SignalContactRecord other) {
        return Arrays.equals(merged.toProto().encode(), other.toProto().encode());
    }
}

