/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.util;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.asamk.signal.manager.config.ServiceConfig;
import org.asamk.signal.manager.storage.SignalAccount;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.kem.KEMKeyPair;
import org.signal.libsignal.protocol.kem.KEMKeyType;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.account.PreKeyCollection;
import org.whispersystems.signalservice.api.kbs.MasterKey;

public class KeyUtils {
    private static final SecureRandom secureRandom = new SecureRandom();

    private KeyUtils() {
    }

    public static IdentityKeyPair getIdentityKeyPair(byte[] publicKeyBytes, byte[] privateKeyBytes) {
        try {
            IdentityKey publicKey = new IdentityKey(publicKeyBytes);
            ECPrivateKey privateKey = Curve.decodePrivatePoint((byte[])privateKeyBytes);
            return new IdentityKeyPair(publicKey, privateKey);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static IdentityKeyPair generateIdentityKeyPair() {
        ECKeyPair djbKeyPair = Curve.generateKeyPair();
        IdentityKey djbIdentityKey = new IdentityKey(djbKeyPair.getPublicKey());
        ECPrivateKey djbPrivateKey = djbKeyPair.getPrivateKey();
        return new IdentityKeyPair(djbIdentityKey, djbPrivateKey);
    }

    public static List<PreKeyRecord> generatePreKeyRecords(int offset) {
        ArrayList<PreKeyRecord> records = new ArrayList<PreKeyRecord>(100);
        for (int i = 0; i < 100; ++i) {
            int preKeyId = (offset + i) % ServiceConfig.PREKEY_MAXIMUM_ID;
            ECKeyPair keyPair = Curve.generateKeyPair();
            PreKeyRecord record = new PreKeyRecord(preKeyId, keyPair);
            records.add(record);
        }
        return records;
    }

    public static SignedPreKeyRecord generateSignedPreKeyRecord(int signedPreKeyId, ECPrivateKey privateKey) {
        byte[] signature;
        ECKeyPair keyPair = Curve.generateKeyPair();
        try {
            signature = Curve.calculateSignature((ECPrivateKey)privateKey, (byte[])keyPair.getPublicKey().serialize());
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
        return new SignedPreKeyRecord(signedPreKeyId, System.currentTimeMillis(), keyPair, signature);
    }

    public static List<KyberPreKeyRecord> generateKyberPreKeyRecords(int offset, ECPrivateKey privateKey) {
        ArrayList<KyberPreKeyRecord> records = new ArrayList<KyberPreKeyRecord>(100);
        for (int i = 0; i < 100; ++i) {
            int preKeyId = (offset + i) % ServiceConfig.PREKEY_MAXIMUM_ID;
            records.add(KeyUtils.generateKyberPreKeyRecord(preKeyId, privateKey));
        }
        return records;
    }

    public static KyberPreKeyRecord generateKyberPreKeyRecord(int preKeyId, ECPrivateKey privateKey) {
        KEMKeyPair keyPair = KEMKeyPair.generate((KEMKeyType)KEMKeyType.KYBER_1024);
        byte[] signature = privateKey.calculateSignature(keyPair.getPublicKey().serialize());
        return new KyberPreKeyRecord(preKeyId, System.currentTimeMillis(), keyPair, signature);
    }

    public static ProfileKey createProfileKey() {
        try {
            return new ProfileKey(KeyUtils.getSecretBytes(32));
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)"Profile key is guaranteed to be 32 bytes here");
        }
    }

    public static String createPassword() {
        return KeyUtils.getSecret(18);
    }

    public static byte[] createStickerUploadKey() {
        return KeyUtils.getSecretBytes(32);
    }

    public static MasterKey createMasterKey() {
        return MasterKey.createNew((SecureRandom)secureRandom);
    }

    public static byte[] createRawStorageId() {
        return KeyUtils.getSecretBytes(16);
    }

    private static String getSecret(int size) {
        byte[] secret = KeyUtils.getSecretBytes(size);
        return Base64.getEncoder().encodeToString(secret);
    }

    public static byte[] getSecretBytes(int size) {
        byte[] secret = new byte[size];
        secureRandom.nextBytes(secret);
        return secret;
    }

    public static int getRandomInt(int bound) {
        return secureRandom.nextInt(bound);
    }

    public static PreKeyCollection generatePreKeysForType(SignalAccount.AccountData<?> accountData) {
        IdentityKeyPair keyPair = accountData.getIdentityKeyPair();
        SignalAccount.PreKeyMetadata preKeyMetadata = accountData.getPreKeyMetadata();
        int nextSignedPreKeyId = preKeyMetadata.getNextSignedPreKeyId();
        SignedPreKeyRecord signedPreKey = KeyUtils.generateSignedPreKeyRecord(nextSignedPreKeyId, keyPair.getPrivateKey());
        ECPrivateKey privateKey = keyPair.getPrivateKey();
        int kyberPreKeyIdOffset = preKeyMetadata.getNextKyberPreKeyId();
        KyberPreKeyRecord lastResortKyberPreKey = KeyUtils.generateKyberPreKeyRecord(kyberPreKeyIdOffset, privateKey);
        return new PreKeyCollection(keyPair.getPublicKey(), signedPreKey, lastResortKyberPreKey);
    }
}

