/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class DigestingOutputStream
extends FilterOutputStream {
    private final MessageDigest runningDigest;
    private byte[] digest;
    private long totalBytesWritten = 0L;

    public DigestingOutputStream(OutputStream outputStream) {
        super(outputStream);
        try {
            this.runningDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.runningDigest.update(buffer, 0, buffer.length);
        this.out.write(buffer, 0, buffer.length);
        this.totalBytesWritten += (long)buffer.length;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.runningDigest.update(buffer, offset, length);
        this.out.write(buffer, offset, length);
        this.totalBytesWritten += (long)length;
    }

    @Override
    public void write(int b) throws IOException {
        this.runningDigest.update((byte)b);
        this.out.write(b);
        ++this.totalBytesWritten;
    }

    @Override
    public void flush() throws IOException {
        this.digest = this.runningDigest.digest();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public byte[] getTransmittedDigest() {
        return this.digest;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }
}

