/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.kbs;

import java.security.SecureRandom;
import java.util.Arrays;
import org.signal.core.util.Base64;
import org.signal.core.util.CryptoUtil;
import org.signal.libsignal.protocol.kdf.HKDF;
import org.whispersystems.signalservice.api.backup.BackupKey;
import org.whispersystems.signalservice.api.storage.StorageKey;
import org.whispersystems.signalservice.internal.util.Hex;
import org.whispersystems.util.StringUtil;

public final class MasterKey {
    private static final int LENGTH = 32;
    private final byte[] masterKey;

    public MasterKey(byte[] masterKey) {
        if (masterKey.length != 32) {
            throw new AssertionError();
        }
        this.masterKey = masterKey;
    }

    public static MasterKey createNew(SecureRandom secureRandom) {
        byte[] key = new byte[32];
        secureRandom.nextBytes(key);
        return new MasterKey(key);
    }

    public String deriveRegistrationLock() {
        return Hex.toStringCondensed(this.derive("Registration Lock"));
    }

    public String deriveRegistrationRecoveryPassword() {
        return Base64.encodeWithPadding((byte[])this.derive("Registration Recovery"));
    }

    public StorageKey deriveStorageServiceKey() {
        return new StorageKey(this.derive("Storage Service Encryption"));
    }

    public byte[] deriveLoggingKey() {
        return this.derive("Logging Key");
    }

    public BackupKey deriveBackupKey() {
        return new BackupKey(HKDF.deriveSecrets((byte[])this.masterKey, (byte[])"20231003_Signal_Backups_GenerateBackupKey".getBytes(), (int)32));
    }

    private byte[] derive(String keyName) {
        return CryptoUtil.hmacSha256((byte[])this.masterKey, (byte[])StringUtil.utf8(keyName));
    }

    public byte[] serialize() {
        return (byte[])this.masterKey.clone();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return Arrays.equals(((MasterKey)o).masterKey, this.masterKey);
    }

    public int hashCode() {
        return Arrays.hashCode(this.masterKey);
    }

    public String toString() {
        return "MasterKey(xxx)";
    }
}

