/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push;

import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.util.UuidUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001b2\u00020\u0001:\u0003\u001a\u001b\u001cB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0010H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0002\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/whispersystems/signalservice/api/push/ServiceId;", "", "libSignalServiceId", "Lorg/signal/libsignal/protocol/ServiceId;", "(Lorg/signal/libsignal/protocol/ServiceId;)V", "isUnknown", "", "()Z", "isValid", "getLibSignalServiceId", "()Lorg/signal/libsignal/protocol/ServiceId;", "rawUuid", "Ljava/util/UUID;", "getRawUuid", "()Ljava/util/UUID;", "logString", "", "toByteArray", "", "toByteString", "Lokio/ByteString;", "toProtocolAddress", "Lorg/signal/libsignal/protocol/SignalProtocolAddress;", "deviceId", "", "toString", "ACI", "Companion", "PNI", "Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;", "Lorg/whispersystems/signalservice/api/push/ServiceId$PNI;", "signal-service-java"})
public abstract class ServiceId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final org.signal.libsignal.protocol.ServiceId libSignalServiceId;
    @NotNull
    private final UUID rawUuid;
    private final boolean isUnknown;
    private final boolean isValid;
    @NotNull
    private static final String TAG = "ServiceId";

    private ServiceId(org.signal.libsignal.protocol.ServiceId libSignalServiceId) {
        this.libSignalServiceId = libSignalServiceId;
        UUID uUID = this.libSignalServiceId.getRawUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getRawUUID(...)");
        this.rawUuid = uUID;
        this.isUnknown = Intrinsics.areEqual((Object)this.rawUuid, (Object)UuidUtil.UNKNOWN_UUID);
        this.isValid = !this.isUnknown;
    }

    @NotNull
    public final org.signal.libsignal.protocol.ServiceId getLibSignalServiceId() {
        return this.libSignalServiceId;
    }

    @NotNull
    public final UUID getRawUuid() {
        return this.rawUuid;
    }

    public final boolean isUnknown() {
        return this.isUnknown;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public final SignalProtocolAddress toProtocolAddress(int deviceId) {
        return new SignalProtocolAddress(this.libSignalServiceId.toServiceIdString(), deviceId);
    }

    @NotNull
    public final ByteString toByteString() {
        byte[] byArray = this.libSignalServiceId.toServiceIdBinary();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toServiceIdBinary(...)");
        byte[] byArray2 = byArray;
        return ByteString.Companion.of(Arrays.copyOf(byArray2, byArray2.length));
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = this.libSignalServiceId.toServiceIdBinary();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toServiceIdBinary(...)");
        return byArray;
    }

    @NotNull
    public final String logString() {
        String string = this.libSignalServiceId.toLogString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLogString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.libSignalServiceId.toServiceIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toServiceIdString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ServiceId fromLibSignal(@NotNull org.signal.libsignal.protocol.ServiceId serviceId) {
        return Companion.fromLibSignal(serviceId);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ServiceId parseOrNull(@Nullable String raw, boolean logFailures) {
        return Companion.parseOrNull(raw, logFailures);
    }

    @JvmStatic
    @Nullable
    public static final ServiceId parseOrNull(@Nullable byte[] raw) {
        return Companion.parseOrNull(raw);
    }

    @JvmStatic
    @Nullable
    public static final ServiceId parseOrNull(@Nullable ByteString bytes) {
        return Companion.parseOrNull(bytes);
    }

    @JvmStatic
    @NotNull
    public static final ServiceId parseOrThrow(@NotNull String raw) throws IllegalArgumentException {
        return Companion.parseOrThrow(raw);
    }

    @JvmStatic
    @NotNull
    public static final ServiceId parseOrThrow(@NotNull byte[] raw) throws IllegalArgumentException {
        return Companion.parseOrThrow(raw);
    }

    @JvmStatic
    @NotNull
    public static final ServiceId parseOrThrow(@NotNull ByteString bytes) throws IllegalArgumentException {
        return Companion.parseOrThrow(bytes);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ServiceId parseOrNull(@Nullable String raw) {
        return Companion.parseOrNull(raw);
    }

    public /* synthetic */ ServiceId(org.signal.libsignal.protocol.ServiceId libSignalServiceId, DefaultConstructorMarker $constructor_marker) {
        this(libSignalServiceId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;", "Lorg/whispersystems/signalservice/api/push/ServiceId;", "libSignalAci", "Lorg/signal/libsignal/protocol/ServiceId$Aci;", "(Lorg/signal/libsignal/protocol/ServiceId$Aci;)V", "getLibSignalAci", "()Lorg/signal/libsignal/protocol/ServiceId$Aci;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "signal-service-java"})
    public static final class ACI
    extends ServiceId {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ServiceId.Aci libSignalAci;
        @JvmField
        @NotNull
        public static final ACI UNKNOWN;

        public ACI(@NotNull ServiceId.Aci libSignalAci) {
            Intrinsics.checkNotNullParameter((Object)libSignalAci, (String)"libSignalAci");
            super((org.signal.libsignal.protocol.ServiceId)libSignalAci, null);
            this.libSignalAci = libSignalAci;
        }

        @NotNull
        public final ServiceId.Aci getLibSignalAci() {
            return this.libSignalAci;
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString();
        }

        @NotNull
        public final ServiceId.Aci component1() {
            return this.libSignalAci;
        }

        @NotNull
        public final ACI copy(@NotNull ServiceId.Aci libSignalAci) {
            Intrinsics.checkNotNullParameter((Object)libSignalAci, (String)"libSignalAci");
            return new ACI(libSignalAci);
        }

        public static /* synthetic */ ACI copy$default(ACI aCI, ServiceId.Aci aci, int n, Object object) {
            if ((n & 1) != 0) {
                aci = aCI.libSignalAci;
            }
            return aCI.copy(aci);
        }

        public int hashCode() {
            return this.libSignalAci.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ACI)) {
                return false;
            }
            ACI aCI = (ACI)other;
            return Intrinsics.areEqual((Object)this.libSignalAci, (Object)aCI.libSignalAci);
        }

        @JvmStatic
        @NotNull
        public static final ACI from(@NotNull UUID uuid) {
            return Companion.from(uuid);
        }

        @JvmStatic
        @NotNull
        public static final ACI fromLibSignal(@NotNull ServiceId.Aci aci) {
            return Companion.fromLibSignal(aci);
        }

        @JvmStatic
        @Nullable
        public static final ACI parseOrNull(@Nullable String raw) {
            return Companion.parseOrNull(raw);
        }

        @JvmStatic
        @Nullable
        public static final ACI parseOrNull(@Nullable byte[] raw) {
            return Companion.parseOrNull(raw);
        }

        @JvmStatic
        @Nullable
        public static final ACI parseOrNull(@NotNull ByteString bytes) {
            return Companion.parseOrNull(bytes);
        }

        @JvmStatic
        @NotNull
        public static final ACI parseOrThrow(@Nullable String raw) throws IllegalArgumentException {
            return Companion.parseOrThrow(raw);
        }

        @JvmStatic
        @NotNull
        public static final ACI parseOrThrow(@Nullable byte[] raw) throws IllegalArgumentException {
            return Companion.parseOrThrow(raw);
        }

        @JvmStatic
        @NotNull
        public static final ACI parseOrThrow(@NotNull ByteString bytes) throws IllegalArgumentException {
            return Companion.parseOrThrow(bytes);
        }

        @JvmStatic
        @NotNull
        public static final ACI parseOrUnknown(@Nullable ByteString bytes) {
            return Companion.parseOrUnknown(bytes);
        }

        @JvmStatic
        @NotNull
        public static final ACI parseOrUnknown(@Nullable String raw) {
            return Companion.parseOrUnknown(raw);
        }

        static {
            UUID uUID = UuidUtil.UNKNOWN_UUID;
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UNKNOWN_UUID");
            UNKNOWN = Companion.from(uUID);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u0011\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0012\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010\u0012\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/push/ServiceId$ACI$Companion;", "", "()V", "UNKNOWN", "Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;", "from", "uuid", "Ljava/util/UUID;", "fromLibSignal", "aci", "Lorg/signal/libsignal/protocol/ServiceId$Aci;", "parseOrNull", "raw", "", "", "bytes", "Lokio/ByteString;", "parseOrThrow", "parseOrUnknown", "signal-service-java"})
        @SourceDebugExtension(value={"SMAP\nServiceId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceId.kt\norg/whispersystems/signalservice/api/push/ServiceId$ACI$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final ACI from(@NotNull UUID uuid) {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                return new ACI(new ServiceId.Aci(uuid));
            }

            @JvmStatic
            @NotNull
            public final ACI fromLibSignal(@NotNull ServiceId.Aci aci) {
                Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
                return new ACI(aci);
            }

            @JvmStatic
            @Nullable
            public final ACI parseOrNull(@Nullable String raw) {
                ServiceId it = org.whispersystems.signalservice.api.push.ServiceId$Companion.parseOrNull$default(ServiceId.Companion, raw, false, 2, null);
                boolean bl = false;
                return it instanceof ACI ? (ACI)it : null;
            }

            @JvmStatic
            @Nullable
            public final ACI parseOrNull(@Nullable byte[] raw) {
                ServiceId it = ServiceId.Companion.parseOrNull(raw);
                boolean bl = false;
                return it instanceof ACI ? (ACI)it : null;
            }

            @JvmStatic
            @Nullable
            public final ACI parseOrNull(@NotNull ByteString bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                return this.parseOrNull(bytes.toByteArray());
            }

            @JvmStatic
            @NotNull
            public final ACI parseOrThrow(@Nullable String raw) throws IllegalArgumentException {
                ACI aCI = this.parseOrNull(raw);
                if (aCI == null) {
                    throw new IllegalArgumentException("Invalid ACI!");
                }
                return aCI;
            }

            @JvmStatic
            @NotNull
            public final ACI parseOrThrow(@Nullable byte[] raw) throws IllegalArgumentException {
                ACI aCI = this.parseOrNull(raw);
                if (aCI == null) {
                    throw new IllegalArgumentException("Invalid ACI!");
                }
                return aCI;
            }

            @JvmStatic
            @NotNull
            public final ACI parseOrThrow(@NotNull ByteString bytes) throws IllegalArgumentException {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                return this.parseOrThrow(bytes.toByteArray());
            }

            @JvmStatic
            @NotNull
            public final ACI parseOrUnknown(@Nullable ByteString bytes) {
                Object object;
                block3: {
                    block2: {
                        object = UuidUtil.fromByteStringOrNull(bytes);
                        if (object == null) break block2;
                        UUID it = object;
                        boolean bl = false;
                        ACI aCI = Companion.from(it);
                        object = aCI;
                        if (aCI != null) break block3;
                    }
                    object = UNKNOWN;
                }
                return object;
            }

            @JvmStatic
            @NotNull
            public final ACI parseOrUnknown(@Nullable String raw) {
                ACI aCI = this.parseOrNull(raw);
                if (aCI == null) {
                    aCI = UNKNOWN;
                }
                return aCI;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u001e\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/whispersystems/signalservice/api/push/ServiceId$Companion;", "", "()V", "TAG", "", "fromLibSignal", "Lorg/whispersystems/signalservice/api/push/ServiceId;", "serviceId", "Lorg/signal/libsignal/protocol/ServiceId;", "parseOrNull", "raw", "", "logFailures", "", "bytes", "Lokio/ByteString;", "parseOrThrow", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ServiceId fromLibSignal(@NotNull org.signal.libsignal.protocol.ServiceId serviceId) {
            ServiceId serviceId2;
            Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
            org.signal.libsignal.protocol.ServiceId serviceId3 = serviceId;
            if (serviceId3 instanceof ServiceId.Aci) {
                serviceId2 = new ACI((ServiceId.Aci)serviceId);
            } else if (serviceId3 instanceof ServiceId.Pni) {
                serviceId2 = new PNI((ServiceId.Pni)serviceId);
            } else {
                throw new IllegalArgumentException("Unknown libsignal ServiceId type!");
            }
            return serviceId2;
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ServiceId parseOrNull(@Nullable String raw, boolean logFailures) {
            ServiceId serviceId;
            if (raw == null) {
                return null;
            }
            try {
                org.signal.libsignal.protocol.ServiceId serviceId2 = org.signal.libsignal.protocol.ServiceId.parseFromString((String)raw);
                Intrinsics.checkNotNullExpressionValue((Object)serviceId2, (String)"parseFromString(...)");
                serviceId = this.fromLibSignal(serviceId2);
            }
            catch (IllegalArgumentException e) {
                if (logFailures) {
                    Log.w((String)ServiceId.TAG, (String)"[parseOrNull(String)] Illegal argument!", (Throwable)e);
                }
                serviceId = null;
            }
            catch (ServiceId.InvalidServiceIdException e) {
                if (logFailures) {
                    Log.w((String)ServiceId.TAG, (String)"[parseOrNull(String)] Invalid ServiceId!", (Throwable)e);
                }
                serviceId = null;
            }
            return serviceId;
        }

        public static /* synthetic */ ServiceId parseOrNull$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.parseOrNull(string, bl);
        }

        @JvmStatic
        @Nullable
        public final ServiceId parseOrNull(@Nullable byte[] raw) {
            ServiceId serviceId;
            if (raw == null) {
                return null;
            }
            try {
                ServiceId serviceId2;
                if (raw.length == 17) {
                    org.signal.libsignal.protocol.ServiceId serviceId3 = org.signal.libsignal.protocol.ServiceId.parseFromFixedWidthBinary((byte[])raw);
                    Intrinsics.checkNotNullExpressionValue((Object)serviceId3, (String)"parseFromFixedWidthBinary(...)");
                    serviceId2 = this.fromLibSignal(serviceId3);
                } else {
                    org.signal.libsignal.protocol.ServiceId serviceId4 = org.signal.libsignal.protocol.ServiceId.parseFromBinary((byte[])raw);
                    Intrinsics.checkNotNullExpressionValue((Object)serviceId4, (String)"parseFromBinary(...)");
                    serviceId2 = this.fromLibSignal(serviceId4);
                }
                serviceId = serviceId2;
            }
            catch (IllegalArgumentException e) {
                Log.w((String)ServiceId.TAG, (String)"[parseOrNull(Bytes)] Illegal argument!", (Throwable)e);
                serviceId = null;
            }
            catch (ServiceId.InvalidServiceIdException e) {
                Log.w((String)ServiceId.TAG, (String)"[parseOrNull(Bytes)] Invalid ServiceId!", (Throwable)e);
                serviceId = null;
            }
            return serviceId;
        }

        @JvmStatic
        @Nullable
        public final ServiceId parseOrNull(@Nullable ByteString bytes) {
            ByteString byteString = bytes;
            return this.parseOrNull((byte[])(byteString != null ? byteString.toByteArray() : null));
        }

        @JvmStatic
        @NotNull
        public final ServiceId parseOrThrow(@NotNull String raw) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            ServiceId serviceId = org.whispersystems.signalservice.api.push.ServiceId$Companion.parseOrNull$default(this, raw, false, 2, null);
            if (serviceId == null) {
                throw new IllegalArgumentException("Invalid ServiceId!");
            }
            return serviceId;
        }

        @JvmStatic
        @NotNull
        public final ServiceId parseOrThrow(@NotNull byte[] raw) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            ServiceId serviceId = this.parseOrNull(raw);
            if (serviceId == null) {
                throw new IllegalArgumentException("Invalid ServiceId!");
            }
            return serviceId;
        }

        @JvmStatic
        @NotNull
        public final ServiceId parseOrThrow(@NotNull ByteString bytes) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return this.parseOrThrow(bytes.toByteArray());
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final ServiceId parseOrNull(@Nullable String raw) {
            return org.whispersystems.signalservice.api.push.ServiceId$Companion.parseOrNull$default(this, raw, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/push/ServiceId$PNI;", "Lorg/whispersystems/signalservice/api/push/ServiceId;", "libSignalPni", "Lorg/signal/libsignal/protocol/ServiceId$Pni;", "(Lorg/signal/libsignal/protocol/ServiceId$Pni;)V", "getLibSignalPni", "()Lorg/signal/libsignal/protocol/ServiceId$Pni;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "toStringWithoutPrefix", "Companion", "signal-service-java"})
    public static final class PNI
    extends ServiceId {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ServiceId.Pni libSignalPni;
        @JvmField
        @NotNull
        public static PNI UNKNOWN;

        public PNI(@NotNull ServiceId.Pni libSignalPni) {
            Intrinsics.checkNotNullParameter((Object)libSignalPni, (String)"libSignalPni");
            super((org.signal.libsignal.protocol.ServiceId)libSignalPni, null);
            this.libSignalPni = libSignalPni;
        }

        @NotNull
        public final ServiceId.Pni getLibSignalPni() {
            return this.libSignalPni;
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString();
        }

        @NotNull
        public final String toStringWithoutPrefix() {
            String string = this.getRawUuid().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @NotNull
        public final ServiceId.Pni component1() {
            return this.libSignalPni;
        }

        @NotNull
        public final PNI copy(@NotNull ServiceId.Pni libSignalPni) {
            Intrinsics.checkNotNullParameter((Object)libSignalPni, (String)"libSignalPni");
            return new PNI(libSignalPni);
        }

        public static /* synthetic */ PNI copy$default(PNI pNI, ServiceId.Pni pni, int n, Object object) {
            if ((n & 1) != 0) {
                pni = pNI.libSignalPni;
            }
            return pNI.copy(pni);
        }

        public int hashCode() {
            return this.libSignalPni.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PNI)) {
                return false;
            }
            PNI pNI = (PNI)other;
            return Intrinsics.areEqual((Object)this.libSignalPni, (Object)pNI.libSignalPni);
        }

        @JvmStatic
        @NotNull
        public static final PNI from(@NotNull UUID uuid) {
            return Companion.from(uuid);
        }

        @JvmStatic
        @Nullable
        public static final PNI parseOrNull(@Nullable String raw) {
            return Companion.parseOrNull(raw);
        }

        @JvmStatic
        @Nullable
        public static final PNI parseOrNull(@Nullable byte[] raw) {
            return Companion.parseOrNull(raw);
        }

        @JvmStatic
        @Nullable
        public static final PNI parseOrNull(@NotNull ByteString bytes) {
            return Companion.parseOrNull(bytes);
        }

        @JvmStatic
        @NotNull
        public static final PNI parseOrThrow(@Nullable String raw) throws IllegalArgumentException {
            return Companion.parseOrThrow(raw);
        }

        @JvmStatic
        @NotNull
        public static final PNI parseOrThrow(@Nullable byte[] raw) throws IllegalArgumentException {
            return Companion.parseOrThrow(raw);
        }

        @JvmStatic
        @NotNull
        public static final PNI parseOrThrow(@NotNull ByteString bytes) throws IllegalArgumentException {
            return Companion.parseOrThrow(bytes);
        }

        @JvmStatic
        @Nullable
        public static final PNI parsePrefixedOrNull(@Nullable String raw) {
            return Companion.parsePrefixedOrNull(raw);
        }

        static {
            UUID uUID = UuidUtil.UNKNOWN_UUID;
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UNKNOWN_UUID");
            UNKNOWN = Companion.from(uUID);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u000e\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u000bH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/whispersystems/signalservice/api/push/ServiceId$PNI$Companion;", "", "()V", "UNKNOWN", "Lorg/whispersystems/signalservice/api/push/ServiceId$PNI;", "from", "uuid", "Ljava/util/UUID;", "parseOrNull", "raw", "", "", "bytes", "Lokio/ByteString;", "parseOrThrow", "parsePrefixedOrNull", "signal-service-java"})
        @SourceDebugExtension(value={"SMAP\nServiceId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceId.kt\norg/whispersystems/signalservice/api/push/ServiceId$PNI$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final PNI from(@NotNull UUID uuid) {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                return new PNI(new ServiceId.Pni(uuid));
            }

            @JvmStatic
            @Nullable
            public final PNI parseOrNull(@Nullable String raw) {
                PNI pNI;
                if (raw == null) {
                    pNI = null;
                } else {
                    if (StringsKt.startsWith$default((String)raw, (String)"PNI:", (boolean)false, (int)2, null)) {
                        return this.parsePrefixedOrNull(raw);
                    }
                    UUID uuid = UuidUtil.parseOrNull(raw);
                    pNI = uuid != null ? new PNI(new ServiceId.Pni(uuid)) : null;
                }
                return pNI;
            }

            @JvmStatic
            @Nullable
            public final PNI parseOrNull(@Nullable byte[] raw) {
                PNI pNI;
                if (raw == null) {
                    pNI = null;
                } else if (raw.length == 17) {
                    ServiceId it = ServiceId.Companion.parseOrNull(raw);
                    boolean bl = false;
                    pNI = it instanceof PNI ? (PNI)it : null;
                } else {
                    UUID uuid = UuidUtil.parseOrNull(raw);
                    pNI = uuid != null ? new PNI(new ServiceId.Pni(uuid)) : null;
                }
                return pNI;
            }

            @JvmStatic
            @Nullable
            public final PNI parseOrNull(@NotNull ByteString bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                return this.parseOrNull(bytes.toByteArray());
            }

            @JvmStatic
            @NotNull
            public final PNI parseOrThrow(@Nullable String raw) throws IllegalArgumentException {
                PNI pNI = this.parseOrNull(raw);
                if (pNI == null) {
                    throw new IllegalArgumentException("Invalid PNI!");
                }
                return pNI;
            }

            @JvmStatic
            @NotNull
            public final PNI parseOrThrow(@Nullable byte[] raw) throws IllegalArgumentException {
                PNI pNI = this.parseOrNull(raw);
                if (pNI == null) {
                    throw new IllegalArgumentException("Invalid PNI!");
                }
                return pNI;
            }

            @JvmStatic
            @NotNull
            public final PNI parseOrThrow(@NotNull ByteString bytes) throws IllegalArgumentException {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                return this.parseOrThrow(bytes.toByteArray());
            }

            @JvmStatic
            @Nullable
            public final PNI parsePrefixedOrNull(@Nullable String raw) {
                ServiceId it = org.whispersystems.signalservice.api.push.ServiceId$Companion.parseOrNull$default(ServiceId.Companion, raw, false, 2, null);
                boolean bl = false;
                return it instanceof PNI ? (PNI)it : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

