/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.services;

import io.reactivex.rxjava3.annotations.NonNull;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.protocol.util.Pair;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialPresentation;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialRequest;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialResponse;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.subscriptions.ActiveSubscription;
import org.whispersystems.signalservice.api.subscriptions.PayPalConfirmPaymentIntentResponse;
import org.whispersystems.signalservice.api.subscriptions.PayPalCreatePaymentIntentResponse;
import org.whispersystems.signalservice.api.subscriptions.PayPalCreatePaymentMethodResponse;
import org.whispersystems.signalservice.api.subscriptions.StripeClientSecret;
import org.whispersystems.signalservice.api.subscriptions.SubscriberId;
import org.whispersystems.signalservice.internal.EmptyResponse;
import org.whispersystems.signalservice.internal.ServiceResponse;
import org.whispersystems.signalservice.internal.push.BankMandate;
import org.whispersystems.signalservice.internal.push.DonationProcessor;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.push.SubscriptionsConfiguration;

public class DonationsService {
    private static final long DONATION_CONFIGURATION_TTL = TimeUnit.HOURS.toMillis(1L);
    private static final long SEPA_DEBIT_MANDATE_TTL = TimeUnit.DAYS.toMillis(1L);
    private static final String TAG = DonationsService.class.getSimpleName();
    private final PushServiceSocket pushServiceSocket;
    private final AtomicReference<CacheEntry<SubscriptionsConfiguration>> donationsConfigurationCache = new AtomicReference<Object>(null);
    private final AtomicReference<CacheEntry<BankMandate>> sepaBankMandateCache = new AtomicReference<Object>(null);

    public DonationsService(@NonNull PushServiceSocket pushServiceSocket) {
        this.pushServiceSocket = pushServiceSocket;
    }

    public ServiceResponse<EmptyResponse> redeemDonationReceipt(ReceiptCredentialPresentation receiptCredentialPresentation, boolean visible, boolean primary) {
        try {
            this.pushServiceSocket.redeemDonationReceipt(receiptCredentialPresentation, visible, primary);
            return ServiceResponse.forResult(EmptyResponse.INSTANCE, 200, null);
        }
        catch (Exception e) {
            return ServiceResponse.forUnknownError(e);
        }
    }

    public ServiceResponse<EmptyResponse> redeemArchivesReceipt(ReceiptCredentialPresentation receiptCredentialPresentation) {
        try {
            this.pushServiceSocket.redeemArchivesReceipt(receiptCredentialPresentation);
            return ServiceResponse.forResult(EmptyResponse.INSTANCE, 200, null);
        }
        catch (Exception e) {
            return ServiceResponse.forUnknownError(e);
        }
    }

    public ServiceResponse<StripeClientSecret> createDonationIntentWithAmount(String amount, String currencyCode, long level, String paymentMethod) {
        return this.wrapInServiceResponse(() -> new Pair((Object)this.pushServiceSocket.createStripeOneTimePaymentIntent(currencyCode, paymentMethod, Long.parseLong(amount), level), (Object)200));
    }

    public ServiceResponse<ReceiptCredentialResponse> submitBoostReceiptCredentialRequestSync(String paymentIntentId, ReceiptCredentialRequest receiptCredentialRequest, DonationProcessor processor) {
        return this.wrapInServiceResponse(() -> new Pair((Object)this.pushServiceSocket.submitBoostReceiptCredentials(paymentIntentId, receiptCredentialRequest, processor), (Object)200));
    }

    public ServiceResponse<SubscriptionsConfiguration> getDonationsConfiguration(Locale locale) {
        return this.getCachedValue(locale, this.donationsConfigurationCache, this.pushServiceSocket::getDonationsConfiguration, DONATION_CONFIGURATION_TTL);
    }

    public ServiceResponse<BankMandate> getBankMandate(Locale locale, String bankTransferType) {
        return this.getCachedValue(locale, this.sepaBankMandateCache, l -> this.pushServiceSocket.getBankMandate(l, bankTransferType), SEPA_DEBIT_MANDATE_TTL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ServiceResponse<T> getCachedValue(Locale locale, AtomicReference<CacheEntry<T>> cachedValueReference, CacheEntryValueProducer<T> cacheEntryValueProducer, long cacheTTL) {
        CacheEntry<T> cacheEntryOutsideLock = cachedValueReference.get();
        if (this.isNewCacheEntryRequired(cacheEntryOutsideLock, locale)) {
            DonationsService donationsService = this;
            synchronized (donationsService) {
                CacheEntry<T> cacheEntryInLock = cachedValueReference.get();
                if (this.isNewCacheEntryRequired(cacheEntryInLock, locale)) {
                    return this.wrapInServiceResponse(() -> {
                        Object value = cacheEntryValueProducer.produce(locale);
                        cachedValueReference.set(new CacheEntry(value, System.currentTimeMillis() + cacheTTL, locale));
                        return new Pair(value, (Object)200);
                    });
                }
                return this.wrapInServiceResponse(() -> new Pair(cacheEntryInLock.cachedValue, (Object)200));
            }
        }
        return this.wrapInServiceResponse(() -> new Pair(cacheEntryOutsideLock.cachedValue, (Object)200));
    }

    public ServiceResponse<EmptyResponse> updateSubscriptionLevel(SubscriberId subscriberId, String level, String currencyCode, String idempotencyKey, Object mutex) {
        return this.wrapInServiceResponse(() -> {
            Object object = mutex;
            synchronized (object) {
                this.pushServiceSocket.updateSubscriptionLevel(subscriberId.serialize(), level, currencyCode, idempotencyKey);
            }
            return new Pair((Object)EmptyResponse.INSTANCE, (Object)200);
        });
    }

    public ServiceResponse<EmptyResponse> linkGooglePlayBillingPurchaseTokenToSubscriberId(SubscriberId subscriberId, String purchaseToken, Object mutex) {
        return this.wrapInServiceResponse(() -> {
            Object object = mutex;
            synchronized (object) {
                this.pushServiceSocket.linkPlayBillingPurchaseToken(subscriberId.serialize(), purchaseToken);
            }
            return new Pair((Object)EmptyResponse.INSTANCE, (Object)200);
        });
    }

    public ServiceResponse<ActiveSubscription> getSubscription(SubscriberId subscriberId) {
        return this.wrapInServiceResponse(() -> {
            ActiveSubscription response = this.pushServiceSocket.getSubscription(subscriberId.serialize());
            return new Pair((Object)response, (Object)200);
        });
    }

    public ServiceResponse<EmptyResponse> putSubscription(SubscriberId subscriberId) {
        return this.wrapInServiceResponse(() -> {
            this.pushServiceSocket.putSubscription(subscriberId.serialize());
            return new Pair((Object)EmptyResponse.INSTANCE, (Object)200);
        });
    }

    public ServiceResponse<EmptyResponse> cancelSubscription(SubscriberId subscriberId) {
        return this.wrapInServiceResponse(() -> {
            this.pushServiceSocket.deleteSubscription(subscriberId.serialize());
            return new Pair((Object)EmptyResponse.INSTANCE, (Object)200);
        });
    }

    public ServiceResponse<EmptyResponse> setDefaultStripePaymentMethod(SubscriberId subscriberId, String paymentMethodId) {
        return this.wrapInServiceResponse(() -> {
            this.pushServiceSocket.setDefaultStripeSubscriptionPaymentMethod(subscriberId.serialize(), paymentMethodId);
            return new Pair((Object)EmptyResponse.INSTANCE, (Object)200);
        });
    }

    public ServiceResponse<EmptyResponse> setDefaultIdealPaymentMethod(SubscriberId subscriberId, String setupIntentId) {
        return this.wrapInServiceResponse(() -> {
            this.pushServiceSocket.setDefaultIdealSubscriptionPaymentMethod(subscriberId.serialize(), setupIntentId);
            return new Pair((Object)EmptyResponse.INSTANCE, (Object)200);
        });
    }

    public ServiceResponse<StripeClientSecret> createStripeSubscriptionPaymentMethod(SubscriberId subscriberId, String type) {
        return this.wrapInServiceResponse(() -> {
            StripeClientSecret clientSecret = this.pushServiceSocket.createStripeSubscriptionPaymentMethod(subscriberId.serialize(), type);
            return new Pair((Object)clientSecret, (Object)200);
        });
    }

    public ServiceResponse<PayPalCreatePaymentIntentResponse> createPayPalOneTimePaymentIntent(Locale locale, String currencyCode, String amount, long level, String returnUrl, String cancelUrl) {
        return this.wrapInServiceResponse(() -> {
            PayPalCreatePaymentIntentResponse response = this.pushServiceSocket.createPayPalOneTimePaymentIntent(locale, currencyCode.toUpperCase(Locale.US), Long.parseLong(amount), level, returnUrl, cancelUrl);
            return new Pair((Object)response, (Object)200);
        });
    }

    public ServiceResponse<PayPalConfirmPaymentIntentResponse> confirmPayPalOneTimePaymentIntent(String currency, String amount, long level, String payerId, String paymentId, String paymentToken) {
        return this.wrapInServiceResponse(() -> {
            PayPalConfirmPaymentIntentResponse response = this.pushServiceSocket.confirmPayPalOneTimePaymentIntent(currency, amount, level, payerId, paymentId, paymentToken);
            return new Pair((Object)response, (Object)200);
        });
    }

    public ServiceResponse<PayPalCreatePaymentMethodResponse> createPayPalPaymentMethod(Locale locale, SubscriberId subscriberId, String returnUrl, String cancelUrl) {
        return this.wrapInServiceResponse(() -> {
            PayPalCreatePaymentMethodResponse response = this.pushServiceSocket.createPayPalPaymentMethod(locale, subscriberId.serialize(), returnUrl, cancelUrl);
            return new Pair((Object)response, (Object)200);
        });
    }

    public ServiceResponse<EmptyResponse> setDefaultPayPalPaymentMethod(SubscriberId subscriberId, String paymentMethodId) {
        return this.wrapInServiceResponse(() -> {
            this.pushServiceSocket.setDefaultPaypalSubscriptionPaymentMethod(subscriberId.serialize(), paymentMethodId);
            return new Pair((Object)EmptyResponse.INSTANCE, (Object)200);
        });
    }

    public ServiceResponse<ReceiptCredentialResponse> submitReceiptCredentialRequestSync(SubscriberId subscriberId, ReceiptCredentialRequest receiptCredentialRequest) {
        return this.wrapInServiceResponse(() -> {
            ReceiptCredentialResponse response = this.pushServiceSocket.submitReceiptCredentials(subscriberId.serialize(), receiptCredentialRequest);
            return new Pair((Object)response, (Object)200);
        });
    }

    private <T> ServiceResponse<T> wrapInServiceResponse(Producer<T> producer) {
        try {
            Pair<T, Integer> responseAndCode = producer.produce();
            return ServiceResponse.forResult(responseAndCode.first(), (Integer)responseAndCode.second(), null);
        }
        catch (NonSuccessfulResponseCodeException e) {
            Log.w((String)TAG, (String)"Bad response code from server.", (Throwable)e);
            return ServiceResponse.forApplicationError(e, e.getCode(), e.getMessage());
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"An unknown error occurred.", (Throwable)e);
            return ServiceResponse.forUnknownError(e);
        }
    }

    private <T> boolean isNewCacheEntryRequired(CacheEntry<T> cacheEntry, Locale locale) {
        return cacheEntry == null || cacheEntry.expiresAt < System.currentTimeMillis() || !Objects.equals(locale, cacheEntry.locale);
    }

    private static interface Producer<T> {
        public Pair<T, Integer> produce() throws IOException;
    }

    static interface CacheEntryValueProducer<T> {
        public T produce(Locale var1) throws IOException;
    }

    private static class CacheEntry<T> {
        private final T cachedValue;
        private final long expiresAt;
        private final Locale locale;

        private CacheEntry(T cachedValue, long expiresAt, Locale locale) {
            this.cachedValue = cachedValue;
            this.expiresAt = expiresAt;
            this.locale = locale;
        }
    }
}

