/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.services;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Single;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.protocol.util.Pair;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.profiles.ClientZkProfileOperations;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCredentialRequest;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCredentialRequestContext;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyVersion;
import org.whispersystems.signalservice.api.SignalServiceMessageReceiver;
import org.whispersystems.signalservice.api.SignalWebSocket;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.profiles.ProfileAndCredential;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.MalformedResponseException;
import org.whispersystems.signalservice.internal.ServiceResponse;
import org.whispersystems.signalservice.internal.ServiceResponseProcessor;
import org.whispersystems.signalservice.internal.push.IdentityCheckRequest;
import org.whispersystems.signalservice.internal.push.IdentityCheckResponse;
import org.whispersystems.signalservice.internal.push.http.AcceptLanguagesUtil;
import org.whispersystems.signalservice.internal.util.Hex;
import org.whispersystems.signalservice.internal.util.JsonUtil;
import org.whispersystems.signalservice.internal.websocket.DefaultResponseMapper;
import org.whispersystems.signalservice.internal.websocket.ResponseMapper;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

public final class ProfileService {
    private static final String TAG = ProfileService.class.getSimpleName();
    private final ClientZkProfileOperations clientZkProfileOperations;
    private final SignalServiceMessageReceiver receiver;
    private final SignalWebSocket signalWebSocket;

    public ProfileService(ClientZkProfileOperations clientZkProfileOperations, SignalServiceMessageReceiver receiver, SignalWebSocket signalWebSocket) {
        this.clientZkProfileOperations = clientZkProfileOperations;
        this.receiver = receiver;
        this.signalWebSocket = signalWebSocket;
    }

    public Single<ServiceResponse<ProfileAndCredential>> getProfile(@Nonnull SignalServiceAddress address, @Nonnull Optional<ProfileKey> profileKey, @Nullable SealedSenderAccess sealedSenderAccess, @Nonnull SignalServiceProfile.RequestType requestType, @Nonnull Locale locale) {
        ServiceId serviceId = address.getServiceId();
        SecureRandom random = new SecureRandom();
        ProfileKeyCredentialRequestContext requestContext = null;
        WebSocketRequestMessage.Builder builder = new WebSocketRequestMessage.Builder().id(random.nextLong()).verb("GET");
        if (profileKey.isPresent()) {
            if (!(serviceId instanceof ServiceId.ACI)) {
                Log.w((String)TAG, (String)"ServiceId  must be an ACI if a profile key is available!");
                return Single.just(ServiceResponse.forUnknownError(new IllegalArgumentException("ServiceId  must be an ACI if a profile key is available!")));
            }
            ServiceId.ACI aci = (ServiceId.ACI)serviceId;
            ProfileKeyVersion profileKeyIdentifier = profileKey.get().getProfileKeyVersion(aci.getLibSignalAci());
            String version = profileKeyIdentifier.serialize();
            if (requestType == SignalServiceProfile.RequestType.PROFILE_AND_CREDENTIAL) {
                requestContext = this.clientZkProfileOperations.createProfileKeyCredentialRequestContext(random, aci.getLibSignalAci(), profileKey.get());
                ProfileKeyCredentialRequest request = requestContext.getRequest();
                String credentialRequest = Hex.toStringCondensed(request.serialize());
                builder.path(String.format("/v1/profile/%s/%s/%s?credentialType=expiringProfileKey", serviceId, version, credentialRequest));
            } else {
                builder.path(String.format("/v1/profile/%s/%s", serviceId, version));
            }
        } else {
            builder.path(String.format("/v1/profile/%s", address.getIdentifier()));
        }
        builder.headers(Collections.singletonList(AcceptLanguagesUtil.getAcceptLanguageHeader(locale)));
        WebSocketRequestMessage requestMessage = builder.build();
        ResponseMapper<ProfileAndCredential> responseMapper = DefaultResponseMapper.extend(ProfileAndCredential.class).withResponseMapper(new ProfileResponseMapper(requestType, requestContext)).build();
        return this.signalWebSocket.request(requestMessage, sealedSenderAccess).map(responseMapper::map).onErrorResumeNext(t -> this.getProfileRestFallback(address, profileKey, sealedSenderAccess, requestType, locale)).onErrorReturn(ServiceResponse::forUnknownError);
    }

    @NonNull
    public Single<ServiceResponse<IdentityCheckResponse>> performIdentityCheck(@Nonnull Map<ServiceId, IdentityKey> serviceIdIdentityKeyMap) {
        List<IdentityCheckRequest.ServiceIdFingerprintPair> serviceIdKeyPairs = serviceIdIdentityKeyMap.entrySet().stream().map(e -> new IdentityCheckRequest.ServiceIdFingerprintPair((ServiceId)e.getKey(), (IdentityKey)e.getValue())).collect(Collectors.toList());
        IdentityCheckRequest request = new IdentityCheckRequest(serviceIdKeyPairs);
        WebSocketRequestMessage.Builder builder = new WebSocketRequestMessage.Builder().id(new SecureRandom().nextLong()).verb("POST").path("/v1/profile/identity_check/batch").headers(Collections.singletonList("content-type:application/json")).body(JsonUtil.toJsonByteString(request));
        DefaultResponseMapper<IdentityCheckResponse> responseMapper = DefaultResponseMapper.getDefault(IdentityCheckResponse.class);
        return this.signalWebSocket.request(builder.build(), SealedSenderAccess.NONE).map(responseMapper::map).onErrorResumeNext(t -> this.performIdentityCheckRestFallback(request, responseMapper)).onErrorReturn(ServiceResponse::forUnknownError);
    }

    private Single<ServiceResponse<ProfileAndCredential>> getProfileRestFallback(@Nonnull SignalServiceAddress address, @Nonnull Optional<ProfileKey> profileKey, @Nullable SealedSenderAccess sealedSenderAccess, @Nonnull SignalServiceProfile.RequestType requestType, @Nonnull Locale locale) {
        return Single.fromFuture(this.receiver.retrieveProfile(address, profileKey, sealedSenderAccess, requestType, locale), (long)10L, (TimeUnit)TimeUnit.SECONDS).onErrorResumeNext(t -> {
            Throwable error = t instanceof ExecutionException && t.getCause() != null ? t.getCause() : t;
            if (error instanceof AuthorizationFailedException) {
                return Single.fromFuture(this.receiver.retrieveProfile(address, profileKey, null, requestType, locale), (long)10L, (TimeUnit)TimeUnit.SECONDS);
            }
            return Single.error((Throwable)t);
        }).map(p -> ServiceResponse.forResult(p, 0, null));
    }

    @NonNull
    private Single<ServiceResponse<IdentityCheckResponse>> performIdentityCheckRestFallback(@Nonnull IdentityCheckRequest request, @Nonnull ResponseMapper<IdentityCheckResponse> responseMapper) {
        return this.receiver.performIdentityCheck(request, responseMapper).onErrorResumeNext(t -> {
            Throwable error = t instanceof ExecutionException && t.getCause() != null ? t.getCause() : t;
            if (error instanceof AuthorizationFailedException) {
                return this.receiver.performIdentityCheck(request, responseMapper);
            }
            return Single.error((Throwable)t);
        });
    }

    private class ProfileResponseMapper
    implements DefaultResponseMapper.CustomResponseMapper<ProfileAndCredential> {
        private final SignalServiceProfile.RequestType requestType;
        private final ProfileKeyCredentialRequestContext requestContext;

        public ProfileResponseMapper(SignalServiceProfile.RequestType requestType, ProfileKeyCredentialRequestContext requestContext) {
            this.requestType = requestType;
            this.requestContext = requestContext;
        }

        @Override
        public ServiceResponse<ProfileAndCredential> map(int status, String body, Function<String, String> getHeader, boolean unidentified) throws MalformedResponseException {
            try {
                SignalServiceProfile signalServiceProfile = JsonUtil.fromJsonResponse(body, SignalServiceProfile.class);
                ExpiringProfileKeyCredential expiringProfileKeyCredential = null;
                if (this.requestContext != null && signalServiceProfile.getExpiringProfileKeyCredentialResponse() != null) {
                    expiringProfileKeyCredential = ProfileService.this.clientZkProfileOperations.receiveExpiringProfileKeyCredential(this.requestContext, signalServiceProfile.getExpiringProfileKeyCredentialResponse());
                }
                return ServiceResponse.forResult(new ProfileAndCredential(signalServiceProfile, this.requestType, Optional.ofNullable(expiringProfileKeyCredential)), status, body);
            }
            catch (VerificationFailedException e) {
                return ServiceResponse.forApplicationError(e, status, body);
            }
        }
    }

    public static final class ProfileResponseProcessor
    extends ServiceResponseProcessor<ProfileAndCredential> {
        public ProfileResponseProcessor(ServiceResponse<ProfileAndCredential> response) {
            super(response);
        }

        public <T> Pair<T, ProfileAndCredential> getResult(T with) {
            return new Pair(with, (Object)((ProfileAndCredential)this.getResult()));
        }

        @Override
        public boolean notFound() {
            return super.notFound();
        }

        @Override
        public boolean genericIoError() {
            return super.genericIoError();
        }

        @Override
        public Throwable getError() {
            return super.getError();
        }
    }
}

