/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import com.squareup.wire.Message;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import okio.ByteString;
import org.signal.core.util.ProtoUtil;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.storage.SignalRecord;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.util.OptionalUtil;
import org.whispersystems.signalservice.internal.storage.protos.ContactRecord;

public final class SignalContactRecord
implements SignalRecord {
    private static final String TAG = SignalContactRecord.class.getSimpleName();
    private final StorageId id;
    private final ContactRecord proto;
    private final boolean hasUnknownFields;
    private final Optional<ServiceId.ACI> aci;
    private final Optional<ServiceId.PNI> pni;
    private final Optional<String> e164;
    private final Optional<String> profileGivenName;
    private final Optional<String> profileFamilyName;
    private final Optional<String> systemGivenName;
    private final Optional<String> systemFamilyName;
    private final Optional<String> systemNickname;
    private final Optional<byte[]> profileKey;
    private final Optional<String> username;
    private final Optional<byte[]> identityKey;
    private final Optional<String> nicknameGivenName;
    private final Optional<String> nicknameFamilyName;
    private final Optional<String> note;

    public SignalContactRecord(StorageId id, ContactRecord proto) {
        this.id = id;
        this.proto = proto;
        this.hasUnknownFields = ProtoUtil.hasUnknownFields((Message)proto);
        this.aci = OptionalUtil.absentIfEmpty(proto.aci).map(ServiceId.ACI::parseOrNull).map(it -> it.isUnknown() ? null : it);
        this.pni = OptionalUtil.absentIfEmpty(proto.pni).map(ServiceId.PNI::parseOrNull).map(it -> it.isUnknown() ? null : it);
        this.e164 = OptionalUtil.absentIfEmpty(proto.e164);
        this.profileGivenName = OptionalUtil.absentIfEmpty(proto.givenName);
        this.profileFamilyName = OptionalUtil.absentIfEmpty(proto.familyName);
        this.systemGivenName = OptionalUtil.absentIfEmpty(proto.systemGivenName);
        this.systemFamilyName = OptionalUtil.absentIfEmpty(proto.systemFamilyName);
        this.systemNickname = OptionalUtil.absentIfEmpty(proto.systemNickname);
        this.profileKey = OptionalUtil.absentIfEmpty(proto.profileKey);
        this.username = OptionalUtil.absentIfEmpty(proto.username);
        this.identityKey = OptionalUtil.absentIfEmpty(proto.identityKey);
        this.nicknameGivenName = Optional.ofNullable(proto.nickname).flatMap(n -> OptionalUtil.absentIfEmpty(n.given));
        this.nicknameFamilyName = Optional.ofNullable(proto.nickname).flatMap(n -> OptionalUtil.absentIfEmpty(n.family));
        this.note = OptionalUtil.absentIfEmpty(proto.note);
    }

    @Override
    public StorageId getId() {
        return this.id;
    }

    @Override
    public SignalStorageRecord asStorageRecord() {
        return SignalStorageRecord.forContact(this);
    }

    @Override
    public String describeDiff(SignalRecord other) {
        if (other instanceof SignalContactRecord) {
            SignalContactRecord that = (SignalContactRecord)other;
            LinkedList<String> diff = new LinkedList<String>();
            if (!Arrays.equals(this.id.getRaw(), that.id.getRaw())) {
                diff.add("ID");
            }
            if (!Objects.equals(this.getAci(), that.getAci())) {
                diff.add("ACI");
            }
            if (!Objects.equals(this.getPni(), that.getPni())) {
                diff.add("PNI");
            }
            if (!Objects.equals(this.getNumber(), that.getNumber())) {
                diff.add("E164");
            }
            if (!Objects.equals(this.profileGivenName, that.profileGivenName)) {
                diff.add("ProfileGivenName");
            }
            if (!Objects.equals(this.profileFamilyName, that.profileFamilyName)) {
                diff.add("ProfileFamilyName");
            }
            if (!Objects.equals(this.systemGivenName, that.systemGivenName)) {
                diff.add("SystemGivenName");
            }
            if (!Objects.equals(this.systemFamilyName, that.systemFamilyName)) {
                diff.add("SystemFamilyName");
            }
            if (!Objects.equals(this.systemNickname, that.systemNickname)) {
                diff.add("SystemNickname");
            }
            if (!OptionalUtil.byteArrayEquals(this.profileKey, that.profileKey)) {
                diff.add("ProfileKey");
            }
            if (!Objects.equals(this.username, that.username)) {
                diff.add("Username");
            }
            if (!OptionalUtil.byteArrayEquals(this.identityKey, that.identityKey)) {
                diff.add("IdentityKey");
            }
            if (!Objects.equals((Object)this.getIdentityState(), (Object)that.getIdentityState())) {
                diff.add("IdentityState");
            }
            if (!Objects.equals(this.isBlocked(), that.isBlocked())) {
                diff.add("Blocked");
            }
            if (!Objects.equals(this.isProfileSharingEnabled(), that.isProfileSharingEnabled())) {
                diff.add("ProfileSharing");
            }
            if (!Objects.equals(this.isArchived(), that.isArchived())) {
                diff.add("Archived");
            }
            if (!Objects.equals(this.isForcedUnread(), that.isForcedUnread())) {
                diff.add("ForcedUnread");
            }
            if (!Objects.equals(this.getMuteUntil(), that.getMuteUntil())) {
                diff.add("MuteUntil");
            }
            if (this.shouldHideStory() != that.shouldHideStory()) {
                diff.add("HideStory");
            }
            if (this.getUnregisteredTimestamp() != that.getUnregisteredTimestamp()) {
                diff.add("UnregisteredTimestamp");
            }
            if (this.isHidden() != that.isHidden()) {
                diff.add("Hidden");
            }
            if (this.isPniSignatureVerified() != that.isPniSignatureVerified()) {
                diff.add("PniSignatureVerified");
            }
            if (!Objects.equals(this.hasUnknownFields(), that.hasUnknownFields())) {
                diff.add("UnknownFields");
            }
            if (!Objects.equals(this.nicknameGivenName, that.nicknameGivenName)) {
                diff.add("NicknameGivenName");
            }
            if (!Objects.equals(this.nicknameFamilyName, that.nicknameFamilyName)) {
                diff.add("NicknameFamilyName");
            }
            if (!Objects.equals(this.note, that.note)) {
                diff.add("Note");
            }
            return ((Object)diff).toString();
        }
        return "Different class. " + this.getClass().getSimpleName() + " | " + other.getClass().getSimpleName();
    }

    public boolean hasUnknownFields() {
        return this.hasUnknownFields;
    }

    public byte[] serializeUnknownFields() {
        return this.hasUnknownFields ? this.proto.encode() : null;
    }

    public Optional<ServiceId.ACI> getAci() {
        return this.aci;
    }

    public Optional<ServiceId.PNI> getPni() {
        return this.pni;
    }

    public Optional<? extends ServiceId> getServiceId() {
        if (this.aci.isPresent()) {
            return this.aci;
        }
        if (this.pni.isPresent()) {
            return this.pni;
        }
        return Optional.empty();
    }

    public Optional<String> getNumber() {
        return this.e164;
    }

    public Optional<String> getProfileGivenName() {
        return this.profileGivenName;
    }

    public Optional<String> getProfileFamilyName() {
        return this.profileFamilyName;
    }

    public Optional<String> getSystemGivenName() {
        return this.systemGivenName;
    }

    public Optional<String> getSystemFamilyName() {
        return this.systemFamilyName;
    }

    public Optional<String> getSystemNickname() {
        return this.systemNickname;
    }

    public Optional<String> getNicknameGivenName() {
        return this.nicknameGivenName;
    }

    public Optional<String> getNicknameFamilyName() {
        return this.nicknameFamilyName;
    }

    public Optional<String> getNote() {
        return this.note;
    }

    public Optional<byte[]> getProfileKey() {
        return this.profileKey;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public Optional<byte[]> getIdentityKey() {
        return this.identityKey;
    }

    public ContactRecord.IdentityState getIdentityState() {
        return this.proto.identityState;
    }

    public boolean isBlocked() {
        return this.proto.blocked;
    }

    public boolean isProfileSharingEnabled() {
        return this.proto.whitelisted;
    }

    public boolean isArchived() {
        return this.proto.archived;
    }

    public boolean isForcedUnread() {
        return this.proto.markedUnread;
    }

    public long getMuteUntil() {
        return this.proto.mutedUntilTimestamp;
    }

    public boolean shouldHideStory() {
        return this.proto.hideStory;
    }

    public long getUnregisteredTimestamp() {
        return this.proto.unregisteredAtTimestamp;
    }

    public boolean isHidden() {
        return this.proto.hidden;
    }

    public boolean isPniSignatureVerified() {
        return this.proto.pniSignatureVerified;
    }

    public SignalContactRecord withoutPni() {
        return new SignalContactRecord(this.id, this.proto.newBuilder().pni("").build());
    }

    public ContactRecord toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalContactRecord that = (SignalContactRecord)o;
        return this.id.equals(that.id) && this.proto.equals((Object)that.proto);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.proto});
    }

    public static final class Builder {
        private StorageId id;
        private final ContactRecord.Builder builder;

        public Builder(byte[] rawId, @Nullable ServiceId.ACI aci, byte[] serializedUnknowns) {
            this.id = StorageId.forContact(rawId);
            this.builder = serializedUnknowns != null ? Builder.parseUnknowns(serializedUnknowns) : new ContactRecord.Builder();
            this.builder.aci(aci == null ? "" : aci.toString());
        }

        public Builder setId(byte[] rawId) {
            this.id = StorageId.forContact(rawId);
            return this;
        }

        public Builder setE164(String e164) {
            this.builder.e164(e164 == null ? "" : e164);
            return this;
        }

        public Builder setPni(ServiceId.PNI pni) {
            this.builder.pni(pni == null ? "" : pni.toStringWithoutPrefix());
            return this;
        }

        public Builder setProfileGivenName(String givenName) {
            this.builder.givenName(givenName == null ? "" : givenName);
            return this;
        }

        public Builder setProfileFamilyName(String familyName) {
            this.builder.familyName(familyName == null ? "" : familyName);
            return this;
        }

        public Builder setSystemGivenName(String givenName) {
            this.builder.systemGivenName(givenName == null ? "" : givenName);
            return this;
        }

        public Builder setSystemFamilyName(String familyName) {
            this.builder.systemFamilyName(familyName == null ? "" : familyName);
            return this;
        }

        public Builder setSystemNickname(String nickname) {
            this.builder.systemNickname(nickname == null ? "" : nickname);
            return this;
        }

        public Builder setProfileKey(byte[] profileKey) {
            this.builder.profileKey(profileKey == null ? ByteString.EMPTY : ByteString.of((byte[])profileKey));
            return this;
        }

        public Builder setUsername(String username) {
            this.builder.username(username == null ? "" : username);
            return this;
        }

        public Builder setIdentityKey(byte[] identityKey) {
            this.builder.identityKey(identityKey == null ? ByteString.EMPTY : ByteString.of((byte[])identityKey));
            return this;
        }

        public Builder setIdentityState(ContactRecord.IdentityState identityState) {
            this.builder.identityState(identityState == null ? ContactRecord.IdentityState.DEFAULT : identityState);
            return this;
        }

        public Builder setBlocked(boolean blocked) {
            this.builder.blocked(blocked);
            return this;
        }

        public Builder setProfileSharingEnabled(boolean profileSharingEnabled) {
            this.builder.whitelisted(profileSharingEnabled);
            return this;
        }

        public Builder setArchived(boolean archived) {
            this.builder.archived(archived);
            return this;
        }

        public Builder setForcedUnread(boolean forcedUnread) {
            this.builder.markedUnread(forcedUnread);
            return this;
        }

        public Builder setMuteUntil(long muteUntil) {
            this.builder.mutedUntilTimestamp(muteUntil);
            return this;
        }

        public Builder setHideStory(boolean hideStory) {
            this.builder.hideStory(hideStory);
            return this;
        }

        public Builder setUnregisteredTimestamp(long timestamp) {
            this.builder.unregisteredAtTimestamp(timestamp);
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.builder.hidden(hidden);
            return this;
        }

        public Builder setPniSignatureVerified(boolean verified) {
            this.builder.pniSignatureVerified(verified);
            return this;
        }

        public Builder setNicknameGivenName(String nicknameGivenName) {
            ContactRecord.Name.Builder name = this.builder.nickname == null ? new ContactRecord.Name.Builder() : this.builder.nickname.newBuilder();
            name.given(nicknameGivenName);
            this.builder.nickname(name.build());
            return this;
        }

        public Builder setNicknameFamilyName(String nicknameFamilyName) {
            ContactRecord.Name.Builder name = this.builder.nickname == null ? new ContactRecord.Name.Builder() : this.builder.nickname.newBuilder();
            name.family(nicknameFamilyName);
            this.builder.nickname(name.build());
            return this;
        }

        public Builder setNote(String note) {
            this.builder.note(note == null ? "" : note);
            return this;
        }

        private static ContactRecord.Builder parseUnknowns(byte[] serializedUnknowns) {
            try {
                return ((ContactRecord)((Object)ContactRecord.ADAPTER.decode(serializedUnknowns))).newBuilder();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Failed to combine unknown fields!", (Throwable)e);
                return new ContactRecord.Builder();
            }
        }

        public SignalContactRecord build() {
            return new SignalContactRecord(this.id, this.builder.build());
        }
    }
}

