/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.contacts.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.signal.core.util.CryptoUtil;
import org.signal.libsignal.protocol.util.ByteUtil;
import org.whispersystems.signalservice.api.crypto.InvalidCiphertextException;
import org.whispersystems.signalservice.internal.contacts.crypto.AESCipher;
import org.whispersystems.signalservice.internal.contacts.crypto.RemoteAttestation;
import org.whispersystems.signalservice.internal.contacts.entities.DiscoveryRequest;
import org.whispersystems.signalservice.internal.contacts.entities.DiscoveryResponse;
import org.whispersystems.signalservice.internal.contacts.entities.QueryEnvelope;
import org.whispersystems.signalservice.internal.util.Util;

public final class ContactDiscoveryCipher {
    private ContactDiscoveryCipher() {
    }

    public static DiscoveryRequest createDiscoveryRequest(List<String> addressBook, Map<String, RemoteAttestation> remoteAttestations) {
        byte[] queryDataKey = Util.getSecretBytes(32);
        byte[] queryData = ContactDiscoveryCipher.buildQueryData(addressBook);
        AESCipher.AESEncryptedResult encryptedQueryData = AESCipher.encrypt(queryDataKey, null, queryData);
        byte[] commitment = CryptoUtil.sha256((byte[])queryData);
        HashMap<String, QueryEnvelope> envelopes = new HashMap<String, QueryEnvelope>(remoteAttestations.size());
        for (Map.Entry<String, RemoteAttestation> entry : remoteAttestations.entrySet()) {
            envelopes.put(entry.getKey(), ContactDiscoveryCipher.buildQueryEnvelope(entry.getValue().getRequestId(), entry.getValue().getKeys().getClientKey(), queryDataKey));
        }
        return new DiscoveryRequest(addressBook.size(), commitment, encryptedQueryData.iv, encryptedQueryData.data, encryptedQueryData.mac, envelopes);
    }

    public static byte[] getDiscoveryResponseData(DiscoveryResponse response, Collection<RemoteAttestation> attestations) throws InvalidCiphertextException, IOException {
        for (RemoteAttestation attestation : attestations) {
            if (!Arrays.equals(response.getRequestId(), attestation.getRequestId())) continue;
            return AESCipher.decrypt(attestation.getKeys().getServerKey(), response.getIv(), response.getData(), response.getMac());
        }
        throw new NoMatchingRequestIdException();
    }

    private static byte[] buildQueryData(List<String> addresses) {
        try {
            byte[] nonce = Util.getSecretBytes(32);
            ByteArrayOutputStream requestDataStream = new ByteArrayOutputStream();
            requestDataStream.write(nonce);
            for (String address : addresses) {
                requestDataStream.write(ByteUtil.longToByteArray((long)Long.parseLong(address)));
            }
            return requestDataStream.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static QueryEnvelope buildQueryEnvelope(byte[] requestId, byte[] clientKey, byte[] queryDataKey) {
        AESCipher.AESEncryptedResult result2 = AESCipher.encrypt(clientKey, requestId, queryDataKey);
        return new QueryEnvelope(requestId, result2.iv, result2.data, result2.mac);
    }

    static class NoMatchingRequestIdException
    extends IOException {
        NoMatchingRequestIdException() {
        }
    }
}

