/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.push;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.wire.Message;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http2.StreamResetException;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.Base64;
import org.signal.core.util.concurrent.FutureTransformers;
import org.signal.core.util.concurrent.ListenableFuture;
import org.signal.core.util.concurrent.SettableFuture;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.kem.KEMPublicKey;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.protocol.state.PreKeyBundle;
import org.signal.libsignal.protocol.util.Pair;
import org.signal.libsignal.usernames.BaseUsernameException;
import org.signal.libsignal.usernames.Username;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.backups.BackupAuthCredentialRequest;
import org.signal.libsignal.zkgroup.calllinks.CreateCallLinkCredentialRequest;
import org.signal.libsignal.zkgroup.calllinks.CreateCallLinkCredentialResponse;
import org.signal.libsignal.zkgroup.profiles.ClientZkProfileOperations;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCredentialRequest;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCredentialRequestContext;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyVersion;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialPresentation;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialRequest;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialResponse;
import org.signal.storageservice.protos.groups.AvatarUploadAttributes;
import org.signal.storageservice.protos.groups.Group;
import org.signal.storageservice.protos.groups.GroupChange;
import org.signal.storageservice.protos.groups.GroupChangeResponse;
import org.signal.storageservice.protos.groups.GroupChanges;
import org.signal.storageservice.protos.groups.GroupExternalCredential;
import org.signal.storageservice.protos.groups.GroupJoinInfo;
import org.signal.storageservice.protos.groups.GroupResponse;
import org.signal.storageservice.protos.groups.Member;
import org.whispersystems.signalservice.api.account.AccountAttributes;
import org.whispersystems.signalservice.api.account.ChangePhoneNumberRequest;
import org.whispersystems.signalservice.api.account.PniKeyDistributionRequest;
import org.whispersystems.signalservice.api.account.PreKeyCollection;
import org.whispersystems.signalservice.api.account.PreKeyUpload;
import org.whispersystems.signalservice.api.archive.ArchiveCredentialPresentation;
import org.whispersystems.signalservice.api.archive.ArchiveGetBackupInfoResponse;
import org.whispersystems.signalservice.api.archive.ArchiveGetMediaItemsResponse;
import org.whispersystems.signalservice.api.archive.ArchiveMediaRequest;
import org.whispersystems.signalservice.api.archive.ArchiveMediaResponse;
import org.whispersystems.signalservice.api.archive.ArchiveServiceCredentialsResponse;
import org.whispersystems.signalservice.api.archive.ArchiveSetBackupIdRequest;
import org.whispersystems.signalservice.api.archive.ArchiveSetPublicKeyRequest;
import org.whispersystems.signalservice.api.archive.BatchArchiveMediaRequest;
import org.whispersystems.signalservice.api.archive.BatchArchiveMediaResponse;
import org.whispersystems.signalservice.api.archive.DeleteArchivedMediaRequest;
import org.whispersystems.signalservice.api.archive.GetArchiveCdnCredentialsResponse;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherStreamUtil;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.groupsv2.CredentialResponse;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2AuthorizationString;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentRemoteId;
import org.whispersystems.signalservice.api.messages.calls.CallingResponse;
import org.whispersystems.signalservice.api.messages.calls.TurnServerInfo;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceInfo;
import org.whispersystems.signalservice.api.payments.CurrencyConversions;
import org.whispersystems.signalservice.api.profiles.ProfileAndCredential;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfileWrite;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.SignedPreKeyEntity;
import org.whispersystems.signalservice.api.push.exceptions.AlreadyVerifiedException;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.CaptchaRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.ConflictException;
import org.whispersystems.signalservice.api.push.exceptions.ContactManifestMismatchException;
import org.whispersystems.signalservice.api.push.exceptions.DeprecatedVersionException;
import org.whispersystems.signalservice.api.push.exceptions.ExpectationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.ExternalServiceFailureException;
import org.whispersystems.signalservice.api.push.exceptions.HttpConflictException;
import org.whispersystems.signalservice.api.push.exceptions.IncorrectRegistrationRecoveryPasswordException;
import org.whispersystems.signalservice.api.push.exceptions.InvalidTransportModeException;
import org.whispersystems.signalservice.api.push.exceptions.MalformedRequestException;
import org.whispersystems.signalservice.api.push.exceptions.MalformedResponseException;
import org.whispersystems.signalservice.api.push.exceptions.MissingConfigurationException;
import org.whispersystems.signalservice.api.push.exceptions.MustRequestNewCodeException;
import org.whispersystems.signalservice.api.push.exceptions.NoContentException;
import org.whispersystems.signalservice.api.push.exceptions.NoSuchSessionException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResumableUploadResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.NotFoundException;
import org.whispersystems.signalservice.api.push.exceptions.ProofRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.PushChallengeRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.PushNetworkException;
import org.whispersystems.signalservice.api.push.exceptions.RangeException;
import org.whispersystems.signalservice.api.push.exceptions.RateLimitException;
import org.whispersystems.signalservice.api.push.exceptions.RegistrationRetryException;
import org.whispersystems.signalservice.api.push.exceptions.ResumeLocationInvalidException;
import org.whispersystems.signalservice.api.push.exceptions.ServerRejectedException;
import org.whispersystems.signalservice.api.push.exceptions.TokenNotAcceptedException;
import org.whispersystems.signalservice.api.push.exceptions.UnregisteredUserException;
import org.whispersystems.signalservice.api.push.exceptions.UsernameIsNotAssociatedWithAnAccountException;
import org.whispersystems.signalservice.api.push.exceptions.UsernameIsNotReservedException;
import org.whispersystems.signalservice.api.push.exceptions.UsernameMalformedException;
import org.whispersystems.signalservice.api.push.exceptions.UsernameTakenException;
import org.whispersystems.signalservice.api.storage.StorageAuthResponse;
import org.whispersystems.signalservice.api.subscriptions.ActiveSubscription;
import org.whispersystems.signalservice.api.subscriptions.PayPalConfirmPaymentIntentResponse;
import org.whispersystems.signalservice.api.subscriptions.PayPalCreatePaymentIntentResponse;
import org.whispersystems.signalservice.api.subscriptions.PayPalCreatePaymentMethodResponse;
import org.whispersystems.signalservice.api.subscriptions.StripeClientSecret;
import org.whispersystems.signalservice.api.svr.SetShareSetRequest;
import org.whispersystems.signalservice.api.svr.Svr3Credentials;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.api.util.Tls12SocketFactory;
import org.whispersystems.signalservice.api.util.TlsProxySocketFactory;
import org.whispersystems.signalservice.internal.ServiceResponse;
import org.whispersystems.signalservice.internal.configuration.SignalCdnUrl;
import org.whispersystems.signalservice.internal.configuration.SignalProxy;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.configuration.SignalUrl;
import org.whispersystems.signalservice.internal.crypto.AttachmentDigest;
import org.whispersystems.signalservice.internal.push.AttachmentUploadForm;
import org.whispersystems.signalservice.internal.push.AttachmentV2UploadAttributes;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.push.BackupAuthCheckRequest;
import org.whispersystems.signalservice.internal.push.BackupV2AuthCheckResponse;
import org.whispersystems.signalservice.internal.push.BackupV3AuthCheckResponse;
import org.whispersystems.signalservice.internal.push.BankMandate;
import org.whispersystems.signalservice.internal.push.BoostReceiptCredentialRequestJson;
import org.whispersystems.signalservice.internal.push.CdsiAuthResponse;
import org.whispersystems.signalservice.internal.push.CheckRepeatedUsedPreKeysRequest;
import org.whispersystems.signalservice.internal.push.ConfirmUsernameRequest;
import org.whispersystems.signalservice.internal.push.ConfirmUsernameResponse;
import org.whispersystems.signalservice.internal.push.ContentRange;
import org.whispersystems.signalservice.internal.push.CreateCallLinkAuthRequest;
import org.whispersystems.signalservice.internal.push.CreateCallLinkAuthResponse;
import org.whispersystems.signalservice.internal.push.DeviceCode;
import org.whispersystems.signalservice.internal.push.DeviceId;
import org.whispersystems.signalservice.internal.push.DeviceInfoList;
import org.whispersystems.signalservice.internal.push.DeviceLimit;
import org.whispersystems.signalservice.internal.push.DeviceLimitExceededException;
import org.whispersystems.signalservice.internal.push.DonationProcessor;
import org.whispersystems.signalservice.internal.push.GcmRegistrationId;
import org.whispersystems.signalservice.internal.push.GetAciByUsernameResponse;
import org.whispersystems.signalservice.internal.push.GetUsernameFromLinkResponseBody;
import org.whispersystems.signalservice.internal.push.IdentityCheckRequest;
import org.whispersystems.signalservice.internal.push.IdentityCheckResponse;
import org.whispersystems.signalservice.internal.push.KyberPreKeyEntity;
import org.whispersystems.signalservice.internal.push.LinkDeviceRequest;
import org.whispersystems.signalservice.internal.push.LockedException;
import org.whispersystems.signalservice.internal.push.MismatchedDevices;
import org.whispersystems.signalservice.internal.push.NowhereBufferedSink;
import org.whispersystems.signalservice.internal.push.OneTimePreKeyCounts;
import org.whispersystems.signalservice.internal.push.OutgoingPushMessageList;
import org.whispersystems.signalservice.internal.push.PayPalConfirmOneTimePaymentIntentPayload;
import org.whispersystems.signalservice.internal.push.PayPalCreateOneTimePaymentIntentPayload;
import org.whispersystems.signalservice.internal.push.PayPalCreatePaymentMethodPayload;
import org.whispersystems.signalservice.internal.push.PreKeyEntity;
import org.whispersystems.signalservice.internal.push.PreKeyResponse;
import org.whispersystems.signalservice.internal.push.PreKeyResponseItem;
import org.whispersystems.signalservice.internal.push.PreKeyState;
import org.whispersystems.signalservice.internal.push.ProfileAvatarData;
import org.whispersystems.signalservice.internal.push.ProfileAvatarUploadAttributes;
import org.whispersystems.signalservice.internal.push.ProofRequiredResponse;
import org.whispersystems.signalservice.internal.push.ProvisioningMessage;
import org.whispersystems.signalservice.internal.push.PushAttachmentData;
import org.whispersystems.signalservice.internal.push.ReceiptCredentialRequestJson;
import org.whispersystems.signalservice.internal.push.ReceiptCredentialResponseJson;
import org.whispersystems.signalservice.internal.push.RedeemArchivesReceiptRequest;
import org.whispersystems.signalservice.internal.push.RedeemDonationReceiptRequest;
import org.whispersystems.signalservice.internal.push.RegistrationSessionMetadataHeaders;
import org.whispersystems.signalservice.internal.push.RegistrationSessionMetadataJson;
import org.whispersystems.signalservice.internal.push.RegistrationSessionMetadataResponse;
import org.whispersystems.signalservice.internal.push.RegistrationSessionRequestBody;
import org.whispersystems.signalservice.internal.push.RemoteConfigResponse;
import org.whispersystems.signalservice.internal.push.ReserveUsernameRequest;
import org.whispersystems.signalservice.internal.push.ReserveUsernameResponse;
import org.whispersystems.signalservice.internal.push.SendGroupMessageResponse;
import org.whispersystems.signalservice.internal.push.SendMessageResponse;
import org.whispersystems.signalservice.internal.push.SenderCertificate;
import org.whispersystems.signalservice.internal.push.SetUsernameLinkRequestBody;
import org.whispersystems.signalservice.internal.push.SetUsernameLinkResponseBody;
import org.whispersystems.signalservice.internal.push.SignalServiceEnvelopeEntity;
import org.whispersystems.signalservice.internal.push.SignalServiceEnvelopeEntityList;
import org.whispersystems.signalservice.internal.push.SignalServiceMessagesResult;
import org.whispersystems.signalservice.internal.push.SpamTokenMessage;
import org.whispersystems.signalservice.internal.push.StaleDevices;
import org.whispersystems.signalservice.internal.push.StickerUploadAttributes;
import org.whispersystems.signalservice.internal.push.StickerUploadAttributesResponse;
import org.whispersystems.signalservice.internal.push.StripeOneTimePaymentIntentPayload;
import org.whispersystems.signalservice.internal.push.SubmitPushChallengePayload;
import org.whispersystems.signalservice.internal.push.SubmitRecaptchaChallengePayload;
import org.whispersystems.signalservice.internal.push.SubscriptionsConfiguration;
import org.whispersystems.signalservice.internal.push.UpdateVerificationSessionRequestBody;
import org.whispersystems.signalservice.internal.push.VerificationCodeFailureResponseBody;
import org.whispersystems.signalservice.internal.push.VerificationSessionMetadataRequestBody;
import org.whispersystems.signalservice.internal.push.VerifyAccountResponse;
import org.whispersystems.signalservice.internal.push.WhoAmIResponse;
import org.whispersystems.signalservice.internal.push.exceptions.CaptchaRejectedException;
import org.whispersystems.signalservice.internal.push.exceptions.ForbiddenException;
import org.whispersystems.signalservice.internal.push.exceptions.GroupExistsException;
import org.whispersystems.signalservice.internal.push.exceptions.GroupNotFoundException;
import org.whispersystems.signalservice.internal.push.exceptions.GroupPatchNotAcceptedException;
import org.whispersystems.signalservice.internal.push.exceptions.InAppPaymentProcessorError;
import org.whispersystems.signalservice.internal.push.exceptions.InAppPaymentReceiptCredentialError;
import org.whispersystems.signalservice.internal.push.exceptions.MismatchedDevicesException;
import org.whispersystems.signalservice.internal.push.exceptions.MissingCapabilitiesException;
import org.whispersystems.signalservice.internal.push.exceptions.NotInGroupException;
import org.whispersystems.signalservice.internal.push.exceptions.PaymentsRegionException;
import org.whispersystems.signalservice.internal.push.exceptions.StaleDevicesException;
import org.whispersystems.signalservice.internal.push.http.AcceptLanguagesUtil;
import org.whispersystems.signalservice.internal.push.http.CancelationSignal;
import org.whispersystems.signalservice.internal.push.http.DigestingRequestBody;
import org.whispersystems.signalservice.internal.push.http.NoCipherOutputStreamFactory;
import org.whispersystems.signalservice.internal.push.http.OutputStreamFactory;
import org.whispersystems.signalservice.internal.push.http.ResumableUploadSpec;
import org.whispersystems.signalservice.internal.push.http.StickerCipherOutputStreamFactory;
import org.whispersystems.signalservice.internal.storage.protos.ReadOperation;
import org.whispersystems.signalservice.internal.storage.protos.StorageItems;
import org.whispersystems.signalservice.internal.storage.protos.StorageManifest;
import org.whispersystems.signalservice.internal.storage.protos.WriteOperation;
import org.whispersystems.signalservice.internal.util.BlacklistingTrustManager;
import org.whispersystems.signalservice.internal.util.Hex;
import org.whispersystems.signalservice.internal.util.JsonUtil;
import org.whispersystems.signalservice.internal.util.Util;
import org.whispersystems.signalservice.internal.websocket.ResponseMapper;

public class PushServiceSocket
implements Closeable {
    private static final String TAG = PushServiceSocket.class.getSimpleName();
    private static final String REGISTER_GCM_PATH = "/v1/accounts/gcm/";
    private static final String SET_ACCOUNT_ATTRIBUTES = "/v1/accounts/attributes/";
    private static final String PIN_PATH = "/v1/accounts/pin/";
    private static final String REGISTRATION_LOCK_PATH = "/v1/accounts/registration_lock";
    private static final String WHO_AM_I = "/v1/accounts/whoami";
    private static final String GET_USERNAME_PATH = "/v1/accounts/username_hash/%s";
    private static final String MODIFY_USERNAME_PATH = "/v1/accounts/username_hash";
    private static final String RESERVE_USERNAME_PATH = "/v1/accounts/username_hash/reserve";
    private static final String CONFIRM_USERNAME_PATH = "/v1/accounts/username_hash/confirm";
    private static final String USERNAME_LINK_PATH = "/v1/accounts/username_link";
    private static final String USERNAME_FROM_LINK_PATH = "/v1/accounts/username_link/%s";
    private static final String DELETE_ACCOUNT_PATH = "/v1/accounts/me";
    private static final String CHANGE_NUMBER_PATH = "/v2/accounts/number";
    private static final String IDENTIFIER_REGISTERED_PATH = "/v1/accounts/account/%s";
    private static final String REQUEST_ACCOUNT_DATA_PATH = "/v2/accounts/data_report";
    private static final String PNI_KEY_DISTRUBTION_PATH = "/v2/accounts/phone_number_identity_key_distribution";
    private static final String PREKEY_METADATA_PATH = "/v2/keys?identity=%s";
    private static final String PREKEY_PATH = "/v2/keys?identity=%s";
    private static final String PREKEY_DEVICE_PATH = "/v2/keys/%s/%s";
    private static final String PREKEY_CHECK_PATH = "/v2/keys/check";
    private static final String TURN_SERVER_INFO = "/v1/calling/relays";
    private static final String PROVISIONING_CODE_PATH = "/v1/devices/provisioning/code";
    private static final String PROVISIONING_MESSAGE_PATH = "/v1/provisioning/%s";
    private static final String DEVICE_PATH = "/v1/devices/%s";
    private static final String DEVICE_LINK_PATH = "/v1/devices/link";
    private static final String MESSAGE_PATH = "/v1/messages/%s";
    private static final String GROUP_MESSAGE_PATH = "/v1/messages/multi_recipient?ts=%s&online=%s&urgent=%s&story=%s";
    private static final String SENDER_ACK_MESSAGE_PATH = "/v1/messages/%s/%d";
    private static final String UUID_ACK_MESSAGE_PATH = "/v1/messages/uuid/%s";
    private static final String ATTACHMENT_V4_PATH = "/v4/attachments/form/upload";
    private static final String STICKER_UPLOAD_PATH = "/v1/sticker/pack/form/%d";
    private static final String PAYMENTS_AUTH_PATH = "/v1/payments/auth";
    private static final String PROFILE_PATH = "/v1/profile/%s";
    private static final String PROFILE_BATCH_CHECK_PATH = "/v1/profile/identity_check/batch";
    private static final String SENDER_CERTIFICATE_PATH = "/v1/certificate/delivery";
    private static final String SENDER_CERTIFICATE_NO_E164_PATH = "/v1/certificate/delivery?includeE164=false";
    private static final String ATTACHMENT_KEY_DOWNLOAD_PATH = "attachments/%s";
    private static final String ATTACHMENT_ID_DOWNLOAD_PATH = "attachments/%d";
    private static final String ATTACHMENT_UPLOAD_PATH = "attachments/";
    private static final String AVATAR_UPLOAD_PATH = "";
    private static final String STICKER_MANIFEST_PATH = "stickers/%s/manifest.proto";
    private static final String STICKER_PATH = "stickers/%s/full/%d";
    private static final String GROUPSV2_CREDENTIAL = "/v1/certificate/auth/group?redemptionStartSeconds=%d&redemptionEndSeconds=%d&zkcCredential=true";
    private static final String GROUPSV2_GROUP = "/v2/groups/";
    private static final String GROUPSV2_GROUP_PASSWORD = "/v2/groups/?inviteLinkPassword=%s";
    private static final String GROUPSV2_GROUP_CHANGES = "/v2/groups/logs/%s?maxSupportedChangeEpoch=%d&includeFirstState=%s&includeLastState=false";
    private static final String GROUPSV2_AVATAR_REQUEST = "/v2/groups/avatar/form";
    private static final String GROUPSV2_GROUP_JOIN = "/v2/groups/join/%s";
    private static final String GROUPSV2_TOKEN = "/v2/groups/token";
    private static final String GROUPSV2_JOINED_AT = "/v2/groups/joined_at_version";
    private static final String PAYMENTS_CONVERSIONS = "/v1/payments/conversions";
    private static final String SUBMIT_RATE_LIMIT_CHALLENGE = "/v1/challenge";
    private static final String REQUEST_RATE_LIMIT_PUSH_CHALLENGE = "/v1/challenge/push";
    private static final String DONATION_REDEEM_RECEIPT = "/v1/donation/redeem-receipt";
    private static final String ARCHIVES_REDEEM_RECEIPT = "/v1/archives/redeem-receipt";
    private static final String UPDATE_SUBSCRIPTION_LEVEL = "/v1/subscription/%s/level/%s/%s/%s";
    private static final String SUBSCRIPTION = "/v1/subscription/%s";
    private static final String CREATE_STRIPE_SUBSCRIPTION_PAYMENT_METHOD = "/v1/subscription/%s/create_payment_method?type=%s";
    private static final String CREATE_PAYPAL_SUBSCRIPTION_PAYMENT_METHOD = "/v1/subscription/%s/create_payment_method/paypal";
    private static final String DEFAULT_STRIPE_SUBSCRIPTION_PAYMENT_METHOD = "/v1/subscription/%s/default_payment_method/stripe/%s";
    private static final String DEFAULT_IDEAL_SUBSCRIPTION_PAYMENT_METHOD = "/v1/subscription/%s/default_payment_method_for_ideal/%s";
    private static final String DEFAULT_PAYPAL_SUBSCRIPTION_PAYMENT_METHOD = "/v1/subscription/%s/default_payment_method/braintree/%s";
    private static final String SUBSCRIPTION_RECEIPT_CREDENTIALS = "/v1/subscription/%s/receipt_credentials";
    private static final String CREATE_STRIPE_ONE_TIME_PAYMENT_INTENT = "/v1/subscription/boost/create";
    private static final String CREATE_PAYPAL_ONE_TIME_PAYMENT_INTENT = "/v1/subscription/boost/paypal/create";
    private static final String CONFIRM_PAYPAL_ONE_TIME_PAYMENT_INTENT = "/v1/subscription/boost/paypal/confirm";
    private static final String BOOST_RECEIPT_CREDENTIALS = "/v1/subscription/boost/receipt_credentials";
    private static final String DONATIONS_CONFIGURATION = "/v1/subscription/configuration";
    private static final String BANK_MANDATE = "/v1/subscription/bank_mandate/%s";
    private static final String LINK_PLAY_BILLING_PURCHASE_TOKEN = "/v1/subscription/%s/playbilling/%s";
    private static final String VERIFICATION_SESSION_PATH = "/v1/verification/session";
    private static final String VERIFICATION_CODE_PATH = "/v1/verification/session/%s/code";
    private static final String REGISTRATION_PATH = "/v1/registration";
    private static final String CDSI_AUTH = "/v2/directory/auth";
    private static final String SVR2_AUTH = "/v2/backup/auth";
    private static final String SVR3_AUTH = "/v3/backup/auth";
    private static final String REPORT_SPAM = "/v1/messages/report/%s/%s";
    private static final String BACKUP_AUTH_CHECK_V2 = "/v2/backup/auth/check";
    private static final String BACKUP_AUTH_CHECK_V3 = "/v3/backup/auth/check";
    private static final String ARCHIVE_CREDENTIALS = "/v1/archives/auth?redemptionStartSeconds=%d&redemptionEndSeconds=%d";
    private static final String ARCHIVE_READ_CREDENTIALS = "/v1/archives/auth/read?cdn=%d";
    private static final String ARCHIVE_BACKUP_ID = "/v1/archives/backupid";
    private static final String ARCHIVE_PUBLIC_KEY = "/v1/archives/keys";
    private static final String ARCHIVE_INFO = "/v1/archives";
    private static final String ARCHIVE_MESSAGE_UPLOAD_FORM = "/v1/archives/upload/form";
    private static final String ARCHIVE_MEDIA_UPLOAD_FORM = "/v1/archives/media/upload/form";
    private static final String ARCHIVE_MEDIA = "/v1/archives/media";
    private static final String ARCHIVE_MEDIA_LIST = "/v1/archives/media?limit=%d";
    private static final String ARCHIVE_MEDIA_BATCH = "/v1/archives/media/batch";
    private static final String ARCHIVE_MEDIA_DELETE = "/v1/archives/media/delete";
    private static final String ARCHIVE_MEDIA_DOWNLOAD_PATH = "backups/%s/%s/%s";
    private static final String SET_SHARE_SET_PATH = "/v3/backup/share-set";
    private static final String CALL_LINK_CREATION_AUTH = "/v1/call-link/create-auth";
    private static final String SERVER_DELIVERED_TIMESTAMP_HEADER = "X-Signal-Timestamp";
    private static final Map<String, String> NO_HEADERS = Collections.emptyMap();
    private static final ResponseCodeHandler NO_HANDLER = new EmptyResponseCodeHandler();
    private static final ResponseCodeHandler UNOPINIONATED_HANDLER = new UnopinionatedResponseCodeHandler();
    public static final long CDN2_RESUMABLE_LINK_LIFETIME_MILLIS = TimeUnit.DAYS.toMillis(7L);
    private static final int MAX_FOLLOW_UPS = 20;
    private long soTimeoutMillis = TimeUnit.SECONDS.toMillis(30L);
    private final Set<Call> connections = new HashSet<Call>();
    private final ServiceConnectionHolder[] serviceClients;
    private final Map<Integer, ConnectionHolder[]> cdnClientsMap;
    private final ConnectionHolder[] storageClients;
    private final SignalServiceConfiguration configuration;
    private final CredentialsProvider credentialsProvider;
    private final String signalAgent;
    private final SecureRandom random;
    private final ClientZkProfileOperations clientZkProfileOperations;
    private final boolean automaticNetworkRetry;
    private static final ResponseCodeHandler NEW_DEVICE_PUT_RESPONSE_HANDLER = (responseCode, body) -> {
        if (responseCode == 409) {
            throw new MissingCapabilitiesException();
        }
    };
    private static final ResponseCodeHandler SUBMIT_RATE_LIMIT_CHALLENGE_RESPONSE_HANDLER = (responseCode, body) -> {
        if (responseCode == 428) {
            throw new CaptchaRejectedException();
        }
    };
    private static final ResponseCodeHandler GROUPS_V2_PUT_RESPONSE_HANDLER = (responseCode, body) -> {
        if (responseCode == 409) {
            throw new GroupExistsException();
        }
    };
    private static final ResponseCodeHandler GROUPS_V2_GET_CURRENT_HANDLER = (responseCode, body) -> {
        switch (responseCode) {
            case 403: {
                throw new NotInGroupException();
            }
            case 404: {
                throw new GroupNotFoundException();
            }
        }
    };
    private static final ResponseCodeHandler GROUPS_V2_PATCH_RESPONSE_HANDLER = (responseCode, body) -> {
        if (responseCode == 400) {
            throw new GroupPatchNotAcceptedException();
        }
    };
    private static final ResponseCodeHandler GROUPS_V2_GET_JOIN_INFO_HANDLER = new ResponseCodeHandler(){

        @Override
        public void handle(int responseCode, ResponseBody body) throws NonSuccessfulResponseCodeException {
            if (responseCode == 403) {
                throw new ForbiddenException();
            }
        }

        @Override
        public void handle(int responseCode, ResponseBody body, Function<String, String> getHeader) throws NonSuccessfulResponseCodeException {
            if (responseCode == 403) {
                throw new ForbiddenException(Optional.ofNullable(getHeader.apply("X-Signal-Forbidden-Reason")));
            }
        }
    };

    public PushServiceSocket(SignalServiceConfiguration configuration, CredentialsProvider credentialsProvider, String signalAgent, ClientZkProfileOperations clientZkProfileOperations, boolean automaticNetworkRetry) {
        this.configuration = configuration;
        this.credentialsProvider = credentialsProvider;
        this.signalAgent = signalAgent;
        this.automaticNetworkRetry = automaticNetworkRetry;
        this.serviceClients = this.createServiceConnectionHolders(configuration.getSignalServiceUrls(), configuration.getNetworkInterceptors(), configuration.getDns(), configuration.getSignalProxy());
        this.cdnClientsMap = PushServiceSocket.createCdnClientsMap(configuration.getSignalCdnUrlMap(), configuration.getNetworkInterceptors(), configuration.getDns(), configuration.getSignalProxy());
        this.storageClients = PushServiceSocket.createConnectionHolders(configuration.getSignalStorageUrls(), configuration.getNetworkInterceptors(), configuration.getDns(), configuration.getSignalProxy());
        this.random = new SecureRandom();
        this.clientZkProfileOperations = clientZkProfileOperations;
    }

    public SignalServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public RegistrationSessionMetadataResponse createVerificationSession(@Nullable String pushToken, @Nullable String mcc, @Nullable String mnc) throws IOException {
        String jsonBody = JsonUtil.toJson(new VerificationSessionMetadataRequestBody(this.credentialsProvider.getE164(), pushToken, mcc, mnc));
        try (Response response = this.makeServiceRequest(VERIFICATION_SESSION_PATH, "POST", PushServiceSocket.jsonRequestBody(jsonBody), NO_HEADERS, new RegistrationSessionResponseHandler(), SealedSenderAccess.NONE, false);){
            RegistrationSessionMetadataResponse registrationSessionMetadataResponse = PushServiceSocket.parseSessionMetadataResponse(response);
            return registrationSessionMetadataResponse;
        }
    }

    public RegistrationSessionMetadataResponse getSessionStatus(String sessionId) throws IOException {
        String path = "/v1/verification/session/" + sessionId;
        try (Response response = this.makeServiceRequest(path, "GET", PushServiceSocket.jsonRequestBody(null), NO_HEADERS, new RegistrationSessionResponseHandler(), SealedSenderAccess.NONE, false);){
            RegistrationSessionMetadataResponse registrationSessionMetadataResponse = PushServiceSocket.parseSessionMetadataResponse(response);
            return registrationSessionMetadataResponse;
        }
    }

    public RegistrationSessionMetadataResponse patchVerificationSession(String sessionId, @Nullable String pushToken, @Nullable String mcc, @Nullable String mnc, @Nullable String captchaToken, @Nullable String pushChallengeToken) throws IOException {
        String path = "/v1/verification/session/" + sessionId;
        UpdateVerificationSessionRequestBody requestBody = new UpdateVerificationSessionRequestBody(captchaToken, pushToken, pushChallengeToken, mcc, mnc);
        try (Response response = this.makeServiceRequest(path, "PATCH", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(requestBody)), NO_HEADERS, new PatchRegistrationSessionResponseHandler(), SealedSenderAccess.NONE, false);){
            RegistrationSessionMetadataResponse registrationSessionMetadataResponse = PushServiceSocket.parseSessionMetadataResponse(response);
            return registrationSessionMetadataResponse;
        }
    }

    public RegistrationSessionMetadataResponse requestVerificationCode(String sessionId, Locale locale, boolean androidSmsRetriever, VerificationCodeTransport transport) throws IOException {
        String path = String.format(VERIFICATION_CODE_PATH, sessionId);
        Map<String, String> headers = locale != null ? Collections.singletonMap("Accept-Language", locale.getLanguage() + "-" + locale.getCountry()) : NO_HEADERS;
        HashMap<String, String> body = new HashMap<String, String>();
        switch (transport.ordinal()) {
            case 0: {
                body.put("transport", "sms");
                break;
            }
            case 1: {
                body.put("transport", "voice");
            }
        }
        body.put("client", androidSmsRetriever ? "android-2021-03" : "android");
        try (Response response = this.makeServiceRequest(path, "POST", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(body)), headers, new RegistrationCodeRequestResponseHandler(), SealedSenderAccess.NONE, false);){
            RegistrationSessionMetadataResponse registrationSessionMetadataResponse = PushServiceSocket.parseSessionMetadataResponse(response);
            return registrationSessionMetadataResponse;
        }
    }

    public RegistrationSessionMetadataResponse submitVerificationCode(String sessionId, String verificationCode) throws IOException {
        String path = String.format(VERIFICATION_CODE_PATH, sessionId);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("code", verificationCode);
        try (Response response = this.makeServiceRequest(path, "PUT", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(body)), NO_HEADERS, new RegistrationCodeSubmissionResponseHandler(), SealedSenderAccess.NONE, false);){
            RegistrationSessionMetadataResponse registrationSessionMetadataResponse = PushServiceSocket.parseSessionMetadataResponse(response);
            return registrationSessionMetadataResponse;
        }
    }

    public VerifyAccountResponse submitRegistrationRequest(@Nullable String sessionId, @Nullable String recoveryPassword, AccountAttributes attributes, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys, @Nullable String fcmToken, boolean skipDeviceTransfer) throws IOException {
        RegistrationSessionRequestBody body;
        String path = REGISTRATION_PATH;
        if (sessionId == null && recoveryPassword == null) {
            throw new IllegalArgumentException("Neither Session ID nor Recovery Password provided.");
        }
        if (sessionId != null && recoveryPassword != null) {
            throw new IllegalArgumentException("You must supply one and only one of either: Session ID, or Recovery Password.");
        }
        GcmRegistrationId gcmRegistrationId = attributes.getFetchesMessages() ? null : new GcmRegistrationId(fcmToken, true);
        try {
            SignedPreKeyEntity aciSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(aciPreKeys.getSignedPreKey()).getId(), aciPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), aciPreKeys.getSignedPreKey().getSignature());
            SignedPreKeyEntity pniSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(pniPreKeys.getSignedPreKey()).getId(), pniPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), pniPreKeys.getSignedPreKey().getSignature());
            KyberPreKeyEntity aciLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(aciPreKeys.getLastResortKyberPreKey()).getId(), aciPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), aciPreKeys.getLastResortKyberPreKey().getSignature());
            KyberPreKeyEntity pniLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(pniPreKeys.getLastResortKyberPreKey()).getId(), pniPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), pniPreKeys.getLastResortKyberPreKey().getSignature());
            body = new RegistrationSessionRequestBody(sessionId, recoveryPassword, attributes, Base64.encodeWithoutPadding((byte[])aciPreKeys.getIdentityKey().serialize()), Base64.encodeWithoutPadding((byte[])pniPreKeys.getIdentityKey().serialize()), aciSignedPreKey, pniSignedPreKey, aciLastResortKyberPreKey, pniLastResortKyberPreKey, gcmRegistrationId, skipDeviceTransfer, true);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError("unexpected invalid key", e);
        }
        String response = this.makeServiceRequest(path, "POST", JsonUtil.toJson(body), NO_HEADERS, new RegistrationSessionResponseHandler(), SealedSenderAccess.NONE);
        return JsonUtil.fromJson(response, VerifyAccountResponse.class);
    }

    public WhoAmIResponse getWhoAmI() throws IOException {
        return JsonUtil.fromJson(this.makeServiceRequest(WHO_AM_I, "GET", null), WhoAmIResponse.class);
    }

    public boolean isIdentifierRegistered(ServiceId identifier) throws IOException {
        try {
            this.makeServiceRequestWithoutAuthentication(String.format(IDENTIFIER_REGISTERED_PATH, identifier.toString()), "HEAD", null);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public String getAccountDataReport() throws IOException {
        return this.makeServiceRequest(REQUEST_ACCOUNT_DATA_PATH, "GET", null);
    }

    public CdsiAuthResponse getCdsiAuth() throws IOException {
        String body = this.makeServiceRequest(CDSI_AUTH, "GET", null);
        return JsonUtil.fromJsonResponse(body, CdsiAuthResponse.class);
    }

    public AuthCredentials getSvr2Authorization() throws IOException {
        String body = this.makeServiceRequest(SVR2_AUTH, "GET", null);
        AuthCredentials credentials = JsonUtil.fromJsonResponse(body, AuthCredentials.class);
        return credentials;
    }

    public Svr3Credentials getSvr3Authorization() throws IOException {
        String body = this.makeServiceRequest(SVR3_AUTH, "GET", null);
        return JsonUtil.fromJsonResponse(body, Svr3Credentials.class);
    }

    public ArchiveServiceCredentialsResponse getArchiveCredentials(long currentTime) throws IOException {
        long secondsRoundedToNearestDay = TimeUnit.DAYS.toSeconds(TimeUnit.MILLISECONDS.toDays(currentTime));
        long endTimeInSeconds = secondsRoundedToNearestDay + TimeUnit.DAYS.toSeconds(7L);
        String response = this.makeServiceRequest(String.format(Locale.US, ARCHIVE_CREDENTIALS, secondsRoundedToNearestDay, endTimeInSeconds), "GET", null, NO_HEADERS, UNOPINIONATED_HANDLER, SealedSenderAccess.NONE);
        return JsonUtil.fromJson(response, ArchiveServiceCredentialsResponse.class);
    }

    public void setArchiveBackupId(BackupAuthCredentialRequest request) throws IOException {
        String body = JsonUtil.toJson(new ArchiveSetBackupIdRequest(request));
        this.makeServiceRequest(ARCHIVE_BACKUP_ID, "PUT", body, NO_HEADERS, UNOPINIONATED_HANDLER, SealedSenderAccess.NONE);
    }

    public void setArchivePublicKey(ECPublicKey publicKey, ArchiveCredentialPresentation credentialPresentation) throws IOException {
        Map<String, String> headers = credentialPresentation.toHeaders();
        String body = JsonUtil.toJson(new ArchiveSetPublicKeyRequest(publicKey));
        this.makeServiceRequestWithoutAuthentication(ARCHIVE_PUBLIC_KEY, "PUT", body, headers, NO_HANDLER);
    }

    public ArchiveGetBackupInfoResponse getArchiveBackupInfo(ArchiveCredentialPresentation credentialPresentation) throws IOException {
        Map<String, String> headers = credentialPresentation.toHeaders();
        String response = this.makeServiceRequestWithoutAuthentication(ARCHIVE_INFO, "GET", null, headers, NO_HANDLER);
        return JsonUtil.fromJson(response, ArchiveGetBackupInfoResponse.class);
    }

    public List<ArchiveGetMediaItemsResponse.StoredMediaObject> debugGetAllArchiveMediaItems(ArchiveCredentialPresentation credentialPresentation) throws IOException {
        ArchiveGetMediaItemsResponse response;
        ArrayList<ArchiveGetMediaItemsResponse.StoredMediaObject> mediaObjects = new ArrayList<ArchiveGetMediaItemsResponse.StoredMediaObject>();
        String cursor = null;
        do {
            response = this.getArchiveMediaItemsPage(credentialPresentation, 512, cursor);
            mediaObjects.addAll(response.getStoredMediaObjects());
        } while ((cursor = response.getCursor()) != null);
        return mediaObjects;
    }

    public ArchiveGetMediaItemsResponse getArchiveMediaItemsPage(ArchiveCredentialPresentation credentialPresentation, int limit, String cursor) throws IOException {
        Map<String, String> headers = credentialPresentation.toHeaders();
        Object url = String.format(Locale.US, ARCHIVE_MEDIA_LIST, limit);
        if (cursor != null) {
            url = (String)url + "&cursor=" + cursor;
        }
        String response = this.makeServiceRequestWithoutAuthentication((String)url, "GET", null, headers, NO_HANDLER);
        return JsonUtil.fromJson(response, ArchiveGetMediaItemsResponse.class);
    }

    public ArchiveMediaResponse archiveAttachmentMedia(@Nonnull ArchiveCredentialPresentation credentialPresentation, @Nonnull ArchiveMediaRequest request) throws IOException {
        Map<String, String> headers = credentialPresentation.toHeaders();
        String response = this.makeServiceRequestWithoutAuthentication(ARCHIVE_MEDIA, "PUT", JsonUtil.toJson(request), headers, UNOPINIONATED_HANDLER);
        return JsonUtil.fromJson(response, ArchiveMediaResponse.class);
    }

    public BatchArchiveMediaResponse archiveAttachmentMedia(@Nonnull ArchiveCredentialPresentation credentialPresentation, @Nonnull BatchArchiveMediaRequest request) throws IOException {
        Map<String, String> headers = credentialPresentation.toHeaders();
        String response = this.makeServiceRequestWithoutAuthentication(ARCHIVE_MEDIA_BATCH, "PUT", JsonUtil.toJson(request), headers, UNOPINIONATED_HANDLER);
        return JsonUtil.fromJson(response, BatchArchiveMediaResponse.class);
    }

    public void deleteArchivedMedia(@Nonnull ArchiveCredentialPresentation credentialPresentation, @Nonnull DeleteArchivedMediaRequest request) throws IOException {
        Map<String, String> headers = credentialPresentation.toHeaders();
        this.makeServiceRequestWithoutAuthentication(ARCHIVE_MEDIA_DELETE, "POST", JsonUtil.toJson(request), headers, NO_HANDLER);
    }

    public AttachmentUploadForm getArchiveMessageBackupUploadForm(ArchiveCredentialPresentation credentialPresentation) throws IOException {
        Map<String, String> headers = credentialPresentation.toHeaders();
        String response = this.makeServiceRequestWithoutAuthentication(ARCHIVE_MESSAGE_UPLOAD_FORM, "GET", null, headers, NO_HANDLER);
        return JsonUtil.fromJson(response, AttachmentUploadForm.class);
    }

    public AttachmentUploadForm getArchiveMediaUploadForm(@NotNull ArchiveCredentialPresentation credentialPresentation) throws IOException {
        Map<String, String> headers = credentialPresentation.toHeaders();
        String response = this.makeServiceRequestWithoutAuthentication(ARCHIVE_MEDIA_UPLOAD_FORM, "GET", null, headers, UNOPINIONATED_HANDLER);
        return JsonUtil.fromJson(response, AttachmentUploadForm.class);
    }

    public GetArchiveCdnCredentialsResponse getArchiveCdnReadCredentials(int cdnNumber, @Nonnull ArchiveCredentialPresentation credentialPresentation) throws IOException {
        Map<String, String> headers = credentialPresentation.toHeaders();
        String response = this.makeServiceRequestWithoutAuthentication(String.format(Locale.US, ARCHIVE_READ_CREDENTIALS, cdnNumber), "GET", null, headers, NO_HANDLER);
        return JsonUtil.fromJson(response, GetArchiveCdnCredentialsResponse.class);
    }

    public void setShareSet(byte[] shareSet) throws IOException {
        SetShareSetRequest request = new SetShareSetRequest(shareSet);
        this.makeServiceRequest(SET_SHARE_SET_PATH, "PUT", JsonUtil.toJson(request));
    }

    public VerifyAccountResponse changeNumber(@Nonnull ChangePhoneNumberRequest changePhoneNumberRequest) throws IOException {
        String requestBody = JsonUtil.toJson(changePhoneNumberRequest);
        String responseBody = this.makeServiceRequest(CHANGE_NUMBER_PATH, "PUT", requestBody);
        return JsonUtil.fromJson(responseBody, VerifyAccountResponse.class);
    }

    public VerifyAccountResponse distributePniKeys(@NonNull PniKeyDistributionRequest distributionRequest) throws IOException {
        String request = JsonUtil.toJson(distributionRequest);
        String response = this.makeServiceRequest(PNI_KEY_DISTRUBTION_PATH, "PUT", request);
        return JsonUtil.fromJson(response, VerifyAccountResponse.class);
    }

    public void setAccountAttributes(@Nonnull AccountAttributes accountAttributes) throws IOException {
        this.makeServiceRequest(SET_ACCOUNT_ATTRIBUTES, "PUT", JsonUtil.toJson(accountAttributes));
    }

    public int finishNewDeviceRegistration(String provisioningCode, AccountAttributes accountAttributes, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys) throws IOException {
        LinkDeviceRequest linkDeviceRequest;
        try {
            SignedPreKeyEntity aciSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(aciPreKeys.getSignedPreKey()).getId(), aciPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), aciPreKeys.getSignedPreKey().getSignature());
            SignedPreKeyEntity pniSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(pniPreKeys.getSignedPreKey()).getId(), pniPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), pniPreKeys.getSignedPreKey().getSignature());
            KyberPreKeyEntity aciLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(aciPreKeys.getLastResortKyberPreKey()).getId(), aciPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), aciPreKeys.getLastResortKyberPreKey().getSignature());
            KyberPreKeyEntity pniLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(pniPreKeys.getLastResortKyberPreKey()).getId(), pniPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), pniPreKeys.getLastResortKyberPreKey().getSignature());
            linkDeviceRequest = new LinkDeviceRequest(provisioningCode, accountAttributes, aciSignedPreKey, pniSignedPreKey, aciLastResortKyberPreKey, pniLastResortKyberPreKey);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError("unexpected invalid key", e);
        }
        String json = JsonUtil.toJson(linkDeviceRequest);
        String responseText = this.makeServiceRequest(DEVICE_LINK_PATH, "PUT", json, NO_HEADERS, NEW_DEVICE_PUT_RESPONSE_HANDLER, null);
        DeviceId response = JsonUtil.fromJson(responseText, DeviceId.class);
        return response.getDeviceId();
    }

    public String getNewDeviceVerificationCode() throws IOException {
        String responseText = this.makeServiceRequest(PROVISIONING_CODE_PATH, "GET", null);
        return JsonUtil.fromJson(responseText, DeviceCode.class).getVerificationCode();
    }

    public List<DeviceInfo> getDevices() throws IOException {
        String responseText = this.makeServiceRequest(String.format(DEVICE_PATH, AVATAR_UPLOAD_PATH), "GET", null);
        return JsonUtil.fromJson(responseText, DeviceInfoList.class).getDevices();
    }

    public void removeDevice(int deviceId) throws IOException {
        this.makeServiceRequest(String.format(DEVICE_PATH, String.valueOf(deviceId)), "DELETE", null);
    }

    public void sendProvisioningMessage(String destination, byte[] body) throws IOException {
        this.makeServiceRequest(String.format(PROVISIONING_MESSAGE_PATH, URLEncoder.encode(destination, StandardCharsets.UTF_8.name())), "PUT", JsonUtil.toJson(new ProvisioningMessage(Base64.encodeWithPadding((byte[])body))));
    }

    public void registerGcmId(@Nonnull String gcmRegistrationId) throws IOException {
        GcmRegistrationId registration = new GcmRegistrationId(gcmRegistrationId, true);
        this.makeServiceRequest(REGISTER_GCM_PATH, "PUT", JsonUtil.toJson(registration));
    }

    public void unregisterGcmId() throws IOException {
        this.makeServiceRequest(REGISTER_GCM_PATH, "DELETE", null);
    }

    public void requestPushChallenge(String sessionId, String gcmRegistrationId) throws IOException {
        this.patchVerificationSession(sessionId, gcmRegistrationId, null, null, null, null);
    }

    public void removeRegistrationLockV1() throws IOException {
        this.makeServiceRequest(PIN_PATH, "DELETE", null);
    }

    public void setRegistrationLockV2(String registrationLock) throws IOException {
        RegistrationLockV2 accountLock = new RegistrationLockV2(registrationLock);
        this.makeServiceRequest(REGISTRATION_LOCK_PATH, "PUT", JsonUtil.toJson(accountLock));
    }

    public void disableRegistrationLockV2() throws IOException {
        this.makeServiceRequest(REGISTRATION_LOCK_PATH, "DELETE", null);
    }

    public byte[] getSenderCertificate() throws IOException {
        String responseText = this.makeServiceRequest(SENDER_CERTIFICATE_PATH, "GET", null);
        return JsonUtil.fromJson(responseText, SenderCertificate.class).getCertificate();
    }

    public byte[] getUuidOnlySenderCertificate() throws IOException {
        String responseText = this.makeServiceRequest(SENDER_CERTIFICATE_NO_E164_PATH, "GET", null);
        return JsonUtil.fromJson(responseText, SenderCertificate.class).getCertificate();
    }

    /*
     * Exception decompiling
     */
    public SendGroupMessageResponse sendGroupMessage(byte[] body, @Nonnull SealedSenderAccess sealedSenderAccess, long timestamp, boolean online, boolean urgent, boolean story) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SendMessageResponse sendMessage(OutgoingPushMessageList bundle, @Nullable SealedSenderAccess sealedSenderAccess, boolean story) throws IOException {
        try {
            String responseText = this.makeServiceRequest(String.format("/v1/messages/%s?story=%s", bundle.getDestination(), story ? "true" : "false"), "PUT", JsonUtil.toJson(bundle), NO_HEADERS, NO_HANDLER, sealedSenderAccess);
            SendMessageResponse response = JsonUtil.fromJson(responseText, SendMessageResponse.class);
            response.setSentUnidentfied(sealedSenderAccess != null);
            return response;
        }
        catch (NotFoundException nfe) {
            throw new UnregisteredUserException(bundle.getDestination(), nfe);
        }
    }

    public SignalServiceMessagesResult getMessages(boolean allowStories) throws IOException {
        Map<String, String> headers = Collections.singletonMap("X-Signal-Receive-Stories", allowStories ? "true" : "false");
        try (Response response = this.makeServiceRequest(String.format(MESSAGE_PATH, AVATAR_UPLOAD_PATH), "GET", null, headers, NO_HANDLER, SealedSenderAccess.NONE, false);){
            this.validateServiceResponse(response);
            List<SignalServiceEnvelopeEntity> envelopes = PushServiceSocket.readBodyJson(response.body(), SignalServiceEnvelopeEntityList.class).getMessages();
            long serverDeliveredTimestamp = 0L;
            try {
                String stringValue = response.header(SERVER_DELIVERED_TIMESTAMP_HEADER);
                stringValue = stringValue != null ? stringValue : "0";
                serverDeliveredTimestamp = Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            SignalServiceMessagesResult signalServiceMessagesResult = new SignalServiceMessagesResult(envelopes, serverDeliveredTimestamp);
            return signalServiceMessagesResult;
        }
    }

    public void acknowledgeMessage(String sender, long timestamp) throws IOException {
        this.makeServiceRequest(String.format(Locale.US, SENDER_ACK_MESSAGE_PATH, sender, timestamp), "DELETE", null);
    }

    public void acknowledgeMessage(String uuid) throws IOException {
        this.makeServiceRequest(String.format(UUID_ACK_MESSAGE_PATH, uuid), "DELETE", null);
    }

    public void registerPreKeys(PreKeyUpload preKeyUpload) throws IOException {
        SignedPreKeyEntity signedPreKey = null;
        List<PreKeyEntity> oneTimeEcPreKeys = null;
        KyberPreKeyEntity lastResortKyberPreKey = null;
        List<KyberPreKeyEntity> oneTimeKyberPreKeys = null;
        try {
            if (preKeyUpload.getSignedPreKey() != null) {
                signedPreKey = new SignedPreKeyEntity(preKeyUpload.getSignedPreKey().getId(), preKeyUpload.getSignedPreKey().getKeyPair().getPublicKey(), preKeyUpload.getSignedPreKey().getSignature());
            }
        }
        catch (InvalidKeyException e) {
            throw new AssertionError("unexpected invalid key", e);
        }
        if (preKeyUpload.getOneTimeEcPreKeys() != null) {
            oneTimeEcPreKeys = preKeyUpload.getOneTimeEcPreKeys().stream().map(it -> {
                try {
                    return new PreKeyEntity(it.getId(), it.getKeyPair().getPublicKey());
                }
                catch (InvalidKeyException e) {
                    throw new AssertionError("unexpected invalid key", e);
                }
            }).collect(Collectors.toList());
        }
        if (preKeyUpload.getLastResortKyberPreKey() != null) {
            try {
                lastResortKyberPreKey = new KyberPreKeyEntity(preKeyUpload.getLastResortKyberPreKey().getId(), preKeyUpload.getLastResortKyberPreKey().getKeyPair().getPublicKey(), preKeyUpload.getLastResortKyberPreKey().getSignature());
            }
            catch (InvalidKeyException e) {
                throw new AssertionError("unexpected invalid key", e);
            }
        }
        if (preKeyUpload.getOneTimeKyberPreKeys() != null) {
            oneTimeKyberPreKeys = preKeyUpload.getOneTimeKyberPreKeys().stream().map(it -> {
                try {
                    return new KyberPreKeyEntity(it.getId(), it.getKeyPair().getPublicKey(), it.getSignature());
                }
                catch (InvalidKeyException e) {
                    throw new AssertionError("unexpected invalid key", e);
                }
            }).collect(Collectors.toList());
        }
        this.makeServiceRequest(String.format(Locale.US, "/v2/keys?identity=%s", preKeyUpload.getServiceIdType().queryParam()), "PUT", JsonUtil.toJson(new PreKeyState(signedPreKey, oneTimeEcPreKeys, lastResortKyberPreKey, oneTimeKyberPreKeys)));
    }

    public OneTimePreKeyCounts getAvailablePreKeys(ServiceIdType serviceIdType) throws IOException {
        String path = String.format("/v2/keys?identity=%s", serviceIdType.queryParam());
        String responseText = this.makeServiceRequest(path, "GET", null);
        OneTimePreKeyCounts preKeyStatus = JsonUtil.fromJson(responseText, OneTimePreKeyCounts.class);
        return preKeyStatus;
    }

    public List<PreKeyBundle> getPreKeys(SignalServiceAddress destination, @Nullable SealedSenderAccess sealedSenderAccess, int deviceId) throws IOException {
        return this.getPreKeysBySpecifier(destination, sealedSenderAccess, deviceId == 1 ? "*" : String.valueOf(deviceId));
    }

    public PreKeyBundle getPreKey(SignalServiceAddress destination, int deviceId) throws IOException {
        List<PreKeyBundle> bundles = this.getPreKeysBySpecifier(destination, null, String.valueOf(deviceId));
        if (bundles.size() > 0) {
            return bundles.get(0);
        }
        throw new IOException("No prekeys available!");
    }

    private List<PreKeyBundle> getPreKeysBySpecifier(SignalServiceAddress destination, @Nullable SealedSenderAccess sealedSenderAccess, String deviceSpecifier) throws IOException {
        try {
            String path = String.format(PREKEY_DEVICE_PATH, destination.getIdentifier(), deviceSpecifier);
            Log.d((String)TAG, (String)("Fetching prekeys for " + destination.getIdentifier() + "." + deviceSpecifier + ", i.e. GET " + path));
            String responseText = this.makeServiceRequest(path, "GET", null, NO_HEADERS, NO_HANDLER, sealedSenderAccess);
            PreKeyResponse response = JsonUtil.fromJson(responseText, PreKeyResponse.class);
            LinkedList<PreKeyBundle> bundles = new LinkedList<PreKeyBundle>();
            for (PreKeyResponseItem device : response.getDevices()) {
                ECPublicKey preKey = null;
                ECPublicKey signedPreKey = null;
                byte[] signedPreKeySignature = null;
                int preKeyId = -1;
                int signedPreKeyId = -1;
                int kyberPreKeyId = -1;
                KEMPublicKey kyberPreKey = null;
                byte[] kyberPreKeySignature = null;
                if (device.getSignedPreKey() != null) {
                    signedPreKey = device.getSignedPreKey().getPublicKey();
                    signedPreKeyId = device.getSignedPreKey().getKeyId();
                    signedPreKeySignature = device.getSignedPreKey().getSignature();
                }
                if (device.getPreKey() != null) {
                    preKeyId = device.getPreKey().getKeyId();
                    preKey = device.getPreKey().getPublicKey();
                }
                if (device.getKyberPreKey() != null) {
                    kyberPreKey = device.getKyberPreKey().getPublicKey();
                    kyberPreKeyId = device.getKyberPreKey().getKeyId();
                    kyberPreKeySignature = device.getKyberPreKey().getSignature();
                }
                bundles.add(new PreKeyBundle(device.getRegistrationId(), device.getDeviceId(), preKeyId, preKey, signedPreKeyId, signedPreKey, signedPreKeySignature, response.getIdentityKey(), kyberPreKeyId, kyberPreKey, kyberPreKeySignature));
            }
            return bundles;
        }
        catch (NotFoundException nfe) {
            throw new UnregisteredUserException(destination.getIdentifier(), nfe);
        }
    }

    public void checkRepeatedUsePreKeys(ServiceIdType serviceIdType, byte[] digest) throws IOException {
        String body = JsonUtil.toJson(new CheckRepeatedUsedPreKeysRequest(serviceIdType.toString(), digest));
        this.makeServiceRequest(PREKEY_CHECK_PATH, "POST", body, NO_HEADERS, (responseCode, body1) -> {
            if (responseCode == 409) {
                throw new NonSuccessfulResponseCodeException(409);
            }
        }, null);
    }

    public void retrieveBackup(int cdnNumber, Map<String, String> headers, String cdnPath, File destination, long maxSizeBytes, SignalServiceAttachment.ProgressListener listener) throws MissingConfigurationException, IOException {
        this.downloadFromCdn(destination, cdnNumber, headers, cdnPath, maxSizeBytes, listener);
    }

    public void retrieveAttachment(int cdnNumber, Map<String, String> headers, SignalServiceAttachmentRemoteId cdnPath, File destination, long maxSizeBytes, SignalServiceAttachment.ProgressListener listener) throws IOException, MissingConfigurationException {
        String path;
        if (cdnPath instanceof SignalServiceAttachmentRemoteId.V2) {
            path = String.format(Locale.US, ATTACHMENT_ID_DOWNLOAD_PATH, ((SignalServiceAttachmentRemoteId.V2)cdnPath).getCdnId());
        } else if (cdnPath instanceof SignalServiceAttachmentRemoteId.V4) {
            String urlEncodedKey = URLEncoder.encode(((SignalServiceAttachmentRemoteId.V4)cdnPath).getCdnKey(), StandardCharsets.UTF_8.name());
            path = String.format(Locale.US, ATTACHMENT_KEY_DOWNLOAD_PATH, urlEncodedKey);
        } else if (cdnPath instanceof SignalServiceAttachmentRemoteId.Backup) {
            SignalServiceAttachmentRemoteId.Backup backupCdnId = (SignalServiceAttachmentRemoteId.Backup)cdnPath;
            path = String.format(Locale.US, ARCHIVE_MEDIA_DOWNLOAD_PATH, backupCdnId.getBackupDir(), backupCdnId.getMediaDir(), backupCdnId.getMediaId());
        } else {
            throw new IllegalArgumentException("Invalid cdnPath type: " + cdnPath.getClass().getSimpleName());
        }
        this.downloadFromCdn(destination, cdnNumber, headers, path, maxSizeBytes, listener);
    }

    public byte[] retrieveSticker(byte[] packId, int stickerId) throws NonSuccessfulResponseCodeException, PushNetworkException {
        String hexPackId = Hex.toStringCondensed(packId);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.downloadFromCdn(output, 0L, 0, Collections.emptyMap(), String.format(Locale.US, STICKER_PATH, hexPackId, stickerId), 0x100000L, null);
        }
        catch (MissingConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        return output.toByteArray();
    }

    public byte[] retrieveStickerManifest(byte[] packId) throws NonSuccessfulResponseCodeException, PushNetworkException {
        String hexPackId = Hex.toStringCondensed(packId);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.downloadFromCdn(output, 0L, 0, Collections.emptyMap(), String.format(STICKER_MANIFEST_PATH, hexPackId), 0x100000L, null);
        }
        catch (MissingConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        return output.toByteArray();
    }

    public ListenableFuture<SignalServiceProfile> retrieveProfile(SignalServiceAddress target, @Nullable SealedSenderAccess sealedSenderAccess, Locale locale) {
        ListenableFuture<String> response = this.submitServiceRequest(String.format(PROFILE_PATH, target.getIdentifier()), "GET", null, AcceptLanguagesUtil.getHeadersWithAcceptLanguage(locale), sealedSenderAccess);
        return FutureTransformers.map(response, body -> {
            try {
                return JsonUtil.fromJson(body, SignalServiceProfile.class);
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
                throw new MalformedResponseException("Unable to parse entity", e);
            }
        });
    }

    public ListenableFuture<ProfileAndCredential> retrieveVersionedProfileAndCredential(ServiceId.ACI target, ProfileKey profileKey, @Nullable SealedSenderAccess sealedSenderAccess, Locale locale) {
        ProfileKeyVersion profileKeyIdentifier = profileKey.getProfileKeyVersion(target.getLibSignalAci());
        ProfileKeyCredentialRequestContext requestContext = this.clientZkProfileOperations.createProfileKeyCredentialRequestContext(this.random, target.getLibSignalAci(), profileKey);
        ProfileKeyCredentialRequest request = requestContext.getRequest();
        String version = profileKeyIdentifier.serialize();
        String credentialRequest = Hex.toStringCondensed(request.serialize());
        String subPath = String.format("%s/%s/%s?credentialType=expiringProfileKey", target, version, credentialRequest);
        ListenableFuture<String> response = this.submitServiceRequest(String.format(PROFILE_PATH, subPath), "GET", null, AcceptLanguagesUtil.getHeadersWithAcceptLanguage(locale), sealedSenderAccess);
        return FutureTransformers.map(response, body -> this.formatProfileAndCredentialBody(requestContext, (String)body));
    }

    private ProfileAndCredential formatProfileAndCredentialBody(ProfileKeyCredentialRequestContext requestContext, String body) throws MalformedResponseException {
        try {
            SignalServiceProfile signalServiceProfile = JsonUtil.fromJson(body, SignalServiceProfile.class);
            try {
                ExpiringProfileKeyCredential expiringProfileKeyCredential = signalServiceProfile.getExpiringProfileKeyCredentialResponse() != null ? this.clientZkProfileOperations.receiveExpiringProfileKeyCredential(requestContext, signalServiceProfile.getExpiringProfileKeyCredentialResponse()) : null;
                return new ProfileAndCredential(signalServiceProfile, SignalServiceProfile.RequestType.PROFILE_AND_CREDENTIAL, Optional.ofNullable(expiringProfileKeyCredential));
            }
            catch (VerificationFailedException e) {
                Log.w((String)TAG, (String)"Failed to verify credential.", (Throwable)e);
                return new ProfileAndCredential(signalServiceProfile, SignalServiceProfile.RequestType.PROFILE_AND_CREDENTIAL, Optional.empty());
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
            throw new MalformedResponseException("Unable to parse entity", e);
        }
    }

    public ListenableFuture<SignalServiceProfile> retrieveVersionedProfile(ServiceId.ACI target, ProfileKey profileKey, @Nullable SealedSenderAccess sealedSenderAccess, Locale locale) {
        ProfileKeyVersion profileKeyIdentifier = profileKey.getProfileKeyVersion(target.getLibSignalAci());
        String version = profileKeyIdentifier.serialize();
        String subPath = String.format("%s/%s", target, version);
        ListenableFuture<String> response = this.submitServiceRequest(String.format(PROFILE_PATH, subPath), "GET", null, AcceptLanguagesUtil.getHeadersWithAcceptLanguage(locale), sealedSenderAccess);
        return FutureTransformers.map(response, body -> {
            try {
                return JsonUtil.fromJson(body, SignalServiceProfile.class);
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
                throw new MalformedResponseException("Unable to parse entity", e);
            }
        });
    }

    public void retrieveProfileAvatar(String path, File destination, long maxSizeBytes) throws IOException {
        try {
            this.downloadFromCdn(destination, 0, Collections.emptyMap(), path, maxSizeBytes, null);
        }
        catch (MissingConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Optional<String> writeProfile(SignalServiceProfileWrite signalServiceProfileWrite, ProfileAvatarData profileAvatar) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        String requestBody = JsonUtil.toJson(signalServiceProfileWrite);
        String response = this.makeServiceRequest(String.format(PROFILE_PATH, AVATAR_UPLOAD_PATH), "PUT", requestBody, NO_HEADERS, PaymentsRegionException::responseCodeHandler, SealedSenderAccess.NONE);
        if (signalServiceProfileWrite.hasAvatar() && profileAvatar != null) {
            ProfileAvatarUploadAttributes formAttributes;
            try {
                formAttributes = JsonUtil.fromJson(response, ProfileAvatarUploadAttributes.class);
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
                throw new MalformedResponseException("Unable to parse entity", e);
            }
            this.uploadToCdn0(AVATAR_UPLOAD_PATH, formAttributes.getAcl(), formAttributes.getKey(), formAttributes.getPolicy(), formAttributes.getAlgorithm(), formAttributes.getCredential(), formAttributes.getDate(), formAttributes.getSignature(), profileAvatar.getData(), profileAvatar.getContentType(), profileAvatar.getDataLength(), false, profileAvatar.getOutputStreamFactory(), null, null);
            return Optional.of(formAttributes.getKey());
        }
        return Optional.empty();
    }

    public Single<ServiceResponse<IdentityCheckResponse>> performIdentityCheck(@Nonnull IdentityCheckRequest request, @Nonnull ResponseMapper<IdentityCheckResponse> responseMapper) {
        Single requestSingle = Single.fromCallable(() -> {
            try (Response response = this.getServiceConnection(PROFILE_BATCH_CHECK_PATH, "POST", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(request)), Collections.emptyMap(), SealedSenderAccess.NONE, false);){
                String body = response.body() != null ? PushServiceSocket.readBodyString(response.body()) : AVATAR_UPLOAD_PATH;
                ServiceResponse serviceResponse = responseMapper.map(response.code(), body, arg_0 -> ((Response)response).header(arg_0), false);
                return serviceResponse;
            }
        });
        return requestSingle.subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).onErrorReturn(ServiceResponse::forUnknownError);
    }

    public Single<ServiceResponse<BackupV2AuthCheckResponse>> checkSvr2AuthCredentials(@Nonnull BackupAuthCheckRequest request, @Nonnull ResponseMapper<BackupV2AuthCheckResponse> responseMapper) {
        Single requestSingle = Single.fromCallable(() -> {
            try (Response response = this.getServiceConnection(BACKUP_AUTH_CHECK_V2, "POST", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(request)), Collections.emptyMap(), SealedSenderAccess.NONE, false);){
                String body = response.body() != null ? PushServiceSocket.readBodyString(response.body()) : AVATAR_UPLOAD_PATH;
                ServiceResponse serviceResponse = responseMapper.map(response.code(), body, arg_0 -> ((Response)response).header(arg_0), false);
                return serviceResponse;
            }
        });
        return requestSingle.subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).onErrorReturn(ServiceResponse::forUnknownError);
    }

    public BackupV2AuthCheckResponse checkSvr2AuthCredentials(@Nullable String number, @Nonnull List<String> passwords) throws IOException {
        String response = this.makeServiceRequest(BACKUP_AUTH_CHECK_V2, "POST", JsonUtil.toJson(new BackupAuthCheckRequest(number, passwords)), NO_HEADERS, UNOPINIONATED_HANDLER, SealedSenderAccess.NONE);
        return JsonUtil.fromJson(response, BackupV2AuthCheckResponse.class);
    }

    public BackupV3AuthCheckResponse checkSvr3AuthCredentials(@Nullable String number, @Nonnull List<String> passwords) throws IOException {
        String response = this.makeServiceRequest(BACKUP_AUTH_CHECK_V3, "POST", JsonUtil.toJson(new BackupAuthCheckRequest(number, passwords)), NO_HEADERS, UNOPINIONATED_HANDLER, SealedSenderAccess.NONE);
        return JsonUtil.fromJson(response, BackupV3AuthCheckResponse.class);
    }

    @NonNull
    public ServiceId.ACI getAciByUsernameHash(String usernameHash) throws IOException {
        String response = this.makeServiceRequestWithoutAuthentication(String.format(GET_USERNAME_PATH, URLEncoder.encode(usernameHash, StandardCharsets.UTF_8.name())), "GET", null, NO_HEADERS, (responseCode, body) -> {
            if (responseCode == 404) {
                throw new UsernameIsNotAssociatedWithAnAccountException();
            }
        });
        GetAciByUsernameResponse getAciByUsernameResponse = JsonUtil.fromJsonResponse(response, GetAciByUsernameResponse.class);
        return ServiceId.ACI.from(UUID.fromString(getAciByUsernameResponse.getUuid()));
    }

    @NonNull
    public ReserveUsernameResponse reserveUsername(@NonNull List<String> usernameHashes) throws IOException {
        ReserveUsernameRequest reserveUsernameRequest = new ReserveUsernameRequest(usernameHashes);
        String responseString = this.makeServiceRequest(RESERVE_USERNAME_PATH, "PUT", JsonUtil.toJson(reserveUsernameRequest), NO_HEADERS, (responseCode, body) -> {
            switch (responseCode) {
                case 422: {
                    throw new UsernameMalformedException();
                }
                case 409: {
                    throw new UsernameTakenException();
                }
            }
        }, SealedSenderAccess.NONE);
        return JsonUtil.fromJsonResponse(responseString, ReserveUsernameResponse.class);
    }

    public UUID confirmUsernameAndCreateNewLink(Username username, Username.UsernameLink link) throws IOException {
        try {
            byte[] randomness = new byte[32];
            this.random.nextBytes(randomness);
            byte[] proof = username.generateProofWithRandomness(randomness);
            ConfirmUsernameRequest confirmUsernameRequest = new ConfirmUsernameRequest(Base64.encodeUrlSafeWithoutPadding((byte[])username.getHash()), Base64.encodeUrlSafeWithoutPadding((byte[])proof), Base64.encodeUrlSafeWithoutPadding((byte[])link.getEncryptedUsername()));
            String response = this.makeServiceRequest(CONFIRM_USERNAME_PATH, "PUT", JsonUtil.toJson(confirmUsernameRequest), NO_HEADERS, (responseCode, body) -> {
                switch (responseCode) {
                    case 409: {
                        throw new UsernameIsNotReservedException();
                    }
                    case 410: {
                        throw new UsernameTakenException();
                    }
                }
            }, SealedSenderAccess.NONE);
            return JsonUtil.fromJson(response, ConfirmUsernameResponse.class).getUsernameLinkHandle();
        }
        catch (BaseUsernameException e) {
            throw new IOException(e);
        }
    }

    public void deleteUsername() throws IOException {
        this.makeServiceRequest(MODIFY_USERNAME_PATH, "DELETE", null);
    }

    public UUID createUsernameLink(String encryptedUsername, boolean keepLinkHandle) throws IOException {
        String response = this.makeServiceRequest(USERNAME_LINK_PATH, "PUT", JsonUtil.toJson(new SetUsernameLinkRequestBody(encryptedUsername, keepLinkHandle)));
        SetUsernameLinkResponseBody parsed = JsonUtil.fromJson(response, SetUsernameLinkResponseBody.class);
        return parsed.getUsernameLinkHandle();
    }

    public void deleteUsernameLink() throws IOException {
        this.makeServiceRequest(USERNAME_LINK_PATH, "DELETE", null);
    }

    public byte[] getEncryptedUsernameFromLinkServerId(UUID serverId) throws IOException {
        String response = this.makeServiceRequestWithoutAuthentication(String.format(USERNAME_FROM_LINK_PATH, serverId.toString()), "GET", null);
        GetUsernameFromLinkResponseBody parsed = JsonUtil.fromJson(response, GetUsernameFromLinkResponseBody.class);
        return Base64.decode((String)parsed.getUsernameLinkEncryptedValue());
    }

    public void deleteAccount() throws IOException {
        this.makeServiceRequest(DELETE_ACCOUNT_PATH, "DELETE", null);
    }

    public void requestRateLimitPushChallenge() throws IOException {
        this.makeServiceRequest(REQUEST_RATE_LIMIT_PUSH_CHALLENGE, "POST", AVATAR_UPLOAD_PATH);
    }

    public void submitRateLimitPushChallenge(String challenge) throws IOException {
        String payload = JsonUtil.toJson(new SubmitPushChallengePayload(challenge));
        this.makeServiceRequest(SUBMIT_RATE_LIMIT_CHALLENGE, "PUT", payload, NO_HEADERS, (responseCode, body) -> {
            if (responseCode == 428) {
                throw new CaptchaRejectedException();
            }
        }, SealedSenderAccess.NONE);
    }

    public void submitRateLimitRecaptchaChallenge(String challenge, String recaptchaToken) throws IOException {
        String payload = JsonUtil.toJson(new SubmitRecaptchaChallengePayload(challenge, recaptchaToken));
        this.makeServiceRequest(SUBMIT_RATE_LIMIT_CHALLENGE, "PUT", payload, NO_HEADERS, SUBMIT_RATE_LIMIT_CHALLENGE_RESPONSE_HANDLER, null);
    }

    public void redeemDonationReceipt(ReceiptCredentialPresentation receiptCredentialPresentation, boolean visible, boolean primary) throws IOException {
        String payload = JsonUtil.toJson(new RedeemDonationReceiptRequest(Base64.encodeWithPadding((byte[])receiptCredentialPresentation.serialize()), visible, primary));
        this.makeServiceRequest(DONATION_REDEEM_RECEIPT, "POST", payload);
    }

    public void redeemArchivesReceipt(ReceiptCredentialPresentation receiptCredentialPresentation) throws IOException {
        String payload = JsonUtil.toJson(new RedeemArchivesReceiptRequest(Base64.encodeWithPadding((byte[])receiptCredentialPresentation.serialize())));
        this.makeServiceRequest(ARCHIVES_REDEEM_RECEIPT, "POST", payload);
    }

    public StripeClientSecret createStripeOneTimePaymentIntent(String currencyCode, String paymentMethod, long amount, long level) throws IOException {
        String payload = JsonUtil.toJson(new StripeOneTimePaymentIntentPayload(amount, currencyCode, level, paymentMethod));
        String result2 = this.makeServiceRequestWithoutAuthentication(CREATE_STRIPE_ONE_TIME_PAYMENT_INTENT, "POST", payload);
        return JsonUtil.fromJsonResponse(result2, StripeClientSecret.class);
    }

    public PayPalCreatePaymentIntentResponse createPayPalOneTimePaymentIntent(Locale locale, String currencyCode, long amount, long level, String returnUrl, String cancelUrl) throws IOException {
        Map<String, CallSite> headers = Collections.singletonMap("Accept-Language", locale.getLanguage() + "-" + locale.getCountry());
        String payload = JsonUtil.toJson(new PayPalCreateOneTimePaymentIntentPayload(amount, currencyCode, level, returnUrl, cancelUrl));
        String result2 = this.makeServiceRequestWithoutAuthentication(CREATE_PAYPAL_ONE_TIME_PAYMENT_INTENT, "POST", payload, headers, NO_HANDLER);
        return JsonUtil.fromJsonResponse(result2, PayPalCreatePaymentIntentResponse.class);
    }

    public PayPalConfirmPaymentIntentResponse confirmPayPalOneTimePaymentIntent(String currency, String amount, long level, String payerId, String paymentId, String paymentToken) throws IOException {
        String payload = JsonUtil.toJson(new PayPalConfirmOneTimePaymentIntentPayload(amount, currency, level, payerId, paymentId, paymentToken));
        String result2 = this.makeServiceRequestWithoutAuthentication(CONFIRM_PAYPAL_ONE_TIME_PAYMENT_INTENT, "POST", payload, NO_HEADERS, new InAppPaymentResponseCodeHandler());
        return JsonUtil.fromJsonResponse(result2, PayPalConfirmPaymentIntentResponse.class);
    }

    public PayPalCreatePaymentMethodResponse createPayPalPaymentMethod(Locale locale, String subscriberId, String returnUrl, String cancelUrl) throws IOException {
        Map<String, CallSite> headers = Collections.singletonMap("Accept-Language", locale.getLanguage() + "-" + locale.getCountry());
        String payload = JsonUtil.toJson(new PayPalCreatePaymentMethodPayload(returnUrl, cancelUrl));
        String result2 = this.makeServiceRequestWithoutAuthentication(String.format(CREATE_PAYPAL_SUBSCRIPTION_PAYMENT_METHOD, subscriberId), "POST", payload, headers, NO_HANDLER);
        return JsonUtil.fromJsonResponse(result2, PayPalCreatePaymentMethodResponse.class);
    }

    public ReceiptCredentialResponse submitBoostReceiptCredentials(String paymentIntentId, ReceiptCredentialRequest receiptCredentialRequest, DonationProcessor processor) throws IOException {
        String payload = JsonUtil.toJson(new BoostReceiptCredentialRequestJson(paymentIntentId, receiptCredentialRequest, processor));
        String response = this.makeServiceRequestWithoutAuthentication(BOOST_RECEIPT_CREDENTIALS, "POST", payload, NO_HEADERS, (code, body) -> {
            if (code == 204) {
                throw new NonSuccessfulResponseCodeException(204);
            }
            if (code == 402) {
                InAppPaymentReceiptCredentialError inAppPaymentReceiptCredentialError;
                try {
                    inAppPaymentReceiptCredentialError = JsonUtil.fromJson(body.string(), InAppPaymentReceiptCredentialError.class);
                }
                catch (IOException e) {
                    throw new NonSuccessfulResponseCodeException(402);
                }
                throw inAppPaymentReceiptCredentialError;
            }
        });
        ReceiptCredentialResponseJson responseJson = JsonUtil.fromJson(response, ReceiptCredentialResponseJson.class);
        if (responseJson.getReceiptCredentialResponse() != null) {
            return responseJson.getReceiptCredentialResponse();
        }
        throw new MalformedResponseException("Unable to parse response");
    }

    public SubscriptionsConfiguration getDonationsConfiguration(Locale locale) throws IOException {
        Map<String, CallSite> headers = Collections.singletonMap("Accept-Language", locale.getLanguage() + "-" + locale.getCountry());
        String result2 = this.makeServiceRequestWithoutAuthentication(DONATIONS_CONFIGURATION, "GET", null, headers, NO_HANDLER);
        return JsonUtil.fromJson(result2, SubscriptionsConfiguration.class);
    }

    public BankMandate getBankMandate(Locale locale, String bankTransferType) throws IOException {
        Map<String, CallSite> headers = Collections.singletonMap("Accept-Language", locale.getLanguage() + "-" + locale.getCountry());
        String result2 = this.makeServiceRequestWithoutAuthentication(String.format(BANK_MANDATE, bankTransferType), "GET", null, headers, NO_HANDLER);
        return JsonUtil.fromJson(result2, BankMandate.class);
    }

    public void linkPlayBillingPurchaseToken(String subscriberId, String purchaseToken) throws IOException {
        this.makeServiceRequestWithoutAuthentication(String.format(LINK_PLAY_BILLING_PURCHASE_TOKEN, subscriberId, purchaseToken), "POST", AVATAR_UPLOAD_PATH, NO_HEADERS, new LinkGooglePlayBillingPurchaseTokenResponseCodeHandler());
    }

    public void updateSubscriptionLevel(String subscriberId, String level, String currencyCode, String idempotencyKey) throws IOException {
        this.makeServiceRequestWithoutAuthentication(String.format(UPDATE_SUBSCRIPTION_LEVEL, subscriberId, level, currencyCode, idempotencyKey), "PUT", AVATAR_UPLOAD_PATH, NO_HEADERS, new InAppPaymentResponseCodeHandler());
    }

    public ActiveSubscription getSubscription(String subscriberId) throws IOException {
        String response = this.makeServiceRequestWithoutAuthentication(String.format(SUBSCRIPTION, subscriberId), "GET", null);
        return JsonUtil.fromJson(response, ActiveSubscription.class);
    }

    public void putSubscription(String subscriberId) throws IOException {
        this.makeServiceRequestWithoutAuthentication(String.format(SUBSCRIPTION, subscriberId), "PUT", AVATAR_UPLOAD_PATH);
    }

    public void deleteSubscription(String subscriberId) throws IOException {
        this.makeServiceRequestWithoutAuthentication(String.format(SUBSCRIPTION, subscriberId), "DELETE", null);
    }

    public StripeClientSecret createStripeSubscriptionPaymentMethod(String subscriberId, String type) throws IOException {
        String response = this.makeServiceRequestWithoutAuthentication(String.format(CREATE_STRIPE_SUBSCRIPTION_PAYMENT_METHOD, subscriberId, type), "POST", AVATAR_UPLOAD_PATH);
        return JsonUtil.fromJson(response, StripeClientSecret.class);
    }

    public void setDefaultStripeSubscriptionPaymentMethod(String subscriberId, String paymentMethodId) throws IOException {
        this.makeServiceRequestWithoutAuthentication(String.format(DEFAULT_STRIPE_SUBSCRIPTION_PAYMENT_METHOD, subscriberId, paymentMethodId), "POST", AVATAR_UPLOAD_PATH);
    }

    public void setDefaultIdealSubscriptionPaymentMethod(String subscriberId, String setupIntentId) throws IOException {
        this.makeServiceRequestWithoutAuthentication(String.format(DEFAULT_IDEAL_SUBSCRIPTION_PAYMENT_METHOD, subscriberId, setupIntentId), "POST", AVATAR_UPLOAD_PATH);
    }

    public void setDefaultPaypalSubscriptionPaymentMethod(String subscriberId, String paymentMethodId) throws IOException {
        this.makeServiceRequestWithoutAuthentication(String.format(DEFAULT_PAYPAL_SUBSCRIPTION_PAYMENT_METHOD, subscriberId, paymentMethodId), "POST", AVATAR_UPLOAD_PATH);
    }

    public ReceiptCredentialResponse submitReceiptCredentials(String subscriptionId, ReceiptCredentialRequest receiptCredentialRequest) throws IOException {
        String payload = JsonUtil.toJson(new ReceiptCredentialRequestJson(receiptCredentialRequest));
        String response = this.makeServiceRequestWithoutAuthentication(String.format(SUBSCRIPTION_RECEIPT_CREDENTIALS, subscriptionId), "POST", payload, NO_HEADERS, (code, body) -> {
            if (code == 204) {
                throw new NonSuccessfulResponseCodeException(204);
            }
        });
        ReceiptCredentialResponseJson responseJson = JsonUtil.fromJson(response, ReceiptCredentialResponseJson.class);
        if (responseJson.getReceiptCredentialResponse() != null) {
            return responseJson.getReceiptCredentialResponse();
        }
        throw new MalformedResponseException("Unable to parse response");
    }

    public CreateCallLinkCredentialResponse getCallLinkAuthResponse(CreateCallLinkCredentialRequest request) throws IOException {
        String payload = JsonUtil.toJson(CreateCallLinkAuthRequest.create(request));
        String response = this.makeServiceRequest(CALL_LINK_CREATION_AUTH, "POST", payload);
        return JsonUtil.fromJson(response, CreateCallLinkAuthResponse.class).getCreateCallLinkCredentialResponse();
    }

    private AuthCredentials getAuthCredentials(String authPath) throws IOException {
        String response = this.makeServiceRequest(authPath, "GET", null);
        AuthCredentials token = JsonUtil.fromJson(response, AuthCredentials.class);
        return token;
    }

    private String getCredentials(String authPath) throws IOException {
        return this.getAuthCredentials(authPath).asBasic();
    }

    public AuthCredentials getPaymentsAuthorization() throws IOException {
        return this.getAuthCredentials(PAYMENTS_AUTH_PATH);
    }

    public TurnServerInfo getTurnServerInfo() throws IOException {
        String response = this.makeServiceRequest(TURN_SERVER_INFO, "GET", null);
        return JsonUtil.fromJson(response, TurnServerInfo.class);
    }

    public String getStorageAuth() throws IOException {
        String response = this.makeServiceRequest("/v1/storage/auth", "GET", null);
        StorageAuthResponse authResponse = JsonUtil.fromJson(response, StorageAuthResponse.class);
        return Credentials.basic((String)authResponse.getUsername(), (String)authResponse.getPassword());
    }

    public StorageManifest getStorageManifest(String authToken) throws IOException {
        try (Response response = this.makeStorageRequest(authToken, "/v1/storage/manifest", "GET", null, NO_HANDLER);){
            StorageManifest storageManifest = (StorageManifest)((Object)StorageManifest.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return storageManifest;
        }
    }

    public StorageManifest getStorageManifestIfDifferentVersion(String authToken, long version) throws IOException {
        try (Response response = this.makeStorageRequest(authToken, "/v1/storage/manifest/version/" + version, "GET", null, NO_HANDLER);){
            StorageManifest storageManifest = (StorageManifest)((Object)StorageManifest.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return storageManifest;
        }
    }

    public StorageItems readStorageItems(String authToken, ReadOperation operation) throws IOException {
        try (Response response = this.makeStorageRequest(authToken, "/v1/storage/read", "PUT", PushServiceSocket.protobufRequestBody(operation), NO_HANDLER);){
            StorageItems storageItems = (StorageItems)((Object)StorageItems.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return storageItems;
        }
    }

    public Optional<StorageManifest> writeStorageContacts(String authToken, WriteOperation writeOperation) throws IOException {
        Optional<StorageManifest> optional;
        block8: {
            Response response = this.makeStorageRequest(authToken, "/v1/storage", "PUT", PushServiceSocket.protobufRequestBody(writeOperation), NO_HANDLER);
            try {
                optional = Optional.empty();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContactManifestMismatchException e) {
                    return Optional.of((StorageManifest)((Object)StorageManifest.ADAPTER.decode(e.getResponseBody())));
                }
            }
            response.close();
        }
        return optional;
    }

    public void pingStorageService() throws IOException {
        Response response = this.makeStorageRequest(null, "/ping", "GET", null, NO_HANDLER);
        if (response != null) {
            response.close();
        }
    }

    public RemoteConfigResponse getRemoteConfig() throws IOException {
        String response = this.makeServiceRequest("/v1/config", "GET", null);
        return JsonUtil.fromJson(response, RemoteConfigResponse.class);
    }

    public void setSoTimeoutMillis(long soTimeoutMillis) {
        this.soTimeoutMillis = soTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelInFlightRequests() {
        Set<Call> set = this.connections;
        synchronized (set) {
            Log.w((String)TAG, (String)("Canceling: " + this.connections.size()));
            for (Call connection : this.connections) {
                Log.w((String)TAG, (String)("Canceling: " + String.valueOf(connection)));
                connection.cancel();
            }
        }
    }

    public AttachmentUploadForm getAttachmentV4UploadAttributes() throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        String response = this.makeServiceRequest(ATTACHMENT_V4_PATH, "GET", null);
        try {
            return JsonUtil.fromJson(response, AttachmentUploadForm.class);
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
            throw new MalformedResponseException("Unable to parse entity", e);
        }
    }

    public StickerUploadAttributesResponse getStickerUploadAttributes(int stickerCount) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        String response = this.makeServiceRequest(String.format(Locale.ROOT, STICKER_UPLOAD_PATH, stickerCount), "GET", null);
        try {
            return JsonUtil.fromJson(response, StickerUploadAttributesResponse.class);
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
            throw new MalformedResponseException("Unable to parse entity", e);
        }
    }

    public AttachmentDigest uploadGroupV2Avatar(byte[] avatarCipherText, AvatarUploadAttributes uploadAttributes) throws IOException {
        return this.uploadToCdn0(AVATAR_UPLOAD_PATH, uploadAttributes.acl, uploadAttributes.key, uploadAttributes.policy, uploadAttributes.algorithm, uploadAttributes.credential, uploadAttributes.date, uploadAttributes.signature, new ByteArrayInputStream(avatarCipherText), "application/octet-stream", avatarCipherText.length, false, new NoCipherOutputStreamFactory(), null, null);
    }

    public Pair<Long, AttachmentDigest> uploadAttachment(PushAttachmentData attachment, AttachmentV2UploadAttributes uploadAttributes) throws PushNetworkException, NonSuccessfulResponseCodeException {
        long id = Long.parseLong(uploadAttributes.getAttachmentId());
        AttachmentDigest digest = this.uploadToCdn0(ATTACHMENT_UPLOAD_PATH, uploadAttributes.getAcl(), uploadAttributes.getKey(), uploadAttributes.getPolicy(), uploadAttributes.getAlgorithm(), uploadAttributes.getCredential(), uploadAttributes.getDate(), uploadAttributes.getSignature(), attachment.getData(), "application/octet-stream", attachment.getDataSize(), attachment.getIncremental(), attachment.getOutputStreamFactory(), attachment.getListener(), attachment.getCancelationSignal());
        return new Pair((Object)id, (Object)digest);
    }

    public ResumableUploadSpec getResumableUploadSpec(AttachmentUploadForm uploadForm) throws IOException {
        return new ResumableUploadSpec(Util.getSecretBytes(64), Util.getSecretBytes(16), uploadForm.key, uploadForm.cdn, this.getResumableUploadUrl(uploadForm), System.currentTimeMillis() + CDN2_RESUMABLE_LINK_LIFETIME_MILLIS, uploadForm.headers);
    }

    public ResumableUploadSpec getResumableUploadSpecWithKey(AttachmentUploadForm uploadForm, byte[] secretKey) throws IOException {
        return new ResumableUploadSpec(secretKey, Util.getSecretBytes(16), uploadForm.key, uploadForm.cdn, this.getResumableUploadUrl(uploadForm), System.currentTimeMillis() + CDN2_RESUMABLE_LINK_LIFETIME_MILLIS, uploadForm.headers);
    }

    public AttachmentDigest uploadAttachment(PushAttachmentData attachment) throws IOException {
        if (attachment.getResumableUploadSpec() == null || attachment.getResumableUploadSpec().getExpirationTimestamp() < System.currentTimeMillis()) {
            throw new ResumeLocationInvalidException();
        }
        if (attachment.getResumableUploadSpec().getCdnNumber() == 2) {
            return this.uploadToCdn2(attachment.getResumableUploadSpec().getResumeLocation(), attachment.getData(), "application/octet-stream", attachment.getDataSize(), attachment.getIncremental(), attachment.getOutputStreamFactory(), attachment.getListener(), attachment.getCancelationSignal());
        }
        return this.uploadToCdn3(attachment.getResumableUploadSpec().getResumeLocation(), attachment.getData(), "application/offset+octet-stream", attachment.getDataSize(), attachment.getIncremental(), attachment.getOutputStreamFactory(), attachment.getListener(), attachment.getCancelationSignal(), attachment.getResumableUploadSpec().getHeaders());
    }

    public void uploadStickerContent(InputStream content, long length, byte[] expandedPackKey, StickerUploadAttributes uploadAttributes) throws NonSuccessfulResponseCodeException, PushNetworkException {
        this.uploadToCdn0(AVATAR_UPLOAD_PATH, uploadAttributes.getAcl(), uploadAttributes.getKey(), uploadAttributes.getPolicy(), uploadAttributes.getAlgorithm(), uploadAttributes.getCredential(), uploadAttributes.getDate(), uploadAttributes.getSignature(), content, "application/octet-stream", AttachmentCipherStreamUtil.getCiphertextLength(length), false, new StickerCipherOutputStreamFactory(expandedPackKey), null, null);
    }

    private void downloadFromCdn(File destination, int cdnNumber, Map<String, String> headers, String path, long maxSizeBytes, SignalServiceAttachment.ProgressListener listener) throws IOException, MissingConfigurationException {
        try (FileOutputStream outputStream = new FileOutputStream(destination, true);){
            this.downloadFromCdn(outputStream, destination.length(), cdnNumber, headers, path, maxSizeBytes, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFromCdn(OutputStream outputStream, long offset, int cdnNumber, Map<String, String> headers, String path, long maxSizeBytes, SignalServiceAttachment.ProgressListener listener) throws PushNetworkException, NonSuccessfulResponseCodeException, MissingConfigurationException {
        block31: {
            ConnectionHolder[] cdnNumberClients = this.cdnClientsMap.get(cdnNumber);
            if (cdnNumberClients == null) {
                throw new MissingConfigurationException("Attempted to download from unsupported CDN number: " + cdnNumber + ", Our configuration supports: " + String.valueOf(this.cdnClientsMap.keySet()));
            }
            ConnectionHolder connectionHolder = this.getRandom(cdnNumberClients, this.random);
            OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
            Request.Builder request = new Request.Builder().url(connectionHolder.getUrl() + "/" + path).get();
            if (connectionHolder.getHostHeader().isPresent()) {
                request.addHeader("Host", connectionHolder.getHostHeader().get());
            }
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
            if (offset > 0L) {
                Log.i((String)TAG, (String)("Starting download from CDN with offset " + offset));
                request.addHeader("Range", "bytes=" + offset + "-");
            }
            Call call = okHttpClient.newCall(request.build());
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.add(call);
            }
            try (Response response = call.execute();){
                if (response.isSuccessful()) {
                    ResponseBody body = response.body();
                    if (body == null) {
                        throw new PushNetworkException("No response body!");
                    }
                    if (body.contentLength() > maxSizeBytes) {
                        throw new PushNetworkException("Response exceeds max size!");
                    }
                    InputStream in = body.byteStream();
                    byte[] buffer = new byte[32768];
                    int read = 0;
                    long totalRead = offset;
                    while ((read = in.read(buffer, 0, buffer.length)) != -1) {
                        outputStream.write(buffer, 0, read);
                        if ((totalRead += (long)read) > maxSizeBytes) {
                            throw new PushNetworkException("Response exceeded max size!");
                        }
                        if (listener == null) continue;
                        listener.onAttachmentProgress(body.contentLength() + offset, totalRead);
                        if (!listener.shouldCancel()) continue;
                        call.cancel();
                        throw new PushNetworkException("Canceled by listener check.");
                    }
                    break block31;
                }
                if (response.code() == 416) {
                    throw new RangeException(offset);
                }
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException iOException) {
                throw iOException;
            }
            catch (IOException iOException) {
                throw new PushNetworkException(iOException);
            }
            finally {
                Set<Call> set2 = this.connections;
                synchronized (set2) {
                    this.connections.remove(call);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Nullable
    public ZonedDateTime getCdnLastModifiedTime(int cdnNumber, Map<String, String> headers, String path) throws MissingConfigurationException, PushNetworkException, NonSuccessfulResponseCodeException {
        Object header2;
        ConnectionHolder[] cdnNumberClients = this.cdnClientsMap.get(cdnNumber);
        if (cdnNumberClients == null) {
            throw new MissingConfigurationException("Attempted to download from unsupported CDN number: " + cdnNumber + ", Our configuration supports: " + String.valueOf(this.cdnClientsMap.keySet()));
        }
        ConnectionHolder connectionHolder = this.getRandom(cdnNumberClients, this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        Request.Builder request = new Request.Builder().url(connectionHolder.getUrl() + "/" + path).get();
        if (connectionHolder.getHostHeader().isPresent()) {
            request.addHeader("Host", connectionHolder.getHostHeader().get());
        }
        for (Object header2 : headers.entrySet()) {
            request.addHeader(header2.getKey(), header2.getValue());
        }
        Call call = okHttpClient.newCall(request.build());
        header2 = this.connections;
        synchronized (header2) {
            this.connections.add(call);
        }
        try {
            Response response;
            block31: {
                String lastModified;
                block32: {
                    ZonedDateTime zonedDateTime;
                    block33: {
                        response = call.execute();
                        if (!response.isSuccessful()) break block31;
                        lastModified = response.header("Last-Modified");
                        if (lastModified != null) break block32;
                        zonedDateTime = null;
                        if (response == null) break block33;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        response.close();
                    }
                    return zonedDateTime;
                }
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(lastModified, DateTimeFormatter.RFC_1123_DATE_TIME);
                return zonedDateTime;
            }
            try {
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                throw new PushNetworkException(e);
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        finally {
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.remove(call);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private AttachmentDigest uploadToCdn0(String path, String acl, String key, String policy, String algorithm, String credential, String date, String signature, InputStream data, String contentType, long length, boolean incremental, OutputStreamFactory outputStreamFactory, SignalServiceAttachment.ProgressListener progressListener, CancelationSignal cancelationSignal) throws PushNetworkException, NonSuccessfulResponseCodeException {
        ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(0), this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        DigestingRequestBody file = new DigestingRequestBody(data, outputStreamFactory, contentType, length, incremental, progressListener, cancelationSignal, 0L);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("acl", acl).addFormDataPart("key", key).addFormDataPart("policy", policy).addFormDataPart("Content-Type", contentType).addFormDataPart("x-amz-algorithm", algorithm).addFormDataPart("x-amz-credential", credential).addFormDataPart("x-amz-date", date).addFormDataPart("x-amz-signature", signature).addFormDataPart("file", "file", (RequestBody)file).build();
        Request.Builder request = new Request.Builder().url(connectionHolder.getUrl() + "/" + path).post((RequestBody)requestBody);
        if (connectionHolder.getHostHeader().isPresent()) {
            request.addHeader("Host", connectionHolder.getHostHeader().get());
        }
        Call call = okHttpClient.newCall(request.build());
        Set<Call> set = this.connections;
        synchronized (set) {
            this.connections.add(call);
        }
        try {
            Response response;
            block23: {
                AttachmentDigest attachmentDigest;
                block24: {
                    response = call.execute();
                    if (!response.isSuccessful()) break block23;
                    attachmentDigest = file.getAttachmentDigest();
                    if (response == null) break block24;
                    {
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    response.close();
                }
                return attachmentDigest;
            }
            try {
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                throw new PushNetworkException(e);
            }
        }
        finally {
            Set<Call> set2 = this.connections;
            synchronized (set2) {
                this.connections.remove(call);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getResumableUploadUrl(AttachmentUploadForm uploadForm) throws IOException {
        Map.Entry<String, String> header2222;
        ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(uploadForm.cdn), this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        Request.Builder request = new Request.Builder().url(PushServiceSocket.buildConfiguredUrl(connectionHolder, uploadForm.signedUploadLocation)).post(RequestBody.create(null, (String)AVATAR_UPLOAD_PATH));
        for (Map.Entry<String, String> header2222 : uploadForm.headers.entrySet()) {
            if (header2222.getKey().equalsIgnoreCase("host")) continue;
            request.header(header2222.getKey(), header2222.getValue());
        }
        if (connectionHolder.getHostHeader().isPresent()) {
            request.header("host", connectionHolder.getHostHeader().get());
        }
        request.addHeader("Content-Length", "0");
        if (uploadForm.cdn == 2) {
            request.addHeader("Content-Type", "application/octet-stream");
        } else if (uploadForm.cdn == 3) {
            request.addHeader("Upload-Defer-Length", "1").addHeader("Tus-Resumable", "1.0.0");
        } else {
            throw new AssertionError((Object)("Unknown CDN version: " + uploadForm.cdn));
        }
        Call call = okHttpClient.newCall(request.build());
        header2222 = this.connections;
        synchronized (header2222) {
            this.connections.add(call);
        }
        try {
            Response response;
            block28: {
                String string;
                block29: {
                    response = call.execute();
                    if (!response.isSuccessful()) break block28;
                    string = response.header("location");
                    if (response == null) break block29;
                    {
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    response.close();
                }
                return string;
            }
            try {
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                throw new PushNetworkException(e);
            }
        }
        finally {
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.remove(call);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private AttachmentDigest uploadToCdn2(String resumableUrl, InputStream data, String contentType, long length, boolean incremental, OutputStreamFactory outputStreamFactory, SignalServiceAttachment.ProgressListener progressListener, CancelationSignal cancelationSignal) throws IOException {
        ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(2), this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        ResumeInfo resumeInfo = this.getResumeInfoCdn2(resumableUrl, length);
        DigestingRequestBody file = new DigestingRequestBody(data, outputStreamFactory, contentType, length, incremental, progressListener, cancelationSignal, resumeInfo.contentStart);
        if (resumeInfo.contentStart == length) {
            Log.w((String)TAG, (String)"Resume start point == content length");
            try (NowhereBufferedSink buffer = new NowhereBufferedSink();){
                file.writeTo(buffer);
            }
            return file.getAttachmentDigest();
        }
        Request.Builder request = new Request.Builder().url(PushServiceSocket.buildConfiguredUrl(connectionHolder, resumableUrl)).put((RequestBody)file).addHeader("Content-Range", resumeInfo.contentRange);
        if (connectionHolder.getHostHeader().isPresent()) {
            request.header("host", connectionHolder.getHostHeader().get());
        }
        Call call = okHttpClient.newCall(request.build());
        Set<Call> set = this.connections;
        synchronized (set) {
            this.connections.add(call);
        }
        try {
            Response response;
            block31: {
                AttachmentDigest attachmentDigest;
                block32: {
                    response = call.execute();
                    if (!response.isSuccessful()) break block31;
                    attachmentDigest = file.getAttachmentDigest();
                    if (response == null) break block32;
                    {
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    response.close();
                }
                return attachmentDigest;
            }
            try {
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                if (e instanceof StreamResetException) {
                    throw e;
                }
                throw new PushNetworkException(e);
            }
        }
        finally {
            Set<Call> set2 = this.connections;
            synchronized (set2) {
                this.connections.remove(call);
            }
        }
    }

    public void uploadBackupFile(AttachmentUploadForm uploadForm, String resumableUploadUrl, InputStream data, long dataLength) throws IOException {
        this.uploadToCdn3(resumableUploadUrl, data, "application/octet-stream", dataLength, false, new NoCipherOutputStreamFactory(), null, null, uploadForm.headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private AttachmentDigest uploadToCdn3(String resumableUrl, InputStream data, String contentType, long length, boolean incremental, OutputStreamFactory outputStreamFactory, SignalServiceAttachment.ProgressListener progressListener, CancelationSignal cancelationSignal, Map<String, String> headers) throws IOException {
        Object entry2;
        ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(3), this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        ResumeInfo resumeInfo = this.getResumeInfoCdn3(resumableUrl, headers);
        DigestingRequestBody file = new DigestingRequestBody(data, outputStreamFactory, contentType, length, incremental, progressListener, cancelationSignal, resumeInfo.contentStart);
        if (resumeInfo.contentStart == length) {
            Log.w((String)TAG, (String)"Resume start point == content length");
            try (NowhereBufferedSink buffer = new NowhereBufferedSink();){
                file.writeTo(buffer);
            }
            return file.getAttachmentDigest();
        }
        if (resumeInfo.contentStart != 0L) {
            Log.w((String)TAG, (String)"Resuming previous attachment upload");
        }
        Request.Builder request = new Request.Builder().url(PushServiceSocket.buildConfiguredUrl(connectionHolder, resumableUrl)).patch((RequestBody)file).addHeader("Upload-Offset", String.valueOf(resumeInfo.contentStart)).addHeader("Upload-Length", String.valueOf(length)).addHeader("Tus-Resumable", "1.0.0");
        for (Object entry2 : headers.entrySet()) {
            request.addHeader(entry2.getKey(), entry2.getValue());
        }
        if (connectionHolder.getHostHeader().isPresent()) {
            request.header("host", connectionHolder.getHostHeader().get());
        }
        Call call = okHttpClient.newCall(request.build());
        entry2 = this.connections;
        synchronized (entry2) {
            this.connections.add(call);
        }
        try {
            Response response;
            block33: {
                AttachmentDigest attachmentDigest;
                block34: {
                    response = call.execute();
                    if (!response.isSuccessful()) break block33;
                    attachmentDigest = file.getAttachmentDigest();
                    if (response == null) break block34;
                    {
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    response.close();
                }
                return attachmentDigest;
            }
            try {
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                if (e instanceof StreamResetException) {
                    throw e;
                }
                throw new PushNetworkException(e);
            }
        }
        finally {
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.remove(call);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResumeInfo getResumeInfoCdn2(String resumableUrl, long contentLength) throws IOException {
        String contentRange;
        long offset;
        block25: {
            ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(2), this.random);
            OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
            Request.Builder request = new Request.Builder().url(PushServiceSocket.buildConfiguredUrl(connectionHolder, resumableUrl)).put(RequestBody.create(null, (String)AVATAR_UPLOAD_PATH)).addHeader("Content-Range", String.format(Locale.US, "bytes */%d", contentLength));
            if (connectionHolder.getHostHeader().isPresent()) {
                request.header("host", connectionHolder.getHostHeader().get());
            }
            Call call = okHttpClient.newCall(request.build());
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.add(call);
            }
            try (Object response = call.execute();){
                if (response.isSuccessful()) {
                    offset = contentLength;
                    contentRange = null;
                    break block25;
                }
                if (response.code() == 308) {
                    String rangeCompleted = response.header("Range");
                    offset = rangeCompleted == null ? 0L : Long.parseLong(rangeCompleted.split("-")[1]) + 1L;
                    contentRange = String.format(Locale.US, "bytes %d-%d/%d", offset, contentLength - 1L, contentLength);
                    break block25;
                }
                if (response.code() == 404) {
                    throw new ResumeLocationInvalidException();
                }
                throw new NonSuccessfulResumableUploadResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                throw new PushNetworkException(e);
            }
            finally {
                Set<Call> set2 = this.connections;
                synchronized (set2) {
                    this.connections.remove(call);
                }
            }
        }
        return new ResumeInfo(contentRange, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResumeInfo getResumeInfoCdn3(String resumableUrl, Map<String, String> headers) throws IOException {
        long offset;
        block24: {
            ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(3), this.random);
            OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
            Request.Builder request = new Request.Builder().url(PushServiceSocket.buildConfiguredUrl(connectionHolder, resumableUrl)).head().addHeader("Tus-Resumable", "1.0.0");
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
            if (connectionHolder.getHostHeader().isPresent()) {
                request.header("host", connectionHolder.getHostHeader().get());
            }
            Call call = okHttpClient.newCall(request.build());
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.add(call);
            }
            try (Response response = call.execute();){
                if (response.isSuccessful()) {
                    offset = Long.parseLong(Objects.requireNonNull(response.header("Upload-Offset")));
                    break block24;
                }
                throw new ResumeLocationInvalidException("Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException iOException) {
                throw iOException;
            }
            catch (IOException iOException) {
                throw new PushNetworkException(iOException);
            }
            finally {
                Set<Call> set2 = this.connections;
                synchronized (set2) {
                    this.connections.remove(call);
                }
            }
        }
        return new ResumeInfo(null, offset);
    }

    private static HttpUrl buildConfiguredUrl(ConnectionHolder connectionHolder, String url) throws IOException {
        HttpUrl resumableHttpUrl;
        HttpUrl endpointUrl = HttpUrl.get((String)connectionHolder.url);
        try {
            resumableHttpUrl = HttpUrl.get((String)url);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Malformed URL!", e);
        }
        return new HttpUrl.Builder().scheme(endpointUrl.scheme()).host(endpointUrl.host()).port(endpointUrl.port()).encodedPath(endpointUrl.encodedPath()).addEncodedPathSegments(resumableHttpUrl.encodedPath().substring(1)).encodedQuery(resumableHttpUrl.encodedQuery()).encodedFragment(resumableHttpUrl.encodedFragment()).build();
    }

    private String makeServiceRequestWithoutAuthentication(String urlFragment, String method, String jsonBody) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        return this.makeServiceRequestWithoutAuthentication(urlFragment, method, jsonBody, NO_HEADERS, NO_HANDLER);
    }

    private String makeServiceRequestWithoutAuthentication(String urlFragment, String method, String jsonBody, Map<String, String> headers, ResponseCodeHandler responseCodeHandler) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        try (Response response = this.makeServiceRequest(urlFragment, method, PushServiceSocket.jsonRequestBody(jsonBody), headers, responseCodeHandler, SealedSenderAccess.NONE, true);){
            String string = PushServiceSocket.readBodyString(response);
            return string;
        }
    }

    private String makeServiceRequest(String urlFragment, String method, String jsonBody) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        return this.makeServiceRequest(urlFragment, method, jsonBody, NO_HEADERS, NO_HANDLER, SealedSenderAccess.NONE);
    }

    private String makeServiceRequest(String urlFragment, String method, String jsonBody, Map<String, String> headers, ResponseCodeHandler responseCodeHandler, @Nullable SealedSenderAccess sealedSenderAccess) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        try (Response response = this.makeServiceRequest(urlFragment, method, PushServiceSocket.jsonRequestBody(jsonBody), headers, responseCodeHandler, sealedSenderAccess, false);){
            String string = PushServiceSocket.readBodyString(response);
            return string;
        }
    }

    private static RequestBody jsonRequestBody(String jsonBody) {
        return jsonBody != null ? RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonBody) : null;
    }

    private static RequestBody protobufRequestBody(Message<?, ?> protobufBody) {
        return protobufBody != null ? RequestBody.create((MediaType)MediaType.parse((String)"application/x-protobuf"), (byte[])protobufBody.encode()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<String> submitServiceRequest(String urlFragment, String method, String jsonBody, Map<String, String> headers, @Nullable SealedSenderAccess sealedSenderAccess) {
        OkHttpClient okHttpClient = this.buildOkHttpClient(sealedSenderAccess != null);
        Call call = okHttpClient.newCall(this.buildServiceRequest(urlFragment, method, PushServiceSocket.jsonRequestBody(jsonBody), headers, sealedSenderAccess, false));
        Set<Call> set = this.connections;
        synchronized (set) {
            this.connections.add(call);
        }
        final SettableFuture bodyFuture = new SettableFuture();
        call.enqueue(new Callback(){
            final /* synthetic */ PushServiceSocket this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(Call call, Response response) {
                try (ResponseBody body = response.body();){
                    this.this$0.validateServiceResponse(response);
                    bodyFuture.set((Object)PushServiceSocket.readBodyString(body));
                }
                catch (IOException e) {
                    bodyFuture.setException((Throwable)e);
                }
            }

            public void onFailure(Call call, IOException e) {
                bodyFuture.setException((Throwable)e);
            }
        });
        return bodyFuture;
    }

    private Response makeServiceRequest(String urlFragment, String method, RequestBody body, Map<String, String> headers, ResponseCodeHandler responseCodeHandler, @Nullable SealedSenderAccess sealedSenderAccess, boolean doNotAddAuthenticationOrUnidentifiedAccessKey) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        Response response = null;
        try {
            response = this.getServiceConnection(urlFragment, method, body, headers, sealedSenderAccess, doNotAddAuthenticationOrUnidentifiedAccessKey);
            responseCodeHandler.handle(response.code(), response.body());
            return this.validateServiceResponse(response);
        }
        catch (Exception e) {
            if (response != null && response.body() != null) {
                response.body().close();
            }
            throw e;
        }
    }

    private Response validateServiceResponse(Response response) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        int responseCode = response.code();
        String responseMessage = response.message();
        switch (responseCode) {
            case 413: 
            case 429: {
                long retryAfterLong = Util.parseLong(response.header("Retry-After"), -1L);
                Optional<Long> retryAfter = retryAfterLong != -1L ? Optional.of(TimeUnit.SECONDS.toMillis(retryAfterLong)) : Optional.empty();
                throw new RateLimitException(responseCode, "Rate limit exceeded: " + responseCode, retryAfter);
            }
            case 401: 
            case 403: {
                throw new AuthorizationFailedException(responseCode, "Authorization failed!");
            }
            case 404: {
                throw new NotFoundException("Not found");
            }
            case 409: {
                MismatchedDevices mismatchedDevices = PushServiceSocket.readResponseJson(response, MismatchedDevices.class);
                throw new MismatchedDevicesException(mismatchedDevices);
            }
            case 410: {
                StaleDevices staleDevices = PushServiceSocket.readResponseJson(response, StaleDevices.class);
                throw new StaleDevicesException(staleDevices);
            }
            case 411: {
                DeviceLimit deviceLimit = PushServiceSocket.readResponseJson(response, DeviceLimit.class);
                throw new DeviceLimitExceededException(deviceLimit);
            }
            case 417: {
                throw new ExpectationFailedException();
            }
            case 423: {
                RegistrationLockFailure accountLockFailure = PushServiceSocket.readResponseJson(response, RegistrationLockFailure.class);
                throw new LockedException(accountLockFailure.length, accountLockFailure.timeRemaining, accountLockFailure.svr2Credentials, accountLockFailure.svr3Credentials);
            }
            case 428: {
                ProofRequiredResponse proofRequiredResponse = PushServiceSocket.readResponseJson(response, ProofRequiredResponse.class);
                String retryAfterRaw = response.header("Retry-After");
                long retryAfter = Util.parseInt(retryAfterRaw, -1);
                throw new ProofRequiredException(proofRequiredResponse, retryAfter);
            }
            case 499: {
                throw new DeprecatedVersionException();
            }
            case 508: {
                throw new ServerRejectedException();
            }
        }
        if (responseCode != 200 && responseCode != 202 && responseCode != 204 && responseCode != 207) {
            throw new NonSuccessfulResponseCodeException(responseCode, "Bad response: " + responseCode + " " + responseMessage + ": " + (response.body() == null ? AVATAR_UPLOAD_PATH : PushServiceSocket.readBodyString(response.body())));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getServiceConnection(String urlFragment, String method, RequestBody body, Map<String, String> headers, @Nullable SealedSenderAccess sealedSenderAccess, boolean doNotAddAuthenticationOrUnidentifiedAccessKey) throws PushNetworkException {
        Set<Call> set;
        OkHttpClient okHttpClient = this.buildOkHttpClient(sealedSenderAccess != null);
        Call call = okHttpClient.newCall(this.buildServiceRequest(urlFragment, method, body, headers, sealedSenderAccess, doNotAddAuthenticationOrUnidentifiedAccessKey));
        Response response = this.connections;
        synchronized (response) {
            this.connections.add(call);
        }
        try {
            response = call.execute();
            set = this.connections;
        }
        catch (Throwable throwable) {
            try {
                Set<Call> set2 = this.connections;
                synchronized (set2) {
                    this.connections.remove(call);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PushNetworkException(e);
            }
        }
        synchronized (set) {
            this.connections.remove(call);
        }
        return response;
    }

    private OkHttpClient buildOkHttpClient(boolean unidentified) {
        ServiceConnectionHolder connectionHolder = (ServiceConnectionHolder)this.getRandom(this.serviceClients, this.random);
        OkHttpClient baseClient = unidentified ? connectionHolder.getUnidentifiedClient() : connectionHolder.getClient();
        return baseClient.newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).retryOnConnectionFailure(this.automaticNetworkRetry).build();
    }

    private Request buildServiceRequest(String urlFragment, String method, RequestBody body, Map<String, String> headers, @Nullable SealedSenderAccess sealedSenderAccess, boolean doNotAddAuthenticationOrUnidentifiedAccessKey) {
        ServiceConnectionHolder connectionHolder = (ServiceConnectionHolder)this.getRandom(this.serviceClients, this.random);
        Request.Builder request = new Request.Builder();
        request.url(String.format("%s%s", connectionHolder.getUrl(), urlFragment));
        request.method(method, body);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.addHeader(header.getKey(), header.getValue());
        }
        if (!headers.containsKey("Authorization") && !doNotAddAuthenticationOrUnidentifiedAccessKey) {
            if (sealedSenderAccess != null) {
                request.addHeader(sealedSenderAccess.getHeaderName(), sealedSenderAccess.getHeaderValue());
            } else if (this.credentialsProvider.getPassword() != null) {
                request.addHeader("Authorization", this.getAuthorizationHeader(this.credentialsProvider));
            }
        }
        if (this.signalAgent != null) {
            request.addHeader("X-Signal-Agent", this.signalAgent);
        }
        if (connectionHolder.getHostHeader().isPresent()) {
            request.addHeader("Host", connectionHolder.getHostHeader().get());
        }
        return request.build();
    }

    private Response makeStorageRequest(String authorization, String path, String method, RequestBody body, ResponseCodeHandler responseCodeHandler) throws PushNetworkException, NonSuccessfulResponseCodeException {
        return this.makeStorageRequest(authorization, path, method, body, NO_HEADERS, responseCodeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response makeStorageRequest(String authorization, String path, String method, RequestBody body, Map<String, String> headers, ResponseCodeHandler responseCodeHandler) throws PushNetworkException, NonSuccessfulResponseCodeException {
        Response response;
        ConnectionHolder connectionHolder = this.getRandom(this.storageClients, this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        Request.Builder request = new Request.Builder().url(connectionHolder.getUrl() + path);
        request.method(method, body);
        if (connectionHolder.getHostHeader().isPresent()) {
            request.addHeader("Host", connectionHolder.getHostHeader().get());
        }
        if (authorization != null) {
            request.addHeader("Authorization", authorization);
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
        Call call = okHttpClient.newCall(request.build());
        Set<Call> set = this.connections;
        synchronized (set) {
            this.connections.add(call);
        }
        try {
            response = call.execute();
            if (response.isSuccessful() && response.code() != 204) {
                Response response2 = response;
                return response2;
            }
        }
        catch (IOException e) {
            throw new PushNetworkException(e);
        }
        finally {
            Set<Call> set2 = this.connections;
            synchronized (set2) {
                this.connections.remove(call);
            }
        }
        ResponseBody responseBody = response.body();
        try {
            responseCodeHandler.handle(response.code(), responseBody, arg_0 -> ((Response)response).header(arg_0));
            switch (response.code()) {
                case 204: {
                    throw new NoContentException("No content!");
                }
                case 401: 
                case 403: {
                    throw new AuthorizationFailedException(response.code(), "Authorization failed!");
                }
                case 404: {
                    throw new NotFoundException("Not found");
                }
                case 409: {
                    if (responseBody != null) {
                        throw new ContactManifestMismatchException(PushServiceSocket.readBodyBytes(responseBody));
                    }
                    throw new ConflictException();
                }
                case 429: {
                    throw new RateLimitException(response.code(), "Rate limit exceeded: " + response.code());
                }
                case 499: {
                    throw new DeprecatedVersionException();
                }
            }
            throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
        }
        catch (Throwable throwable) {
            if (responseBody != null) {
                try {
                    responseBody.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CallingResponse makeCallingRequest(long requestId, String url, String httpMethod, List<Pair<String, String>> headers, byte[] body) {
        ConnectionHolder connectionHolder = this.getRandom(this.serviceClients, this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().followRedirects(false).connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        RequestBody requestBody = body != null ? RequestBody.create(null, (byte[])body) : null;
        Request.Builder builder = new Request.Builder().url(url).method(httpMethod, requestBody);
        if (headers != null) {
            for (Pair<String, String> header : headers) {
                builder.addHeader((String)header.first(), (String)header.second());
            }
        }
        Request request = builder.build();
        int i = 0;
        while (true) {
            if (i >= 20) {
                Log.w((String)TAG, (String)"Calling request max redirects exceeded");
                return new CallingResponse.Error(requestId, new IOException("Redirect limit exceeded"));
            }
            try (Response response = okHttpClient.newCall(request).execute();){
                HttpUrl newUrl;
                int responseStatus = response.code();
                if (responseStatus != 307) {
                    CallingResponse.Success success = new CallingResponse.Success(requestId, responseStatus, response.body() != null ? response.body().bytes() : new byte[]{});
                    return success;
                }
                String location = response.header("Location");
                HttpUrl httpUrl = newUrl = location != null ? request.url().resolve(location) : null;
                if (newUrl == null) {
                    CallingResponse.Error error = new CallingResponse.Error(requestId, new IOException("Received redirect without a valid Location header"));
                    return error;
                }
                request = request.newBuilder().url(newUrl).build();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Exception during ringrtc http call.", (Throwable)e);
                return new CallingResponse.Error(requestId, e);
            }
            ++i;
        }
    }

    private ServiceConnectionHolder[] createServiceConnectionHolders(SignalUrl[] urls, List<Interceptor> interceptors, Optional<Dns> dns, Optional<SignalProxy> proxy) {
        LinkedList<ServiceConnectionHolder> serviceConnectionHolders = new LinkedList<ServiceConnectionHolder>();
        for (SignalUrl url : urls) {
            serviceConnectionHolders.add(new ServiceConnectionHolder(PushServiceSocket.createConnectionClient(url, interceptors, dns, proxy), PushServiceSocket.createConnectionClient(url, interceptors, dns, proxy), url.getUrl(), url.getHostHeader()));
        }
        return serviceConnectionHolders.toArray(new ServiceConnectionHolder[0]);
    }

    private static Map<Integer, ConnectionHolder[]> createCdnClientsMap(Map<Integer, SignalCdnUrl[]> signalCdnUrlMap, List<Interceptor> interceptors, Optional<Dns> dns, Optional<SignalProxy> proxy) {
        PushServiceSocket.validateConfiguration(signalCdnUrlMap);
        HashMap<Integer, ConnectionHolder[]> result2 = new HashMap<Integer, ConnectionHolder[]>();
        for (Map.Entry<Integer, SignalCdnUrl[]> entry : signalCdnUrlMap.entrySet()) {
            result2.put(entry.getKey(), PushServiceSocket.createConnectionHolders(entry.getValue(), interceptors, dns, proxy));
        }
        return Collections.unmodifiableMap(result2);
    }

    private static void validateConfiguration(Map<Integer, SignalCdnUrl[]> signalCdnUrlMap) {
        if (!signalCdnUrlMap.containsKey(0) || !signalCdnUrlMap.containsKey(2)) {
            throw new AssertionError((Object)"Configuration used to create PushServiceSocket must support CDN 0 and CDN 2");
        }
    }

    private static ConnectionHolder[] createConnectionHolders(SignalUrl[] urls, List<Interceptor> interceptors, Optional<Dns> dns, Optional<SignalProxy> proxy) {
        LinkedList<ConnectionHolder> connectionHolders = new LinkedList<ConnectionHolder>();
        for (SignalUrl url : urls) {
            connectionHolders.add(new ConnectionHolder(PushServiceSocket.createConnectionClient(url, interceptors, dns, proxy), url.getUrl(), url.getHostHeader()));
        }
        return connectionHolders.toArray(new ConnectionHolder[0]);
    }

    private static OkHttpClient createConnectionClient(SignalUrl url, List<Interceptor> interceptors, Optional<Dns> dns, Optional<SignalProxy> proxy) {
        try {
            TrustManager[] trustManagers = BlacklistingTrustManager.createFor(url.getTrustStore());
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, trustManagers, null);
            OkHttpClient.Builder builder = new OkHttpClient.Builder().sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(context.getSocketFactory()), (X509TrustManager)trustManagers[0]).connectionSpecs(url.getConnectionSpecs().orElse(Util.immutableList(ConnectionSpec.RESTRICTED_TLS))).dns(dns.orElse(Dns.SYSTEM));
            if (proxy.isPresent()) {
                builder.socketFactory((SocketFactory)new TlsProxySocketFactory(proxy.get().getHost(), proxy.get().getPort(), dns));
            }
            builder.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(context.getSocketFactory()), (X509TrustManager)trustManagers[0]).connectionSpecs(url.getConnectionSpecs().orElse(Util.immutableList(ConnectionSpec.RESTRICTED_TLS))).build();
            builder.connectionPool(new ConnectionPool(5, 45L, TimeUnit.SECONDS));
            for (Interceptor interceptor : interceptors) {
                builder.addInterceptor(interceptor);
            }
            return builder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String getAuthorizationHeader(CredentialsProvider credentialsProvider) {
        try {
            Object identifier;
            Object object = identifier = credentialsProvider.getAci() != null ? credentialsProvider.getAci().toString() : credentialsProvider.getE164();
            if (credentialsProvider.getDeviceId() != 1) {
                identifier = (String)identifier + "." + credentialsProvider.getDeviceId();
            }
            return "Basic " + Base64.encodeWithPadding((byte[])((String)identifier + ":" + credentialsProvider.getPassword()).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ConnectionHolder getRandom(ConnectionHolder[] connections, SecureRandom random) {
        return connections[random.nextInt(connections.length)];
    }

    private static byte[] readBodyBytes(Response response) throws PushNetworkException, MalformedResponseException {
        if (response.body() == null) {
            throw new MalformedResponseException("No body!");
        }
        try {
            return response.body().bytes();
        }
        catch (IOException e) {
            throw new PushNetworkException(e);
        }
    }

    private static byte[] readBodyBytes(@Nonnull ResponseBody responseBody) throws PushNetworkException {
        try {
            return responseBody.bytes();
        }
        catch (IOException e) {
            throw new PushNetworkException(e);
        }
    }

    static String readBodyString(Response response) throws PushNetworkException, MalformedResponseException {
        return PushServiceSocket.readBodyString(response.body());
    }

    private static String readBodyString(ResponseBody body) throws PushNetworkException, MalformedResponseException {
        if (body == null) {
            throw new MalformedResponseException("No body!");
        }
        return PushServiceSocket.readBodyStringNonNull(body);
    }

    private static String readBodyStringNonNull(ResponseBody body) throws PushNetworkException {
        try {
            return body.string();
        }
        catch (IOException e) {
            throw new PushNetworkException(e);
        }
    }

    private static <T> T readBodyJson(Response response, Class<T> clazz) throws PushNetworkException, MalformedResponseException {
        return PushServiceSocket.readBodyJson(response.body(), clazz);
    }

    private static <T> T readBodyJson(ResponseBody body, Class<T> clazz) throws PushNetworkException, MalformedResponseException {
        String json = PushServiceSocket.readBodyString(body);
        try {
            return JsonUtil.fromJson(json, clazz);
        }
        catch (JsonProcessingException e) {
            Log.w((String)TAG, (Throwable)e);
            throw new MalformedResponseException("Unable to parse entity", (IOException)((Object)e));
        }
        catch (IOException e) {
            throw new PushNetworkException(e);
        }
    }

    private static <T> T readResponseJson(Response response, Class<T> clazz) throws PushNetworkException, MalformedResponseException {
        return PushServiceSocket.readBodyJson(response.body(), clazz);
    }

    @Override
    public void close() {
        for (ServiceConnectionHolder holder : this.serviceClients) {
            holder.getClient().dispatcher().executorService().shutdown();
        }
        Iterator<ConnectionHolder[]> iterator = this.cdnClientsMap.values().iterator();
        while (iterator.hasNext()) {
            ConnectionHolder[] holders;
            for (ConnectionHolder holder : holders = (ConnectionHolder[])iterator.next()) {
                holder.getClient().dispatcher().executorService().shutdown();
            }
        }
        for (ConnectionHolder holder : this.storageClients) {
            holder.getClient().dispatcher().executorService().shutdown();
        }
    }

    public CredentialResponse retrieveGroupsV2Credentials(long todaySeconds) throws IOException {
        long todayPlus7 = todaySeconds + TimeUnit.DAYS.toSeconds(7L);
        String response = this.makeServiceRequest(String.format(Locale.US, GROUPSV2_CREDENTIAL, todaySeconds, todayPlus7), "GET", null, NO_HEADERS, NO_HANDLER, SealedSenderAccess.NONE);
        return JsonUtil.fromJson(response, CredentialResponse.class);
    }

    public GroupResponse putNewGroupsV2Group(Group group, GroupsV2AuthorizationString authorization) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        try (Response response = this.makeStorageRequest(authorization.toString(), GROUPSV2_GROUP, "PUT", PushServiceSocket.protobufRequestBody(group), GROUPS_V2_PUT_RESPONSE_HANDLER);){
            GroupResponse groupResponse = (GroupResponse)((Object)GroupResponse.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return groupResponse;
        }
    }

    public GroupResponse getGroupsV2Group(GroupsV2AuthorizationString authorization) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        try (Response response = this.makeStorageRequest(authorization.toString(), GROUPSV2_GROUP, "GET", null, GROUPS_V2_GET_CURRENT_HANDLER);){
            GroupResponse groupResponse = (GroupResponse)((Object)GroupResponse.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return groupResponse;
        }
    }

    public AvatarUploadAttributes getGroupsV2AvatarUploadForm(String authorization) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        try (Response response = this.makeStorageRequest(authorization, GROUPSV2_AVATAR_REQUEST, "GET", null, NO_HANDLER);){
            AvatarUploadAttributes avatarUploadAttributes = (AvatarUploadAttributes)((Object)AvatarUploadAttributes.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return avatarUploadAttributes;
        }
    }

    public GroupChangeResponse patchGroupsV2Group(GroupChange.Actions groupChange, String authorization, Optional<byte[]> groupLinkPassword) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        String path = groupLinkPassword.isPresent() ? String.format(GROUPSV2_GROUP_PASSWORD, Base64.encodeUrlSafeWithoutPadding((byte[])groupLinkPassword.get())) : GROUPSV2_GROUP;
        try (Response response = this.makeStorageRequest(authorization, path, "PATCH", PushServiceSocket.protobufRequestBody(groupChange), GROUPS_V2_PATCH_RESPONSE_HANDLER);){
            GroupChangeResponse groupChangeResponse = (GroupChangeResponse)((Object)GroupChangeResponse.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return groupChangeResponse;
        }
    }

    public GroupHistory getGroupHistory(int fromVersion, GroupsV2AuthorizationString authorization, int highestKnownEpoch, boolean includeFirstState, long sendEndorsementsExpirationMs) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Cached-Send-Endorsements", Long.toString(TimeUnit.MILLISECONDS.toSeconds(sendEndorsementsExpirationMs)));
        try (Response response = this.makeStorageRequest(authorization.toString(), String.format(Locale.US, GROUPSV2_GROUP_CHANGES, fromVersion, highestKnownEpoch, includeFirstState), "GET", null, headers, GROUPS_V2_GET_CURRENT_HANDLER);){
            if (response.body() == null) {
                throw new PushNetworkException("No body!");
            }
            GroupChanges groupChanges = (GroupChanges)((Object)GroupChanges.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            if (response.code() == 206) {
                String contentRangeHeader = response.header("Content-Range");
                Optional<ContentRange> contentRange = ContentRange.parse(contentRangeHeader);
                if (contentRange.isPresent()) {
                    Log.i((String)TAG, (String)("Additional logs for group: " + contentRangeHeader));
                    GroupHistory groupHistory = new GroupHistory(groupChanges, contentRange);
                    return groupHistory;
                }
                Log.w((String)TAG, (String)("Unable to parse Content-Range header: " + contentRangeHeader));
                throw new MalformedResponseException("Unable to parse content range header on 206");
            }
            GroupHistory groupHistory = new GroupHistory(groupChanges, Optional.empty());
            return groupHistory;
        }
    }

    public int getGroupJoinedAtRevision(GroupsV2AuthorizationString authorization) throws IOException {
        try (Response response = this.makeStorageRequest(authorization.toString(), GROUPSV2_JOINED_AT, "GET", null, GROUPS_V2_GET_CURRENT_HANDLER);){
            int n = ((Member)((Object)Member.ADAPTER.decode((byte[])PushServiceSocket.readBodyBytes((Response)response)))).joinedAtRevision;
            return n;
        }
    }

    public GroupJoinInfo getGroupJoinInfo(Optional<byte[]> groupLinkPassword, GroupsV2AuthorizationString authorization) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        String passwordParam = groupLinkPassword.map(Base64::encodeUrlSafeWithoutPadding).orElse(AVATAR_UPLOAD_PATH);
        try (Response response = this.makeStorageRequest(authorization.toString(), String.format(GROUPSV2_GROUP_JOIN, passwordParam), "GET", null, GROUPS_V2_GET_JOIN_INFO_HANDLER);){
            GroupJoinInfo groupJoinInfo = (GroupJoinInfo)((Object)GroupJoinInfo.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return groupJoinInfo;
        }
    }

    public GroupExternalCredential getGroupExternalCredential(GroupsV2AuthorizationString authorization) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        try (Response response = this.makeStorageRequest(authorization.toString(), GROUPSV2_TOKEN, "GET", null, NO_HANDLER);){
            GroupExternalCredential groupExternalCredential = (GroupExternalCredential)((Object)GroupExternalCredential.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return groupExternalCredential;
        }
    }

    public CurrencyConversions getCurrencyConversions() throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        String response = this.makeServiceRequest(PAYMENTS_CONVERSIONS, "GET", null);
        try {
            return JsonUtil.fromJson(response, CurrencyConversions.class);
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
            throw new MalformedResponseException("Unable to parse entity", e);
        }
    }

    public void reportSpam(ServiceId serviceId, String serverGuid, String reportingToken) throws NonSuccessfulResponseCodeException, MalformedResponseException, PushNetworkException {
        this.makeServiceRequest(String.format(REPORT_SPAM, serviceId.toString(), serverGuid), "POST", JsonUtil.toJson(new SpamTokenMessage(reportingToken)));
    }

    private static RegistrationSessionMetadataResponse parseSessionMetadataResponse(Response response) throws IOException {
        long serverDeliveredTimestamp = 0L;
        try {
            String stringValue = response.header(SERVER_DELIVERED_TIMESTAMP_HEADER);
            stringValue = stringValue != null ? stringValue : "0";
            serverDeliveredTimestamp = Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        RegistrationSessionMetadataHeaders responseHeaders = new RegistrationSessionMetadataHeaders(serverDeliveredTimestamp);
        RegistrationSessionMetadataJson responseBody = JsonUtil.fromJson(PushServiceSocket.readBodyString(response), RegistrationSessionMetadataJson.class);
        return new RegistrationSessionMetadataResponse(responseHeaders, responseBody, null);
    }

    private static class ServiceConnectionHolder
    extends ConnectionHolder {
        private final OkHttpClient unidentifiedClient;

        private ServiceConnectionHolder(OkHttpClient identifiedClient, OkHttpClient unidentifiedClient, String url, Optional<String> hostHeader) {
            super(identifiedClient, url, hostHeader);
            this.unidentifiedClient = unidentifiedClient;
        }

        OkHttpClient getUnidentifiedClient() {
            return this.unidentifiedClient;
        }
    }

    private static class ConnectionHolder {
        private final OkHttpClient client;
        private final String url;
        private final Optional<String> hostHeader;

        private ConnectionHolder(OkHttpClient client, String url, Optional<String> hostHeader) {
            this.client = client;
            this.url = url;
            this.hostHeader = hostHeader;
        }

        OkHttpClient getClient() {
            return this.client;
        }

        public String getUrl() {
            return this.url;
        }

        Optional<String> getHostHeader() {
            return this.hostHeader;
        }
    }

    private static class RegistrationSessionResponseHandler
    implements ResponseCodeHandler {
        private RegistrationSessionResponseHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body) throws NonSuccessfulResponseCodeException, PushNetworkException {
            if (responseCode == 403) {
                throw new IncorrectRegistrationRecoveryPasswordException();
            }
            if (responseCode == 404) {
                throw new NoSuchSessionException();
            }
            if (responseCode == 409) {
                RegistrationSessionMetadataJson response;
                try {
                    response = JsonUtil.fromJson(body.string(), RegistrationSessionMetadataJson.class);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                    throw new NonSuccessfulResponseCodeException(409);
                }
                if (response.getVerified()) {
                    throw new AlreadyVerifiedException();
                }
                if (response.pushChallengedRequired()) {
                    throw new PushChallengeRequiredException();
                }
                if (response.captchaRequired()) {
                    throw new CaptchaRequiredException();
                }
                Log.i((String)TAG, (String)("Received 409 in reg session handler that is not verified, with required information: " + String.join((CharSequence)", ", response.getRequestedInformation())));
                throw new HttpConflictException();
            }
            if (responseCode == 502) {
                VerificationCodeFailureResponseBody response;
                try {
                    response = JsonUtil.fromJson(body.string(), VerificationCodeFailureResponseBody.class);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                    throw new NonSuccessfulResponseCodeException(responseCode);
                }
                throw new ExternalServiceFailureException(response.getPermanentFailure(), response.getReason());
            }
        }
    }

    private static interface ResponseCodeHandler {
        public void handle(int var1, ResponseBody var2) throws NonSuccessfulResponseCodeException, PushNetworkException;

        default public void handle(int responseCode, ResponseBody body, Function<String, String> getHeader) throws NonSuccessfulResponseCodeException, PushNetworkException {
            this.handle(responseCode, body);
        }
    }

    private static class PatchRegistrationSessionResponseHandler
    implements ResponseCodeHandler {
        private PatchRegistrationSessionResponseHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body) throws NonSuccessfulResponseCodeException, PushNetworkException {
            switch (responseCode) {
                case 403: {
                    throw new TokenNotAcceptedException();
                }
                case 404: {
                    throw new NoSuchSessionException();
                }
                case 409: {
                    RegistrationSessionMetadataJson response;
                    try {
                        response = JsonUtil.fromJson(body.string(), RegistrationSessionMetadataJson.class);
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                        throw new NonSuccessfulResponseCodeException(409);
                    }
                    if (response.getVerified()) {
                        throw new AlreadyVerifiedException();
                    }
                    if (response.pushChallengedRequired()) {
                        throw new PushChallengeRequiredException();
                    }
                    if (response.captchaRequired()) {
                        throw new CaptchaRequiredException();
                    }
                    Log.i((String)TAG, (String)("Received 409 for patching reg session that is not verified, with required information: " + String.join((CharSequence)", ", response.getRequestedInformation())));
                    throw new HttpConflictException();
                }
            }
        }
    }

    public static enum VerificationCodeTransport {
        SMS,
        VOICE;

    }

    private static class RegistrationCodeRequestResponseHandler
    implements ResponseCodeHandler {
        private RegistrationCodeRequestResponseHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body) throws NonSuccessfulResponseCodeException, PushNetworkException {
            if (responseCode == 400) {
                throw new MalformedRequestException();
            }
            if (responseCode == 403) {
                throw new IncorrectRegistrationRecoveryPasswordException();
            }
            if (responseCode == 404) {
                throw new NoSuchSessionException();
            }
            if (responseCode == 409) {
                RegistrationSessionMetadataJson response;
                try {
                    response = JsonUtil.fromJson(body.string(), RegistrationSessionMetadataJson.class);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                    throw new NonSuccessfulResponseCodeException(409);
                }
                if (response.getVerified()) {
                    throw new AlreadyVerifiedException();
                }
                if (response.pushChallengedRequired()) {
                    throw new PushChallengeRequiredException();
                }
                if (response.captchaRequired()) {
                    throw new CaptchaRequiredException();
                }
                Log.i((String)TAG, (String)("Received 409 in for reg code request that is not verified, with required information: " + String.join((CharSequence)", ", response.getRequestedInformation())));
                throw new HttpConflictException();
            }
            if (responseCode == 418) {
                throw new InvalidTransportModeException();
            }
            if (responseCode == 429) {
                throw new RegistrationRetryException();
            }
            if (responseCode == 440) {
                VerificationCodeFailureResponseBody response;
                try {
                    response = JsonUtil.fromJson(body.string(), VerificationCodeFailureResponseBody.class);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                    throw new NonSuccessfulResponseCodeException(responseCode);
                }
                throw new ExternalServiceFailureException(response.getPermanentFailure(), response.getReason());
            }
        }
    }

    private static class RegistrationCodeSubmissionResponseHandler
    implements ResponseCodeHandler {
        private RegistrationCodeSubmissionResponseHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body) throws NonSuccessfulResponseCodeException, PushNetworkException {
            switch (responseCode) {
                case 400: {
                    throw new InvalidTransportModeException();
                }
                case 404: {
                    throw new NoSuchSessionException();
                }
                case 409: {
                    RegistrationSessionMetadataJson sessionMetadata;
                    try {
                        sessionMetadata = JsonUtil.fromJson(body.string(), RegistrationSessionMetadataJson.class);
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                        throw new NonSuccessfulResponseCodeException(409);
                    }
                    if (sessionMetadata.getVerified()) {
                        throw new AlreadyVerifiedException();
                    }
                    if (sessionMetadata.getNextVerificationAttempt() == null) {
                        throw new MustRequestNewCodeException();
                    }
                    Log.i((String)TAG, (String)("Received 409 for reg code submission that is not verified, with required information: " + String.join((CharSequence)", ", sessionMetadata.getRequestedInformation())));
                    throw new HttpConflictException();
                }
                case 440: {
                    VerificationCodeFailureResponseBody codeFailureResponse;
                    try {
                        codeFailureResponse = JsonUtil.fromJson(body.string(), VerificationCodeFailureResponseBody.class);
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                        throw new NonSuccessfulResponseCodeException(responseCode);
                    }
                    throw new ExternalServiceFailureException(codeFailureResponse.getPermanentFailure(), codeFailureResponse.getReason());
                }
            }
        }
    }

    private static class RegistrationLockV2 {
        @JsonProperty
        private String registrationLock;

        public RegistrationLockV2() {
        }

        public RegistrationLockV2(String registrationLock) {
            this.registrationLock = registrationLock;
        }
    }

    private static class InAppPaymentResponseCodeHandler
    implements ResponseCodeHandler {
        private InAppPaymentResponseCodeHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body) throws NonSuccessfulResponseCodeException, PushNetworkException {
            if (responseCode < 400) {
                return;
            }
            if (responseCode == 440) {
                InAppPaymentProcessorError exception;
                try {
                    exception = JsonUtil.fromJson(body.string(), InAppPaymentProcessorError.class);
                }
                catch (IOException e) {
                    throw new NonSuccessfulResponseCodeException(440);
                }
                throw exception;
            }
            throw new NonSuccessfulResponseCodeException(responseCode);
        }
    }

    private static class LinkGooglePlayBillingPurchaseTokenResponseCodeHandler
    implements ResponseCodeHandler {
        private LinkGooglePlayBillingPurchaseTokenResponseCodeHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body) throws NonSuccessfulResponseCodeException, PushNetworkException {
            if (responseCode < 400) {
                return;
            }
            throw new NonSuccessfulResponseCodeException(responseCode);
        }
    }

    private final class ResumeInfo {
        private final String contentRange;
        private final long contentStart;

        private ResumeInfo(String contentRange, long offset) {
            this.contentRange = contentRange;
            this.contentStart = offset;
        }
    }

    public static class RegistrationLockFailure {
        @JsonProperty
        public int length;
        @JsonProperty
        public long timeRemaining;
        @JsonProperty(value="backupCredentials")
        public AuthCredentials svr1Credentials;
        @JsonProperty
        public AuthCredentials svr2Credentials;
        @JsonProperty
        public Svr3Credentials svr3Credentials;
    }

    public static final class GroupHistory {
        private final GroupChanges groupChanges;
        private final Optional<ContentRange> contentRange;

        public GroupHistory(GroupChanges groupChanges, Optional<ContentRange> contentRange) {
            this.groupChanges = groupChanges;
            this.contentRange = contentRange;
        }

        public GroupChanges getGroupChanges() {
            return this.groupChanges;
        }

        public boolean hasMore() {
            return this.contentRange.isPresent();
        }

        public int getNextPageStartGroupRevision() {
            return this.contentRange.get().getRangeEnd() + 1;
        }
    }

    private static class EmptyResponseCodeHandler
    implements ResponseCodeHandler {
        private EmptyResponseCodeHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body) {
        }
    }

    private static class UnopinionatedResponseCodeHandler
    implements ResponseCodeHandler {
        private UnopinionatedResponseCodeHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body) throws NonSuccessfulResponseCodeException, PushNetworkException {
            if (responseCode < 200 || responseCode > 299) {
                String bodyString = null;
                if (body != null) {
                    try {
                        bodyString = PushServiceSocket.readBodyString(body);
                    }
                    catch (MalformedResponseException e) {
                        Log.w((String)TAG, (String)"Failed to read body string", (Throwable)e);
                    }
                }
                throw new NonSuccessfulResponseCodeException(responseCode, "Response: " + responseCode, bodyString);
            }
        }
    }

    public static enum ClientSet {
        KeyBackup;

    }

    private static class RegistrationLock {
        @JsonProperty
        private String pin;

        public RegistrationLock() {
        }

        public RegistrationLock(String pin) {
            this.pin = pin;
        }
    }
}

