/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state;

import java.time.Instant;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class SessionRecord
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.SessionRecord_Destroy(this.unsafeHandle);
    }

    public SessionRecord() {
        this.unsafeHandle = Native.SessionRecord_NewFresh();
    }

    private SessionRecord(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    public SessionRecord(byte[] serialized) throws InvalidMessageException {
        this.unsafeHandle = FilterExceptions.filterExceptions(InvalidMessageException.class, () -> Native.SessionRecord_Deserialize(serialized));
    }

    public void archiveCurrentState() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            FilterExceptions.filterExceptions(() -> Native.SessionRecord_ArchiveCurrentState(guard.nativeHandle()));
        }
    }

    public int getSessionVersion() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.SessionRecord_GetSessionVersion(guard.nativeHandle()));
            return n;
        }
    }

    public int getRemoteRegistrationId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.SessionRecord_GetRemoteRegistrationId(guard.nativeHandle()));
            return n;
        }
    }

    public int getLocalRegistrationId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.SessionRecord_GetLocalRegistrationId(guard.nativeHandle()));
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IdentityKey getRemoteIdentityKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] keyBytes = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.SessionRecord_GetRemoteIdentityKeyPublic(guard.nativeHandle()));
            if (keyBytes == null) {
                IdentityKey identityKey = null;
                return identityKey;
            }
            IdentityKey identityKey = new IdentityKey(keyBytes);
            return identityKey;
        }
        catch (InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public IdentityKey getLocalIdentityKey() {
        NativeHandleGuard guard = new NativeHandleGuard(this);
        try {
            byte[] keyBytes = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.SessionRecord_GetLocalIdentityKeyPublic(guard.nativeHandle()));
            IdentityKey identityKey = new IdentityKey(keyBytes);
            guard.close();
            return identityKey;
        }
        catch (Throwable throwable) {
            try {
                try {
                    guard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InvalidKeyException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public boolean hasSenderChain() {
        return this.hasSenderChain(Instant.now());
    }

    public boolean hasSenderChain(Instant now) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            boolean bl = FilterExceptions.filterExceptions(() -> Native.SessionRecord_HasUsableSenderChain(guard.nativeHandle(), now.toEpochMilli()));
            return bl;
        }
    }

    public boolean currentRatchetKeyMatches(ECPublicKey key) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            NativeHandleGuard keyGuard = new NativeHandleGuard(key);
            try {
                boolean bl = FilterExceptions.filterExceptions(() -> Native.SessionRecord_CurrentRatchetKeyMatches(guard.nativeHandle(), keyGuard.nativeHandle()));
                keyGuard.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    keyGuard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.SessionRecord_Serialize(guard.nativeHandle()));
            return byArray;
        }
    }

    public byte[] getReceiverChainKeyValue(ECPublicKey senderEphemeral) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            NativeHandleGuard ephemeralGuard = new NativeHandleGuard(senderEphemeral);
            try {
                byte[] byArray = FilterExceptions.filterExceptions(() -> Native.SessionRecord_GetReceiverChainKeyValue(guard.nativeHandle(), ephemeralGuard.nativeHandle()));
                ephemeralGuard.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    ephemeralGuard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public byte[] getSenderChainKeyValue() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.SessionRecord_GetSenderChainKeyValue(guard.nativeHandle()));
            return byArray;
        }
    }

    public byte[] getAliceBaseKey() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.SessionRecord_GetAliceBaseKey(guard.nativeHandle()));
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    public static SessionRecord initializeAliceSession(IdentityKeyPair identityKey, ECKeyPair baseKey, IdentityKey theirIdentityKey, ECPublicKey theirSignedPreKey, ECPublicKey theirRatchetKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static SessionRecord initializeBobSession(IdentityKeyPair identityKey, ECKeyPair signedPreKey, ECKeyPair ephemeralKey, IdentityKey theirIdentityKey, ECPublicKey theirBaseKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    private static /* synthetic */ long lambda$initializeBobSession$14(NativeHandleGuard identityPrivateGuard, NativeHandleGuard identityPublicGuard, NativeHandleGuard signedPreKeyPrivateGuard, NativeHandleGuard signedPreKeyPublicGuard, NativeHandleGuard ephemeralPrivateGuard, NativeHandleGuard ephemeralPublicGuard, NativeHandleGuard theirIdentityGuard, NativeHandleGuard theirBaseKeyGuard) throws Exception {
        return Native.SessionRecord_InitializeBobSession(identityPrivateGuard.nativeHandle(), identityPublicGuard.nativeHandle(), signedPreKeyPrivateGuard.nativeHandle(), signedPreKeyPublicGuard.nativeHandle(), ephemeralPrivateGuard.nativeHandle(), ephemeralPublicGuard.nativeHandle(), theirIdentityGuard.nativeHandle(), theirBaseKeyGuard.nativeHandle());
    }

    private static /* synthetic */ long lambda$initializeAliceSession$13(NativeHandleGuard identityPrivateGuard, NativeHandleGuard identityPublicGuard, NativeHandleGuard basePrivateGuard, NativeHandleGuard basePublicGuard, NativeHandleGuard theirIdentityGuard, NativeHandleGuard theirSignedPreKeyGuard, NativeHandleGuard theirRatchetKeyGuard) throws Exception {
        return Native.SessionRecord_InitializeAliceSession(identityPrivateGuard.nativeHandle(), identityPublicGuard.nativeHandle(), basePrivateGuard.nativeHandle(), basePublicGuard.nativeHandle(), theirIdentityGuard.nativeHandle(), theirSignedPreKeyGuard.nativeHandle(), theirRatchetKeyGuard.nativeHandle());
    }
}

