/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.backups;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BackupLevel {
    MESSAGES(200),
    MEDIA(201);

    private static final Map<Integer, BackupLevel> LOOKUP;
    private final int value;

    private BackupLevel(int value) {
        this.value = value;
    }

    int getValue() {
        return this.value;
    }

    public static BackupLevel fromValue(int value) {
        BackupLevel backupLevel = LOOKUP.get(value);
        if (backupLevel == null) {
            throw new IllegalArgumentException("Invalid backup level: " + value);
        }
        return backupLevel;
    }

    static {
        LOOKUP = Arrays.stream(BackupLevel.values()).collect(Collectors.toMap(BackupLevel::getValue, Function.identity()));
    }
}

