# This file generated by `mix dagger.gen`. Please DO NOT EDIT.
defmodule Dagger.Host do
  @moduledoc "Information about the host environment."
  use Dagger.QueryBuilder
  @type t() :: %__MODULE__{}
  defstruct [:selection, :client]

  (
    @doc "Accesses a directory on the host.\n\n## Required Arguments\n\n* `path` - Location of the directory to access (e.g., \".\").\n\n## Optional Arguments\n\n* `exclude` - Exclude artifacts that match the given pattern (e.g., [\"node_modules/\", \".git*\"]).\n* `include` - Include only artifacts that match the given pattern (e.g., [\"app/\", \"package.*\"])."
    @spec directory(t(), Dagger.String.t(), keyword()) :: Dagger.Directory.t()
    def directory(%__MODULE__{} = host, path, optional_args \\ []) do
      selection = select(host.selection, "directory")
      selection = arg(selection, "path", path)

      selection =
        if is_nil(optional_args[:exclude]) do
          selection
        else
          arg(selection, "exclude", optional_args[:exclude])
        end

      selection =
        if is_nil(optional_args[:include]) do
          selection
        else
          arg(selection, "include", optional_args[:include])
        end

      %Dagger.Directory{selection: selection, client: host.client}
    end
  )

  (
    @doc "Accesses a file on the host.\n\n## Required Arguments\n\n* `path` - Location of the file to retrieve (e.g., \"README.md\")."
    @spec file(t(), Dagger.String.t()) :: Dagger.File.t()
    def file(%__MODULE__{} = host, path) do
      selection = select(host.selection, "file")
      selection = arg(selection, "path", path)
      %Dagger.File{selection: selection, client: host.client}
    end
  )

  (
    @doc "A unique identifier for this Host."
    @spec id(t()) :: {:ok, Dagger.HostID.t()} | {:error, term()}
    def id(%__MODULE__{} = host) do
      selection = select(host.selection, "id")
      execute(selection, host.client)
    end
  )

  (
    @doc "Creates a service that forwards traffic to a specified address via the host.\n\n## Required Arguments\n\n* `ports` - Ports to expose via the service, forwarding through the host network.\n\nIf a port's frontend is unspecified or 0, it defaults to the same as the backend port.\n\nAn empty set of ports is not valid; an error will be returned.\n\n## Optional Arguments\n\n* `host` - Upstream host to forward traffic to."
    @spec service(t(), [Dagger.PortForward.t()], keyword()) :: Dagger.Service.t()
    def service(%__MODULE__{} = host, ports, optional_args \\ []) do
      selection = select(host.selection, "service")
      selection = arg(selection, "ports", ports)

      selection =
        if is_nil(optional_args[:host]) do
          selection
        else
          arg(selection, "host", optional_args[:host])
        end

      %Dagger.Service{selection: selection, client: host.client}
    end
  )

  (
    @doc "Sets a secret given a user-defined name and the file path on the host, and returns the secret.\n\nThe file is limited to a size of 512000 bytes.\n\n## Required Arguments\n\n* `name` - The user defined name for this secret.\n* `path` - Location of the file to set as a secret."
    @spec set_secret_file(t(), Dagger.String.t(), Dagger.String.t()) :: Dagger.Secret.t()
    def set_secret_file(%__MODULE__{} = host, name, path) do
      selection = select(host.selection, "setSecretFile")
      selection = arg(selection, "name", name)
      selection = arg(selection, "path", path)
      %Dagger.Secret{selection: selection, client: host.client}
    end
  )

  (
    @doc "Creates a tunnel that forwards traffic from the host to a service.\n\n## Required Arguments\n\n* `service` - Service to send traffic from the tunnel.\n\n## Optional Arguments\n\n* `ports` - Configure explicit port forwarding rules for the tunnel.\n\nIf a port's frontend is unspecified or 0, a random port will be chosen by the host.\n\nIf no ports are given, all of the service's ports are forwarded. If native is true, each port maps to the same port on the host. If native is false, each port maps to a random port chosen by the host.\n\nIf ports are given and native is true, the ports are additive.\n* `native` - Map each service port to the same port on the host, as if the service were running natively.\n\nNote: enabling may result in port conflicts."
    @spec tunnel(t(), Dagger.Service.t(), keyword()) :: Dagger.Service.t()
    def tunnel(%__MODULE__{} = host, service, optional_args \\ []) do
      selection = select(host.selection, "tunnel")

      (
        {:ok, id} = Dagger.Service.id(service)
        selection = arg(selection, "service", id)
      )

      selection =
        if is_nil(optional_args[:ports]) do
          selection
        else
          arg(selection, "ports", optional_args[:ports])
        end

      selection =
        if is_nil(optional_args[:native]) do
          selection
        else
          arg(selection, "native", optional_args[:native])
        end

      %Dagger.Service{selection: selection, client: host.client}
    end
  )

  (
    @doc "Accesses a Unix socket on the host.\n\n## Required Arguments\n\n* `path` - Location of the Unix socket (e.g., \"/var/run/docker.sock\")."
    @spec unix_socket(t(), Dagger.String.t()) :: Dagger.Socket.t()
    def unix_socket(%__MODULE__{} = host, path) do
      selection = select(host.selection, "unixSocket")
      selection = arg(selection, "path", path)
      %Dagger.Socket{selection: selection, client: host.client}
    end
  )
end
