<?php

/**
 * This class has been generated by dagger-php-sdk. DO NOT EDIT.
 */

declare(strict_types=1);

namespace Dagger;

/**
 * A file.
 */
class File extends Client\AbstractObject implements Client\IdAble
{
    /**
     * Retrieves the contents of the file.
     */
    public function contents(): string
    {
        $leafQueryBuilder = new \Dagger\Client\QueryBuilder('contents');
        return (string)$this->queryLeaf($leafQueryBuilder, 'contents');
    }

    /**
     * Writes the file to a file path on the host.
     */
    public function export(string $path, ?bool $allowParentDirPath = false): bool
    {
        $leafQueryBuilder = new \Dagger\Client\QueryBuilder('export');
        $leafQueryBuilder->setArgument('path', $path);
        if (null !== $allowParentDirPath) {
        $leafQueryBuilder->setArgument('allowParentDirPath', $allowParentDirPath);
        }
        return (bool)$this->queryLeaf($leafQueryBuilder, 'export');
    }

    /**
     * A unique identifier for this File.
     */
    public function id(): FileId
    {
        $leafQueryBuilder = new \Dagger\Client\QueryBuilder('id');
        return new \Dagger\FileId((string)$this->queryLeaf($leafQueryBuilder, 'id'));
    }

    /**
     * Retrieves the name of the file.
     */
    public function name(): string
    {
        $leafQueryBuilder = new \Dagger\Client\QueryBuilder('name');
        return (string)$this->queryLeaf($leafQueryBuilder, 'name');
    }

    /**
     * Retrieves the size of the file, in bytes.
     */
    public function size(): int
    {
        $leafQueryBuilder = new \Dagger\Client\QueryBuilder('size');
        return (int)$this->queryLeaf($leafQueryBuilder, 'size');
    }

    /**
     * Force evaluation in the engine.
     */
    public function sync(): FileId
    {
        $leafQueryBuilder = new \Dagger\Client\QueryBuilder('sync');
        return new \Dagger\FileId((string)$this->queryLeaf($leafQueryBuilder, 'sync'));
    }

    /**
     * Retrieves this file with its created/modified timestamps set to the given time.
     */
    public function withTimestamps(int $timestamp): File
    {
        $innerQueryBuilder = new \Dagger\Client\QueryBuilder('withTimestamps');
        $innerQueryBuilder->setArgument('timestamp', $timestamp);
        return new \Dagger\File($this->client, $this->queryBuilderChain->chain($innerQueryBuilder));
    }
}
