<?php

/**
 * This class has been generated by dagger-php-sdk. DO NOT EDIT.
 */

declare(strict_types=1);

namespace Dagger;

/**
 * Information about the host environment.
 */
class Host extends Client\AbstractObject implements Client\IdAble
{
    /**
     * Accesses a directory on the host.
     */
    public function directory(string $path, ?array $exclude = null, ?array $include = null): Directory
    {
        $innerQueryBuilder = new \Dagger\Client\QueryBuilder('directory');
        $innerQueryBuilder->setArgument('path', $path);
        if (null !== $exclude) {
        $innerQueryBuilder->setArgument('exclude', $exclude);
        }
        if (null !== $include) {
        $innerQueryBuilder->setArgument('include', $include);
        }
        return new \Dagger\Directory($this->client, $this->queryBuilderChain->chain($innerQueryBuilder));
    }

    /**
     * Accesses a file on the host.
     */
    public function file(string $path): File
    {
        $innerQueryBuilder = new \Dagger\Client\QueryBuilder('file');
        $innerQueryBuilder->setArgument('path', $path);
        return new \Dagger\File($this->client, $this->queryBuilderChain->chain($innerQueryBuilder));
    }

    /**
     * A unique identifier for this Host.
     */
    public function id(): HostId
    {
        $leafQueryBuilder = new \Dagger\Client\QueryBuilder('id');
        return new \Dagger\HostId((string)$this->queryLeaf($leafQueryBuilder, 'id'));
    }

    /**
     * Creates a service that forwards traffic to a specified address via the host.
     */
    public function service(?string $host = 'localhost', array $ports): Service
    {
        $innerQueryBuilder = new \Dagger\Client\QueryBuilder('service');
        if (null !== $host) {
        $innerQueryBuilder->setArgument('host', $host);
        }
        $innerQueryBuilder->setArgument('ports', $ports);
        return new \Dagger\Service($this->client, $this->queryBuilderChain->chain($innerQueryBuilder));
    }

    /**
     * Sets a secret given a user-defined name and the file path on the host, and returns the secret.
     *
     * The file is limited to a size of 512000 bytes.
     */
    public function setSecretFile(string $name, string $path): Secret
    {
        $innerQueryBuilder = new \Dagger\Client\QueryBuilder('setSecretFile');
        $innerQueryBuilder->setArgument('name', $name);
        $innerQueryBuilder->setArgument('path', $path);
        return new \Dagger\Secret($this->client, $this->queryBuilderChain->chain($innerQueryBuilder));
    }

    /**
     * Creates a tunnel that forwards traffic from the host to a service.
     */
    public function tunnel(ServiceId|Service $service, ?array $ports = null, ?bool $native = false): Service
    {
        $innerQueryBuilder = new \Dagger\Client\QueryBuilder('tunnel');
        $innerQueryBuilder->setArgument('service', $service);
        if (null !== $ports) {
        $innerQueryBuilder->setArgument('ports', $ports);
        }
        if (null !== $native) {
        $innerQueryBuilder->setArgument('native', $native);
        }
        return new \Dagger\Service($this->client, $this->queryBuilderChain->chain($innerQueryBuilder));
    }

    /**
     * Accesses a Unix socket on the host.
     */
    public function unixSocket(string $path): Socket
    {
        $innerQueryBuilder = new \Dagger\Client\QueryBuilder('unixSocket');
        $innerQueryBuilder->setArgument('path', $path);
        return new \Dagger\Socket($this->client, $this->queryBuilderChain->chain($innerQueryBuilder));
    }
}
