/*
 *
 * Copyright (c) 2007-2016 The University of Waikato, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This file is part of libtrace.
 *
 * This code has been developed by the University of Waikato WAND
 * research group. For further information please see http://www.wand.net.nz/
 *
 * libtrace is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * libtrace is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
#include "lt_bswap.h"

/* Byte swapping functions for various inttypes */
uint64_t byteswap64(uint64_t num)
{
    return (byteswap32((num & 0xFFFFFFFF00000000ULL) >> 32)) |
           ((uint64_t)byteswap32(num & 0x00000000FFFFFFFFULL) << 32);
}

uint32_t byteswap32(uint32_t num)
{
    return ((num & 0x000000FFU) << 24) | ((num & 0x0000FF00U) << 8) |
           ((num & 0x00FF0000U) >> 8) | ((num & 0xFF000000U) >> 24);
}

uint16_t byteswap16(uint16_t num)
{
    return ((num << 8) & 0xFF00) | ((num >> 8) & 0x00FF);
}
