/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.facet.base.AbstractSubScopeFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.cdom.facet.model.ClassLevelFacet;
import pcgen.cdom.facet.model.DomainFacet;
import pcgen.cdom.helper.ClassSource;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.Skill;
import pcgen.util.Logging;

public class LocalSkillCostFacet
extends AbstractSubScopeFacet<PCClass, SkillCost, Skill>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private DomainFacet domainFacet;
    private ClassFacet classFacet;
    private ClassLevelFacet classLevelFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        PCClass owner;
        CDOMObject cdo = dfce.getCDOMObject();
        CharID id = dfce.getCharID();
        if (cdo instanceof Domain) {
            owner = ((ClassSource)this.domainFacet.getSource(id, (Domain)cdo)).getPcclass();
        } else if (cdo instanceof PCClassLevel) {
            owner = (PCClass)cdo.get(ObjectKey.PARENT);
        } else if (cdo instanceof PCClass) {
            owner = (PCClass)cdo;
        } else {
            Logging.errorPrint(this.getClass().getSimpleName() + " was given " + cdo + " which is not an expected object type");
            return;
        }
        for (CDOMReference<Skill> ref : cdo.getSafeListFor(ListKey.LOCALCSKILL)) {
            for (Skill sk : ref.getContainedObjects()) {
                this.add(id, owner, SkillCost.CLASS, sk, cdo);
            }
        }
        for (CDOMReference<Skill> ref : cdo.getSafeListFor(ListKey.LOCALCCSKILL)) {
            for (Skill sk : ref.getContainedObjects()) {
                this.add(id, owner, SkillCost.CROSS_CLASS, sk, cdo);
            }
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAllFromSource(dfce.getCharID(), dfce.getCDOMObject());
    }

    public void setDomainFacet(DomainFacet domainFacet) {
        this.domainFacet = domainFacet;
    }

    public void setClassFacet(ClassFacet classFacet) {
        this.classFacet = classFacet;
    }

    public void setClassLevelFacet(ClassLevelFacet classLevelFacet) {
        this.classLevelFacet = classLevelFacet;
    }

    public void init() {
        this.classFacet.addDataFacetChangeListener(this);
        this.domainFacet.addDataFacetChangeListener(this);
        this.classLevelFacet.addDataFacetChangeListener(this);
    }
}

