/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.facet.CDOMObjectConsolidationFacet;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.Race;
import pcgen.core.SizeAdjustment;
import pcgen.core.analysis.SizeUtilities;

public class UnarmedDamageFacet
extends AbstractSourcedListFacet<CharID, List<String>>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private RaceFacet raceFacet;
    private FormulaResolvingFacet formulaResolvingFacet;
    private CDOMObjectConsolidationFacet consolidationFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        CDOMObject cdo = dfce.getCDOMObject();
        if (cdo instanceof PCClass || cdo instanceof PCClassLevel) {
            return;
        }
        List<String> damage = cdo.getListFor(ListKey.UNARMED_DAMAGE);
        if (damage != null) {
            this.add(dfce.getCharID(), damage, cdo);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.removeAll(dfce.getCharID(), dfce.getCDOMObject());
    }

    public String getUDamForRace(CharID id) {
        Race race = (Race)((AbstractItemFacet)this.raceFacet).get(id);
        int iSize = this.formulaResolvingFacet.resolve(id, race.getSafe(FormulaKey.SIZE), race.getQualifiedKey()).intValue();
        SizeAdjustment defAdj = SizeUtilities.getDefaultSizeAdjustment();
        SizeAdjustment sizAdj = Globals.getContext().getReferenceContext().getSortedList(SizeAdjustment.class, IntegerKey.SIZEORDER).get(iSize);
        if (sizAdj != null) {
            return Globals.adjustDamage("1d3", defAdj, sizAdj);
        }
        return "1d3";
    }

    @Override
    protected Map<List<String>, Set<Object>> getComponentMap() {
        return new HashMap<List<String>, Set<Object>>();
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setConsolidationFacet(CDOMObjectConsolidationFacet consolidationFacet) {
        this.consolidationFacet = consolidationFacet;
    }

    public void init() {
        this.consolidationFacet.addDataFacetChangeListener(this);
    }
}

