/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.BonusObj;
import pcgen.facade.core.SkillFacade;

public final class Skill
extends PObject
implements SkillFacade,
ChooseDriver {
    public String getKeyStatAbb() {
        CDOMSingleRef<PCStat> keyStat = this.get(ObjectKey.KEY_STAT);
        return keyStat == null ? "" : keyStat.resolvesTo().getKeyName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Skill && this.getKeyName().equalsIgnoreCase(((Skill)obj).getKeyName());
    }

    public int hashCode() {
        return this.getKeyName().hashCode();
    }

    @Override
    public String getKeyStat() {
        return this.getKeyStatAbb();
    }

    @Override
    public boolean isUntrained() {
        return this.getSafe(ObjectKey.USE_UNTRAINED);
    }

    @Override
    public String getDisplayType() {
        List<Type> trueTypeList = this.getTrueTypeList(true);
        return StringUtil.join(trueTypeList, (String)".");
    }

    @Override
    public List<BonusObj> getRawBonusList(PlayerCharacter pc) {
        ArrayList<BonusObj> list = new ArrayList<BonusObj>(super.getRawBonusList(pc));
        Collections.sort(list, new SkillBonusComparator(this));
        return list;
    }

    @Override
    public ChooseInformation<?> getChooseInfo() {
        return this.get(ObjectKey.CHOOSE_INFO);
    }

    @Override
    public Formula getSelectFormula() {
        return this.getSafe(FormulaKey.SELECT);
    }

    @Override
    public List<ChooseSelectionActor<?>> getActors() {
        return this.getListFor(ListKey.NEW_CHOOSE_ACTOR);
    }

    @Override
    public String getFormulaSource() {
        return this.getKeyName();
    }

    @Override
    public Formula getNumChoices() {
        return this.getSafe(FormulaKey.NUMCHOICES);
    }

    public class SkillBonusComparator
    implements Comparator<BonusObj> {
        private final Skill skill;

        private SkillBonusComparator(Skill skill2) {
            this.skill = skill2;
        }

        @Override
        public int compare(BonusObj arg0, BonusObj arg1) {
            boolean arg1BonusThisSkill;
            boolean arg0BonusThisSkill = this.bonusToThisSkill(arg0);
            if (arg0BonusThisSkill != (arg1BonusThisSkill = this.bonusToThisSkill(arg1))) {
                if (arg0BonusThisSkill) {
                    return -1;
                }
                return 1;
            }
            if (arg0.hasPrerequisites() != arg1.hasPrerequisites()) {
                if (arg1.hasPrerequisites()) {
                    return -1;
                }
                return 1;
            }
            return arg0.toString().compareTo(arg1.toString());
        }

        private boolean bonusToThisSkill(BonusObj bonus) {
            if (!"SKILL".equals(bonus.getBonusName())) {
                return false;
            }
            for (Object target : bonus.getBonusInfoList()) {
                if (!String.valueOf(target).equalsIgnoreCase(this.skill.getKeyName())) continue;
                return true;
            }
            return false;
        }
    }
}

