/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.HashMap;
import java.util.Map;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SubClass;
import pcgen.core.npcgen.SkillChoice;
import pcgen.core.spell.Spell;

public class ClassData {
    private PCClass theClass = null;
    private WeightedCollection<PCStat> theStatWeights = null;
    private WeightedCollection<SkillChoice> theSkillWeights = null;
    private Map<AbilityCategory, WeightedCollection<Ability>> theAbilityWeights = null;
    private WeightedCollection<Deity> theDeityWeights = null;
    private Map<String, WeightedCollection<Domain>> theDomainWeights = null;
    private Map<Integer, WeightedCollection<Spell>> theKnownSpellWeights = null;
    private Map<Integer, WeightedCollection<Spell>> thePreparedSpellWeights = null;
    private WeightedCollection<String> theSubClassWeights = null;

    public ClassData(PCClass aClass) {
        this.theClass = aClass;
    }

    public PCClass getPCClass() {
        return this.theClass;
    }

    public void addStat(PCStat stat, int aWeight) {
        if (this.theStatWeights == null) {
            this.theStatWeights = new WeightedCollection();
        }
        this.theStatWeights.add(stat, aWeight);
    }

    public WeightedCollection<PCStat> getStatWeights() {
        for (PCStat stat : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCStat.class)) {
            if (this.theStatWeights != null && this.theStatWeights.contains(stat)) continue;
            this.addStat(stat, 1);
        }
        return this.theStatWeights;
    }

    public void addSkill(String aKey, int aWeight) {
        if (this.theSkillWeights == null) {
            this.theSkillWeights = new WeightedCollection();
        }
        for (SkillChoice sc : this.theSkillWeights) {
            if (!sc.hasSkill(aKey)) continue;
            return;
        }
        this.theSkillWeights.add(new SkillChoice(aKey), aWeight);
    }

    public void removeSkill(String aKey) {
        if (this.theSkillWeights == null) {
            return;
        }
        this.theSkillWeights.remove(new SkillChoice(aKey));
    }

    public WeightedCollection<SkillChoice> getSkillWeights() {
        return this.theSkillWeights;
    }

    public void addAbility(AbilityCategory aCategory, Ability anAbility, int aWeight) {
        WeightedCollection<Ability> abilities;
        if (this.theAbilityWeights == null) {
            this.theAbilityWeights = new HashMap<AbilityCategory, WeightedCollection<Ability>>();
        }
        if ((abilities = this.theAbilityWeights.get(aCategory)) == null) {
            abilities = new WeightedCollection();
            this.theAbilityWeights.put(aCategory, abilities);
        }
        if (!abilities.contains(anAbility)) {
            abilities.add(anAbility, aWeight);
        }
    }

    public void removeAbility(AbilityCategory aCategory, Ability anAbility) {
        if (this.theAbilityWeights == null) {
            return;
        }
        WeightedCollection<Ability> abilities = this.theAbilityWeights.get(aCategory);
        if (abilities == null) {
            return;
        }
        abilities.remove(anAbility);
    }

    public WeightedCollection<Ability> getAbilityWeights(AbilityCategory aCategory) {
        if (this.theAbilityWeights == null) {
            return null;
        }
        return this.theAbilityWeights.get(aCategory);
    }

    public void addDeity(Deity aDeity, int aWeight) {
        if (this.theDeityWeights == null) {
            this.theDeityWeights = new WeightedCollection();
        }
        this.theDeityWeights.add(aDeity, aWeight);
    }

    public WeightedCollection<Deity> getDeityWeights() {
        if (this.theDeityWeights == null) {
            for (Deity deity : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Deity.class)) {
                this.addDeity(deity, 1);
            }
        }
        return this.theDeityWeights;
    }

    public void addDomain(String aDeityKey, Domain aDomain, int aWeight) {
        WeightedCollection<Domain> domains;
        if (this.theDomainWeights == null) {
            this.theDomainWeights = new HashMap<String, WeightedCollection<Domain>>();
        }
        if ((domains = this.theDomainWeights.get(aDeityKey)) == null) {
            domains = new WeightedCollection();
            this.theDomainWeights.put(aDeityKey, domains);
        }
        domains.add(aDomain, aWeight);
    }

    public WeightedCollection<Domain> getDomainWeights(String aDeityKey) {
        WeightedCollection<Domain> domains;
        if (this.theDomainWeights == null) {
            this.theDomainWeights = new HashMap<String, WeightedCollection<Domain>>();
        }
        if ((domains = this.theDomainWeights.get(aDeityKey)) == null) {
            domains = new WeightedCollection();
            Deity deity = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Deity.class, aDeityKey);
            for (CDOMReference deityDomains : deity.getSafeListMods(Deity.DOMAINLIST)) {
                domains.addAll(deityDomains.getContainedObjects(), deity.getListAssociations(Deity.DOMAINLIST, deityDomains).size());
            }
        }
        return domains;
    }

    public void addKnownSpell(int aLevel, Spell aSpell, int aWeight) {
        WeightedCollection<Spell> spells;
        if (this.theKnownSpellWeights == null) {
            this.theKnownSpellWeights = new HashMap<Integer, WeightedCollection<Spell>>();
        }
        if ((spells = this.theKnownSpellWeights.get(aLevel)) == null) {
            spells = new WeightedCollection();
            this.theKnownSpellWeights.put(aLevel, spells);
        }
        if (!spells.contains(aSpell)) {
            spells.add(aSpell, aWeight);
        }
    }

    public void removeKnownSpell(int aLevel, Spell aSpell) {
        if (this.theKnownSpellWeights == null) {
            return;
        }
        WeightedCollection<Spell> spells = this.theKnownSpellWeights.get(aLevel);
        if (spells != null) {
            spells.remove(aSpell);
        }
    }

    public WeightedCollection<Spell> getKnownSpellWeights(int aLevel, PlayerCharacter pc) {
        WeightedCollection<Spell> spells;
        if (this.theKnownSpellWeights == null) {
            this.theKnownSpellWeights = new HashMap<Integer, WeightedCollection<Spell>>();
        }
        if ((spells = this.theKnownSpellWeights.get(aLevel)) == null) {
            spells = new WeightedCollection();
            for (Spell spell : pc.getSpellsIn(this.theClass.get(ObjectKey.CLASS_SPELLLIST), aLevel)) {
                spells.add(spell, 1);
            }
        }
        return spells;
    }

    public void addPreparedSpell(int aLevel, Spell aSpell, int aWeight) {
        WeightedCollection<Spell> spells;
        if (this.thePreparedSpellWeights == null) {
            this.thePreparedSpellWeights = new HashMap<Integer, WeightedCollection<Spell>>();
        }
        if ((spells = this.thePreparedSpellWeights.get(aLevel)) == null) {
            spells = new WeightedCollection();
            this.thePreparedSpellWeights.put(aLevel, spells);
        }
        if (!spells.contains(aSpell)) {
            spells.add(aSpell, aWeight);
        }
    }

    public void removePreparedSpell(int aLevel, Spell aSpell) {
        if (this.thePreparedSpellWeights == null) {
            return;
        }
        WeightedCollection<Spell> spells = this.thePreparedSpellWeights.get(aLevel);
        if (spells != null) {
            spells.remove(aSpell);
        }
    }

    public WeightedCollection<Spell> getPreparedSpellWeights(int aLevel, PlayerCharacter pc) {
        WeightedCollection<Spell> spells;
        if (this.thePreparedSpellWeights == null) {
            this.thePreparedSpellWeights = new HashMap<Integer, WeightedCollection<Spell>>();
        }
        if ((spells = this.thePreparedSpellWeights.get(aLevel)) == null) {
            spells = new WeightedCollection();
            for (Spell spell : pc.getSpellsIn(this.theClass.get(ObjectKey.CLASS_SPELLLIST), aLevel)) {
                spells.add(spell, 1);
            }
        }
        return spells;
    }

    public void addSubClass(String aKey, int aWeight) {
        if (this.theSubClassWeights == null) {
            this.theSubClassWeights = new WeightedCollection();
        }
        this.theSubClassWeights.add(aKey, aWeight);
    }

    public WeightedCollection<String> getSubClassWeights() {
        if (this.theSubClassWeights == null && this.theClass != null) {
            for (SubClass subClass : this.theClass.getListFor(ListKey.SUB_CLASS)) {
                this.addSubClass(subClass.getKeyName(), 1);
            }
        }
        return this.theSubClassWeights;
    }
}

