/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.models.CharacterTreeCellRenderer;
import pcgen.gui2.tabs.models.QualifiedTreeCellRenderer;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.SortMode;
import pcgen.gui2.util.SortingPriority;
import pcgen.gui2.util.table.TableUtils;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class ClassInfoTab
extends FlippingSplitPane
implements CharacterInfoTab {
    private final FilteredTreeViewTable<Object, ClassFacade> availableTable = new FilteredTreeViewTable();
    private final JTable classTable = TableUtils.createDefaultTable();
    private final JButton addButton = new JButton();
    private final JButton removeButton = new JButton();
    private final TabTitle tabTitle = new TabTitle(Tab.CLASSES);
    private final InfoPane infoPane = new InfoPane(LanguageBundle.getString("in_clInfo"));
    private final JSpinner spinner = new JSpinner(new SpinnerNumberModel(1, 1, 50, 1));
    private final FilterButton<Object, ClassFacade> qFilterButton = new FilterButton("ClassQualified");
    private final QualifiedTreeCellRenderer qualifiedRenderer = new QualifiedTreeCellRenderer();
    private final ClassTransferHandler classTransferHandler = new ClassTransferHandler();
    private int spinnerValue;

    public ClassInfoTab() {
        super("Class");
        this.initComponents();
    }

    private void initComponents() {
        FlippingSplitPane topPane = new FlippingSplitPane("ClassTop");
        this.setTopComponent(topPane);
        this.setOrientation(0);
        JPanel availPanel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> bar = new FilterBar<Object, Object>();
        bar.addDisplayableFilter(new SearchFilterPanel());
        this.qFilterButton.setText(LanguageBundle.getString("in_igQualFilter"));
        bar.addDisplayableFilter(this.qFilterButton);
        availPanel.add(bar, "North");
        this.availableTable.setTreeCellRenderer(this.qualifiedRenderer);
        this.availableTable.setDisplayableFilter(bar);
        this.availableTable.setSortingPriority(Collections.singletonList(new SortingPriority(0, SortMode.ASCENDING)));
        this.availableTable.sortModel();
        availPanel.add((Component)new JScrollPane(this.availableTable), "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.spinner.setMaximumSize(this.spinner.getPreferredSize());
        box.add(this.spinner);
        box.add(Box.createHorizontalStrut(5));
        this.addButton.setHorizontalTextPosition(10);
        box.add(this.addButton);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        availPanel.add((Component)box, "South");
        topPane.setLeftComponent(availPanel);
        JPanel selPanel = new JPanel(new BorderLayout());
        JScrollPane tablePane = new JScrollPane(this.classTable);
        selPanel.add((Component)tablePane, "Center");
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.removeButton);
        box2.add(Box.createHorizontalGlue());
        box2.setBorder(new EmptyBorder(0, 0, 5, 0));
        selPanel.add((Component)box2, "South");
        this.classTable.setDragEnabled(true);
        this.classTable.setTransferHandler(this.classTransferHandler);
        this.availableTable.setDragEnabled(true);
        this.availableTable.setTransferHandler(this.classTransferHandler);
        this.initListeners();
        topPane.setRightComponent(selPanel);
        this.setBottomComponent(this.infoPane);
        this.setResizeWeight(0.75);
    }

    private void initListeners() {
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClassInfoTab.this.spinnerValue = (Integer)ClassInfoTab.this.spinner.getValue();
            }
        });
        this.spinnerValue = (Integer)this.spinner.getValue();
        this.classTable.getSelectionModel().setSelectionMode(0);
        this.availableTable.getSelectionModel().setSelectionMode(0);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(ClassTransferHandler.TransHandler.class, this.classTransferHandler.createHandler(character));
        models.put(ClassTreeViewModel.class, new ClassTreeViewModel(character));
        models.put(ClassTableModel.class, new ClassTableModel(character));
        models.put(AddClassAction.class, new AddClassAction(character));
        models.put(RemoveClassAction.class, new RemoveClassAction(character));
        models.put(InfoHandler.class, new InfoHandler(character));
        models.put(CharacterTreeCellRenderer.Handler.class, this.qualifiedRenderer.createHandler(character));
        models.put(QualifiedFilterHandler.class, new QualifiedFilterHandler(character));
        return models;
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(InfoHandler.class).uninstall();
        models.get(AddClassAction.class).uninstall();
        models.get(CharacterTreeCellRenderer.Handler.class).uninstall();
        models.get(ClassTransferHandler.TransHandler.class).uninstall();
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(CharacterTreeCellRenderer.Handler.class).install();
        models.get(QualifiedFilterHandler.class).install();
        this.classTable.setModel(models.get(ClassTableModel.class));
        this.availableTable.setTreeViewModel(models.get(ClassTreeViewModel.class));
        models.get(AddClassAction.class).install();
        models.get(RemoveClassAction.class).install();
        models.get(InfoHandler.class).install();
        models.get(ClassTransferHandler.TransHandler.class).install();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    private ClassFacade getSelectedClass(Object eventSource) {
        Object data = null;
        if (eventSource == this.availableTable.getSelectionModel()) {
            data = this.availableTable.getSelectedObject();
        } else {
            int selectedRow = this.classTable.getSelectedRow();
            if (selectedRow != -1) {
                data = this.classTable.getModel().getValueAt(selectedRow, 1);
            }
        }
        if (data != null && data instanceof ClassFacade) {
            return (ClassFacade)data;
        }
        return null;
    }

    public void addCharacterLevels(CharacterFacade character, ClassFacade clazz) {
        if (clazz != null) {
            ClassFacade[] classes = new ClassFacade[this.spinnerValue];
            for (int x = 0; x < this.spinnerValue; ++x) {
                classes[x] = clazz;
            }
            character.addCharacterLevels(classes);
        }
    }

    private class InfoHandler
    implements ListSelectionListener {
        private final CharacterFacade character;
        private String text;

        public InfoHandler(CharacterFacade character) {
            this.character = character;
            this.text = "";
        }

        public void install() {
            ClassInfoTab.this.classTable.getSelectionModel().addListSelectionListener(this);
            ClassInfoTab.this.availableTable.getSelectionModel().addListSelectionListener(this);
            ClassInfoTab.this.infoPane.setText(this.text);
        }

        public void uninstall() {
            ClassInfoTab.this.classTable.getSelectionModel().removeListSelectionListener(this);
            ClassInfoTab.this.availableTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ClassFacade data = ClassInfoTab.this.getSelectedClass(e.getSource());
                if (data != null) {
                    this.text = this.character.getInfoFactory().getHTMLInfo(data, null);
                    ClassInfoTab.this.infoPane.setText(this.text);
                } else {
                    this.text = "";
                    ClassInfoTab.this.infoPane.setText("");
                }
            }
        }
    }

    private static class ClassTableModel
    extends AbstractTableModel
    implements ListListener<CharacterLevelFacade> {
        private static final String[] columns = new String[]{LanguageBundle.getString("in_level"), LanguageBundle.getString("in_class"), LanguageBundle.getString("in_source")};
        private final CharacterLevelsFacade model;

        public ClassTableModel(CharacterFacade character) {
            this.model = character.getCharacterLevelsFacade();
            this.model.addListListener(this);
        }

        @Override
        public int getRowCount() {
            return this.model.getSize();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            return columns[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return rowIndex + 1;
            }
            ClassFacade c = this.model.getClassTaken((CharacterLevelFacade)this.model.getElementAt(rowIndex));
            switch (columnIndex) {
                case 1: {
                    return c;
                }
                case 2: {
                    return c.getSource();
                }
            }
            return null;
        }

        @Override
        public void elementAdded(ListEvent<CharacterLevelFacade> e) {
            this.fireTableRowsInserted(e.getIndex(), e.getIndex());
        }

        @Override
        public void elementRemoved(ListEvent<CharacterLevelFacade> e) {
            this.fireTableRowsDeleted(e.getIndex(), e.getIndex());
        }

        @Override
        public void elementsChanged(ListEvent<CharacterLevelFacade> e) {
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        }

        @Override
        public void elementModified(ListEvent<CharacterLevelFacade> e) {
            this.fireTableRowsUpdated(e.getIndex(), e.getIndex());
        }
    }

    private static class ClassTreeViewModel
    implements TreeViewModel<ClassFacade>,
    DataView<ClassFacade> {
        private static final List<DefaultDataViewColumn> columns = Arrays.asList(new DefaultDataViewColumn("in_clInfoHD", String.class), new DefaultDataViewColumn("in_clInfoType", String.class, true), new DefaultDataViewColumn("in_descrip", String.class, false), new DefaultDataViewColumn("in_baseStat", String.class), new DefaultDataViewColumn("in_spellType", String.class), new DefaultDataViewColumn("in_source", String.class));
        private static final ListFacade<? extends TreeView<ClassFacade>> treeviews = new DefaultListFacade<ClassTreeView>(Arrays.asList(ClassTreeView.values()));
        private final CharacterFacade character;

        public ClassTreeViewModel(CharacterFacade character) {
            this.character = character;
        }

        @Override
        public String getPrefsKey() {
            return "ClassTree";
        }

        @Override
        public ListFacade<? extends TreeView<ClassFacade>> getTreeViews() {
            return treeviews;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<ClassFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<ClassFacade> getDataModel() {
            return this.character.getDataSet().getClasses();
        }

        @Override
        public List<?> getData(ClassFacade obj) {
            return Arrays.asList(obj.getHD(), this.getTypes(obj), this.character.getInfoFactory().getDescription(obj), "None".equals(obj.getBaseStat()) ? "" : obj.getBaseStat(), obj.getSpellType(), obj.getSource());
        }

        private String getTypes(ClassFacade obj) {
            String ret = "";
            String[] types = obj.getTypes();
            if (types != null && types.length > 0) {
                ret = ret + types[0];
                for (int x = 1; x < types.length; ++x) {
                    ret = ret + ", " + types[x];
                }
            }
            return ret;
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return columns;
        }

        private static enum ClassTreeView implements TreeView<ClassFacade>
        {
            NAME("in_nameLabel"),
            TYPE_NAME("in_typeName"),
            SOURCE_NAME("in_sourceName");

            private final String name;

            private ClassTreeView(String nameKey) {
                this.name = LanguageBundle.getString(nameKey);
            }

            @Override
            public String getViewName() {
                return this.name;
            }

            @Override
            public List<TreeViewPath<ClassFacade>> getPaths(ClassFacade pobj) {
                switch (this) {
                    case TYPE_NAME: {
                        String[] types = pobj.getTypes();
                        if (types != null && types.length > 0) {
                            ArrayList<TreeViewPath<ClassFacade>> paths = new ArrayList<TreeViewPath<ClassFacade>>(types.length);
                            for (String type : types) {
                                paths.add(new TreeViewPath<ClassFacade>(pobj, (Object)type));
                            }
                            return paths;
                        }
                    }
                    case NAME: {
                        return Collections.singletonList(new TreeViewPath<ClassFacade>(pobj));
                    }
                    case SOURCE_NAME: {
                        return Collections.singletonList(new TreeViewPath<ClassFacade>(pobj, (Object)pobj.getSourceForNodeDisplay()));
                    }
                }
                throw new InternalError();
            }
        }
    }

    private class QualifiedFilterHandler
    implements Filter<Object, ClassFacade> {
        private final CharacterFacade character;

        public QualifiedFilterHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            ClassInfoTab.this.qFilterButton.setFilter(this);
        }

        @Override
        public boolean accept(Object context, ClassFacade element) {
            return this.character.isQualifiedFor(element);
        }
    }

    private final class ClassTransferHandler
    extends TransferHandler {
        private final DataFlavor classFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + ClassFacade.class.getName(), null);
        private CharacterFacade character = null;

        private ClassTransferHandler() {
        }

        public void setCharacter(CharacterFacade character) {
            this.character = character;
        }

        public TransHandler createHandler(CharacterFacade character) {
            return new TransHandler(character);
        }

        @Override
        public int getSourceActions(JComponent c) {
            if (c == ClassInfoTab.this.classTable) {
                return 0;
            }
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            final ClassFacade selClass = ClassInfoTab.this.getSelectedClass(ClassInfoTab.this.availableTable);
            if (selClass == null) {
                return null;
            }
            return new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{ClassTransferHandler.this.classFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return ClassTransferHandler.this.classFlavor == flavor;
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    if (!this.isDataFlavorSupported(flavor)) {
                        throw new UnsupportedFlavorException(flavor);
                    }
                    return selClass;
                }
            };
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return transferFlavors[0] == this.classFlavor;
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (comp == ClassInfoTab.this.classTable) {
                try {
                    ClassFacade c = (ClassFacade)t.getTransferData(this.classFlavor);
                    ClassInfoTab.this.addCharacterLevels(this.character, c);
                    return true;
                }
                catch (UnsupportedFlavorException ex) {
                    Logger.getLogger(ClassInfoTab.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(ClassInfoTab.class.getName()).log(Level.SEVERE, null, ex);
                }
                return false;
            }
            return true;
        }

        private class TransHandler {
            private final CharacterFacade character;

            public TransHandler(CharacterFacade character) {
                this.character = character;
            }

            public void install() {
                ClassTransferHandler.this.setCharacter(this.character);
            }

            public void uninstall() {
                ClassTransferHandler.this.setCharacter(null);
            }
        }
    }

    private class RemoveClassAction
    extends AbstractAction
    implements ListListener<CharacterLevelFacade> {
        private final CharacterFacade character;

        public RemoveClassAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_cl_removelevels"));
            this.character = character;
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
            this.setEnabled(false);
            character.getCharacterLevelsFacade().addListListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.character.removeCharacterLevels(1);
        }

        public void install() {
            ClassInfoTab.this.removeButton.setAction(this);
        }

        private void checkEnabled() {
            this.setEnabled(!this.character.getCharacterLevelsFacade().isEmpty());
        }

        @Override
        public void elementAdded(ListEvent<CharacterLevelFacade> e) {
            this.checkEnabled();
        }

        @Override
        public void elementRemoved(ListEvent<CharacterLevelFacade> e) {
            this.checkEnabled();
        }

        @Override
        public void elementsChanged(ListEvent<CharacterLevelFacade> e) {
            this.checkEnabled();
        }

        @Override
        public void elementModified(ListEvent<CharacterLevelFacade> e) {
        }
    }

    private class AddClassAction
    extends AbstractAction
    implements ListSelectionListener {
        private final CharacterFacade character;
        private ClassFacade selectedClass;

        public AddClassAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_cl_addlevels"));
            this.selectedClass = null;
            this.character = character;
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassInfoTab.this.addCharacterLevels(this.character, this.selectedClass);
        }

        public void install() {
            ClassInfoTab.this.addButton.setAction(this);
            ClassInfoTab.this.availableTable.addActionListener(this);
            ClassInfoTab.this.availableTable.getSelectionModel().addListSelectionListener(this);
            ClassInfoTab.this.classTable.getSelectionModel().addListSelectionListener(this);
        }

        public void uninstall() {
            ClassInfoTab.this.availableTable.removeActionListener(this);
            ClassInfoTab.this.availableTable.getSelectionModel().removeListSelectionListener(this);
            ClassInfoTab.this.classTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                this.selectedClass = ClassInfoTab.this.getSelectedClass(e.getSource());
                if (this.selectedClass == null) {
                    this.setEnabled(false);
                }
                this.setEnabled(this.selectedClass != null);
            }
        }
    }
}

