/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import javax.swing.JTabbedPane;
import pcgen.facade.core.CharacterFacade;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.TodoHandler;
import pcgen.gui2.tabs.spells.SpellBooksTab;
import pcgen.gui2.tabs.spells.SpellsKnownTab;
import pcgen.gui2.tabs.spells.SpellsPreparedTab;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class SpellsInfoTab
extends JTabbedPane
implements CharacterInfoTab,
TodoHandler {
    private final TabTitle tabTitle = new TabTitle(Tab.SPELLS);
    private final SpellsKnownTab knownTab = new SpellsKnownTab();
    private final SpellsPreparedTab preparedTab = new SpellsPreparedTab();
    private final SpellBooksTab booksTab = new SpellBooksTab();

    public SpellsInfoTab() {
        this.addTab(LanguageBundle.getString("in_InfoKnown"), this.knownTab);
        this.addTab(LanguageBundle.getString("in_InfoPrepared"), this.preparedTab);
        this.addTab(LanguageBundle.getString("in_InfoSpellbooks"), this.booksTab);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(ModelHandler.class, new ModelHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(ModelHandler.class).restoreModels();
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(ModelHandler.class).storeModels();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    @Override
    public void adviseTodo(String fieldName) {
        if ("Known".equals(fieldName)) {
            this.setSelectedIndex(0);
        }
    }

    private class ModelHandler {
        private final CharacterInfoTab.ModelMap knownTabMap;
        private final CharacterInfoTab.ModelMap preparedTabMap;
        private final CharacterInfoTab.ModelMap booksTabMap;

        public ModelHandler(CharacterFacade character) {
            this.knownTabMap = SpellsInfoTab.this.knownTab.createModels(character);
            this.preparedTabMap = SpellsInfoTab.this.preparedTab.createModels(character);
            this.booksTabMap = SpellsInfoTab.this.booksTab.createModels(character);
        }

        public void restoreModels() {
            SpellsInfoTab.this.knownTab.restoreModels(this.knownTabMap);
            SpellsInfoTab.this.preparedTab.restoreModels(this.preparedTabMap);
            SpellsInfoTab.this.booksTab.restoreModels(this.booksTabMap);
        }

        public void storeModels() {
            SpellsInfoTab.this.knownTab.storeModels(this.knownTabMap);
            SpellsInfoTab.this.preparedTab.storeModels(this.preparedTabMap);
            SpellsInfoTab.this.booksTab.storeModels(this.booksTabMap);
        }
    }
}

