/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.EqModControl;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SizeAdjustment;
import pcgen.core.WeaponProf;
import pcgen.core.character.WieldCategory;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.WeaponToken;
import pcgen.system.LanguageBundle;

public class WeaponhToken
extends WeaponToken {
    public static final String TOKEN_NAME = "WEAPONH";

    @Override
    public String getTokenName() {
        return TOKEN_NAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
        aTok.nextToken();
        Equipment eq = WeaponhToken.getWeaponEquipment(pc.getDisplay());
        if (eq != null) {
            return this.getWeaponToken(pc, eq, aTok, tokenSource);
        }
        if (eh != null && eh.getExistsOnly()) {
            eh.setNoMoreItems(true);
            if (eh.getCheckBefore()) {
                eh.setCanWrite(false);
            }
        }
        return "";
    }

    public static Equipment getWeaponEquipment(CharacterDisplay display) {
        WeaponProf wp = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(WeaponProf.class, "Unarmed Strike");
        if (wp == null) {
            wp = new WeaponProf();
            wp.setName(LanguageBundle.getString("Equipment.UnarmedStrike"));
            wp.put(StringKey.KEY_NAME, "Unarmed Strike");
            wp.addToListFor(ListKey.TYPE, Type.SIMPLE);
            Globals.getContext().getReferenceContext().importObject(wp);
        }
        Equipment eq = new Equipment();
        eq.setName(LanguageBundle.getString("Equipment.UnarmedStrike"));
        eq.put(StringKey.KEY_NAME, "KEY_Unarmed Strike");
        eq.put(ObjectKey.WEAPON_PROF, new CDOMDirectSingleRef<WeaponProf>(wp));
        eq.put(StringKey.OUTPUT_NAME, LanguageBundle.getString("Equipment.UnarmedStrike"));
        eq.addType(Type.WEAPON);
        eq.addType(Type.MELEE);
        eq.addType(Type.SIMPLE);
        eq.addType(Type.UNARMED);
        eq.addType(Type.SUBDUAL);
        eq.addType(Type.STANDARD);
        eq.addType(Type.MONK);
        eq.addType(Type.BLUDGEONING);
        WieldCategory lightWC = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(WieldCategory.class, "Light");
        if (lightWC != null) {
            eq.put(ObjectKey.WIELD, lightWC);
        }
        eq.put(ObjectKey.COST, BigDecimal.ZERO);
        eq.put(ObjectKey.CURRENT_COST, BigDecimal.ZERO);
        eq.put(ObjectKey.WEIGHT, BigDecimal.ZERO);
        EquipmentHead head = eq.getEquipmentHead(1);
        head.put(StringKey.DAMAGE, "1d1");
        head.put(IntegerKey.CRIT_MULT, 2);
        head.put(IntegerKey.CRIT_RANGE, 1);
        eq.put(ObjectKey.MOD_CONTROL, EqModControl.NO);
        SizeAdjustment sa = display.getSizeAdjustment();
        CDOMDirectSingleRef<SizeAdjustment> ref = CDOMDirectSingleRef.getRef(sa);
        eq.put(ObjectKey.SIZE, ref);
        eq.put(ObjectKey.BASESIZE, ref);
        return eq;
    }
}

