/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.output.prereq;

import java.util.HashMap;
import java.util.Map;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteMultWriter;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;
import pcgen.system.PluginLoader;
import pcgen.util.Logging;

public class PrerequisiteWriterFactory
implements PluginLoader {
    private static PrerequisiteWriterFactory instance = null;
    private static Map<String, PrerequisiteWriterInterface> parserLookup = new HashMap<String, PrerequisiteWriterInterface>();

    private PrerequisiteWriterFactory() {
    }

    public static PrerequisiteWriterFactory getInstance() {
        if (instance == null) {
            instance = new PrerequisiteWriterFactory();
        }
        return instance;
    }

    public PrerequisiteWriterInterface getWriter(String kind) {
        PrerequisiteWriterInterface test = null;
        if (kind == null) {
            test = new PrerequisiteMultWriter();
        } else {
            test = parserLookup.get(kind.toLowerCase());
            if (test == null) {
                Logging.errorPrintLocalised("PrerequisiteTestFactory.error.cannot_find_test", kind);
            }
        }
        return test;
    }

    public static void register(PrerequisiteWriterInterface testClass) throws PersistenceLayerException {
        String kindHandled = testClass.kindHandled();
        PrerequisiteWriterInterface test = parserLookup.get(kindHandled.toLowerCase());
        if (test != null) {
            throw new PersistenceLayerException("Error registering '" + testClass.getClass().getName() + "' as test '" + kindHandled + "'. The test is already registered to '" + test.getClass().getName() + "'");
        }
        parserLookup.put(kindHandled.toLowerCase(), testClass);
    }

    @Override
    public void loadPlugin(Class<?> clazz) throws Exception {
        PrerequisiteWriterFactory.register((PrerequisiteWriterInterface)clazz.newInstance());
    }

    public Class[] getPluginClasses() {
        return new Class[]{PrerequisiteWriterInterface.class};
    }
}

