/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.io.SimpleFileFilter;
import gmgen.pluginmgr.messages.AddMenuItemToGMGenToolsMenuMessage;
import gmgen.pluginmgr.messages.FileMenuNewMessage;
import gmgen.pluginmgr.messages.FileMenuOpenMessage;
import gmgen.pluginmgr.messages.FileMenuSaveMessage;
import gmgen.pluginmgr.messages.GMGenBeingClosedMessage;
import gmgen.pluginmgr.messages.RequestAddTabToGMGenMessage;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.SettingsHandler;
import pcgen.gui2.tools.Utility;
import pcgen.pluginmgr.InteractivePlugin;
import pcgen.pluginmgr.PCGenMessage;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.FocusOrStateChangeOccurredMessage;
import pcgen.system.LanguageBundle;
import plugin.dicebag.gui.DiceBagPluginController;

public class DiceBagPlugin
implements InteractivePlugin {
    private static final String DICEBAG_TOOLS_COMMAND = "TOOLS_MENU_ENTRY";
    public static final String LOG_NAME = "DiceBag";
    private DiceBagPluginController theController = null;
    private JMenuItem notesToolsItem;
    private static final String NAME = "DiceBag";
    private static final String IN_NAME = "in_plugin_dicebag_name";
    private String version = "00.00.00.01";
    private PCGenMessageHandler messageHandler;

    public FileFilter[] getFileTypes() {
        FileFilter[] ff = new FileFilter[]{this.getFileType()};
        return ff;
    }

    public FileFilter getFileType() {
        String[] fileExt = new String[]{"dbg"};
        return new SimpleFileFilter(fileExt, LanguageBundle.getString("in_plugin_dicebag_filter"));
    }

    @Override
    public void start(PCGenMessageHandler mh) {
        this.messageHandler = mh;
        this.theController = new DiceBagPluginController();
        this.messageHandler.handleMessage(new RequestAddTabToGMGenMessage(this, this.getLocalizedName(), this.theController.getComponent()));
        this.initMenus();
    }

    @Override
    public void stop() {
        this.messageHandler = null;
    }

    @Override
    public int getPriority() {
        return SettingsHandler.getGMGenOption("DiceBag.LoadOrder", 20);
    }

    @Override
    public String getPluginName() {
        return "DiceBag";
    }

    @Override
    public void handleMessage(PCGenMessage message) {
        if (message instanceof FocusOrStateChangeOccurredMessage) {
            this.handleStateChangedMessage((FocusOrStateChangeOccurredMessage)message);
        } else if (message instanceof GMGenBeingClosedMessage) {
            this.handleWindowClosedMessage((GMGenBeingClosedMessage)message);
        } else if (message instanceof FileMenuOpenMessage) {
            this.handleFileOpenMessage((FileMenuOpenMessage)message);
        } else if (message instanceof FileMenuSaveMessage) {
            this.handleSaveMessage((FileMenuSaveMessage)message);
        } else if (message instanceof FileMenuNewMessage) {
            this.handleLoadMessage((FileMenuNewMessage)message);
        }
    }

    public void toolMenuItem(ActionEvent evt) {
        JTabbedPane tp = GMGenSystemView.getTabPane();
        for (int i = 0; i < tp.getTabCount(); ++i) {
            if (!tp.getComponentAt(i).equals(this.theController.getComponent())) continue;
            tp.setSelectedIndex(i);
        }
    }

    private void handleFileOpenMessage(FileMenuOpenMessage message) {
        if (GMGenSystemView.getTabPane().getSelectedComponent().equals(this.theController.getComponent())) {
            this.theController.fileOpen();
            message.consume();
        }
    }

    private void handleLoadMessage(FileMenuNewMessage message) {
        if (GMGenSystemView.getTabPane().getSelectedComponent().equals(this.theController.getComponent())) {
            this.theController.fileNew();
            message.consume();
        }
    }

    private void handleSaveMessage(FileMenuSaveMessage message) {
        if (this.isActive()) {
            this.theController.fileSave();
            message.consume();
        }
    }

    private void handleStateChangedMessage(FocusOrStateChangeOccurredMessage message) {
        if (GMGenSystemView.getTabPane() != null) {
            if (this.isActive()) {
                this.notesToolsItem.setEnabled(false);
                GMGenSystem.inst.openFileItem.setEnabled(true);
                GMGenSystem.inst.saveFileItem.setEnabled(true);
                GMGenSystem.inst.newFileItem.setEnabled(true);
            } else {
                this.notesToolsItem.setEnabled(true);
            }
        }
    }

    private void handleWindowClosedMessage(GMGenBeingClosedMessage message) {
        this.theController.windowClosed();
    }

    public boolean isActive() {
        JTabbedPane tp = Utility.getTabbedPaneFor(this.theController.getComponent());
        return tp != null && JOptionPane.getFrameForComponent(tp).isFocused() && tp.getSelectedComponent().equals(this.theController.getComponent());
    }

    private void initMenus() {
        this.notesToolsItem = this.makeMenuItem(this.getLocalizedName(), DICEBAG_TOOLS_COMMAND, null, LanguageBundle.getString("in_plugin_dicebag_desc"), LanguageBundle.getMnemonic("in_mn_plugin_dicebag_name"));
        this.messageHandler.handleMessage(new AddMenuItemToGMGenToolsMenuMessage(this, this.notesToolsItem));
    }

    private String getLocalizedName() {
        return LanguageBundle.getString(IN_NAME);
    }

    private JMenuItem makeMenuItem(String text, String key, String iconPath, String desc, Integer mnemonic) {
        URL imageURL = null;
        if (iconPath != null && iconPath.length() > 0) {
            imageURL = this.getClass().getResource(iconPath);
        }
        ActionDelegate action = imageURL != null ? new ActionDelegate(text, new ImageIcon(imageURL)) : new ActionDelegate(text);
        action.putValue("ShortDescription", desc);
        action.putValue("MnemonicKey", mnemonic);
        action.putValue("ActionCommandKey", key);
        JMenuItem menuItem = new JMenuItem(action);
        return menuItem;
    }

    @Override
    public File getDataDirectory() {
        File dataDir = new File(SettingsHandler.getGmgenPluginDir(), this.getPluginName());
        return dataDir;
    }

    private class ActionDelegate
    extends AbstractAction {
        public ActionDelegate() {
        }

        public ActionDelegate(String name) {
            super(name);
        }

        public ActionDelegate(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (DiceBagPlugin.DICEBAG_TOOLS_COMMAND.equals(command)) {
                DiceBagPlugin.this.toolMenuItem(e);
            }
        }
    }
}

