/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class MaxSpellLevelToken
extends Token {
    public static final String TOKENNAME = "MAXSPELLLEVEL";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringBuilder retValue = new StringBuilder();
        String[] tokens = tokenSource.split("\\.");
        if (tokens.length != 2) {
            Logging.errorPrint("MAXSPELLLEVEL token must be of the format 'MAXSPELLLEVEL.x' where 'x' is an integer. '" + tokenSource + "' is not valid");
            return "";
        }
        int classNumber = -1;
        try {
            classNumber = Integer.parseInt(tokens[1]);
        }
        catch (NumberFormatException nfe) {
            Logging.errorPrint("Unknown class number in token: " + tokenSource);
        }
        PObject aObject = pc.getSpellClassAtIndex(classNumber);
        if (aObject != null) {
            PCClass aClass = null;
            if (aObject instanceof PCClass) {
                aClass = (PCClass)aObject;
            }
            if (aClass != null) {
                retValue.append(pc.getSpellSupport(aClass).getHighestLevelSpell(pc));
            }
        }
        return retValue.toString();
    }
}

