/*
 * Decompiled with CFR 0.152.
 */
package plugin.jepcommands;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import pcgen.core.PlayerCharacter;
import pcgen.util.AbstractCountCommand;
import pcgen.util.JepCountType;
import pcgen.util.Logging;

public class CountCommand
extends AbstractCountCommand {
    public CountCommand() {
        this.numberOfParameters = -1;
    }

    @Override
    public String getFunctionName() {
        return "COUNT";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(Stack inStack) throws ParseException {
        PlayerCharacter pc = this.getPC();
        if (pc == null) {
            throw new ParseException("Invalid parent (no PC): " + this.parent.getClass().getName());
        }
        this.checkStack(inStack);
        if (1 > this.curNumberOfParameters) throw new ParseException("missing parameter, nothing to count");
        Object[] params = this.paramStackToArray(inStack, this.curNumberOfParameters - 1);
        Object toCount = inStack.pop();
        if (!(toCount instanceof String)) throw new ParseException("Invalid parameter type");
        JepCountType countEnum = JepCountType.valueOf((String)toCount);
        if (countEnum == null) {
            Logging.errorPrint("Unable to find count type: " + toCount);
        }
        Double result = (Double)countEnum.count(pc, params);
        inStack.push(result);
    }
}

