/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCTemplate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class HdToken
extends AbstractTokenWithSeparator<PCTemplate>
implements CDOMPrimaryToken<PCTemplate> {
    @Override
    public String getTokenName() {
        return "HD";
    }

    @Override
    public ParseResult parseToken(LoadContext context, PCTemplate template, String value) {
        if (".CLEAR".equals(value)) {
            context.getObjectContext().removeList(template, ListKey.HD_TEMPLATES);
            return ParseResult.SUCCESS;
        }
        return super.parseToken(context, template, value);
    }

    @Override
    protected char separator() {
        return ':';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCTemplate template, String value) {
        int maxhd;
        int minhd;
        StringTokenizer tok = new StringTokenizer(value, ":");
        String hdString = tok.nextToken();
        try {
            int minusLoc = hdString.indexOf(45);
            if (minusLoc == -1) {
                int plusLoc = hdString.indexOf(43);
                if (plusLoc == 0) {
                    return new ParseResult.Fail("Malformed " + this.getTokenName() + " Cannot start with +: " + hdString, context);
                }
                if (plusLoc == hdString.length() - 1) {
                    minhd = Integer.parseInt(hdString.substring(0, hdString.length() - 1));
                    maxhd = Integer.MAX_VALUE;
                } else {
                    maxhd = minhd = Integer.parseInt(hdString);
                }
            } else {
                minhd = Integer.parseInt(hdString.substring(0, minusLoc));
                maxhd = Integer.parseInt(hdString.substring(minusLoc + 1));
            }
            if (maxhd < minhd) {
                return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Max < Min): " + hdString, context);
            }
        }
        catch (NumberFormatException ex) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (HD syntax invalid): " + hdString, context);
        }
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail("Invalid " + this.getTokenName() + ": requires 3 colon separated elements (has one): " + value, context);
        }
        String typeStr = tok.nextToken();
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail("Invalid " + this.getTokenName() + ": requires 3 colon separated elements (has two): " + value, context);
        }
        String argument = tok.nextToken();
        PCTemplate derivative = new PCTemplate();
        derivative.put(ObjectKey.VISIBILITY, Visibility.HIDDEN);
        derivative.put(IntegerKey.HD_MIN, minhd);
        derivative.put(IntegerKey.HD_MAX, maxhd);
        context.getReferenceContext().getManufacturer(PCTemplate.class).addDerivativeObject(derivative);
        context.getObjectContext().addToList(template, ListKey.HD_TEMPLATES, derivative);
        try {
            if (context.processToken(derivative, typeStr, argument)) {
                return ParseResult.SUCCESS;
            }
        }
        catch (PersistenceLayerException e) {
            return new ParseResult.Fail(e.getMessage(), context);
        }
        return ParseResult.INTERNAL_ERROR;
    }

    @Override
    public String[] unparse(LoadContext context, PCTemplate pct) {
        Changes<PCTemplate> changes = context.getObjectContext().getListChanges(pct, ListKey.HD_TEMPLATES);
        Collection<PCTemplate> added = changes.getAdded();
        ArrayList<String> ret = new ArrayList<String>();
        boolean globalClear = changes.includesGlobalClear();
        if (globalClear) {
            ret.add(".CLEAR");
        }
        if (added != null) {
            TreeSet<String> set = new TreeSet<String>();
            for (PCTemplate pctChild : added) {
                StringBuilder sb = new StringBuilder();
                Integer min = pctChild.get(IntegerKey.HD_MIN);
                Integer max = pctChild.get(IntegerKey.HD_MAX);
                StringBuilder hd = new StringBuilder();
                hd.append(min);
                if (max == Integer.MAX_VALUE) {
                    hd.append('+');
                } else {
                    hd.append('-').append(max);
                }
                sb.append(hd.toString()).append(':');
                Collection<String> unparse = context.unparse(pctChild);
                if (unparse == null) continue;
                int masterLength = sb.length();
                for (String str : unparse) {
                    sb.setLength(masterLength);
                    set.add(sb.append(str).toString());
                }
            }
            ret.addAll(set);
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

