/*
 * Decompiled with CFR 0.152.
 */
package plugin.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.cdom.base.CDOMObject;
import pcgen.gui2.converter.event.TokenProcessEvent;
import pcgen.gui2.converter.event.TokenProcessorPlugin;

public class ChooseConvertPlugin
implements TokenProcessorPlugin {
    public static Map<String, String> featAnswered = new HashMap<String, String>();
    public static Map<String, String> spelllistAnswered = new HashMap<String, String>();
    public static List<String> CHOICES = Arrays.asList("ABILITY", "ARMORPROFICIENCY", "CLASS", "DOMAIN", "EQUIPMENT", "FEAT", "LANG", "PCSTAT", "RACE", "SCHOOLS", "SHIELDPROFICIENCY", "SKILL", "SPELLS", "STRING", "TEMPLATE", "WEAPONPROFICIENCY");

    public String process(TokenProcessEvent tpe) {
        String value = tpe.getValue();
        if (value.startsWith("FEAT=")) {
            this.processFeatEquals(tpe);
        } else if (value.startsWith("SPELLLIST|")) {
            this.processSpellList(tpe);
        }
        return null;
    }

    private void processFeatEquals(TokenProcessEvent tpe) {
        String value = tpe.getValue();
        String feat = value.substring(5);
        String decision = featAnswered.get(feat);
        if (decision == null) {
            decision = tpe.getDecider().getConversionDecision("Need help with underlying type for " + this.getProcessedToken() + ":" + value + " which is used in " + tpe.getObjectName() + " in file " + tpe.getPrimary().getSourceURI(), this.buildDescriptions(feat), CHOICES, CHOICES.size() - 1);
            featAnswered.put(feat, decision);
        }
        tpe.append((CharSequence)tpe.getKey());
        tpe.append(':');
        tpe.append((CharSequence)decision);
        tpe.append('|');
        tpe.append((CharSequence)value);
        tpe.consume();
    }

    private List<String> buildDescriptions(String feat) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Underlying Feat " + feat + " is CHOOSE:ABILITY");
        list.add("Underlying Feat " + feat + " is CHOOSE:ARMORPROFICIENCY");
        list.add("Underlying Feat " + feat + " is CHOOSE:CLASS");
        list.add("Underlying Feat " + feat + " is CHOOSE:DOMAIN");
        list.add("Underlying Feat " + feat + " is CHOOSE:EQUIPMENT");
        list.add("Underlying Feat " + feat + " is CHOOSE:FEAT");
        list.add("Underlying Feat " + feat + " is CHOOSE:LANG");
        list.add("Underlying Feat " + feat + " is CHOOSE:PCSTAT");
        list.add("Underlying Feat " + feat + " is CHOOSE:RACE");
        list.add("Underlying Feat " + feat + " is CHOOSE:SCHOOLS");
        list.add("Underlying Feat " + feat + " is CHOOSE:SHIELDPROFICIENCY");
        list.add("Underlying Feat " + feat + " is CHOOSE:SKILL");
        list.add("Underlying Feat " + feat + " is CHOOSE:SPELLS");
        list.add("Underlying Feat " + feat + " is CHOOSE:STRING");
        list.add("Underlying Feat " + feat + " is CHOOSE:TEMPLATE");
        list.add("Underlying Feat " + feat + " is CHOOSE:WEAPONPROFICIENCY");
        return list;
    }

    private void processSpellList(TokenProcessEvent tpe) {
        String decision = tpe.getDecider().getConversionInput("Please provide class spell list which " + tpe.getObjectName() + " modifies").trim();
        String stat = spelllistAnswered.get(decision);
        if (stat == null) {
            stat = tpe.getDecider().getConversionInput("Please provide SPELLSTAT (abbreviation) for Class " + decision).trim().toUpperCase();
            spelllistAnswered.put(decision, stat);
        }
        tpe.append((CharSequence)tpe.getKey());
        tpe.append((CharSequence)":SPELLS|CLASSLIST=");
        tpe.append((CharSequence)decision);
        tpe.append((CharSequence)"[KNOWN=YES]\tSELECT:");
        tpe.append((CharSequence)stat);
        tpe.append((CharSequence)"\tPRECLASS:1,");
        tpe.append((CharSequence)decision);
        tpe.append((CharSequence)"=1");
        tpe.consume();
    }

    public Class<? extends CDOMObject> getProcessedClass() {
        return CDOMObject.class;
    }

    public String getProcessedToken() {
        return "CHOOSE";
    }
}

