/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.BuiltInRasterizer;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.FontMeasurer;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizLoader;
import guru.nidi.graphviz.engine.JavascriptEngine;
import guru.nidi.graphviz.engine.MissingDependencyException;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.engine.StringFunctions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class AbstractJsGraphvizEngine
extends AbstractGraphvizEngine {
    private static final String RENDER_JS = GraphvizLoader.loadAsString("guru/nidi/graphviz/engine/render.js");
    private static final String VIZ_BASE = "META-INF/resources/webjars/viz.js-graphviz-java/2.1.3/";
    static final boolean AVAILABLE = GraphvizLoader.isOnClasspath("META-INF/resources/webjars/viz.js-graphviz-java/2.1.3/viz.js");
    private static final Pattern FONT_NAME_PATTERN = Pattern.compile("\"?fontname\"?\\s*=\\s*\"?(.*?)[\",;\\]]");
    private static final Map<Class<?>, ThreadLocal<EngineState>> ENGINES = new HashMap();
    private final Supplier<JavascriptEngine> engineSupplier;

    protected AbstractJsGraphvizEngine(boolean sync, Supplier<JavascriptEngine> engineSupplier) {
        super(sync);
        if (!AVAILABLE) {
            throw new MissingDependencyException("Javascript engines are not available.", "org.webjars.npm:viz.js-graphviz-java");
        }
        this.engineSupplier = engineSupplier;
    }

    @Override
    protected void doInit() {
        EngineState state = this.getState();
        if (state == null || !state.ininted) {
            JavascriptEngine engine = this.engine(true);
            engine.executeJavascript(this.vizJsCode());
            engine.executeJavascript(RENDER_JS);
            this.execute("graph g { a -- b }", Options.create(), Rasterizer.NONE);
        }
    }

    protected JavascriptEngine engine() {
        return this.engine(false);
    }

    private JavascriptEngine engine(boolean init) {
        ThreadLocal holder = ENGINES.computeIfAbsent(this.getClass(), e -> new ThreadLocal());
        EngineState state = (EngineState)holder.get();
        if (state == null) {
            state = new EngineState(this.engineSupplier.get());
            holder.set(state);
            if (!init) {
                this.throwingInit();
            }
        }
        if (init) {
            state.ininted = true;
        }
        return state.engine;
    }

    @Nullable
    private EngineState getState() {
        ThreadLocal<EngineState> holder = ENGINES.get(this.getClass());
        return holder == null ? null : holder.get();
    }

    @Override
    public void close() {
        EngineState state = this.getState();
        if (state != null) {
            GraphvizLoader.closeQuietly(state.engine);
            ENGINES.get(this.getClass()).remove();
        }
    }

    @Override
    public EngineResult execute(String src, Options options, Rasterizer rasterizer) {
        if (rasterizer instanceof BuiltInRasterizer) {
            throw new GraphvizException("Built-in Rasterizer can only be used together with GraphvizCmdLineEngine.");
        }
        return EngineResult.fromString(this.jsVizExec(src, options));
    }

    protected String jsVizExec(String src, Options options) {
        if (src.startsWith("totalMemory") || src.startsWith("render")) {
            return src;
        }
        String memory = options.totalMemory == null ? "" : "totalMemory=" + options.totalMemory + ";";
        this.measureFonts(src);
        return this.engine().executeJavascript(memory + "render(", this.preprocessCode(src, options), "," + options.toJson(false) + ");");
    }

    private void measureFonts(String src) {
        Matcher matcher = FONT_NAME_PATTERN.matcher(src);
        while (matcher.find()) {
            String font = matcher.group(1).trim();
            double[] widths = FontMeasurer.measureFont(font);
            if (widths.length <= 0) continue;
            String widthsString = Arrays.stream(widths).mapToObj(Double::toString).collect(Collectors.joining(","));
            this.engine().executeJavascript("initViz().setFontWidth('" + font + "',[" + widthsString + "])");
        }
    }

    protected String preprocessCode(String src, Options options) {
        if (src.contains("<img")) {
            throw new GraphvizException("Found <img> tag. This is not supported by JS engines. Either use the GraphvizCmdLineEngine or a node with image attribute.");
        }
        return StringFunctions.replaceRegex(src, IMAGE_ATTR, path -> options.image((String)path).processImagePath((String)path));
    }

    private String vizJsCode() {
        return GraphvizLoader.loadAsString("META-INF/resources/webjars/viz.js-graphviz-java/2.1.3/viz.js") + GraphvizLoader.loadAsString("META-INF/resources/webjars/viz.js-graphviz-java/2.1.3/full.render.js");
    }

    protected String promiseJsCode() {
        return GraphvizLoader.loadAsString("net/arnx/nashorn/lib/promise.js");
    }

    private static class EngineState {
        final JavascriptEngine engine;
        boolean ininted;

        EngineState(JavascriptEngine engine) {
            this.engine = engine;
            this.ininted = false;
        }
    }
}

