/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.tika.extractor.EmbeddedDocumentBytesHandler;
import org.apache.tika.io.FilenameUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.pipes.extractor.EmbeddedDocumentBytesConfig;
import org.apache.tika.utils.StringUtils;

public abstract class AbstractEmbeddedDocumentBytesHandler
implements EmbeddedDocumentBytesHandler {
    List<Integer> ids = new ArrayList<Integer>();

    public String getEmitKey(String containerEmitKey, int embeddedId, EmbeddedDocumentBytesConfig embeddedDocumentBytesConfig, Metadata metadata) {
        String embeddedIdString = embeddedDocumentBytesConfig.getZeroPadName() > 0 ? StringUtils.leftPad(Integer.toString(embeddedId), embeddedDocumentBytesConfig.getZeroPadName(), "0") : Integer.toString(embeddedId);
        StringBuilder emitKey = new StringBuilder();
        if (StringUtils.isBlank(embeddedDocumentBytesConfig.getEmitKeyBase())) {
            emitKey.append(containerEmitKey);
            emitKey.append("/").append(FilenameUtils.getName(containerEmitKey));
        } else {
            emitKey.append(embeddedDocumentBytesConfig.getEmitKeyBase());
        }
        emitKey.append(embeddedDocumentBytesConfig.getEmbeddedIdPrefix()).append(embeddedIdString);
        if (embeddedDocumentBytesConfig.getSuffixStrategy().equals((Object)EmbeddedDocumentBytesConfig.SUFFIX_STRATEGY.EXISTING)) {
            String fName = metadata.get("resourceName");
            String suffix = FilenameUtils.getSuffixFromPath(fName);
            suffix = suffix.toLowerCase(Locale.US);
            emitKey.append(suffix);
        }
        return emitKey.toString();
    }

    @Override
    public void add(int id, Metadata metadata, InputStream bytes) throws IOException {
        this.ids.add(id);
    }

    @Override
    public List<Integer> getIds() {
        return this.ids;
    }
}

