/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_zh_Hant_HK extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Gulf = new String[] {
               "波斯灣海域時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "可可斯群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "印度時間",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Nauru = new String[] {
               "瑙魯時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "湯加標準時間",
               "",
               "湯加夏令時間",
               "",
               "湯加時間",
               "",
            };
        final String[] Guyana = new String[] {
               "圭亞那時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "科斯雷時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tuvalu = new String[] {
               "圖瓦盧時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "厄瓜多爾時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "格魯吉亞標準時間",
               "",
               "格魯吉亞夏令時間",
               "",
               "格魯吉亞時間",
               "",
            };
        final String[] Irkutsk = new String[] {
               "伊爾庫茨克標準時間",
               "",
               "伊爾庫茨克夏令時間",
               "",
               "伊爾庫茨克時間",
               "",
            };
        final String[] Noronha = new String[] {
               "費爾南多迪諾羅尼亞標準時間",
               "",
               "費爾南多迪諾羅尼亞夏令時間",
               "",
               "費爾南多迪諾羅尼亞時間",
               "",
            };
        final String[] Solomon = new String[] {
               "所羅門群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "瓦努阿圖標準時間",
               "",
               "瓦努阿圖夏令時間",
               "",
               "瓦努阿圖時間",
               "",
            };
        final String[] Yakutsk = new String[] {
               "雅庫茨克標準時間",
               "",
               "雅庫茨克夏令時間",
               "",
               "雅庫茨克時間",
               "",
            };
        final String[] Maldives = new String[] {
               "馬爾代夫時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "皮特康時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "蘇里南時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "加拉帕戈群島時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marquesas = new String[] {
               "馬克薩斯時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "毛里裘斯標準時間",
               "",
               "毛里裘斯夏令時間",
               "",
               "毛里裘斯時間",
               "",
            };
        final String[] Singapore = new String[] {
               "新加坡時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "亞塞拜疆標準時間",
               "",
               "亞塞拜疆夏令時間",
               "",
               "亞塞拜疆時間",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "佛得角標準時間",
               "",
               "佛得角夏令時間",
               "",
               "佛得角時間",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "塞舌爾時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "新喀里多尼亞標準時間",
               "",
               "新喀里多尼亞夏令時間",
               "",
               "新喀里多尼亞時間",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "迪蒙迪維爾時間",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "南非時間",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "北美中部標準時間",
               "CST",
               "北美中部夏令時間",
               "CDT",
               "北美中部時間",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "北美東部標準時間",
               "EST",
               "北美東部夏令時間",
               "EDT",
               "北美東部時間",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "北美太平洋標準時間",
               "PST",
               "北美太平洋夏令時間",
               "PDT",
               "北美太平洋時間",
               "PT",
            };
        final String[] America_Mountain = new String[] {
               "北美山區標準時間",
               "MST",
               "北美山區夏令時間",
               "MDT",
               "北美山區時間",
               "MT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "巴布亞新畿內亞時間",
               "",
               "",
               "",
               "",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "UTC", EMPTY_ZONE },
            { "CST", America_Central },
            { "EST", America_Eastern },
            { "IET", America_Eastern },
            { "IST", India },
            { "MST", America_Mountain },
            { "PNT", America_Mountain },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "Navajo", America_Mountain },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Baku", Azerbaijan },
            { "Singapore", Singapore },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dubai", Gulf },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Asia/Muscat", Gulf },
            { "Asia/Yangon", Cocos },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Kolkata", India },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Cocos", Cocos },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "Africa/Maseru", Africa_Southern },
            { "America/Boise", America_Mountain },
            { "Asia/Calcutta", India },
            { "Asia/Khandyga", Yakutsk },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Belize", America_Central },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Guyana", Guyana },
            { "America/Inuvik", America_Mountain },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Regina", America_Central },
            { "Asia/Singapore", Singapore },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Indian/Reunion", Gulf },
            { "Mexico/General", America_Central },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Tarawa", Tuvalu },
            { "America/Creston", America_Mountain },
            { "America/Detroit", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "Canada/Mountain", America_Mountain },
            { "Indian/Maldives", Maldives },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "America/Atikokan", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Brazil/DeNoronha", Noronha },
            { "Indian/Kerguelen", Maldives },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Chihuahua", America_Central },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Vancouver", America_Pacific },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Louisville", America_Eastern },
            { "America/Paramaribo", Suriname },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Canada/Saskatchewan", America_Central },
            { "Pacific/Guadalcanal", Solomon },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Gaza", "加沙" },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Qatar", "卡塔爾" },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Anadyr", "阿納德爾" },
            { "timezone.excity.Asia/Hebron", "希伯侖" },
            { "timezone.excity.Asia/Muscat", "馬斯喀特" },
            { "timezone.excity.Asia/Riyadh", "利雅得" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Lagos", "拉各斯" },
            { "timezone.excity.America/Adak", "埃達克" },
            { "timezone.excity.Asia/Bishkek", "比斯凱克" },
            { "timezone.excity.Asia/Colombo", "科倫坡" },
            { "timezone.excity.Asia/Irkutsk", "伊爾庫茨克" },
            { "timezone.excity.Asia/Karachi", "卡拉奇" },
            { "timezone.excity.Asia/Nicosia", "尼科西亞" },
            { "timezone.excity.Asia/Yakutsk", "雅庫茨克" },
            { "timezone.excity.Asia/Yerevan", "埃里温" },
            { "timezone.excity.Europe/Malta", "馬耳他" },
            { "timezone.excity.Europe/Vaduz", "華杜茲" },
            { "timezone.excity.Indian/Cocos", "可可斯群島" },
            { "timezone.excity.Pacific/Wake", "威克島" },
            { "timezone.excity.Africa/Asmera", "阿斯馬拉" },
            { "timezone.excity.Africa/Bangui", "班基" },
            { "timezone.excity.Africa/Luanda", "盧安達" },
            { "timezone.excity.Africa/Lusaka", "盧薩卡" },
            { "timezone.excity.Africa/Maseru", "馬塞魯" },
            { "timezone.excity.America/Aruba", "阿魯巴" },
            { "timezone.excity.America/Bahia", "巴希雅" },
            { "timezone.excity.America/Boise", "博伊西" },
            { "timezone.excity.America/Thule", "圖勒" },
            { "timezone.excity.Asia/Ashgabat", "阿什哈巴德" },
            { "timezone.excity.Asia/Dushanbe", "杜尚別" },
            { "timezone.excity.Asia/Jayapura", "查雅普拉" },
            { "timezone.excity.Asia/Makassar", "錫江" },
            { "timezone.excity.Europe/Skopje", "斯科普里" },
            { "timezone.excity.Europe/Zagreb", "薩格勒布" },
            { "timezone.excity.Indian/Chagos", "查戈斯群島" },
            { "timezone.excity.Indian/Comoro", "科摩羅" },
            { "timezone.excity.Pacific/Nauru", "瑙魯" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "阿比贊" },
            { "timezone.excity.Africa/Conakry", "科納克里" },
            { "timezone.excity.Africa/Nairobi", "內羅畢" },
            { "timezone.excity.America/Belize", "伯利茲" },
            { "timezone.excity.America/Cuiaba", "庫亞巴" },
            { "timezone.excity.America/Guyana", "圭亞那" },
            { "timezone.excity.America/Havana", "夏灣拿" },
            { "timezone.excity.America/Inuvik", "伊努維克" },
            { "timezone.excity.America/Maceio", "馬塞約" },
            { "timezone.excity.America/Nassau", "拿騷" },
            { "timezone.excity.America/Recife", "累西腓" },
            { "timezone.excity.Indian/Mayotte", "馬約特" },
            { "timezone.excity.Indian/Reunion", "留尼旺" },
            { "timezone.excity.Pacific/Kosrae", "科斯雷" },
            { "timezone.excity.Pacific/Majuro", "馬久羅" },
            { "timezone.excity.Pacific/Noumea", "努美阿" },
            { "timezone.excity.Africa/Djibouti", "吉布提" },
            { "timezone.excity.Africa/Kinshasa", "金沙薩" },
            { "timezone.excity.Africa/Windhoek", "溫特和克" },
            { "timezone.excity.America/Antigua", "安提瓜" },
            { "timezone.excity.America/Caracas", "加拉加斯" },
            { "timezone.excity.America/Cayenne", "卡宴" },
            { "timezone.excity.America/Cordoba", "科爾多瓦" },
            { "timezone.excity.America/Grenada", "格林納達" },
            { "timezone.excity.America/Halifax", "哈利法克斯" },
            { "timezone.excity.America/Managua", "馬那瓜" },
            { "timezone.excity.America/Noronha", "諾羅尼亞" },
            { "timezone.excity.America/Tijuana", "蒂華納" },
            { "timezone.excity.America/Yakutat", "亞庫塔特" },
            { "timezone.excity.Atlantic/Canary", "加那利" },
            { "timezone.excity.Australia/Perth", "珀斯" },
            { "timezone.excity.Europe/Belgrade", "貝爾格萊德" },
            { "timezone.excity.Europe/Chisinau", "基希訥烏" },
            { "timezone.excity.Europe/Guernsey", "根西島" },
            { "timezone.excity.Europe/Sarajevo", "薩拉熱窩" },
            { "timezone.excity.Indian/Maldives", "馬爾代夫" },
            { "timezone.excity.Pacific/Chatham", "查塔姆" },
            { "timezone.excity.Pacific/Fakaofo", "法考福環礁" },
            { "timezone.excity.Pacific/Gambier", "甘比爾" },
            { "timezone.excity.Africa/Mogadishu", "摩加迪沙" },
            { "timezone.excity.America/Anguilla", "安圭拉" },
            { "timezone.excity.America/Asuncion", "阿松森" },
            { "timezone.excity.America/Barbados", "巴巴多斯" },
            { "timezone.excity.America/Edmonton", "愛民頓" },
            { "timezone.excity.America/Miquelon", "密克隆" },
            { "timezone.excity.America/Santiago", "聖地亞哥" },
            { "timezone.excity.America/St_Johns", "聖約翰斯" },
            { "timezone.excity.America/St_Lucia", "聖盧西亞" },
            { "timezone.excity.Antarctica/Casey", "凱西站" },
            { "timezone.excity.Antarctica/Davis", "戴維斯站" },
            { "timezone.excity.Antarctica/Syowa", "昭和站" },
            { "timezone.excity.Antarctica/Troll", "特羅爾站" },
            { "timezone.excity.Atlantic/Madeira", "馬德拉島" },
            { "timezone.excity.Atlantic/Stanley", "史丹利" },
            { "timezone.excity.Australia/Hobart", "荷伯特" },
            { "timezone.excity.Australia/Sydney", "悉尼" },
            { "timezone.excity.Europe/Ljubljana", "盧布爾雅那" },
            { "timezone.excity.Europe/Podgorica", "波德戈里察" },
            { "timezone.excity.Indian/Kerguelen", "凱爾蓋朗群島" },
            { "timezone.excity.Indian/Mauritius", "毛里裘斯" },
            { "timezone.excity.Pacific/Pitcairn", "皮特康群島" },
            { "timezone.excity.Africa/Libreville", "利布維" },
            { "timezone.excity.Africa/Nouakchott", "努瓦克肖特" },
            { "timezone.excity.America/Anchorage", "安克雷奇" },
            { "timezone.excity.America/Araguaina", "阿拉瓜伊納" },
            { "timezone.excity.America/Boa_Vista", "博阿維斯塔" },
            { "timezone.excity.America/Chihuahua", "芝娃娃" },
            { "timezone.excity.America/Fortaleza", "福塔萊薩" },
            { "timezone.excity.America/Glace_Bay", "格萊斯灣" },
            { "timezone.excity.America/Guatemala", "危地馬拉" },
            { "timezone.excity.America/Menominee", "梅諾米尼" },
            { "timezone.excity.America/Monterrey", "蒙特雷" },
            { "timezone.excity.Antarctica/Mawson", "莫森站" },
            { "timezone.excity.Antarctica/Palmer", "帕爾默" },
            { "timezone.excity.Europe/Bratislava", "伯拉第斯拉瓦" },
            { "timezone.excity.Pacific/Kwajalein", "瓜加林環礁" },
            { "timezone.excity.Pacific/Marquesas", "馬克薩斯群島" },
            { "timezone.excity.Pacific/Pago_Pago", "帕果帕果" },
            { "timezone.excity.Pacific/Tongatapu", "湯加塔布島" },
            { "timezone.excity.America/Costa_Rica", "哥斯達黎加" },
            { "timezone.excity.America/Guadeloupe", "瓜德羅普" },
            { "timezone.excity.America/Louisville", "路易維爾" },
            { "timezone.excity.America/Martinique", "馬提尼克" },
            { "timezone.excity.America/Montevideo", "蒙得維的亞" },
            { "timezone.excity.America/Montserrat", "蒙塞拉特島" },
            { "timezone.excity.America/Rio_Branco", "里約布蘭科" },
            { "timezone.excity.America/St_Vincent", "聖文森特" },
            { "timezone.excity.America/Whitehorse", "白馬市" },
            { "timezone.excity.Antarctica/McMurdo", "麥克默多站" },
            { "timezone.excity.Antarctica/Rothera", "羅瑟拉站" },
            { "timezone.excity.Asia/Yekaterinburg", "葉卡捷琳堡" },
            { "timezone.excity.Atlantic/Reykjavik", "雷克雅未克" },
            { "timezone.excity.Australia/Adelaide", "阿德萊德" },
            { "timezone.excity.Australia/Brisbane", "布里斯本" },
            { "timezone.excity.Europe/Isle_of_Man", "馬恩島" },
            { "timezone.excity.Africa/Johannesburg", "約翰內斯堡" },
            { "timezone.excity.America/Mexico_City", "墨西哥城" },
            { "timezone.excity.America/Porto_Velho", "韋柳港" },
            { "timezone.excity.America/Tegucigalpa", "特古西加爾巴" },
            { "timezone.excity.Arctic/Longyearbyen", "朗伊爾城" },
            { "timezone.excity.Atlantic/Cape_Verde", "佛得角" },
            { "timezone.excity.Indian/Antananarivo", "安塔那那利佛" },
            { "timezone.excity.Pacific/Guadalcanal", "瓜達爾卡納爾島" },
            { "timezone.excity.Africa/Dar_es_Salaam", "達累斯薩拉姆" },
            { "timezone.excity.America/Campo_Grande", "大坎普" },
            { "timezone.excity.America/Dawson_Creek", "道森灣" },
            { "timezone.excity.America/Indiana/Knox", "印第安納州諾克斯" },
            { "timezone.excity.America/Indianapolis", "印第安納波利斯" },
            { "timezone.excity.Antarctica/Macquarie", "麥夸里" },
            { "timezone.excity.Pacific/Bougainville", "布干維爾島" },
            { "timezone.excity.America/Ciudad_Juarez", "華雷斯城" },
            { "timezone.excity.America/Indiana/Vevay", "印第安納州韋韋" },
            { "timezone.excity.America/Santo_Domingo", "聖多明各" },
            { "timezone.excity.America/St_Barthelemy", "聖巴泰勒米" },
            { "timezone.excity.America/Bahia_Banderas", "巴伊亞德班德拉斯" },
            { "timezone.excity.America/Indiana/Marengo", "印第安納州馬倫哥" },
            { "timezone.excity.America/Indiana/Winamac", "印第安納州威納馬克" },
            { "timezone.excity.America/Indiana/Tell_City", "印第安納州特爾城" },
            { "timezone.excity.America/Indiana/Vincennes", "印第安納州溫森斯" },
            { "timezone.excity.Antarctica/DumontDUrville", "杜蒙迪維爾站" },
            { "timezone.excity.America/Argentina/La_Rioja", "拉里奧哈" },
            { "timezone.excity.America/Indiana/Petersburg", "印第安納州彼得堡" },
            { "timezone.excity.America/North_Dakota/Beulah", "北達科他州比尤拉" },
            { "timezone.excity.America/North_Dakota/Center", "北達科他州中心市" },
            { "timezone.excity.America/North_Dakota/New_Salem", "北達科他州新薩勒姆" },
        };
        return data;
    }
}
