/*  $Id: meaning.h,v 1.14 2005/03/27 21:55:39 marcusva Exp $
 *  
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2001-2004 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef LING_MEANING_H
#define LING_MEANING_H 1

#include "lesson.h"

/*
 * searches the word, which matches int meaning, in the language, which is 
 * given as char* language
 */
lingchar*
meaning_get_word (luint id, lingchar *language, lessonData *lesson);

/*
 * searches the sound matching the meaningId id and language
 */
lingchar*
meaning_get_sound (luint id, lingchar *language, lingLesson *lesson);

/*
 * returns the type of a meaning
 */
lingchar* 
meaning_get_type (luint id, lessonData *lesson);

/* 
 * creates a new node tree of meanings
 */
xmlNodePtr
meaning_create_xml_node_tree (lingMeaning *meaning, xmlNodePtr parent);

#endif /* LING_MEANING_H */
