/*  inn.h: (c) 2002 sibn

    This file is part of GWiz.

    GWiz is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GWiz is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GWiz; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HAVE_INN_H
#define HAVE_INN_H

typedef struct GwizInn_ GwizInn;

typedef enum {
    FIGHTER_LEVEL = 1100,
    MAGE_LEVEL = 1500,
    CLERIC_LEVEL = 1400,
    THIEF_LEVEL = 1200,
    WIZARD_LEVEL = 1800,
    SAMURAI_LEVEL = 2000,
    LORD_LEVEL = 1900,
    NINJA_LEVEL = 2400
} BeginLevelAmounts;

struct GwizInn_ {
    PlayerPawn *pawn;
    SDL_Surface *window;
    SDL_Surface *displace;
    SDL_Surface *statusdisplace;
    SDL_Rect drect;
    SDL_Rect crect;
    long unsigned int nextlevelat;
    int position;
    int gpmodifier;
    int hpmodifier;
    int hadbirthday;
    int levelup;
    short int str;
    short int agi;
    short int dev;
    short int iq;
    short int luck;
    short int vit;
    short int improvements[6];
    int hp;
    short int spell;
    short int unknownspell;
};

void BeginStay (int whichpawn);

void ChooseBed (void);

void Rest (SDL_Event *e);

void MoveInnCursor (int goingup);

void CheckForBirthday (void);

void CheckForLevelUp (void);

void RefillMagic (void);

SDL_Surface *DrawInnOptions (void);

void IncrementHps (void);

void PrintInnStatus (void);

void SubtractCostOfInn (void);

#endif /* HAVE_INN_H */
