/*  levelup.h: (c) 2002 sibn

    This file is part of GWiz.

    GWiz is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GWiz is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GWiz; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef HAVE_LEVELUP_H
#define HAVE_LEVELUP_H

void HandleLevelUp (void);

void GetHpBonus (void);

void ProcessLevelUp (void);

void SummarizeLevelImprovements (void);

/* Run through and give magic level bonuses */
void GetSpellBonus (void);

/* Give 1-2 new magic points to every spell level that has maxpoints >= 9 */
void DistributeNinePlusBonusPoints (void);

/* Give 2-3 new magic points to a pawn at the newest available level */
void DistributeNineMinusBonusPoints (void);

/* Determine whether new spell should be learned. */
char CalculateOddsOfLearningSpell (void);

char LastLevelSpellUnknown(short mage);

void LearnLastLevelSpell (void);

void LearnAnyLevelSpell (void);

int GetLastEligibleSpellToLearn(void);

#endif /* HAVE_LEVELUP_H */
