package devops

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CodeRepositoryType enumerates the values for code repository type.
type CodeRepositoryType string

const (
	// GitHub ...
	GitHub CodeRepositoryType = "gitHub"
	// VstsGit ...
	VstsGit CodeRepositoryType = "vstsGit"
)

// PossibleCodeRepositoryTypeValues returns an array of possible values for the CodeRepositoryType const type.
func PossibleCodeRepositoryTypeValues() []CodeRepositoryType {
	return []CodeRepositoryType{GitHub, VstsGit}
}

// InputDataType enumerates the values for input data type.
type InputDataType string

const (
	// InputDataTypeAuthorization ...
	InputDataTypeAuthorization InputDataType = "Authorization"
	// InputDataTypeBool ...
	InputDataTypeBool InputDataType = "Bool"
	// InputDataTypeInt ...
	InputDataTypeInt InputDataType = "Int"
	// InputDataTypeSecureString ...
	InputDataTypeSecureString InputDataType = "SecureString"
	// InputDataTypeString ...
	InputDataTypeString InputDataType = "String"
)

// PossibleInputDataTypeValues returns an array of possible values for the InputDataType const type.
func PossibleInputDataTypeValues() []InputDataType {
	return []InputDataType{InputDataTypeAuthorization, InputDataTypeBool, InputDataTypeInt, InputDataTypeSecureString, InputDataTypeString}
}
