package sqlapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/sql/mgmt/v3.0/sql"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/satori/go.uuid"
)

// RecoverableDatabasesClientAPI contains the set of methods on the RecoverableDatabasesClient type.
type RecoverableDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.RecoverableDatabase, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.RecoverableDatabaseListResult, err error)
}

var _ RecoverableDatabasesClientAPI = (*sql.RecoverableDatabasesClient)(nil)

// RestorableDroppedDatabasesClientAPI contains the set of methods on the RestorableDroppedDatabasesClient type.
type RestorableDroppedDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, restorableDroppededDatabaseID string) (result sql.RestorableDroppedDatabase, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.RestorableDroppedDatabaseListResult, err error)
}

var _ RestorableDroppedDatabasesClientAPI = (*sql.RestorableDroppedDatabasesClient)(nil)

// ServerConnectionPoliciesClientAPI contains the set of methods on the ServerConnectionPoliciesClient type.
type ServerConnectionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerConnectionPolicy) (result sql.ServerConnectionPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerConnectionPolicy, err error)
}

var _ ServerConnectionPoliciesClientAPI = (*sql.ServerConnectionPoliciesClient)(nil)

// DatabaseThreatDetectionPoliciesClientAPI contains the set of methods on the DatabaseThreatDetectionPoliciesClient type.
type DatabaseThreatDetectionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseSecurityAlertPolicy) (result sql.DatabaseSecurityAlertPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSecurityAlertPolicy, err error)
}

var _ DatabaseThreatDetectionPoliciesClientAPI = (*sql.DatabaseThreatDetectionPoliciesClient)(nil)

// DataMaskingPoliciesClientAPI contains the set of methods on the DataMaskingPoliciesClient type.
type DataMaskingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DataMaskingPolicy) (result sql.DataMaskingPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DataMaskingPolicy, err error)
}

var _ DataMaskingPoliciesClientAPI = (*sql.DataMaskingPoliciesClient)(nil)

// DataMaskingRulesClientAPI contains the set of methods on the DataMaskingRulesClient type.
type DataMaskingRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, dataMaskingRuleName string, parameters sql.DataMaskingRule) (result sql.DataMaskingRule, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DataMaskingRuleListResult, err error)
}

var _ DataMaskingRulesClientAPI = (*sql.DataMaskingRulesClient)(nil)

// FirewallRulesClientAPI contains the set of methods on the FirewallRulesClient type.
type FirewallRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string, parameters sql.FirewallRule) (result sql.FirewallRule, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result sql.FirewallRule, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.FirewallRuleListResult, err error)
}

var _ FirewallRulesClientAPI = (*sql.FirewallRulesClient)(nil)

// GeoBackupPoliciesClientAPI contains the set of methods on the GeoBackupPoliciesClient type.
type GeoBackupPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.GeoBackupPolicy) (result sql.GeoBackupPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.GeoBackupPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.GeoBackupPolicyListResult, err error)
}

var _ GeoBackupPoliciesClientAPI = (*sql.GeoBackupPoliciesClient)(nil)

// DatabasesClientAPI contains the set of methods on the DatabasesClient type.
type DatabasesClientAPI interface {
	CreateImportOperation(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ImportExtensionRequest) (result sql.DatabasesCreateImportOperationFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.Database) (result sql.DatabasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesDeleteFuture, err error)
	Export(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ExportRequest) (result sql.DatabasesExportFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, databaseName string, replicaType sql.ReplicaType) (result sql.DatabasesFailoverFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.Database, err error)
	Import(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ImportRequest) (result sql.DatabasesImportFuture, err error)
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.DatabaseListResultPage, err error)
	ListByElasticPoolComplete(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.DatabaseListResultIterator, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.DatabaseListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.DatabaseListResultIterator, err error)
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.MetricDefinitionListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, serverName string, databaseName string, filter string) (result sql.MetricListResult, err error)
	Pause(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesPauseFuture, err error)
	Rename(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ResourceMoveDefinition) (result autorest.Response, err error)
	Resume(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesResumeFuture, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseUpdate) (result sql.DatabasesUpdateFuture, err error)
	UpgradeDataWarehouse(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesUpgradeDataWarehouseFuture, err error)
}

var _ DatabasesClientAPI = (*sql.DatabasesClient)(nil)

// ElasticPoolsClientAPI contains the set of methods on the ElasticPoolsClient type.
type ElasticPoolsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, parameters sql.ElasticPool) (result sql.ElasticPoolsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolsDeleteFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolsFailoverFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPool, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string, skip *int32) (result sql.ElasticPoolListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string, skip *int32) (result sql.ElasticPoolListResultIterator, err error)
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.MetricDefinitionListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, filter string) (result sql.MetricListResult, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, parameters sql.ElasticPoolUpdate) (result sql.ElasticPoolsUpdateFuture, err error)
}

var _ ElasticPoolsClientAPI = (*sql.ElasticPoolsClient)(nil)

// RecommendedElasticPoolsClientAPI contains the set of methods on the RecommendedElasticPoolsClient type.
type RecommendedElasticPoolsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, recommendedElasticPoolName string) (result sql.RecommendedElasticPool, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.RecommendedElasticPoolListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, serverName string, recommendedElasticPoolName string) (result sql.RecommendedElasticPoolListMetricsResult, err error)
}

var _ RecommendedElasticPoolsClientAPI = (*sql.RecommendedElasticPoolsClient)(nil)

// ReplicationLinksClientAPI contains the set of methods on the ReplicationLinksClient type.
type ReplicationLinksClientAPI interface {
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result autorest.Response, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLinksFailoverFuture, err error)
	FailoverAllowDataLoss(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLinksFailoverAllowDataLossFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLink, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ReplicationLinkListResult, err error)
	Unlink(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string, parameters sql.UnlinkParameters) (result sql.ReplicationLinksUnlinkFuture, err error)
}

var _ ReplicationLinksClientAPI = (*sql.ReplicationLinksClient)(nil)

// ServerCommunicationLinksClientAPI contains the set of methods on the ServerCommunicationLinksClient type.
type ServerCommunicationLinksClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, communicationLinkName string, parameters sql.ServerCommunicationLink) (result sql.ServerCommunicationLinksCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, communicationLinkName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, communicationLinkName string) (result sql.ServerCommunicationLink, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerCommunicationLinkListResult, err error)
}

var _ ServerCommunicationLinksClientAPI = (*sql.ServerCommunicationLinksClient)(nil)

// ServiceObjectivesClientAPI contains the set of methods on the ServiceObjectivesClient type.
type ServiceObjectivesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, serviceObjectiveName string) (result sql.ServiceObjective, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServiceObjectiveListResult, err error)
}

var _ ServiceObjectivesClientAPI = (*sql.ServiceObjectivesClient)(nil)

// ElasticPoolActivitiesClientAPI contains the set of methods on the ElasticPoolActivitiesClient type.
type ElasticPoolActivitiesClientAPI interface {
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolActivityListResult, err error)
}

var _ ElasticPoolActivitiesClientAPI = (*sql.ElasticPoolActivitiesClient)(nil)

// ElasticPoolDatabaseActivitiesClientAPI contains the set of methods on the ElasticPoolDatabaseActivitiesClient type.
type ElasticPoolDatabaseActivitiesClientAPI interface {
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolDatabaseActivityListResult, err error)
}

var _ ElasticPoolDatabaseActivitiesClientAPI = (*sql.ElasticPoolDatabaseActivitiesClient)(nil)

// ServiceTierAdvisorsClientAPI contains the set of methods on the ServiceTierAdvisorsClient type.
type ServiceTierAdvisorsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, serviceTierAdvisorName string) (result sql.ServiceTierAdvisor, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ServiceTierAdvisorListResult, err error)
}

var _ ServiceTierAdvisorsClientAPI = (*sql.ServiceTierAdvisorsClient)(nil)

// TransparentDataEncryptionsClientAPI contains the set of methods on the TransparentDataEncryptionsClient type.
type TransparentDataEncryptionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.TransparentDataEncryption) (result sql.TransparentDataEncryption, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.TransparentDataEncryption, err error)
}

var _ TransparentDataEncryptionsClientAPI = (*sql.TransparentDataEncryptionsClient)(nil)

// TransparentDataEncryptionActivitiesClientAPI contains the set of methods on the TransparentDataEncryptionActivitiesClient type.
type TransparentDataEncryptionActivitiesClientAPI interface {
	ListByConfiguration(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.TransparentDataEncryptionActivityListResult, err error)
}

var _ TransparentDataEncryptionActivitiesClientAPI = (*sql.TransparentDataEncryptionActivitiesClient)(nil)

// ServerUsagesClientAPI contains the set of methods on the ServerUsagesClient type.
type ServerUsagesClientAPI interface {
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerUsageListResult, err error)
}

var _ ServerUsagesClientAPI = (*sql.ServerUsagesClient)(nil)

// DatabaseUsagesClientAPI contains the set of methods on the DatabaseUsagesClient type.
type DatabaseUsagesClientAPI interface {
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseUsageListResult, err error)
}

var _ DatabaseUsagesClientAPI = (*sql.DatabaseUsagesClient)(nil)

// DatabaseAutomaticTuningClientAPI contains the set of methods on the DatabaseAutomaticTuningClient type.
type DatabaseAutomaticTuningClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseAutomaticTuning, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseAutomaticTuning) (result sql.DatabaseAutomaticTuning, err error)
}

var _ DatabaseAutomaticTuningClientAPI = (*sql.DatabaseAutomaticTuningClient)(nil)

// EncryptionProtectorsClientAPI contains the set of methods on the EncryptionProtectorsClient type.
type EncryptionProtectorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.EncryptionProtector) (result sql.EncryptionProtectorsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtector, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtectorListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtectorListResultIterator, err error)
	Revalidate(ctx context.Context, resourceGroupName string, serverName string) (result sql.EncryptionProtectorsRevalidateFuture, err error)
}

var _ EncryptionProtectorsClientAPI = (*sql.EncryptionProtectorsClient)(nil)

// FailoverGroupsClientAPI contains the set of methods on the FailoverGroupsClient type.
type FailoverGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, parameters sql.FailoverGroup) (result sql.FailoverGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroupsDeleteFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroupsFailoverFuture, err error)
	ForceFailoverAllowDataLoss(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroupsForceFailoverAllowDataLossFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string) (result sql.FailoverGroup, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.FailoverGroupListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.FailoverGroupListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, failoverGroupName string, parameters sql.FailoverGroupUpdate) (result sql.FailoverGroupsUpdateFuture, err error)
}

var _ FailoverGroupsClientAPI = (*sql.FailoverGroupsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result sql.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*sql.OperationsClient)(nil)

// ServerKeysClientAPI contains the set of methods on the ServerKeysClient type.
type ServerKeysClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, keyName string, parameters sql.ServerKey) (result sql.ServerKeysCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, keyName string) (result sql.ServerKeysDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, keyName string) (result sql.ServerKey, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerKeyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerKeyListResultIterator, err error)
}

var _ ServerKeysClientAPI = (*sql.ServerKeysClient)(nil)

// SyncAgentsClientAPI contains the set of methods on the SyncAgentsClient type.
type SyncAgentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string, parameters sql.SyncAgent) (result sql.SyncAgentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentsDeleteFuture, err error)
	GenerateKey(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentKeyProperties, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgent, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.SyncAgentListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.SyncAgentListResultIterator, err error)
	ListLinkedDatabases(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentLinkedDatabaseListResultPage, err error)
	ListLinkedDatabasesComplete(ctx context.Context, resourceGroupName string, serverName string, syncAgentName string) (result sql.SyncAgentLinkedDatabaseListResultIterator, err error)
}

var _ SyncAgentsClientAPI = (*sql.SyncAgentsClient)(nil)

// SubscriptionUsagesClientAPI contains the set of methods on the SubscriptionUsagesClient type.
type SubscriptionUsagesClientAPI interface {
	Get(ctx context.Context, locationName string, usageName string) (result sql.SubscriptionUsage, err error)
	ListByLocation(ctx context.Context, locationName string) (result sql.SubscriptionUsageListResultPage, err error)
	ListByLocationComplete(ctx context.Context, locationName string) (result sql.SubscriptionUsageListResultIterator, err error)
}

var _ SubscriptionUsagesClientAPI = (*sql.SubscriptionUsagesClient)(nil)

// VirtualClustersClientAPI contains the set of methods on the VirtualClustersClient type.
type VirtualClustersClientAPI interface {
	Delete(ctx context.Context, resourceGroupName string, virtualClusterName string) (result sql.VirtualClustersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, virtualClusterName string) (result sql.VirtualCluster, err error)
	List(ctx context.Context) (result sql.VirtualClusterListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.VirtualClusterListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result sql.VirtualClusterListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result sql.VirtualClusterListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, virtualClusterName string, parameters sql.VirtualClusterUpdate) (result sql.VirtualClustersUpdateFuture, err error)
}

var _ VirtualClustersClientAPI = (*sql.VirtualClustersClient)(nil)

// VirtualNetworkRulesClientAPI contains the set of methods on the VirtualNetworkRulesClient type.
type VirtualNetworkRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, virtualNetworkRuleName string, parameters sql.VirtualNetworkRule) (result sql.VirtualNetworkRulesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, virtualNetworkRuleName string) (result sql.VirtualNetworkRulesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, virtualNetworkRuleName string) (result sql.VirtualNetworkRule, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.VirtualNetworkRuleListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.VirtualNetworkRuleListResultIterator, err error)
}

var _ VirtualNetworkRulesClientAPI = (*sql.VirtualNetworkRulesClient)(nil)

// ExtendedDatabaseBlobAuditingPoliciesClientAPI contains the set of methods on the ExtendedDatabaseBlobAuditingPoliciesClient type.
type ExtendedDatabaseBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ExtendedDatabaseBlobAuditingPolicy) (result sql.ExtendedDatabaseBlobAuditingPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ExtendedDatabaseBlobAuditingPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ExtendedDatabaseBlobAuditingPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ExtendedDatabaseBlobAuditingPolicyListResultIterator, err error)
}

var _ ExtendedDatabaseBlobAuditingPoliciesClientAPI = (*sql.ExtendedDatabaseBlobAuditingPoliciesClient)(nil)

// ExtendedServerBlobAuditingPoliciesClientAPI contains the set of methods on the ExtendedServerBlobAuditingPoliciesClient type.
type ExtendedServerBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ExtendedServerBlobAuditingPolicy) (result sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ExtendedServerBlobAuditingPolicy, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ExtendedServerBlobAuditingPolicyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ExtendedServerBlobAuditingPolicyListResultIterator, err error)
}

var _ ExtendedServerBlobAuditingPoliciesClientAPI = (*sql.ExtendedServerBlobAuditingPoliciesClient)(nil)

// ServerBlobAuditingPoliciesClientAPI contains the set of methods on the ServerBlobAuditingPoliciesClient type.
type ServerBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerBlobAuditingPolicy) (result sql.ServerBlobAuditingPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerBlobAuditingPolicy, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerBlobAuditingPolicyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerBlobAuditingPolicyListResultIterator, err error)
}

var _ ServerBlobAuditingPoliciesClientAPI = (*sql.ServerBlobAuditingPoliciesClient)(nil)

// DatabaseBlobAuditingPoliciesClientAPI contains the set of methods on the DatabaseBlobAuditingPoliciesClient type.
type DatabaseBlobAuditingPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseBlobAuditingPolicy) (result sql.DatabaseBlobAuditingPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseBlobAuditingPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseBlobAuditingPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseBlobAuditingPolicyListResultIterator, err error)
}

var _ DatabaseBlobAuditingPoliciesClientAPI = (*sql.DatabaseBlobAuditingPoliciesClient)(nil)

// DatabaseVulnerabilityAssessmentRuleBaselinesClientAPI contains the set of methods on the DatabaseVulnerabilityAssessmentRuleBaselinesClient type.
type DatabaseVulnerabilityAssessmentRuleBaselinesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName, parameters sql.DatabaseVulnerabilityAssessmentRuleBaseline) (result sql.DatabaseVulnerabilityAssessmentRuleBaseline, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName) (result sql.DatabaseVulnerabilityAssessmentRuleBaseline, err error)
}

var _ DatabaseVulnerabilityAssessmentRuleBaselinesClientAPI = (*sql.DatabaseVulnerabilityAssessmentRuleBaselinesClient)(nil)

// DatabaseVulnerabilityAssessmentsClientAPI contains the set of methods on the DatabaseVulnerabilityAssessmentsClient type.
type DatabaseVulnerabilityAssessmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseVulnerabilityAssessment) (result sql.DatabaseVulnerabilityAssessment, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseVulnerabilityAssessment, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseVulnerabilityAssessmentListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseVulnerabilityAssessmentListResultIterator, err error)
}

var _ DatabaseVulnerabilityAssessmentsClientAPI = (*sql.DatabaseVulnerabilityAssessmentsClient)(nil)

// JobAgentsClientAPI contains the set of methods on the JobAgentsClient type.
type JobAgentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, parameters sql.JobAgent) (result sql.JobAgentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobAgentsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobAgent, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.JobAgentListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.JobAgentListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, parameters sql.JobAgentUpdate) (result sql.JobAgentsUpdateFuture, err error)
}

var _ JobAgentsClientAPI = (*sql.JobAgentsClient)(nil)

// JobCredentialsClientAPI contains the set of methods on the JobCredentialsClient type.
type JobCredentialsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, credentialName string, parameters sql.JobCredential) (result sql.JobCredential, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, credentialName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, credentialName string) (result sql.JobCredential, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobCredentialListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobCredentialListResultIterator, err error)
}

var _ JobCredentialsClientAPI = (*sql.JobCredentialsClient)(nil)

// JobExecutionsClientAPI contains the set of methods on the JobExecutionsClient type.
type JobExecutionsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID) (result autorest.Response, err error)
	Create(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobExecutionsCreateFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID) (result sql.JobExecutionsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID) (result sql.JobExecution, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
	ListByJob(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByJobComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
}

var _ JobExecutionsClientAPI = (*sql.JobExecutionsClient)(nil)

// JobsClientAPI contains the set of methods on the JobsClient type.
type JobsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, parameters sql.Job) (result sql.Job, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.Job, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobListResultIterator, err error)
}

var _ JobsClientAPI = (*sql.JobsClient)(nil)

// JobStepExecutionsClientAPI contains the set of methods on the JobStepExecutionsClient type.
type JobStepExecutionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string) (result sql.JobExecution, err error)
	ListByJobExecution(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByJobExecutionComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
}

var _ JobStepExecutionsClientAPI = (*sql.JobStepExecutionsClient)(nil)

// JobStepsClientAPI contains the set of methods on the JobStepsClient type.
type JobStepsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string, parameters sql.JobStep) (result sql.JobStep, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string) (result sql.JobStep, err error)
	GetByVersion(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32, stepName string) (result sql.JobStep, err error)
	ListByJob(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobStepListResultPage, err error)
	ListByJobComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobStepListResultIterator, err error)
	ListByVersion(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32) (result sql.JobStepListResultPage, err error)
	ListByVersionComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32) (result sql.JobStepListResultIterator, err error)
}

var _ JobStepsClientAPI = (*sql.JobStepsClient)(nil)

// JobTargetExecutionsClientAPI contains the set of methods on the JobTargetExecutionsClient type.
type JobTargetExecutionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string, targetID uuid.UUID) (result sql.JobExecution, err error)
	ListByJobExecution(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByJobExecutionComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
	ListByStep(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultPage, err error)
	ListByStepComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobExecutionID uuid.UUID, stepName string, createTimeMin *date.Time, createTimeMax *date.Time, endTimeMin *date.Time, endTimeMax *date.Time, isActive *bool, skip *int32, top *int32) (result sql.JobExecutionListResultIterator, err error)
}

var _ JobTargetExecutionsClientAPI = (*sql.JobTargetExecutionsClient)(nil)

// JobTargetGroupsClientAPI contains the set of methods on the JobTargetGroupsClient type.
type JobTargetGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, targetGroupName string, parameters sql.JobTargetGroup) (result sql.JobTargetGroup, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, targetGroupName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, targetGroupName string) (result sql.JobTargetGroup, err error)
	ListByAgent(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobTargetGroupListResultPage, err error)
	ListByAgentComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string) (result sql.JobTargetGroupListResultIterator, err error)
}

var _ JobTargetGroupsClientAPI = (*sql.JobTargetGroupsClient)(nil)

// JobVersionsClientAPI contains the set of methods on the JobVersionsClient type.
type JobVersionsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32) (result sql.JobVersion, err error)
	ListByJob(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobVersionListResultPage, err error)
	ListByJobComplete(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string) (result sql.JobVersionListResultIterator, err error)
}

var _ JobVersionsClientAPI = (*sql.JobVersionsClient)(nil)

// LongTermRetentionBackupsClientAPI contains the set of methods on the LongTermRetentionBackupsClient type.
type LongTermRetentionBackupsClientAPI interface {
	Delete(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result sql.LongTermRetentionBackupsDeleteFuture, err error)
	DeleteByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result sql.LongTermRetentionBackupsDeleteByResourceGroupFuture, err error)
	Get(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result sql.LongTermRetentionBackup, err error)
	GetByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result sql.LongTermRetentionBackup, err error)
	ListByDatabase(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	ListByLocation(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByLocationComplete(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupDatabase(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupDatabaseComplete(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupLocation(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupLocationComplete(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupServer(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupServerComplete(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
	ListByServer(ctx context.Context, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultPage, err error)
	ListByServerComplete(ctx context.Context, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState sql.LongTermRetentionDatabaseState) (result sql.LongTermRetentionBackupListResultIterator, err error)
}

var _ LongTermRetentionBackupsClientAPI = (*sql.LongTermRetentionBackupsClient)(nil)

// BackupLongTermRetentionPoliciesClientAPI contains the set of methods on the BackupLongTermRetentionPoliciesClient type.
type BackupLongTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.BackupLongTermRetentionPolicy) (result sql.BackupLongTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.BackupLongTermRetentionPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.BackupLongTermRetentionPolicy, err error)
}

var _ BackupLongTermRetentionPoliciesClientAPI = (*sql.BackupLongTermRetentionPoliciesClient)(nil)

// ManagedBackupShortTermRetentionPoliciesClientAPI contains the set of methods on the ManagedBackupShortTermRetentionPoliciesClient type.
type ManagedBackupShortTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedBackupShortTermRetentionPolicy) (result sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedBackupShortTermRetentionPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedBackupShortTermRetentionPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedBackupShortTermRetentionPolicyListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedBackupShortTermRetentionPolicy) (result sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture, err error)
}

var _ ManagedBackupShortTermRetentionPoliciesClientAPI = (*sql.ManagedBackupShortTermRetentionPoliciesClient)(nil)

// ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientAPI contains the set of methods on the ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient type.
type ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string, parameters sql.ManagedBackupShortTermRetentionPolicy) (result sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string) (result sql.ManagedBackupShortTermRetentionPolicy, err error)
	ListByRestorableDroppedDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string) (result sql.ManagedBackupShortTermRetentionPolicyListResultPage, err error)
	ListByRestorableDroppedDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string) (result sql.ManagedBackupShortTermRetentionPolicyListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string, parameters sql.ManagedBackupShortTermRetentionPolicy) (result sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesUpdateFuture, err error)
}

var _ ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientAPI = (*sql.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient)(nil)

// ServerAutomaticTuningClientAPI contains the set of methods on the ServerAutomaticTuningClient type.
type ServerAutomaticTuningClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAutomaticTuning, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerAutomaticTuning) (result sql.ServerAutomaticTuning, err error)
}

var _ ServerAutomaticTuningClientAPI = (*sql.ServerAutomaticTuningClient)(nil)

// ServerDNSAliasesClientAPI contains the set of methods on the ServerDNSAliasesClient type.
type ServerDNSAliasesClientAPI interface {
	Acquire(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string, parameters sql.ServerDNSAliasAcquisition) (result sql.ServerDNSAliasesAcquireFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string) (result sql.ServerDNSAliasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string) (result sql.ServerDNSAliasesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, DNSAliasName string) (result sql.ServerDNSAlias, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerDNSAliasListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerDNSAliasListResultIterator, err error)
}

var _ ServerDNSAliasesClientAPI = (*sql.ServerDNSAliasesClient)(nil)

// ServerSecurityAlertPoliciesClientAPI contains the set of methods on the ServerSecurityAlertPoliciesClient type.
type ServerSecurityAlertPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerSecurityAlertPolicy) (result sql.ServerSecurityAlertPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerSecurityAlertPolicy, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.LogicalServerSecurityAlertPolicyListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.LogicalServerSecurityAlertPolicyListResultIterator, err error)
}

var _ ServerSecurityAlertPoliciesClientAPI = (*sql.ServerSecurityAlertPoliciesClient)(nil)

// RestorableDroppedManagedDatabasesClientAPI contains the set of methods on the RestorableDroppedManagedDatabasesClient type.
type RestorableDroppedManagedDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, restorableDroppedDatabaseID string) (result sql.RestorableDroppedManagedDatabase, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.RestorableDroppedManagedDatabaseListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.RestorableDroppedManagedDatabaseListResultIterator, err error)
}

var _ RestorableDroppedManagedDatabasesClientAPI = (*sql.RestorableDroppedManagedDatabasesClient)(nil)

// RestorePointsClientAPI contains the set of methods on the RestorePointsClient type.
type RestorePointsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.CreateDatabaseRestorePointDefinition) (result sql.RestorePointsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, restorePointName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, restorePointName string) (result sql.RestorePoint, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.RestorePointListResult, err error)
}

var _ RestorePointsClientAPI = (*sql.RestorePointsClient)(nil)

// ManagedDatabaseSecurityAlertPoliciesClientAPI contains the set of methods on the ManagedDatabaseSecurityAlertPoliciesClient type.
type ManagedDatabaseSecurityAlertPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabaseSecurityAlertPolicy) (result sql.ManagedDatabaseSecurityAlertPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseSecurityAlertPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseSecurityAlertPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseSecurityAlertPolicyListResultIterator, err error)
}

var _ ManagedDatabaseSecurityAlertPoliciesClientAPI = (*sql.ManagedDatabaseSecurityAlertPoliciesClient)(nil)

// ManagedServerSecurityAlertPoliciesClientAPI contains the set of methods on the ManagedServerSecurityAlertPoliciesClient type.
type ManagedServerSecurityAlertPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedServerSecurityAlertPolicy) (result sql.ManagedServerSecurityAlertPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedServerSecurityAlertPolicy, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedServerSecurityAlertPolicyListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedServerSecurityAlertPolicyListResultIterator, err error)
}

var _ ManagedServerSecurityAlertPoliciesClientAPI = (*sql.ManagedServerSecurityAlertPoliciesClient)(nil)

// SensitivityLabelsClientAPI contains the set of methods on the SensitivityLabelsClient type.
type SensitivityLabelsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string, parameters sql.SensitivityLabel) (result sql.SensitivityLabel, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	DisableRecommendation(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	EnableRecommendation(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string, sensitivityLabelSource sql.SensitivityLabelSource) (result sql.SensitivityLabel, err error)
	ListCurrentByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string, filter string) (result sql.SensitivityLabelListResultPage, err error)
	ListCurrentByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, filter string) (result sql.SensitivityLabelListResultIterator, err error)
	ListRecommendedByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string, includeDisabledRecommendations *bool, skipToken string, filter string) (result sql.SensitivityLabelListResultPage, err error)
	ListRecommendedByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, includeDisabledRecommendations *bool, skipToken string, filter string) (result sql.SensitivityLabelListResultIterator, err error)
}

var _ SensitivityLabelsClientAPI = (*sql.SensitivityLabelsClient)(nil)

// ManagedInstanceAdministratorsClientAPI contains the set of methods on the ManagedInstanceAdministratorsClient type.
type ManagedInstanceAdministratorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceAdministrator) (result sql.ManagedInstanceAdministratorsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministratorsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministrator, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministratorListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceAdministratorListResultIterator, err error)
}

var _ ManagedInstanceAdministratorsClientAPI = (*sql.ManagedInstanceAdministratorsClient)(nil)

// DatabaseOperationsClientAPI contains the set of methods on the DatabaseOperationsClient type.
type DatabaseOperationsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, serverName string, databaseName string, operationID uuid.UUID) (result autorest.Response, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseOperationListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseOperationListResultIterator, err error)
}

var _ DatabaseOperationsClientAPI = (*sql.DatabaseOperationsClient)(nil)

// ElasticPoolOperationsClientAPI contains the set of methods on the ElasticPoolOperationsClient type.
type ElasticPoolOperationsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, operationID uuid.UUID) (result autorest.Response, err error)
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolOperationListResultPage, err error)
	ListByElasticPoolComplete(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolOperationListResultIterator, err error)
}

var _ ElasticPoolOperationsClientAPI = (*sql.ElasticPoolOperationsClient)(nil)

// DatabaseVulnerabilityAssessmentScansClientAPI contains the set of methods on the DatabaseVulnerabilityAssessmentScansClient type.
type DatabaseVulnerabilityAssessmentScansClientAPI interface {
	Export(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result sql.DatabaseVulnerabilityAssessmentScansExport, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result sql.VulnerabilityAssessmentScanRecord, err error)
	InitiateScan(ctx context.Context, resourceGroupName string, serverName string, databaseName string, scanID string) (result sql.DatabaseVulnerabilityAssessmentScansInitiateScanFuture, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.VulnerabilityAssessmentScanRecordListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.VulnerabilityAssessmentScanRecordListResultIterator, err error)
}

var _ DatabaseVulnerabilityAssessmentScansClientAPI = (*sql.DatabaseVulnerabilityAssessmentScansClient)(nil)

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientAPI contains the set of methods on the ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient type.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName, parameters sql.DatabaseVulnerabilityAssessmentRuleBaseline) (result sql.DatabaseVulnerabilityAssessmentRuleBaseline, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName sql.VulnerabilityAssessmentPolicyBaselineName) (result sql.DatabaseVulnerabilityAssessmentRuleBaseline, err error)
}

var _ ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientAPI = (*sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient)(nil)

// ManagedDatabaseVulnerabilityAssessmentScansClientAPI contains the set of methods on the ManagedDatabaseVulnerabilityAssessmentScansClient type.
type ManagedDatabaseVulnerabilityAssessmentScansClientAPI interface {
	Export(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, scanID string) (result sql.DatabaseVulnerabilityAssessmentScansExport, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, scanID string) (result sql.VulnerabilityAssessmentScanRecord, err error)
	InitiateScan(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, scanID string) (result sql.ManagedDatabaseVulnerabilityAssessmentScansInitiateScanFuture, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.VulnerabilityAssessmentScanRecordListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.VulnerabilityAssessmentScanRecordListResultIterator, err error)
}

var _ ManagedDatabaseVulnerabilityAssessmentScansClientAPI = (*sql.ManagedDatabaseVulnerabilityAssessmentScansClient)(nil)

// ManagedDatabaseVulnerabilityAssessmentsClientAPI contains the set of methods on the ManagedDatabaseVulnerabilityAssessmentsClient type.
type ManagedDatabaseVulnerabilityAssessmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.DatabaseVulnerabilityAssessment) (result sql.DatabaseVulnerabilityAssessment, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.DatabaseVulnerabilityAssessment, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.DatabaseVulnerabilityAssessmentListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.DatabaseVulnerabilityAssessmentListResultIterator, err error)
}

var _ ManagedDatabaseVulnerabilityAssessmentsClientAPI = (*sql.ManagedDatabaseVulnerabilityAssessmentsClient)(nil)

// InstanceFailoverGroupsClientAPI contains the set of methods on the InstanceFailoverGroupsClient type.
type InstanceFailoverGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string, parameters sql.InstanceFailoverGroup) (result sql.InstanceFailoverGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string) (result sql.InstanceFailoverGroupsDeleteFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string) (result sql.InstanceFailoverGroupsFailoverFuture, err error)
	ForceFailoverAllowDataLoss(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string) (result sql.InstanceFailoverGroupsForceFailoverAllowDataLossFuture, err error)
	Get(ctx context.Context, resourceGroupName string, locationName string, failoverGroupName string) (result sql.InstanceFailoverGroup, err error)
	ListByLocation(ctx context.Context, resourceGroupName string, locationName string) (result sql.InstanceFailoverGroupListResultPage, err error)
	ListByLocationComplete(ctx context.Context, resourceGroupName string, locationName string) (result sql.InstanceFailoverGroupListResultIterator, err error)
}

var _ InstanceFailoverGroupsClientAPI = (*sql.InstanceFailoverGroupsClient)(nil)

// BackupShortTermRetentionPoliciesClientAPI contains the set of methods on the BackupShortTermRetentionPoliciesClient type.
type BackupShortTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.BackupShortTermRetentionPolicy) (result sql.BackupShortTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.BackupShortTermRetentionPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.BackupShortTermRetentionPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.BackupShortTermRetentionPolicyListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.BackupShortTermRetentionPolicy) (result sql.BackupShortTermRetentionPoliciesUpdateFuture, err error)
}

var _ BackupShortTermRetentionPoliciesClientAPI = (*sql.BackupShortTermRetentionPoliciesClient)(nil)

// TdeCertificatesClientAPI contains the set of methods on the TdeCertificatesClient type.
type TdeCertificatesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, serverName string, parameters sql.TdeCertificate) (result sql.TdeCertificatesCreateFuture, err error)
}

var _ TdeCertificatesClientAPI = (*sql.TdeCertificatesClient)(nil)

// ManagedInstanceTdeCertificatesClientAPI contains the set of methods on the ManagedInstanceTdeCertificatesClient type.
type ManagedInstanceTdeCertificatesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.TdeCertificate) (result sql.ManagedInstanceTdeCertificatesCreateFuture, err error)
}

var _ ManagedInstanceTdeCertificatesClientAPI = (*sql.ManagedInstanceTdeCertificatesClient)(nil)

// ManagedInstanceKeysClientAPI contains the set of methods on the ManagedInstanceKeysClient type.
type ManagedInstanceKeysClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, keyName string, parameters sql.ManagedInstanceKey) (result sql.ManagedInstanceKeysCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, keyName string) (result sql.ManagedInstanceKeysDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, keyName string) (result sql.ManagedInstanceKey, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string, filter string) (result sql.ManagedInstanceKeyListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, filter string) (result sql.ManagedInstanceKeyListResultIterator, err error)
}

var _ ManagedInstanceKeysClientAPI = (*sql.ManagedInstanceKeysClient)(nil)

// ManagedInstanceEncryptionProtectorsClientAPI contains the set of methods on the ManagedInstanceEncryptionProtectorsClient type.
type ManagedInstanceEncryptionProtectorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceEncryptionProtector) (result sql.ManagedInstanceEncryptionProtectorsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceEncryptionProtector, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceEncryptionProtectorListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceEncryptionProtectorListResultIterator, err error)
	Revalidate(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceEncryptionProtectorsRevalidateFuture, err error)
}

var _ ManagedInstanceEncryptionProtectorsClientAPI = (*sql.ManagedInstanceEncryptionProtectorsClient)(nil)

// RecoverableManagedDatabasesClientAPI contains the set of methods on the RecoverableManagedDatabasesClient type.
type RecoverableManagedDatabasesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, recoverableDatabaseName string) (result sql.RecoverableManagedDatabase, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.RecoverableManagedDatabaseListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.RecoverableManagedDatabaseListResultIterator, err error)
}

var _ RecoverableManagedDatabasesClientAPI = (*sql.RecoverableManagedDatabasesClient)(nil)

// ManagedInstanceVulnerabilityAssessmentsClientAPI contains the set of methods on the ManagedInstanceVulnerabilityAssessmentsClient type.
type ManagedInstanceVulnerabilityAssessmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceVulnerabilityAssessment) (result sql.ManagedInstanceVulnerabilityAssessment, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceVulnerabilityAssessment, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceVulnerabilityAssessmentListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceVulnerabilityAssessmentListResultIterator, err error)
}

var _ ManagedInstanceVulnerabilityAssessmentsClientAPI = (*sql.ManagedInstanceVulnerabilityAssessmentsClient)(nil)

// ServerVulnerabilityAssessmentsClientAPI contains the set of methods on the ServerVulnerabilityAssessmentsClient type.
type ServerVulnerabilityAssessmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerVulnerabilityAssessment) (result sql.ServerVulnerabilityAssessment, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerVulnerabilityAssessment, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerVulnerabilityAssessmentListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerVulnerabilityAssessmentListResultIterator, err error)
}

var _ ServerVulnerabilityAssessmentsClientAPI = (*sql.ServerVulnerabilityAssessmentsClient)(nil)

// ManagedDatabaseSensitivityLabelsClientAPI contains the set of methods on the ManagedDatabaseSensitivityLabelsClient type.
type ManagedDatabaseSensitivityLabelsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string, parameters sql.SensitivityLabel) (result sql.SensitivityLabel, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	DisableRecommendation(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	EnableRecommendation(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, schemaName string, tableName string, columnName string, sensitivityLabelSource sql.SensitivityLabelSource) (result sql.SensitivityLabel, err error)
	ListCurrentByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, filter string) (result sql.SensitivityLabelListResultPage, err error)
	ListCurrentByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, filter string) (result sql.SensitivityLabelListResultIterator, err error)
	ListRecommendedByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, includeDisabledRecommendations *bool, skipToken string, filter string) (result sql.SensitivityLabelListResultPage, err error)
	ListRecommendedByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, includeDisabledRecommendations *bool, skipToken string, filter string) (result sql.SensitivityLabelListResultIterator, err error)
}

var _ ManagedDatabaseSensitivityLabelsClientAPI = (*sql.ManagedDatabaseSensitivityLabelsClient)(nil)

// InstancePoolsClientAPI contains the set of methods on the InstancePoolsClient type.
type InstancePoolsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, instancePoolName string, parameters sql.InstancePool) (result sql.InstancePoolsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, instancePoolName string) (result sql.InstancePoolsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, instancePoolName string) (result sql.InstancePool, err error)
	List(ctx context.Context) (result sql.InstancePoolListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.InstancePoolListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result sql.InstancePoolListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result sql.InstancePoolListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, instancePoolName string, parameters sql.InstancePoolUpdate) (result sql.InstancePoolsUpdateFuture, err error)
}

var _ InstancePoolsClientAPI = (*sql.InstancePoolsClient)(nil)

// UsagesClientAPI contains the set of methods on the UsagesClient type.
type UsagesClientAPI interface {
	ListByInstancePool(ctx context.Context, resourceGroupName string, instancePoolName string, expandChildren *bool) (result sql.UsageListResultPage, err error)
	ListByInstancePoolComplete(ctx context.Context, resourceGroupName string, instancePoolName string, expandChildren *bool) (result sql.UsageListResultIterator, err error)
}

var _ UsagesClientAPI = (*sql.UsagesClient)(nil)

// ManagedInstancesClientAPI contains the set of methods on the ManagedInstancesClient type.
type ManagedInstancesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstance) (result sql.ManagedInstancesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstancesDeleteFuture, err error)
	Failover(ctx context.Context, resourceGroupName string, managedInstanceName string, replicaType sql.ReplicaType) (result sql.ManagedInstancesFailoverFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstance, err error)
	List(ctx context.Context) (result sql.ManagedInstanceListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.ManagedInstanceListResultIterator, err error)
	ListByInstancePool(ctx context.Context, resourceGroupName string, instancePoolName string) (result sql.ManagedInstanceListResultPage, err error)
	ListByInstancePoolComplete(ctx context.Context, resourceGroupName string, instancePoolName string) (result sql.ManagedInstanceListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result sql.ManagedInstanceListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result sql.ManagedInstanceListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, parameters sql.ManagedInstanceUpdate) (result sql.ManagedInstancesUpdateFuture, err error)
}

var _ ManagedInstancesClientAPI = (*sql.ManagedInstancesClient)(nil)

// PrivateEndpointConnectionsClientAPI contains the set of methods on the PrivateEndpointConnectionsClient type.
type PrivateEndpointConnectionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, privateEndpointConnectionName string, parameters sql.PrivateEndpointConnection) (result sql.PrivateEndpointConnectionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, privateEndpointConnectionName string) (result sql.PrivateEndpointConnectionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, privateEndpointConnectionName string) (result sql.PrivateEndpointConnection, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.PrivateEndpointConnectionListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.PrivateEndpointConnectionListResultIterator, err error)
}

var _ PrivateEndpointConnectionsClientAPI = (*sql.PrivateEndpointConnectionsClient)(nil)

// PrivateLinkResourcesClientAPI contains the set of methods on the PrivateLinkResourcesClient type.
type PrivateLinkResourcesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, groupName string) (result sql.PrivateLinkResource, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.PrivateLinkResourceListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.PrivateLinkResourceListResultIterator, err error)
}

var _ PrivateLinkResourcesClientAPI = (*sql.PrivateLinkResourcesClient)(nil)

// ServersClientAPI contains the set of methods on the ServersClient type.
type ServersClientAPI interface {
	CheckNameAvailability(ctx context.Context, parameters sql.CheckNameAvailabilityRequest) (result sql.CheckNameAvailabilityResponse, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.Server) (result sql.ServersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.Server, err error)
	List(ctx context.Context) (result sql.ServerListResultPage, err error)
	ListComplete(ctx context.Context) (result sql.ServerListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result sql.ServerListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result sql.ServerListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerUpdate) (result sql.ServersUpdateFuture, err error)
}

var _ ServersClientAPI = (*sql.ServersClient)(nil)

// CapabilitiesClientAPI contains the set of methods on the CapabilitiesClient type.
type CapabilitiesClientAPI interface {
	ListByLocation(ctx context.Context, locationName string, include sql.CapabilityGroup) (result sql.LocationCapabilities, err error)
}

var _ CapabilitiesClientAPI = (*sql.CapabilitiesClient)(nil)

// LongTermRetentionManagedInstanceBackupsClientAPI contains the set of methods on the LongTermRetentionManagedInstanceBackupsClient type.
type LongTermRetentionManagedInstanceBackupsClientAPI interface {
	Delete(ctx context.Context, locationName string, managedInstanceName string, databaseName string, backupName string) (result sql.LongTermRetentionManagedInstanceBackupsDeleteFuture, err error)
	DeleteByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, backupName string) (result sql.LongTermRetentionManagedInstanceBackupsDeleteByResourceGroupFuture, err error)
	Get(ctx context.Context, locationName string, managedInstanceName string, databaseName string, backupName string) (result sql.ManagedInstanceLongTermRetentionBackup, err error)
	GetByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, backupName string) (result sql.ManagedInstanceLongTermRetentionBackup, err error)
	ListByDatabase(ctx context.Context, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState1) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState1) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
	ListByInstance(ctx context.Context, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState2) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState2) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
	ListByLocation(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState3) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByLocationComplete(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState3) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupDatabase(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState4) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupDatabaseComplete(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, databaseName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState4) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupInstance(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState5) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupInstanceComplete(ctx context.Context, resourceGroupName string, locationName string, managedInstanceName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState5) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
	ListByResourceGroupLocation(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState6) (result sql.ManagedInstanceLongTermRetentionBackupListResultPage, err error)
	ListByResourceGroupLocationComplete(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState sql.DatabaseState6) (result sql.ManagedInstanceLongTermRetentionBackupListResultIterator, err error)
}

var _ LongTermRetentionManagedInstanceBackupsClientAPI = (*sql.LongTermRetentionManagedInstanceBackupsClient)(nil)

// ManagedInstanceLongTermRetentionPoliciesClientAPI contains the set of methods on the ManagedInstanceLongTermRetentionPoliciesClient type.
type ManagedInstanceLongTermRetentionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedInstanceLongTermRetentionPolicy) (result sql.ManagedInstanceLongTermRetentionPoliciesCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedInstanceLongTermRetentionPolicy, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedInstanceLongTermRetentionPolicyListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedInstanceLongTermRetentionPolicyListResultIterator, err error)
}

var _ ManagedInstanceLongTermRetentionPoliciesClientAPI = (*sql.ManagedInstanceLongTermRetentionPoliciesClient)(nil)

// WorkloadGroupsClientAPI contains the set of methods on the WorkloadGroupsClient type.
type WorkloadGroupsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, parameters sql.WorkloadGroup) (result sql.WorkloadGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string) (result sql.WorkloadGroupsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string) (result sql.WorkloadGroup, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.WorkloadGroupListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.WorkloadGroupListResultIterator, err error)
}

var _ WorkloadGroupsClientAPI = (*sql.WorkloadGroupsClient)(nil)

// WorkloadClassifiersClientAPI contains the set of methods on the WorkloadClassifiersClient type.
type WorkloadClassifiersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, workloadClassifierName string, parameters sql.WorkloadClassifier) (result sql.WorkloadClassifiersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, workloadClassifierName string) (result sql.WorkloadClassifiersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string, workloadClassifierName string) (result sql.WorkloadClassifier, err error)
	ListByWorkloadGroup(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string) (result sql.WorkloadClassifierListResultPage, err error)
	ListByWorkloadGroupComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, workloadGroupName string) (result sql.WorkloadClassifierListResultIterator, err error)
}

var _ WorkloadClassifiersClientAPI = (*sql.WorkloadClassifiersClient)(nil)

// ManagedInstanceOperationsClientAPI contains the set of methods on the ManagedInstanceOperationsClient type.
type ManagedInstanceOperationsClientAPI interface {
	Cancel(ctx context.Context, resourceGroupName string, managedInstanceName string, operationID uuid.UUID) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, operationID uuid.UUID) (result sql.ManagedInstanceOperation, err error)
	ListByManagedInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceOperationListResultPage, err error)
	ListByManagedInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedInstanceOperationListResultIterator, err error)
}

var _ ManagedInstanceOperationsClientAPI = (*sql.ManagedInstanceOperationsClient)(nil)

// ServerAzureADAdministratorsClientAPI contains the set of methods on the ServerAzureADAdministratorsClient type.
type ServerAzureADAdministratorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerAzureADAdministrator) (result sql.ServerAzureADAdministratorsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAzureADAdministratorsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAzureADAdministrator, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.AdministratorListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.AdministratorListResultIterator, err error)
}

var _ ServerAzureADAdministratorsClientAPI = (*sql.ServerAzureADAdministratorsClient)(nil)

// SyncGroupsClientAPI contains the set of methods on the SyncGroupsClient type.
type SyncGroupsClientAPI interface {
	CancelSync(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result autorest.Response, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, parameters sql.SyncGroup) (result sql.SyncGroupsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncGroupsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncGroup, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.SyncGroupListResultPage, err error)
	ListByDatabaseComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.SyncGroupListResultIterator, err error)
	ListHubSchemas(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncFullSchemaPropertiesListResultPage, err error)
	ListHubSchemasComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncFullSchemaPropertiesListResultIterator, err error)
	ListLogs(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, startTime string, endTime string, typeParameter string, continuationToken string) (result sql.SyncGroupLogListResultPage, err error)
	ListLogsComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, startTime string, endTime string, typeParameter string, continuationToken string) (result sql.SyncGroupLogListResultIterator, err error)
	ListSyncDatabaseIds(ctx context.Context, locationName string) (result sql.SyncDatabaseIDListResultPage, err error)
	ListSyncDatabaseIdsComplete(ctx context.Context, locationName string) (result sql.SyncDatabaseIDListResultIterator, err error)
	RefreshHubSchema(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncGroupsRefreshHubSchemaFuture, err error)
	TriggerSync(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, parameters sql.SyncGroup) (result sql.SyncGroupsUpdateFuture, err error)
}

var _ SyncGroupsClientAPI = (*sql.SyncGroupsClient)(nil)

// SyncMembersClientAPI contains the set of methods on the SyncMembersClient type.
type SyncMembersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, parameters sql.SyncMember) (result sql.SyncMembersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncMembersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncMember, err error)
	ListBySyncGroup(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncMemberListResultPage, err error)
	ListBySyncGroupComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string) (result sql.SyncMemberListResultIterator, err error)
	ListMemberSchemas(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncFullSchemaPropertiesListResultPage, err error)
	ListMemberSchemasComplete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncFullSchemaPropertiesListResultIterator, err error)
	RefreshMemberSchema(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string) (result sql.SyncMembersRefreshMemberSchemaFuture, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, syncGroupName string, syncMemberName string, parameters sql.SyncMember) (result sql.SyncMembersUpdateFuture, err error)
}

var _ SyncMembersClientAPI = (*sql.SyncMembersClient)(nil)

// ManagedDatabaseRestoreDetailsClientAPI contains the set of methods on the ManagedDatabaseRestoreDetailsClient type.
type ManagedDatabaseRestoreDetailsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabaseRestoreDetailsResult, err error)
}

var _ ManagedDatabaseRestoreDetailsClientAPI = (*sql.ManagedDatabaseRestoreDetailsClient)(nil)

// ManagedDatabasesClientAPI contains the set of methods on the ManagedDatabasesClient type.
type ManagedDatabasesClientAPI interface {
	CompleteRestore(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.CompleteDatabaseRestoreDefinition) (result sql.ManagedDatabasesCompleteRestoreFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabase) (result sql.ManagedDatabasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabasesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string) (result sql.ManagedDatabase, err error)
	ListByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedDatabaseListResultPage, err error)
	ListByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedDatabaseListResultIterator, err error)
	ListInaccessibleByInstance(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedDatabaseListResultPage, err error)
	ListInaccessibleByInstanceComplete(ctx context.Context, resourceGroupName string, managedInstanceName string) (result sql.ManagedDatabaseListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters sql.ManagedDatabaseUpdate) (result sql.ManagedDatabasesUpdateFuture, err error)
}

var _ ManagedDatabasesClientAPI = (*sql.ManagedDatabasesClient)(nil)

// ServerAzureADOnlyAuthenticationsClientAPI contains the set of methods on the ServerAzureADOnlyAuthenticationsClient type.
type ServerAzureADOnlyAuthenticationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ServerAzureADOnlyAuthentication) (result sql.ServerAzureADOnlyAuthenticationsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAzureADOnlyAuthenticationsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result sql.ServerAzureADOnlyAuthentication, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.AzureADOnlyAuthListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result sql.AzureADOnlyAuthListResultIterator, err error)
}

var _ ServerAzureADOnlyAuthenticationsClientAPI = (*sql.ServerAzureADOnlyAuthenticationsClient)(nil)
