package trafficmanager

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/trafficmanager/mgmt/2018-02-01/trafficmanager"

// CheckTrafficManagerRelativeDNSNameAvailabilityParameters parameters supplied to check Traffic Manager name
// operation.
type CheckTrafficManagerRelativeDNSNameAvailabilityParameters struct {
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// CloudError an error returned by the Azure Resource Manager
type CloudError struct {
	// Error - The content of the error.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody the content of an error returned by the Azure Resource Manager
type CloudErrorBody struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message
	Message *string `json:"message,omitempty"`
	// Target - Error target
	Target *string `json:"target,omitempty"`
	// Details - Error details
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// DeleteOperationResult the result of the request or operation.
type DeleteOperationResult struct {
	autorest.Response `json:"-"`
	// OperationResult - READ-ONLY; The result of the operation or request.
	OperationResult *bool `json:"boolean,omitempty"`
}

// DNSConfig class containing DNS settings in a Traffic Manager profile.
type DNSConfig struct {
	// RelativeName - The relative DNS name provided by this Traffic Manager profile. This value is combined with the DNS domain name used by Azure Traffic Manager to form the fully-qualified domain name (FQDN) of the profile.
	RelativeName *string `json:"relativeName,omitempty"`
	// Fqdn - READ-ONLY; The fully-qualified domain name (FQDN) of the Traffic Manager profile. This is formed from the concatenation of the RelativeName with the DNS domain used by Azure Traffic Manager.
	Fqdn *string `json:"fqdn,omitempty"`
	// TTL - The DNS Time-To-Live (TTL), in seconds. This informs the local DNS resolvers and DNS clients how long to cache DNS responses provided by this Traffic Manager profile.
	TTL *int64 `json:"ttl,omitempty"`
}

// MarshalJSON is the custom marshaler for DNSConfig.
func (dc DNSConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.RelativeName != nil {
		objectMap["relativeName"] = dc.RelativeName
	}
	if dc.TTL != nil {
		objectMap["ttl"] = dc.TTL
	}
	return json.Marshal(objectMap)
}

// Endpoint class representing a Traffic Manager endpoint.
type Endpoint struct {
	autorest.Response `json:"-"`
	// EndpointProperties - The properties of the Traffic Manager endpoint.
	*EndpointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Endpoint.
func (e Endpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.EndpointProperties != nil {
		objectMap["properties"] = e.EndpointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Endpoint struct.
func (e *Endpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var endpointProperties EndpointProperties
				err = json.Unmarshal(*v, &endpointProperties)
				if err != nil {
					return err
				}
				e.EndpointProperties = &endpointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		}
	}

	return nil
}

// EndpointProperties class representing a Traffic Manager endpoint properties.
type EndpointProperties struct {
	// TargetResourceID - The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
	TargetResourceID *string `json:"targetResourceId,omitempty"`
	// Target - The fully-qualified DNS name of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
	Target *string `json:"target,omitempty"`
	// EndpointStatus - The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method. Possible values include: 'EndpointStatusEnabled', 'EndpointStatusDisabled'
	EndpointStatus EndpointStatus `json:"endpointStatus,omitempty"`
	// Weight - The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
	Weight *int64 `json:"weight,omitempty"`
	// Priority - The priority of this endpoint when using the ‘Priority’ traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
	Priority *int64 `json:"priority,omitempty"`
	// EndpointLocation - Specifies the location of the external or nested endpoints when using the ‘Performance’ traffic routing method.
	EndpointLocation *string `json:"endpointLocation,omitempty"`
	// EndpointMonitorStatus - The monitoring status of the endpoint. Possible values include: 'CheckingEndpoint', 'Online', 'Degraded', 'Disabled', 'Inactive', 'Stopped'
	EndpointMonitorStatus EndpointMonitorStatus `json:"endpointMonitorStatus,omitempty"`
	// MinChildEndpoints - The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
	MinChildEndpoints *int64 `json:"minChildEndpoints,omitempty"`
	// GeoMapping - The list of countries/regions mapped to this endpoint when using the ‘Geographic’ traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
	GeoMapping *[]string `json:"geoMapping,omitempty"`
}

// GeographicHierarchy class representing the Geographic hierarchy used with the Geographic traffic routing
// method.
type GeographicHierarchy struct {
	autorest.Response `json:"-"`
	// GeographicHierarchyProperties - The properties of the Geographic Hierarchy resource.
	*GeographicHierarchyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GeographicHierarchy.
func (gh GeographicHierarchy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gh.GeographicHierarchyProperties != nil {
		objectMap["properties"] = gh.GeographicHierarchyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeographicHierarchy struct.
func (gh *GeographicHierarchy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geographicHierarchyProperties GeographicHierarchyProperties
				err = json.Unmarshal(*v, &geographicHierarchyProperties)
				if err != nil {
					return err
				}
				gh.GeographicHierarchyProperties = &geographicHierarchyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gh.Type = &typeVar
			}
		}
	}

	return nil
}

// GeographicHierarchyProperties class representing the properties of the Geographic hierarchy used with the
// Geographic traffic routing method.
type GeographicHierarchyProperties struct {
	// GeographicHierarchy - The region at the root of the hierarchy from all the regions in the hierarchy can be retrieved.
	GeographicHierarchy *Region `json:"geographicHierarchy,omitempty"`
}

// HeatMapEndpoint class which is a sparse representation of a Traffic Manager endpoint.
type HeatMapEndpoint struct {
	// ResourceID - The ARM Resource ID of this Traffic Manager endpoint.
	ResourceID *string `json:"resourceId,omitempty"`
	// EndpointID - A number uniquely identifying this endpoint in query experiences.
	EndpointID *int32 `json:"endpointId,omitempty"`
}

// HeatMapModel class representing a Traffic Manager HeatMap.
type HeatMapModel struct {
	autorest.Response `json:"-"`
	// HeatMapProperties - The properties of the Traffic Manager HeatMap.
	*HeatMapProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HeatMapModel.
func (hmm HeatMapModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hmm.HeatMapProperties != nil {
		objectMap["properties"] = hmm.HeatMapProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HeatMapModel struct.
func (hmm *HeatMapModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var heatMapProperties HeatMapProperties
				err = json.Unmarshal(*v, &heatMapProperties)
				if err != nil {
					return err
				}
				hmm.HeatMapProperties = &heatMapProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hmm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hmm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hmm.Type = &typeVar
			}
		}
	}

	return nil
}

// HeatMapProperties class representing a Traffic Manager HeatMap properties.
type HeatMapProperties struct {
	// StartTime - The beginning of the time window for this HeatMap, inclusive.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The ending of the time window for this HeatMap, exclusive.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Endpoints - The endpoints used in this HeatMap calculation.
	Endpoints *[]HeatMapEndpoint `json:"endpoints,omitempty"`
	// TrafficFlows - The traffic flows produced in this HeatMap calculation.
	TrafficFlows *[]TrafficFlow `json:"trafficFlows,omitempty"`
}

// MonitorConfig class containing endpoint monitoring settings in a Traffic Manager profile.
type MonitorConfig struct {
	// ProfileMonitorStatus - The profile-level monitoring status of the Traffic Manager profile. Possible values include: 'ProfileMonitorStatusCheckingEndpoints', 'ProfileMonitorStatusOnline', 'ProfileMonitorStatusDegraded', 'ProfileMonitorStatusDisabled', 'ProfileMonitorStatusInactive'
	ProfileMonitorStatus ProfileMonitorStatus `json:"profileMonitorStatus,omitempty"`
	// Protocol - The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health. Possible values include: 'HTTP', 'HTTPS', 'TCP'
	Protocol MonitorProtocol `json:"protocol,omitempty"`
	// Port - The TCP port used to probe for endpoint health.
	Port *int64 `json:"port,omitempty"`
	// Path - The path relative to the endpoint domain name used to probe for endpoint health.
	Path *string `json:"path,omitempty"`
	// IntervalInSeconds - The monitor interval for endpoints in this profile. This is the interval at which Traffic Manager will check the health of each endpoint in this profile.
	IntervalInSeconds *int64 `json:"intervalInSeconds,omitempty"`
	// TimeoutInSeconds - The monitor timeout for endpoints in this profile. This is the time that Traffic Manager allows endpoints in this profile to response to the health check.
	TimeoutInSeconds *int64 `json:"timeoutInSeconds,omitempty"`
	// ToleratedNumberOfFailures - The number of consecutive failed health check that Traffic Manager tolerates before declaring an endpoint in this profile Degraded after the next failed health check.
	ToleratedNumberOfFailures *int64 `json:"toleratedNumberOfFailures,omitempty"`
}

// NameAvailability class representing a Traffic Manager Name Availability response.
type NameAvailability struct {
	autorest.Response `json:"-"`
	// Name - The relative name.
	Name *string `json:"name,omitempty"`
	// Type - Traffic Manager profile resource type.
	Type *string `json:"type,omitempty"`
	// NameAvailable - Describes whether the relative name is available or not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason why the name is not available, when applicable.
	Reason *string `json:"reason,omitempty"`
	// Message - Descriptive message that explains why the name is not available, when applicable.
	Message *string `json:"message,omitempty"`
}

// Profile class representing a Traffic Manager profile.
type Profile struct {
	autorest.Response `json:"-"`
	// ProfileProperties - The properties of the Traffic Manager profile.
	*ProfileProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProfileProperties != nil {
		objectMap["properties"] = p.ProfileProperties
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Profile struct.
func (p *Profile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var profileProperties ProfileProperties
				err = json.Unmarshal(*v, &profileProperties)
				if err != nil {
					return err
				}
				p.ProfileProperties = &profileProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProfileListResult the list Traffic Manager profiles operation response.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets the list of Traffic manager profiles.
	Value *[]Profile `json:"value,omitempty"`
}

// ProfileProperties class representing the Traffic Manager profile properties.
type ProfileProperties struct {
	// ProfileStatus - The status of the Traffic Manager profile. Possible values include: 'ProfileStatusEnabled', 'ProfileStatusDisabled'
	ProfileStatus ProfileStatus `json:"profileStatus,omitempty"`
	// TrafficRoutingMethod - The traffic routing method of the Traffic Manager profile. Possible values include: 'Performance', 'Priority', 'Weighted', 'Geographic'
	TrafficRoutingMethod TrafficRoutingMethod `json:"trafficRoutingMethod,omitempty"`
	// DNSConfig - The DNS settings of the Traffic Manager profile.
	DNSConfig *DNSConfig `json:"dnsConfig,omitempty"`
	// MonitorConfig - The endpoint monitoring settings of the Traffic Manager profile.
	MonitorConfig *MonitorConfig `json:"monitorConfig,omitempty"`
	// Endpoints - The list of endpoints in the Traffic Manager profile.
	Endpoints *[]Endpoint `json:"endpoints,omitempty"`
	// TrafficViewEnrollmentStatus - Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature will increase the cost of the Traffic Manage profile. Possible values include: 'TrafficViewEnrollmentStatusEnabled', 'TrafficViewEnrollmentStatusDisabled'
	TrafficViewEnrollmentStatus TrafficViewEnrollmentStatus `json:"trafficViewEnrollmentStatus,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// QueryExperience class representing a Traffic Manager HeatMap query experience properties.
type QueryExperience struct {
	// EndpointID - The id of the endpoint from the 'endpoints' array which these queries were routed to.
	EndpointID *int32 `json:"endpointId,omitempty"`
	// QueryCount - The number of queries originating from this location.
	QueryCount *int32 `json:"queryCount,omitempty"`
	// Latency - The latency experienced by queries originating from this location.
	Latency *float64 `json:"latency,omitempty"`
}

// Region class representing a region in the Geographic hierarchy used with the Geographic traffic routing
// method.
type Region struct {
	// Code - The code of the region
	Code *string `json:"code,omitempty"`
	// Name - The name of the region
	Name *string `json:"name,omitempty"`
	// Regions - The list of Regions grouped under this Region in the Geographic Hierarchy.
	Regions *[]Region `json:"regions,omitempty"`
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TrafficFlow class representing a Traffic Manager HeatMap traffic flow properties.
type TrafficFlow struct {
	// SourceIP - The IP address that this query experience originated from.
	SourceIP *string `json:"sourceIp,omitempty"`
	// Latitude - The approximate latitude that these queries originated from.
	Latitude *float64 `json:"latitude,omitempty"`
	// Longitude - The approximate longitude that these queries originated from.
	Longitude *float64 `json:"longitude,omitempty"`
	// QueryExperiences - The query experiences produced in this HeatMap calculation.
	QueryExperiences *[]QueryExperience `json:"queryExperiences,omitempty"`
}

// UserMetricsKeyModel class representing a Traffic Manager Real User Metrics key response.
type UserMetricsKeyModel struct {
	autorest.Response `json:"-"`
	// Key - The key returned by the Real User Metrics operation.
	Key *string `json:"key,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for UserMetricsKeyModel.
func (umkm UserMetricsKeyModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if umkm.Key != nil {
		objectMap["key"] = umkm.Key
	}
	return json.Marshal(objectMap)
}
