/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Bristorbrot V2 formula
 * @reference http://www.fractalforums.com/theory/bristorbrot-3d/
 * by Doug Bristor

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_bristorbrot2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 Bristorbrot2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	aux->DE = aux->DE * 2.0f * aux->r;

	REAL4 zOrig = z;
	REAL4 zz = z * z;
	REAL4 zNew = z;

	// pre abs
	REAL4 zFabs = fabs(z);
	if (fractal->buffalo.preabsx) zOrig.x = zFabs.x;
	if (fractal->buffalo.preabsy) zOrig.y = zFabs.y;
	if (fractal->buffalo.preabsz) zOrig.z = zFabs.z;

	// Bristorbrot V2 formula
	REAL signT = 1.0f; // signT as "sign" is an operation   sign()

	// conditional operation which can create cuts
	if (fractal->transformCommon.functionEnabledFalse && zz.z >= zz.y)
		signT = -1.0f; // creates fractal surface modification 2019

	// is preabs is used on z.x, it will be !< 0.0f
	if (!fractal->buffalo.preabsy && fractal->transformCommon.functionEnabledxFalse && zOrig.x < 0.0f)
		signT = -signT;

	// flips signT but same as using -1.0f scales
	if (fractal->transformCommon.functionEnabledAwFalse) signT = -signT;

	REAL tmpy = z.y;
	if (fractal->transformCommon.functionEnabledyFalse) tmpy = zFabs.y;
	REAL tmpz = z.z;
	if (fractal->transformCommon.functionEnabledzFalse) tmpz = zFabs.z;

	zNew.x = zz.x - zz.y - zz.z;
	zNew.y = zOrig.y * (zOrig.x * 2.0f - tmpz * signT * fractal->transformCommon.scaleB1);
	zNew.z = zOrig.z * (zOrig.x * 2.0f + tmpy * signT * fractal->transformCommon.scaleC1);
	z = zNew;

	// post abs
	z.x = fractal->buffalo.absx ? fabs(z.x) : z.x;
	z.y = fractal->buffalo.absy ? fabs(z.y) : z.y;
	z.z = fractal->buffalo.absz ? fabs(z.z) : z.z;

	// offset
	z += fractal->transformCommon.additionConstantA000;

	// analyticDE controls
	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset1;
	return z;
}