/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Box Tiling 4d

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_step_xy.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfStepXYIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 zc = (z);
	REAL4 colVec = (REAL4){0.0f, 0.0f, 0.0f, 0.0f};
	zc *= fractal->transformCommon.scale3D111;

	REAL Step = zc.y - 2.0f * floor(zc.y / 2.0f);

	if (Step > 1.0f)
	{
		zc.x += fractal->transformCommon.offset05;
		colVec.x += 1.0f;
	}
	else
		colVec.y += 1.0f;

	Step = zc.x - 2.0f * floor(zc.x / 2.0f);

	if (Step > 1.0f) colVec.z += 1.0f;

	if (fractal->transformCommon.functionEnabledAxFalse)
	{
		zc.x = zc.x - floor(zc.x);
		zc.y = zc.y - floor(zc.y);
	}
	// offset and scale
	zc.x -= fractal->transformCommon.offsetA05;
	zc.y -= fractal->transformCommon.offsetB05;
	zc *= fractal->transformCommon.scale2;
	aux->DE *= fractal->transformCommon.scale2;

	if (fractal->transformCommon.functionEnabledAy)
	{
		REAL4 boxSize = fractal->transformCommon.offset111;
		zc = fabs(zc) - boxSize;
		zc.x = max(zc.x, 0.0f);
		zc.y = max(zc.y, 0.0f);
		zc.z = max(zc.z, 0.0f);
		REAL zcd;
		if (!fractal->transformCommon.functionEnabledAzFalse)
			zcd = length(zc);
		else
			zcd = max(max(zc.x, zc.y), zc.z);
		zcd -= fractal->transformCommon.offset0;

		aux->dist = min(aux->dist, zcd / (aux->DE + 1.0f));
	}

	if (fractal->analyticDE.enabled)
	{
		if (!fractal->analyticDE.enabledFalse)
			aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
		else
		{
			aux->DE =
				aux->DE * length(zc) / length(z) * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
		}
	}
	if (!fractal->transformCommon.functionEnabledAwFalse) z = zc;

	// aux->color
	if (fractal->foldColor.auxColorEnabled)
	{
		aux->color += fractal->foldColor.difs0000.x * colVec.x;
		aux->color += fractal->foldColor.difs0000.y * colVec.y;
		aux->color += fractal->foldColor.difs0000.z * colVec.z;
	}
	return z;
}