//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uieventtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIEventType(pub NSInteger);
impl UIEventType {
    #[doc(alias = "UIEventTypeTouches")]
    pub const Touches: Self = Self(0);
    #[doc(alias = "UIEventTypeMotion")]
    pub const Motion: Self = Self(1);
    #[doc(alias = "UIEventTypeRemoteControl")]
    pub const RemoteControl: Self = Self(2);
    #[doc(alias = "UIEventTypePresses")]
    pub const Presses: Self = Self(3);
    #[doc(alias = "UIEventTypeScroll")]
    pub const Scroll: Self = Self(10);
    #[doc(alias = "UIEventTypeHover")]
    pub const Hover: Self = Self(11);
    #[doc(alias = "UIEventTypeTransform")]
    pub const Transform: Self = Self(14);
}

unsafe impl Encode for UIEventType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIEventType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uieventsubtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIEventSubtype(pub NSInteger);
impl UIEventSubtype {
    #[doc(alias = "UIEventSubtypeNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "UIEventSubtypeMotionShake")]
    pub const MotionShake: Self = Self(1);
    #[doc(alias = "UIEventSubtypeRemoteControlPlay")]
    pub const RemoteControlPlay: Self = Self(100);
    #[doc(alias = "UIEventSubtypeRemoteControlPause")]
    pub const RemoteControlPause: Self = Self(101);
    #[doc(alias = "UIEventSubtypeRemoteControlStop")]
    pub const RemoteControlStop: Self = Self(102);
    #[doc(alias = "UIEventSubtypeRemoteControlTogglePlayPause")]
    pub const RemoteControlTogglePlayPause: Self = Self(103);
    #[doc(alias = "UIEventSubtypeRemoteControlNextTrack")]
    pub const RemoteControlNextTrack: Self = Self(104);
    #[doc(alias = "UIEventSubtypeRemoteControlPreviousTrack")]
    pub const RemoteControlPreviousTrack: Self = Self(105);
    #[doc(alias = "UIEventSubtypeRemoteControlBeginSeekingBackward")]
    pub const RemoteControlBeginSeekingBackward: Self = Self(106);
    #[doc(alias = "UIEventSubtypeRemoteControlEndSeekingBackward")]
    pub const RemoteControlEndSeekingBackward: Self = Self(107);
    #[doc(alias = "UIEventSubtypeRemoteControlBeginSeekingForward")]
    pub const RemoteControlBeginSeekingForward: Self = Self(108);
    #[doc(alias = "UIEventSubtypeRemoteControlEndSeekingForward")]
    pub const RemoteControlEndSeekingForward: Self = Self(109);
}

unsafe impl Encode for UIEventSubtype {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIEventSubtype {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Set of buttons pressed for the current event
/// Raw format of: 1
/// <
/// <
/// (buttonNumber - 1)
/// UIEventButtonMaskPrimary = 1
/// <
/// <
/// 0
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uieventbuttonmask?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIEventButtonMask(pub NSInteger);
bitflags::bitflags! {
    impl UIEventButtonMask: NSInteger {
        #[doc(alias = "UIEventButtonMaskPrimary")]
        const Primary = 1<<0;
        #[doc(alias = "UIEventButtonMaskSecondary")]
        const Secondary = 1<<1;
    }
}

unsafe impl Encode for UIEventButtonMask {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIEventButtonMask {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl UIEventButtonMask {
    /// Convenience initializer for a button mask where `buttonNumber` is a one-based index of the button on the input device
    /// .button(1) == .primary
    /// .button(2) == .secondary
    #[doc(alias = "UIEventButtonMaskForButtonNumber")]
    #[inline]
    pub unsafe fn for_button_number(button_number: NSInteger) -> UIEventButtonMask {
        extern "C-unwind" {
            fn UIEventButtonMaskForButtonNumber(button_number: NSInteger) -> UIEventButtonMask;
        }
        unsafe { UIEventButtonMaskForButtonNumber(button_number) }
    }
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uievent?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIEvent;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIEvent {}
);

impl UIEvent {
    extern_methods!(
        #[unsafe(method(type))]
        #[unsafe(method_family = none)]
        pub unsafe fn r#type(&self) -> UIEventType;

        #[unsafe(method(subtype))]
        #[unsafe(method_family = none)]
        pub unsafe fn subtype(&self) -> UIEventSubtype;

        #[unsafe(method(timestamp))]
        #[unsafe(method_family = none)]
        pub unsafe fn timestamp(&self) -> NSTimeInterval;

        #[cfg(feature = "UICommand")]
        #[unsafe(method(modifierFlags))]
        #[unsafe(method_family = none)]
        pub unsafe fn modifierFlags(&self) -> UIKeyModifierFlags;

        #[unsafe(method(buttonMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonMask(&self) -> UIEventButtonMask;

        #[cfg(feature = "UITouch")]
        #[unsafe(method(allTouches))]
        #[unsafe(method_family = none)]
        pub unsafe fn allTouches(&self) -> Option<Retained<NSSet<UITouch>>>;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITouch",
            feature = "UIView",
            feature = "UIWindow"
        ))]
        #[unsafe(method(touchesForWindow:))]
        #[unsafe(method_family = none)]
        pub unsafe fn touchesForWindow(
            &self,
            window: &UIWindow,
        ) -> Option<Retained<NSSet<UITouch>>>;

        #[cfg(all(feature = "UIResponder", feature = "UITouch", feature = "UIView"))]
        #[unsafe(method(touchesForView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn touchesForView(&self, view: &UIView) -> Option<Retained<NSSet<UITouch>>>;

        #[cfg(all(feature = "UIGestureRecognizer", feature = "UITouch"))]
        #[unsafe(method(touchesForGestureRecognizer:))]
        #[unsafe(method_family = none)]
        pub unsafe fn touchesForGestureRecognizer(
            &self,
            gesture: &UIGestureRecognizer,
        ) -> Option<Retained<NSSet<UITouch>>>;

        #[cfg(feature = "UITouch")]
        #[unsafe(method(coalescedTouchesForTouch:))]
        #[unsafe(method_family = none)]
        pub unsafe fn coalescedTouchesForTouch(
            &self,
            touch: &UITouch,
        ) -> Option<Retained<NSArray<UITouch>>>;

        #[cfg(feature = "UITouch")]
        #[unsafe(method(predictedTouchesForTouch:))]
        #[unsafe(method_family = none)]
        pub unsafe fn predictedTouchesForTouch(
            &self,
            touch: &UITouch,
        ) -> Option<Retained<NSArray<UITouch>>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UIEvent {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `UIEventButtonMask::for_button_number`"]
    pub fn UIEventButtonMaskForButtonNumber(button_number: NSInteger) -> UIEventButtonMask;
}
