TRAMPOLINE(3)              Library Functions Manual              TRAMPOLINE(3)



[1mNAME[0m
       trampoline - closures as first-class C functions

[1mSYNOPSIS[0m
       [1m#include <trampoline.h>[0m

       [1mfunction = alloc_trampoline(address, variable, data);[0m

       [1mfree_trampoline(function);[0m

       [1mis_trampoline(function)[0m
       [1mtrampoline_address(function)[0m
       [1mtrampoline_variable(function)[0m
       [1mtrampoline_data(function)[0m

[1mDESCRIPTION[0m
       These  functions implement [4mclosures[24m as first-class C functions.  A clo‐
       sure consists of a regular C function and a piece of  data  which  gets
       passed to the C function when the closure is called.

       Closures as [4mfirst-class[24m [4mC[24m [4mfunctions[24m means that they fit into a function
       pointer and can be called exactly like any other C function.   [4mfunction[0m
       [1m=  alloc_trampoline([4m[22maddress[24m[1m,  [4m[22mvariable[24m[1m, [4m[22mdata[24m[1m) [22mallocates a closure. When
       [4mfunction[24m gets called, it stores [4mdata[24m in the variable [4mvariable[24m and calls
       the  C function at [4maddress[24m.  The function at [4maddress[24m is responsible for
       fetching [4mdata[24m out of [4mvariable[24m  immediately,  before  execution  of  any
       other function call.

       This  is  much  like [1mgcc[22m's local functions, except that the GNU C local
       functions have dynamic extent (i.e. are deallocated when  the  creating
       function  returns), while [4mtrampoline[24m provides functions with indefinite
       extent: [4mfunction[24m is only deallocated when [1mfree_trampoline([4m[22mfunction[24m[1m)  [22mis
       called.

       [1mis_trampoline([4m[22mfunction[24m[1m) [22mchecks whether the C function [4mfunction[24m was pro‐
       duced by a call to [4malloc_trampoline[24m.  If this returns true,  the  argu‐
       ments given to [4malloc_trampoline[24m can be retrieved:

           [1mtrampoline_address([4m[22mfunction[24m[1m) [22mreturns [4maddress[24m,

           [1mtrampoline_variable([4m[22mfunction[24m[1m) [22mreturns [4mvariable[24m,

           [1mtrampoline_data([4m[22mfunction[24m[1m) [22mreturns [4mdata[24m.


[1mSEE ALSO[0m
       [1mgcc[22m(1), [1mstdarg[22m(3), [1mcallback[22m(3)


[1mBUGS[0m
       Passing the data through a global variable is not reentrant. Don't call
       trampoline functions from within signal handlers. This is fixed in  the
       [1mcallback[22m(3) package.


[1mPORTING[0m
       The way [1mgcc [22mbuilds local functions is described in the gcc source, file
       gcc-2.6.3/config/[4mcpu[24m/[4mcpu[24m.h.


[1mAUTHOR[0m
       Bruno Haible <bruno@clisp.org>


[1mACKNOWLEDGEMENTS[0m
       Many ideas were cribbed from the gcc source.




                                1 January 2017                   TRAMPOLINE(3)
