//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSelectionGranularity(pub NSUInteger);
impl NSSelectionGranularity {
    pub const NSSelectByCharacter: Self = Self(0);
    pub const NSSelectByWord: Self = Self(1);
    pub const NSSelectByParagraph: Self = Self(2);
}

unsafe impl Encode for NSSelectionGranularity {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSSelectionGranularity {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSSelectionAffinity(pub NSUInteger);
impl NSSelectionAffinity {
    #[doc(alias = "NSSelectionAffinityUpstream")]
    pub const Upstream: Self = Self(0);
    #[doc(alias = "NSSelectionAffinityDownstream")]
    pub const Downstream: Self = Self(1);
}

unsafe impl Encode for NSSelectionAffinity {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSSelectionAffinity {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    pub static NSAllRomanInputSourcesLocaleIdentifier: &'static NSString;
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    pub struct NSTextView;

    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl ClassType for NSTextView {
        #[inherits(NSView, NSResponder, NSObject)]
        type Super = NSText;
        type Mutability = MainThreadOnly;
    }
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAccessibility for NSTextView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAccessibilityElementProtocol for NSTextView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAccessibilityNavigableStaticText for NSTextView {}

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAccessibilityStaticText for NSTextView {}

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAnimatablePropertyContainer for NSTextView {}

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSAppearanceCustomization for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSSpellProtocol",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSChangeSpelling for NSTextView {}

#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
unsafe impl NSCoding for NSTextView {}

#[cfg(all(
    feature = "NSColorPanel",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSColorChanging for NSTextView {}

#[cfg(all(
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSDraggingDestination for NSTextView {}

#[cfg(all(
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSDraggingSource for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSSpellProtocol",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSIgnoreMisspelledWords for NSTextView {}

#[cfg(all(
    feature = "NSMenu",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSMenuItemValidation for NSTextView {}

#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
unsafe impl NSObjectProtocol for NSTextView {}

#[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
unsafe impl NSStandardKeyBindingResponding for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSTextContent",
    feature = "NSView"
))]
unsafe impl NSTextContent for NSTextView {}

#[cfg(all(
    feature = "NSInputManager",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSTextInput for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSTextInputClient",
    feature = "NSView"
))]
unsafe impl NSTextInputClient for NSTextView {}

#[cfg(all(
    feature = "NSLayoutManager",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSTextLayoutOrientationProvider for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceItemIdentification for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSUserInterfaceValidation",
    feature = "NSView"
))]
unsafe impl NSUserInterfaceValidations for NSTextView {}

extern_methods!(
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[cfg(feature = "NSTextContainer")]
        #[method_id(@__retain_semantics Init initWithFrame:textContainer:)]
        pub unsafe fn initWithFrame_textContainer(
            this: Allocated<Self>,
            frame_rect: NSRect,
            container: Option<&NSTextContainer>,
        ) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initWithCoder:)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithFrame:)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initUsingTextLayoutManager:)]
        pub unsafe fn initUsingTextLayoutManager(
            this: Allocated<Self>,
            using_text_layout_manager: bool,
        ) -> Retained<Self>;

        #[method_id(@__retain_semantics Other textViewUsingTextLayoutManager:)]
        pub unsafe fn textViewUsingTextLayoutManager(
            using_text_layout_manager: bool,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "NSTextContainer")]
        #[method_id(@__retain_semantics Other textContainer)]
        pub unsafe fn textContainer(&self) -> Option<Retained<NSTextContainer>>;

        #[cfg(feature = "NSTextContainer")]
        #[method(setTextContainer:)]
        pub unsafe fn setTextContainer(&self, text_container: Option<&NSTextContainer>);

        #[cfg(feature = "NSTextContainer")]
        #[method(replaceTextContainer:)]
        pub unsafe fn replaceTextContainer(&self, new_container: &NSTextContainer);

        #[method(textContainerInset)]
        pub unsafe fn textContainerInset(&self) -> NSSize;

        #[method(setTextContainerInset:)]
        pub unsafe fn setTextContainerInset(&self, text_container_inset: NSSize);

        #[method(textContainerOrigin)]
        pub unsafe fn textContainerOrigin(&self) -> NSPoint;

        #[method(invalidateTextContainerOrigin)]
        pub unsafe fn invalidateTextContainerOrigin(&self);

        #[cfg(feature = "NSLayoutManager")]
        #[method_id(@__retain_semantics Other layoutManager)]
        pub unsafe fn layoutManager(&self) -> Option<Retained<NSLayoutManager>>;

        #[cfg(feature = "NSTextStorage")]
        #[method_id(@__retain_semantics Other textStorage)]
        pub unsafe fn textStorage(&self) -> Option<Retained<NSTextStorage>>;

        #[cfg(feature = "NSTextLayoutManager")]
        #[method_id(@__retain_semantics Other textLayoutManager)]
        pub unsafe fn textLayoutManager(&self) -> Option<Retained<NSTextLayoutManager>>;

        #[cfg(feature = "NSTextContentManager")]
        #[method_id(@__retain_semantics Other textContentStorage)]
        pub unsafe fn textContentStorage(&self) -> Option<Retained<NSTextContentStorage>>;

        #[deprecated = "Use -insertText:replacementRange: from NSTextInputClient instead. Since the method is designed to be used solely by the input system, the message should never be sent to a text view from applications. Any content modifications should be via either NSTextStorage or NSText methods."]
        #[method(insertText:)]
        pub unsafe fn insertText(&self, insert_string: &AnyObject);

        #[method(setConstrainedFrameSize:)]
        pub unsafe fn setConstrainedFrameSize(&self, desired_size: NSSize);

        #[method(setAlignment:range:)]
        pub unsafe fn setAlignment_range(&self, alignment: NSTextAlignment, range: NSRange);

        #[method(setBaseWritingDirection:range:)]
        pub unsafe fn setBaseWritingDirection_range(
            &self,
            writing_direction: NSWritingDirection,
            range: NSRange,
        );

        #[method(turnOffKerning:)]
        pub unsafe fn turnOffKerning(&self, sender: Option<&AnyObject>);

        #[method(tightenKerning:)]
        pub unsafe fn tightenKerning(&self, sender: Option<&AnyObject>);

        #[method(loosenKerning:)]
        pub unsafe fn loosenKerning(&self, sender: Option<&AnyObject>);

        #[method(useStandardKerning:)]
        pub unsafe fn useStandardKerning(&self, sender: Option<&AnyObject>);

        #[method(turnOffLigatures:)]
        pub unsafe fn turnOffLigatures(&self, sender: Option<&AnyObject>);

        #[method(useStandardLigatures:)]
        pub unsafe fn useStandardLigatures(&self, sender: Option<&AnyObject>);

        #[method(useAllLigatures:)]
        pub unsafe fn useAllLigatures(&self, sender: Option<&AnyObject>);

        #[method(raiseBaseline:)]
        pub unsafe fn raiseBaseline(&self, sender: Option<&AnyObject>);

        #[method(lowerBaseline:)]
        pub unsafe fn lowerBaseline(&self, sender: Option<&AnyObject>);

        #[deprecated = "Use the traditional shaped characters encoded in the Unicode standard. Access the characters via the character palette."]
        #[method(toggleTraditionalCharacterShape:)]
        pub unsafe fn toggleTraditionalCharacterShape(&self, sender: Option<&AnyObject>);

        #[method(outline:)]
        pub unsafe fn outline(&self, sender: Option<&AnyObject>);

        #[method(performFindPanelAction:)]
        pub unsafe fn performFindPanelAction(&self, sender: Option<&AnyObject>);

        #[method(alignJustified:)]
        pub unsafe fn alignJustified(&self, sender: Option<&AnyObject>);

        #[method(changeColor:)]
        pub unsafe fn changeColor(&self, sender: Option<&AnyObject>);

        #[method(changeAttributes:)]
        pub unsafe fn changeAttributes(&self, sender: Option<&AnyObject>);

        #[method(changeDocumentBackgroundColor:)]
        pub unsafe fn changeDocumentBackgroundColor(&self, sender: Option<&AnyObject>);

        #[method(orderFrontSpacingPanel:)]
        pub unsafe fn orderFrontSpacingPanel(&self, sender: Option<&AnyObject>);

        #[method(orderFrontLinkPanel:)]
        pub unsafe fn orderFrontLinkPanel(&self, sender: Option<&AnyObject>);

        #[method(orderFrontListPanel:)]
        pub unsafe fn orderFrontListPanel(&self, sender: Option<&AnyObject>);

        #[method(orderFrontTablePanel:)]
        pub unsafe fn orderFrontTablePanel(&self, sender: Option<&AnyObject>);

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[method(rulerView:didMoveMarker:)]
        pub unsafe fn rulerView_didMoveMarker(&self, ruler: &NSRulerView, marker: &NSRulerMarker);

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[method(rulerView:didRemoveMarker:)]
        pub unsafe fn rulerView_didRemoveMarker(&self, ruler: &NSRulerView, marker: &NSRulerMarker);

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[method(rulerView:didAddMarker:)]
        pub unsafe fn rulerView_didAddMarker(&self, ruler: &NSRulerView, marker: &NSRulerMarker);

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[method(rulerView:shouldMoveMarker:)]
        pub unsafe fn rulerView_shouldMoveMarker(
            &self,
            ruler: &NSRulerView,
            marker: &NSRulerMarker,
        ) -> bool;

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[method(rulerView:shouldAddMarker:)]
        pub unsafe fn rulerView_shouldAddMarker(
            &self,
            ruler: &NSRulerView,
            marker: &NSRulerMarker,
        ) -> bool;

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[method(rulerView:willMoveMarker:toLocation:)]
        pub unsafe fn rulerView_willMoveMarker_toLocation(
            &self,
            ruler: &NSRulerView,
            marker: &NSRulerMarker,
            location: CGFloat,
        ) -> CGFloat;

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[method(rulerView:shouldRemoveMarker:)]
        pub unsafe fn rulerView_shouldRemoveMarker(
            &self,
            ruler: &NSRulerView,
            marker: &NSRulerMarker,
        ) -> bool;

        #[cfg(all(feature = "NSRulerMarker", feature = "NSRulerView"))]
        #[method(rulerView:willAddMarker:atLocation:)]
        pub unsafe fn rulerView_willAddMarker_atLocation(
            &self,
            ruler: &NSRulerView,
            marker: &NSRulerMarker,
            location: CGFloat,
        ) -> CGFloat;

        #[cfg(all(feature = "NSEvent", feature = "NSRulerView"))]
        #[method(rulerView:handleMouseDown:)]
        pub unsafe fn rulerView_handleMouseDown(&self, ruler: &NSRulerView, event: &NSEvent);

        #[method(setNeedsDisplayInRect:avoidAdditionalLayout:)]
        pub unsafe fn setNeedsDisplayInRect_avoidAdditionalLayout(&self, rect: NSRect, flag: bool);

        #[method(shouldDrawInsertionPoint)]
        pub unsafe fn shouldDrawInsertionPoint(&self) -> bool;

        #[cfg(feature = "NSColor")]
        #[method(drawInsertionPointInRect:color:turnedOn:)]
        pub unsafe fn drawInsertionPointInRect_color_turnedOn(
            &self,
            rect: NSRect,
            color: &NSColor,
            flag: bool,
        );

        #[method(drawViewBackgroundInRect:)]
        pub unsafe fn drawViewBackgroundInRect(&self, rect: NSRect);

        #[method(updateRuler)]
        pub unsafe fn updateRuler(&self);

        #[method(updateFontPanel)]
        pub unsafe fn updateFontPanel(&self);

        #[method(updateDragTypeRegistration)]
        pub unsafe fn updateDragTypeRegistration(&self);

        #[method(selectionRangeForProposedRange:granularity:)]
        pub unsafe fn selectionRangeForProposedRange_granularity(
            &self,
            proposed_char_range: NSRange,
            granularity: NSSelectionGranularity,
        ) -> NSRange;

        #[method(clickedOnLink:atIndex:)]
        pub unsafe fn clickedOnLink_atIndex(&self, link: &AnyObject, char_index: NSUInteger);

        #[method(startSpeaking:)]
        pub unsafe fn startSpeaking(&self, sender: Option<&AnyObject>);

        #[method(stopSpeaking:)]
        pub unsafe fn stopSpeaking(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSLayoutManager")]
        #[method(setLayoutOrientation:)]
        pub unsafe fn setLayoutOrientation(&self, orientation: NSTextLayoutOrientation);

        #[method(changeLayoutOrientation:)]
        pub unsafe fn changeLayoutOrientation(&self, sender: Option<&AnyObject>);

        #[method(characterIndexForInsertionAtPoint:)]
        pub unsafe fn characterIndexForInsertionAtPoint(&self, point: NSPoint) -> NSUInteger;

        #[method(stronglyReferencesTextStorage)]
        pub unsafe fn stronglyReferencesTextStorage(mtm: MainThreadMarker) -> bool;

        #[method(performValidatedReplacementInRange:withAttributedString:)]
        pub unsafe fn performValidatedReplacementInRange_withAttributedString(
            &self,
            range: NSRange,
            attributed_string: &NSAttributedString,
        ) -> bool;

        #[method(usesAdaptiveColorMappingForDarkAppearance)]
        pub unsafe fn usesAdaptiveColorMappingForDarkAppearance(&self) -> bool;

        #[method(setUsesAdaptiveColorMappingForDarkAppearance:)]
        pub unsafe fn setUsesAdaptiveColorMappingForDarkAppearance(
            &self,
            uses_adaptive_color_mapping_for_dark_appearance: bool,
        );
    }
);

extern_methods!(
    /// Methods declared on superclass `NSResponder`
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    }
);

extern_methods!(
    /// NSCompletion
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[method(complete:)]
        pub unsafe fn complete(&self, sender: Option<&AnyObject>);

        #[method(rangeForUserCompletion)]
        pub unsafe fn rangeForUserCompletion(&self) -> NSRange;

        #[method_id(@__retain_semantics Other completionsForPartialWordRange:indexOfSelectedItem:)]
        pub unsafe fn completionsForPartialWordRange_indexOfSelectedItem(
            &self,
            char_range: NSRange,
            index: NonNull<NSInteger>,
        ) -> Option<Retained<NSArray<NSString>>>;

        #[method(insertCompletion:forPartialWordRange:movement:isFinal:)]
        pub unsafe fn insertCompletion_forPartialWordRange_movement_isFinal(
            &self,
            word: &NSString,
            char_range: NSRange,
            movement: NSInteger,
            flag: bool,
        );
    }
);

extern_methods!(
    /// NSPasteboard
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[cfg(feature = "NSPasteboard")]
        #[method_id(@__retain_semantics Other writablePasteboardTypes)]
        pub unsafe fn writablePasteboardTypes(&self) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[method(writeSelectionToPasteboard:type:)]
        pub unsafe fn writeSelectionToPasteboard_type(
            &self,
            pboard: &NSPasteboard,
            r#type: &NSPasteboardType,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[method(writeSelectionToPasteboard:types:)]
        pub unsafe fn writeSelectionToPasteboard_types(
            &self,
            pboard: &NSPasteboard,
            types: &NSArray<NSPasteboardType>,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[method_id(@__retain_semantics Other readablePasteboardTypes)]
        pub unsafe fn readablePasteboardTypes(&self) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[method_id(@__retain_semantics Other preferredPasteboardTypeFromArray:restrictedToTypesFromArray:)]
        pub unsafe fn preferredPasteboardTypeFromArray_restrictedToTypesFromArray(
            &self,
            available_types: &NSArray<NSPasteboardType>,
            allowed_types: Option<&NSArray<NSPasteboardType>>,
        ) -> Option<Retained<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[method(readSelectionFromPasteboard:type:)]
        pub unsafe fn readSelectionFromPasteboard_type(
            &self,
            pboard: &NSPasteboard,
            r#type: &NSPasteboardType,
        ) -> bool;

        #[cfg(feature = "NSPasteboard")]
        #[method(readSelectionFromPasteboard:)]
        pub unsafe fn readSelectionFromPasteboard(&self, pboard: &NSPasteboard) -> bool;

        #[method(registerForServices)]
        pub unsafe fn registerForServices(mtm: MainThreadMarker);

        #[cfg(feature = "NSPasteboard")]
        #[method_id(@__retain_semantics Other validRequestorForSendType:returnType:)]
        pub unsafe fn validRequestorForSendType_returnType(
            &self,
            send_type: Option<&NSPasteboardType>,
            return_type: Option<&NSPasteboardType>,
        ) -> Option<Retained<AnyObject>>;

        #[method(pasteAsPlainText:)]
        pub unsafe fn pasteAsPlainText(&self, sender: Option<&AnyObject>);

        #[method(pasteAsRichText:)]
        pub unsafe fn pasteAsRichText(&self, sender: Option<&AnyObject>);
    }
);

extern_methods!(
    /// NSDragging
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[cfg(feature = "NSEvent")]
        #[method(dragSelectionWithEvent:offset:slideBack:)]
        pub unsafe fn dragSelectionWithEvent_offset_slideBack(
            &self,
            event: &NSEvent,
            mouse_offset: NSSize,
            slide_back: bool,
        ) -> bool;

        #[cfg(all(feature = "NSEvent", feature = "NSImage"))]
        #[method_id(@__retain_semantics Other dragImageForSelectionWithEvent:origin:)]
        pub unsafe fn dragImageForSelectionWithEvent_origin(
            &self,
            event: &NSEvent,
            origin: NSPointPointer,
        ) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSPasteboard")]
        #[method_id(@__retain_semantics Other acceptableDragTypes)]
        pub unsafe fn acceptableDragTypes(&self) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(all(feature = "NSDragging", feature = "NSPasteboard"))]
        #[method(dragOperationForDraggingInfo:type:)]
        pub unsafe fn dragOperationForDraggingInfo_type(
            &self,
            drag_info: &ProtocolObject<dyn NSDraggingInfo>,
            r#type: &NSPasteboardType,
        ) -> NSDragOperation;

        #[method(cleanUpAfterDragOperation)]
        pub unsafe fn cleanUpAfterDragOperation(&self);
    }
);

extern_methods!(
    /// NSSharing
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[method_id(@__retain_semantics Other selectedRanges)]
        pub unsafe fn selectedRanges(&self) -> Retained<NSArray<NSValue>>;

        #[method(setSelectedRanges:)]
        pub unsafe fn setSelectedRanges(&self, selected_ranges: &NSArray<NSValue>);

        #[method(setSelectedRanges:affinity:stillSelecting:)]
        pub unsafe fn setSelectedRanges_affinity_stillSelecting(
            &self,
            ranges: &NSArray<NSValue>,
            affinity: NSSelectionAffinity,
            still_selecting_flag: bool,
        );

        #[method(setSelectedRange:affinity:stillSelecting:)]
        pub unsafe fn setSelectedRange_affinity_stillSelecting(
            &self,
            char_range: NSRange,
            affinity: NSSelectionAffinity,
            still_selecting_flag: bool,
        );

        #[method(selectionAffinity)]
        pub unsafe fn selectionAffinity(&self) -> NSSelectionAffinity;

        #[method(selectionGranularity)]
        pub unsafe fn selectionGranularity(&self) -> NSSelectionGranularity;

        #[method(setSelectionGranularity:)]
        pub unsafe fn setSelectionGranularity(&self, selection_granularity: NSSelectionGranularity);

        #[method_id(@__retain_semantics Other selectedTextAttributes)]
        pub unsafe fn selectedTextAttributes(
            &self,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        #[method(setSelectedTextAttributes:)]
        pub unsafe fn setSelectedTextAttributes(
            &self,
            selected_text_attributes: &NSDictionary<NSAttributedStringKey, AnyObject>,
        );

        #[cfg(feature = "NSColor")]
        #[method_id(@__retain_semantics Other insertionPointColor)]
        pub unsafe fn insertionPointColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        #[method(setInsertionPointColor:)]
        pub unsafe fn setInsertionPointColor(&self, insertion_point_color: Option<&NSColor>);

        #[method(updateInsertionPointStateAndRestartTimer:)]
        pub unsafe fn updateInsertionPointStateAndRestartTimer(&self, restart_flag: bool);

        #[method_id(@__retain_semantics Other markedTextAttributes)]
        pub unsafe fn markedTextAttributes(
            &self,
        ) -> Option<Retained<NSDictionary<NSAttributedStringKey, AnyObject>>>;

        #[method(setMarkedTextAttributes:)]
        pub unsafe fn setMarkedTextAttributes(
            &self,
            marked_text_attributes: Option<&NSDictionary<NSAttributedStringKey, AnyObject>>,
        );

        #[method_id(@__retain_semantics Other linkTextAttributes)]
        pub unsafe fn linkTextAttributes(
            &self,
        ) -> Option<Retained<NSDictionary<NSAttributedStringKey, AnyObject>>>;

        #[method(setLinkTextAttributes:)]
        pub unsafe fn setLinkTextAttributes(
            &self,
            link_text_attributes: Option<&NSDictionary<NSAttributedStringKey, AnyObject>>,
        );

        #[method(displaysLinkToolTips)]
        pub unsafe fn displaysLinkToolTips(&self) -> bool;

        #[method(setDisplaysLinkToolTips:)]
        pub unsafe fn setDisplaysLinkToolTips(&self, displays_link_tool_tips: bool);

        #[method(acceptsGlyphInfo)]
        pub unsafe fn acceptsGlyphInfo(&self) -> bool;

        #[method(setAcceptsGlyphInfo:)]
        pub unsafe fn setAcceptsGlyphInfo(&self, accepts_glyph_info: bool);

        #[method(usesRuler)]
        pub unsafe fn usesRuler(&self) -> bool;

        #[method(setUsesRuler:)]
        pub unsafe fn setUsesRuler(&self, uses_ruler: bool);

        #[method(usesInspectorBar)]
        pub unsafe fn usesInspectorBar(&self) -> bool;

        #[method(setUsesInspectorBar:)]
        pub unsafe fn setUsesInspectorBar(&self, uses_inspector_bar: bool);

        #[method(isContinuousSpellCheckingEnabled)]
        pub unsafe fn isContinuousSpellCheckingEnabled(&self) -> bool;

        #[method(setContinuousSpellCheckingEnabled:)]
        pub unsafe fn setContinuousSpellCheckingEnabled(
            &self,
            continuous_spell_checking_enabled: bool,
        );

        #[method(toggleContinuousSpellChecking:)]
        pub unsafe fn toggleContinuousSpellChecking(&self, sender: Option<&AnyObject>);

        #[method(spellCheckerDocumentTag)]
        pub unsafe fn spellCheckerDocumentTag(&self) -> NSInteger;

        #[method(isGrammarCheckingEnabled)]
        pub unsafe fn isGrammarCheckingEnabled(&self) -> bool;

        #[method(setGrammarCheckingEnabled:)]
        pub unsafe fn setGrammarCheckingEnabled(&self, grammar_checking_enabled: bool);

        #[method(toggleGrammarChecking:)]
        pub unsafe fn toggleGrammarChecking(&self, sender: Option<&AnyObject>);

        #[method(setSpellingState:range:)]
        pub unsafe fn setSpellingState_range(&self, value: NSInteger, char_range: NSRange);

        #[method_id(@__retain_semantics Other typingAttributes)]
        pub unsafe fn typingAttributes(
            &self,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        #[method(setTypingAttributes:)]
        pub unsafe fn setTypingAttributes(
            &self,
            typing_attributes: &NSDictionary<NSAttributedStringKey, AnyObject>,
        );

        #[method(shouldChangeTextInRanges:replacementStrings:)]
        pub unsafe fn shouldChangeTextInRanges_replacementStrings(
            &self,
            affected_ranges: &NSArray<NSValue>,
            replacement_strings: Option<&NSArray<NSString>>,
        ) -> bool;

        #[method_id(@__retain_semantics Other rangesForUserTextChange)]
        pub unsafe fn rangesForUserTextChange(&self) -> Option<Retained<NSArray<NSValue>>>;

        #[method_id(@__retain_semantics Other rangesForUserCharacterAttributeChange)]
        pub unsafe fn rangesForUserCharacterAttributeChange(
            &self,
        ) -> Option<Retained<NSArray<NSValue>>>;

        #[method_id(@__retain_semantics Other rangesForUserParagraphAttributeChange)]
        pub unsafe fn rangesForUserParagraphAttributeChange(
            &self,
        ) -> Option<Retained<NSArray<NSValue>>>;

        #[method(shouldChangeTextInRange:replacementString:)]
        pub unsafe fn shouldChangeTextInRange_replacementString(
            &self,
            affected_char_range: NSRange,
            replacement_string: Option<&NSString>,
        ) -> bool;

        #[method(didChangeText)]
        pub unsafe fn didChangeText(&self);

        #[method(rangeForUserTextChange)]
        pub unsafe fn rangeForUserTextChange(&self) -> NSRange;

        #[method(rangeForUserCharacterAttributeChange)]
        pub unsafe fn rangeForUserCharacterAttributeChange(&self) -> NSRange;

        #[method(rangeForUserParagraphAttributeChange)]
        pub unsafe fn rangeForUserParagraphAttributeChange(&self) -> NSRange;

        #[method(allowsDocumentBackgroundColorChange)]
        pub unsafe fn allowsDocumentBackgroundColorChange(&self) -> bool;

        #[method(setAllowsDocumentBackgroundColorChange:)]
        pub unsafe fn setAllowsDocumentBackgroundColorChange(
            &self,
            allows_document_background_color_change: bool,
        );

        #[cfg(feature = "NSParagraphStyle")]
        #[method_id(@__retain_semantics Other defaultParagraphStyle)]
        pub unsafe fn defaultParagraphStyle(&self) -> Option<Retained<NSParagraphStyle>>;

        #[cfg(feature = "NSParagraphStyle")]
        #[method(setDefaultParagraphStyle:)]
        pub unsafe fn setDefaultParagraphStyle(
            &self,
            default_paragraph_style: Option<&NSParagraphStyle>,
        );

        #[method(allowsUndo)]
        pub unsafe fn allowsUndo(&self) -> bool;

        #[method(setAllowsUndo:)]
        pub unsafe fn setAllowsUndo(&self, allows_undo: bool);

        #[method(breakUndoCoalescing)]
        pub unsafe fn breakUndoCoalescing(&self);

        #[method(isCoalescingUndo)]
        pub unsafe fn isCoalescingUndo(&self) -> bool;

        #[method(allowsImageEditing)]
        pub unsafe fn allowsImageEditing(&self) -> bool;

        #[method(setAllowsImageEditing:)]
        pub unsafe fn setAllowsImageEditing(&self, allows_image_editing: bool);

        #[method(showFindIndicatorForRange:)]
        pub unsafe fn showFindIndicatorForRange(&self, char_range: NSRange);

        #[method(usesRolloverButtonForSelection)]
        pub unsafe fn usesRolloverButtonForSelection(&self) -> bool;

        #[method(setUsesRolloverButtonForSelection:)]
        pub unsafe fn setUsesRolloverButtonForSelection(
            &self,
            uses_rollover_button_for_selection: bool,
        );

        #[method_id(@__retain_semantics Other delegate)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSTextViewDelegate>>>;

        #[method(setDelegate:)]
        pub unsafe fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSTextViewDelegate>>);

        #[method(isEditable)]
        pub unsafe fn isEditable(&self) -> bool;

        #[method(setEditable:)]
        pub unsafe fn setEditable(&self, editable: bool);

        #[method(isSelectable)]
        pub unsafe fn isSelectable(&self) -> bool;

        #[method(setSelectable:)]
        pub unsafe fn setSelectable(&self, selectable: bool);

        #[method(isRichText)]
        pub unsafe fn isRichText(&self) -> bool;

        #[method(setRichText:)]
        pub unsafe fn setRichText(&self, rich_text: bool);

        #[method(importsGraphics)]
        pub unsafe fn importsGraphics(&self) -> bool;

        #[method(setImportsGraphics:)]
        pub unsafe fn setImportsGraphics(&self, imports_graphics: bool);

        #[method(drawsBackground)]
        pub unsafe fn drawsBackground(&self) -> bool;

        #[method(setDrawsBackground:)]
        pub unsafe fn setDrawsBackground(&self, draws_background: bool);

        #[cfg(feature = "NSColor")]
        #[method_id(@__retain_semantics Other backgroundColor)]
        pub unsafe fn backgroundColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        #[method(setBackgroundColor:)]
        pub unsafe fn setBackgroundColor(&self, background_color: &NSColor);

        #[method(isFieldEditor)]
        pub unsafe fn isFieldEditor(&self) -> bool;

        #[method(setFieldEditor:)]
        pub unsafe fn setFieldEditor(&self, field_editor: bool);

        #[method(usesFontPanel)]
        pub unsafe fn usesFontPanel(&self) -> bool;

        #[method(setUsesFontPanel:)]
        pub unsafe fn setUsesFontPanel(&self, uses_font_panel: bool);

        #[method(isRulerVisible)]
        pub unsafe fn isRulerVisible(&self) -> bool;

        #[method(setRulerVisible:)]
        pub unsafe fn setRulerVisible(&self, ruler_visible: bool);

        #[method(setSelectedRange:)]
        pub unsafe fn setSelectedRange(&self, char_range: NSRange);

        #[method_id(@__retain_semantics Other allowedInputSourceLocales)]
        pub unsafe fn allowedInputSourceLocales(&self) -> Option<Retained<NSArray<NSString>>>;

        #[method(setAllowedInputSourceLocales:)]
        pub unsafe fn setAllowedInputSourceLocales(
            &self,
            allowed_input_source_locales: Option<&NSArray<NSString>>,
        );
    }
);

extern_methods!(
    /// NSTextChecking
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[method(smartInsertDeleteEnabled)]
        pub unsafe fn smartInsertDeleteEnabled(&self) -> bool;

        #[method(setSmartInsertDeleteEnabled:)]
        pub unsafe fn setSmartInsertDeleteEnabled(&self, smart_insert_delete_enabled: bool);

        #[method(smartDeleteRangeForProposedRange:)]
        pub unsafe fn smartDeleteRangeForProposedRange(
            &self,
            proposed_char_range: NSRange,
        ) -> NSRange;

        #[method(toggleSmartInsertDelete:)]
        pub unsafe fn toggleSmartInsertDelete(&self, sender: Option<&AnyObject>);

        #[method(smartInsertForString:replacingRange:beforeString:afterString:)]
        pub unsafe fn smartInsertForString_replacingRange_beforeString_afterString(
            &self,
            paste_string: &NSString,
            char_range_to_replace: NSRange,
            before_string: Option<&mut Option<Retained<NSString>>>,
            after_string: Option<&mut Option<Retained<NSString>>>,
        );

        #[method_id(@__retain_semantics Other smartInsertBeforeStringForString:replacingRange:)]
        pub unsafe fn smartInsertBeforeStringForString_replacingRange(
            &self,
            paste_string: &NSString,
            char_range_to_replace: NSRange,
        ) -> Option<Retained<NSString>>;

        #[method_id(@__retain_semantics Other smartInsertAfterStringForString:replacingRange:)]
        pub unsafe fn smartInsertAfterStringForString_replacingRange(
            &self,
            paste_string: &NSString,
            char_range_to_replace: NSRange,
        ) -> Option<Retained<NSString>>;

        #[method(isAutomaticQuoteSubstitutionEnabled)]
        pub unsafe fn isAutomaticQuoteSubstitutionEnabled(&self) -> bool;

        #[method(setAutomaticQuoteSubstitutionEnabled:)]
        pub unsafe fn setAutomaticQuoteSubstitutionEnabled(
            &self,
            automatic_quote_substitution_enabled: bool,
        );

        #[method(toggleAutomaticQuoteSubstitution:)]
        pub unsafe fn toggleAutomaticQuoteSubstitution(&self, sender: Option<&AnyObject>);

        #[method(isAutomaticLinkDetectionEnabled)]
        pub unsafe fn isAutomaticLinkDetectionEnabled(&self) -> bool;

        #[method(setAutomaticLinkDetectionEnabled:)]
        pub unsafe fn setAutomaticLinkDetectionEnabled(
            &self,
            automatic_link_detection_enabled: bool,
        );

        #[method(toggleAutomaticLinkDetection:)]
        pub unsafe fn toggleAutomaticLinkDetection(&self, sender: Option<&AnyObject>);

        #[method(isAutomaticDataDetectionEnabled)]
        pub unsafe fn isAutomaticDataDetectionEnabled(&self) -> bool;

        #[method(setAutomaticDataDetectionEnabled:)]
        pub unsafe fn setAutomaticDataDetectionEnabled(
            &self,
            automatic_data_detection_enabled: bool,
        );

        #[method(toggleAutomaticDataDetection:)]
        pub unsafe fn toggleAutomaticDataDetection(&self, sender: Option<&AnyObject>);

        #[method(isAutomaticDashSubstitutionEnabled)]
        pub unsafe fn isAutomaticDashSubstitutionEnabled(&self) -> bool;

        #[method(setAutomaticDashSubstitutionEnabled:)]
        pub unsafe fn setAutomaticDashSubstitutionEnabled(
            &self,
            automatic_dash_substitution_enabled: bool,
        );

        #[method(toggleAutomaticDashSubstitution:)]
        pub unsafe fn toggleAutomaticDashSubstitution(&self, sender: Option<&AnyObject>);

        #[method(isAutomaticTextReplacementEnabled)]
        pub unsafe fn isAutomaticTextReplacementEnabled(&self) -> bool;

        #[method(setAutomaticTextReplacementEnabled:)]
        pub unsafe fn setAutomaticTextReplacementEnabled(
            &self,
            automatic_text_replacement_enabled: bool,
        );

        #[method(toggleAutomaticTextReplacement:)]
        pub unsafe fn toggleAutomaticTextReplacement(&self, sender: Option<&AnyObject>);

        #[method(isAutomaticSpellingCorrectionEnabled)]
        pub unsafe fn isAutomaticSpellingCorrectionEnabled(&self) -> bool;

        #[method(setAutomaticSpellingCorrectionEnabled:)]
        pub unsafe fn setAutomaticSpellingCorrectionEnabled(
            &self,
            automatic_spelling_correction_enabled: bool,
        );

        #[method(toggleAutomaticSpellingCorrection:)]
        pub unsafe fn toggleAutomaticSpellingCorrection(&self, sender: Option<&AnyObject>);

        #[method(enabledTextCheckingTypes)]
        pub unsafe fn enabledTextCheckingTypes(&self) -> NSTextCheckingTypes;

        #[method(setEnabledTextCheckingTypes:)]
        pub unsafe fn setEnabledTextCheckingTypes(
            &self,
            enabled_text_checking_types: NSTextCheckingTypes,
        );

        #[cfg(feature = "NSSpellChecker")]
        #[method(checkTextInRange:types:options:)]
        pub unsafe fn checkTextInRange_types_options(
            &self,
            range: NSRange,
            checking_types: NSTextCheckingTypes,
            options: &NSDictionary<NSTextCheckingOptionKey, AnyObject>,
        );

        #[cfg(feature = "NSSpellChecker")]
        #[method(handleTextCheckingResults:forRange:types:options:orthography:wordCount:)]
        pub unsafe fn handleTextCheckingResults_forRange_types_options_orthography_wordCount(
            &self,
            results: &NSArray<NSTextCheckingResult>,
            range: NSRange,
            checking_types: NSTextCheckingTypes,
            options: &NSDictionary<NSTextCheckingOptionKey, AnyObject>,
            orthography: &NSOrthography,
            word_count: NSInteger,
        );

        #[method(orderFrontSubstitutionsPanel:)]
        pub unsafe fn orderFrontSubstitutionsPanel(&self, sender: Option<&AnyObject>);

        #[method(checkTextInSelection:)]
        pub unsafe fn checkTextInSelection(&self, sender: Option<&AnyObject>);

        #[method(checkTextInDocument:)]
        pub unsafe fn checkTextInDocument(&self, sender: Option<&AnyObject>);

        #[method(usesFindPanel)]
        pub unsafe fn usesFindPanel(&self) -> bool;

        #[method(setUsesFindPanel:)]
        pub unsafe fn setUsesFindPanel(&self, uses_find_panel: bool);

        #[method(usesFindBar)]
        pub unsafe fn usesFindBar(&self) -> bool;

        #[method(setUsesFindBar:)]
        pub unsafe fn setUsesFindBar(&self, uses_find_bar: bool);

        #[method(isIncrementalSearchingEnabled)]
        pub unsafe fn isIncrementalSearchingEnabled(&self) -> bool;

        #[method(setIncrementalSearchingEnabled:)]
        pub unsafe fn setIncrementalSearchingEnabled(&self, incremental_searching_enabled: bool);

        #[cfg(feature = "NSTextCheckingClient")]
        #[method(inlinePredictionType)]
        pub unsafe fn inlinePredictionType(&self) -> NSTextInputTraitType;

        #[cfg(feature = "NSTextCheckingClient")]
        #[method(setInlinePredictionType:)]
        pub unsafe fn setInlinePredictionType(&self, inline_prediction_type: NSTextInputTraitType);
    }
);

extern_methods!(
    /// NSQuickLookPreview
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[method(toggleQuickLookPreviewPanel:)]
        pub unsafe fn toggleQuickLookPreviewPanel(&self, sender: Option<&AnyObject>);

        #[method(updateQuickLookPreviewPanel)]
        pub unsafe fn updateQuickLookPreviewPanel(&self);
    }
);

extern_methods!(
    /// NSTextView_SharingService
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[method(orderFrontSharingServicePicker:)]
        pub unsafe fn orderFrontSharingServicePicker(&self, sender: Option<&AnyObject>);
    }
);

extern_methods!(
    /// NSTextView_TouchBar
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[method(isAutomaticTextCompletionEnabled)]
        pub unsafe fn isAutomaticTextCompletionEnabled(&self) -> bool;

        #[method(setAutomaticTextCompletionEnabled:)]
        pub unsafe fn setAutomaticTextCompletionEnabled(
            &self,
            automatic_text_completion_enabled: bool,
        );

        #[method(toggleAutomaticTextCompletion:)]
        pub unsafe fn toggleAutomaticTextCompletion(&self, sender: Option<&AnyObject>);

        #[method(allowsCharacterPickerTouchBarItem)]
        pub unsafe fn allowsCharacterPickerTouchBarItem(&self) -> bool;

        #[method(setAllowsCharacterPickerTouchBarItem:)]
        pub unsafe fn setAllowsCharacterPickerTouchBarItem(
            &self,
            allows_character_picker_touch_bar_item: bool,
        );

        #[method(updateTouchBarItemIdentifiers)]
        pub unsafe fn updateTouchBarItemIdentifiers(&self);

        #[method(updateTextTouchBarItems)]
        pub unsafe fn updateTextTouchBarItems(&self);

        #[method(updateCandidates)]
        pub unsafe fn updateCandidates(&self);

        #[cfg(all(feature = "NSCandidateListTouchBarItem", feature = "NSTouchBarItem"))]
        #[method_id(@__retain_semantics Other candidateListTouchBarItem)]
        pub unsafe fn candidateListTouchBarItem(
            &self,
        ) -> Option<Retained<NSCandidateListTouchBarItem>>;
    }
);

#[cfg(all(
    feature = "NSCandidateListTouchBarItem",
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSView"
))]
unsafe impl NSCandidateListTouchBarItemDelegate for NSTextView {}

#[cfg(all(
    feature = "NSResponder",
    feature = "NSText",
    feature = "NSTouchBar",
    feature = "NSView"
))]
unsafe impl NSTouchBarDelegate for NSTextView {}

extern_methods!(
    /// NSTextView_Factory
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[cfg(feature = "NSScrollView")]
        #[method_id(@__retain_semantics Other scrollableTextView)]
        pub unsafe fn scrollableTextView(mtm: MainThreadMarker) -> Retained<NSScrollView>;

        #[method_id(@__retain_semantics Other fieldEditor)]
        pub unsafe fn fieldEditor(mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(feature = "NSScrollView")]
        #[method_id(@__retain_semantics Other scrollableDocumentContentTextView)]
        pub unsafe fn scrollableDocumentContentTextView(
            mtm: MainThreadMarker,
        ) -> Retained<NSScrollView>;

        #[cfg(feature = "NSScrollView")]
        #[method_id(@__retain_semantics Other scrollablePlainDocumentContentTextView)]
        pub unsafe fn scrollablePlainDocumentContentTextView(
            mtm: MainThreadMarker,
        ) -> Retained<NSScrollView>;
    }
);

extern_methods!(
    /// NSDeprecated
    #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
    unsafe impl NSTextView {
        #[deprecated = "Use NSResponder's makeBaseWritingDirectionNatural:, makeBaseWritingDirectionLeftToRight:, and makeBaseWritingDirectionRightToLeft: instead"]
        #[method(toggleBaseWritingDirection:)]
        pub unsafe fn toggleBaseWritingDirection(&self, sender: Option<&AnyObject>);
    }
);

extern_protocol!(
    #[cfg(feature = "NSText")]
    pub unsafe trait NSTextViewDelegate: NSTextDelegate {
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(textView:clickedOnLink:atIndex:)]
        unsafe fn textView_clickedOnLink_atIndex(
            &self,
            text_view: &NSTextView,
            link: &AnyObject,
            char_index: NSUInteger,
        ) -> bool;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[optional]
        #[method(textView:clickedOnCell:inRect:atIndex:)]
        unsafe fn textView_clickedOnCell_inRect_atIndex(
            &self,
            text_view: &NSTextView,
            cell: &ProtocolObject<dyn NSTextAttachmentCellProtocol>,
            cell_frame: NSRect,
            char_index: NSUInteger,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[optional]
        #[method(textView:doubleClickedOnCell:inRect:atIndex:)]
        unsafe fn textView_doubleClickedOnCell_inRect_atIndex(
            &self,
            text_view: &NSTextView,
            cell: &ProtocolObject<dyn NSTextAttachmentCellProtocol>,
            cell_frame: NSRect,
            char_index: NSUInteger,
        );

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[optional]
        #[method(textView:draggedCell:inRect:event:atIndex:)]
        unsafe fn textView_draggedCell_inRect_event_atIndex(
            &self,
            view: &NSTextView,
            cell: &ProtocolObject<dyn NSTextAttachmentCellProtocol>,
            rect: NSRect,
            event: &NSEvent,
            char_index: NSUInteger,
        );

        #[cfg(all(
            feature = "NSPasteboard",
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:writablePasteboardTypesForCell:atIndex:)]
        unsafe fn textView_writablePasteboardTypesForCell_atIndex(
            &self,
            view: &NSTextView,
            cell: &ProtocolObject<dyn NSTextAttachmentCellProtocol>,
            char_index: NSUInteger,
        ) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(all(
            feature = "NSPasteboard",
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[optional]
        #[method(textView:writeCell:atIndex:toPasteboard:type:)]
        unsafe fn textView_writeCell_atIndex_toPasteboard_type(
            &self,
            view: &NSTextView,
            cell: &ProtocolObject<dyn NSTextAttachmentCellProtocol>,
            char_index: NSUInteger,
            pboard: &NSPasteboard,
            r#type: &NSPasteboardType,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(textView:willChangeSelectionFromCharacterRange:toCharacterRange:)]
        unsafe fn textView_willChangeSelectionFromCharacterRange_toCharacterRange(
            &self,
            text_view: &NSTextView,
            old_selected_char_range: NSRange,
            new_selected_char_range: NSRange,
        ) -> NSRange;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:willChangeSelectionFromCharacterRanges:toCharacterRanges:)]
        unsafe fn textView_willChangeSelectionFromCharacterRanges_toCharacterRanges(
            &self,
            text_view: &NSTextView,
            old_selected_char_ranges: &NSArray<NSValue>,
            new_selected_char_ranges: &NSArray<NSValue>,
        ) -> Retained<NSArray<NSValue>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(textView:shouldChangeTextInRanges:replacementStrings:)]
        unsafe fn textView_shouldChangeTextInRanges_replacementStrings(
            &self,
            text_view: &NSTextView,
            affected_ranges: &NSArray<NSValue>,
            replacement_strings: Option<&NSArray<NSString>>,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:shouldChangeTypingAttributes:toAttributes:)]
        unsafe fn textView_shouldChangeTypingAttributes_toAttributes(
            &self,
            text_view: &NSTextView,
            old_typing_attributes: &NSDictionary<NSString, AnyObject>,
            new_typing_attributes: &NSDictionary<NSAttributedStringKey, AnyObject>,
        ) -> Retained<NSDictionary<NSAttributedStringKey, AnyObject>>;

        #[optional]
        #[method(textViewDidChangeSelection:)]
        unsafe fn textViewDidChangeSelection(&self, notification: &NSNotification);

        #[optional]
        #[method(textViewDidChangeTypingAttributes:)]
        unsafe fn textViewDidChangeTypingAttributes(&self, notification: &NSNotification);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:willDisplayToolTip:forCharacterAtIndex:)]
        unsafe fn textView_willDisplayToolTip_forCharacterAtIndex(
            &self,
            text_view: &NSTextView,
            tooltip: &NSString,
            character_index: NSUInteger,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:completions:forPartialWordRange:indexOfSelectedItem:)]
        unsafe fn textView_completions_forPartialWordRange_indexOfSelectedItem(
            &self,
            text_view: &NSTextView,
            words: &NSArray<NSString>,
            char_range: NSRange,
            index: *mut NSInteger,
        ) -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(textView:shouldChangeTextInRange:replacementString:)]
        unsafe fn textView_shouldChangeTextInRange_replacementString(
            &self,
            text_view: &NSTextView,
            affected_char_range: NSRange,
            replacement_string: Option<&NSString>,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(textView:doCommandBySelector:)]
        unsafe fn textView_doCommandBySelector(
            &self,
            text_view: &NSTextView,
            command_selector: Sel,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(textView:shouldSetSpellingState:range:)]
        unsafe fn textView_shouldSetSpellingState_range(
            &self,
            text_view: &NSTextView,
            value: NSInteger,
            affected_char_range: NSRange,
        ) -> NSInteger;

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSMenu",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:menu:forEvent:atIndex:)]
        unsafe fn textView_menu_forEvent_atIndex(
            &self,
            view: &NSTextView,
            menu: &NSMenu,
            event: &NSEvent,
            char_index: NSUInteger,
        ) -> Option<Retained<NSMenu>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSSpellChecker",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:willCheckTextInRange:options:types:)]
        unsafe fn textView_willCheckTextInRange_options_types(
            &self,
            view: &NSTextView,
            range: NSRange,
            options: &NSDictionary<NSTextCheckingOptionKey, AnyObject>,
            checking_types: NonNull<NSTextCheckingTypes>,
        ) -> Retained<NSDictionary<NSTextCheckingOptionKey, AnyObject>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSSpellChecker",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:didCheckTextInRange:types:options:results:orthography:wordCount:)]
        unsafe fn textView_didCheckTextInRange_types_options_results_orthography_wordCount(
            &self,
            view: &NSTextView,
            range: NSRange,
            checking_types: NSTextCheckingTypes,
            options: &NSDictionary<NSTextCheckingOptionKey, AnyObject>,
            results: &NSArray<NSTextCheckingResult>,
            orthography: &NSOrthography,
            word_count: NSInteger,
        ) -> Retained<NSArray<NSTextCheckingResult>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTextAttachment",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:URLForContentsOfTextAttachment:atIndex:)]
        unsafe fn textView_URLForContentsOfTextAttachment_atIndex(
            &self,
            text_view: &NSTextView,
            text_attachment: &NSTextAttachment,
            char_index: NSUInteger,
        ) -> Option<Retained<NSURL>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSSharingService",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:willShowSharingServicePicker:forItems:)]
        unsafe fn textView_willShowSharingServicePicker_forItems(
            &self,
            text_view: &NSTextView,
            service_picker: &NSSharingServicePicker,
            items: &NSArray,
        ) -> Option<Retained<NSSharingServicePicker>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method_id(@__retain_semantics Other undoManagerForTextView:)]
        unsafe fn undoManagerForTextView(
            &self,
            view: &NSTextView,
        ) -> Option<Retained<NSUndoManager>>;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTouchBarItem",
            feature = "NSView"
        ))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:shouldUpdateTouchBarItemIdentifiers:)]
        unsafe fn textView_shouldUpdateTouchBarItemIdentifiers(
            &self,
            text_view: &NSTextView,
            identifiers: &NSArray<NSTouchBarItemIdentifier>,
        ) -> Retained<NSArray<NSTouchBarItemIdentifier>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:candidatesForSelectedRange:)]
        unsafe fn textView_candidatesForSelectedRange(
            &self,
            text_view: &NSTextView,
            selected_range: NSRange,
        ) -> Option<Retained<NSArray>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method_id(@__retain_semantics Other textView:candidates:forSelectedRange:)]
        unsafe fn textView_candidates_forSelectedRange(
            &self,
            text_view: &NSTextView,
            candidates: &NSArray<NSTextCheckingResult>,
            selected_range: NSRange,
        ) -> Retained<NSArray<NSTextCheckingResult>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[method(textView:shouldSelectCandidateAtIndex:)]
        unsafe fn textView_shouldSelectCandidateAtIndex(
            &self,
            text_view: &NSTextView,
            index: NSUInteger,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[deprecated = "Use -textView:clickedOnLink:atIndex: instead"]
        #[optional]
        #[method(textView:clickedOnLink:)]
        unsafe fn textView_clickedOnLink(
            &self,
            text_view: &NSTextView,
            link: Option<&AnyObject>,
        ) -> bool;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[deprecated = "Use -textView:clickedOnCell:inRect:atIndex: instead"]
        #[optional]
        #[method(textView:clickedOnCell:inRect:)]
        unsafe fn textView_clickedOnCell_inRect(
            &self,
            text_view: &NSTextView,
            cell: Option<&ProtocolObject<dyn NSTextAttachmentCellProtocol>>,
            cell_frame: NSRect,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[deprecated = "Use -textView:doubleClickedOnCell:inRect:atIndex: instead"]
        #[optional]
        #[method(textView:doubleClickedOnCell:inRect:)]
        unsafe fn textView_doubleClickedOnCell_inRect(
            &self,
            text_view: &NSTextView,
            cell: Option<&ProtocolObject<dyn NSTextAttachmentCellProtocol>>,
            cell_frame: NSRect,
        );

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSResponder",
            feature = "NSTextAttachmentCell",
            feature = "NSView"
        ))]
        #[deprecated = "Use -textView:draggedCell:inRect:event:atIndex: instead"]
        #[optional]
        #[method(textView:draggedCell:inRect:event:)]
        unsafe fn textView_draggedCell_inRect_event(
            &self,
            view: &NSTextView,
            cell: Option<&ProtocolObject<dyn NSTextAttachmentCellProtocol>>,
            rect: NSRect,
            event: Option<&NSEvent>,
        );
    }

    #[cfg(feature = "NSText")]
    unsafe impl ProtocolType for dyn NSTextViewDelegate {}
);

extern "C" {
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierCharacterPicker: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierTextColorPicker: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierTextStyle: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierTextAlignment: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierTextList: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    #[cfg(feature = "NSTouchBarItem")]
    pub static NSTouchBarItemIdentifierTextFormat: &'static NSTouchBarItemIdentifier;
}

extern "C" {
    pub static NSTextViewWillChangeNotifyingTextViewNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSTextViewDidChangeSelectionNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSTextViewDidChangeTypingAttributesNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSTextViewWillSwitchToNSLayoutManagerNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSTextViewDidSwitchToNSLayoutManagerNotification: &'static NSNotificationName;
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFindPanelAction(pub NSUInteger);
impl NSFindPanelAction {
    #[doc(alias = "NSFindPanelActionShowFindPanel")]
    pub const ShowFindPanel: Self = Self(1);
    #[doc(alias = "NSFindPanelActionNext")]
    pub const Next: Self = Self(2);
    #[doc(alias = "NSFindPanelActionPrevious")]
    pub const Previous: Self = Self(3);
    #[doc(alias = "NSFindPanelActionReplaceAll")]
    pub const ReplaceAll: Self = Self(4);
    #[doc(alias = "NSFindPanelActionReplace")]
    pub const Replace: Self = Self(5);
    #[doc(alias = "NSFindPanelActionReplaceAndFind")]
    pub const ReplaceAndFind: Self = Self(6);
    #[doc(alias = "NSFindPanelActionSetFindString")]
    pub const SetFindString: Self = Self(7);
    #[doc(alias = "NSFindPanelActionReplaceAllInSelection")]
    pub const ReplaceAllInSelection: Self = Self(8);
    #[doc(alias = "NSFindPanelActionSelectAll")]
    pub const SelectAll: Self = Self(9);
    #[doc(alias = "NSFindPanelActionSelectAllInSelection")]
    pub const SelectAllInSelection: Self = Self(10);
}

unsafe impl Encode for NSFindPanelAction {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFindPanelAction {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    #[cfg(feature = "NSPasteboard")]
    pub static NSFindPanelSearchOptionsPboardType: &'static NSPasteboardType;
}

// NS_TYPED_ENUM
pub type NSPasteboardTypeFindPanelSearchOptionKey = NSString;

extern "C" {
    pub static NSFindPanelCaseInsensitiveSearch: &'static NSPasteboardTypeFindPanelSearchOptionKey;
}

extern "C" {
    pub static NSFindPanelSubstringMatch: &'static NSPasteboardTypeFindPanelSearchOptionKey;
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFindPanelSubstringMatchType(pub NSUInteger);
impl NSFindPanelSubstringMatchType {
    #[doc(alias = "NSFindPanelSubstringMatchTypeContains")]
    pub const Contains: Self = Self(0);
    #[doc(alias = "NSFindPanelSubstringMatchTypeStartsWith")]
    pub const StartsWith: Self = Self(1);
    #[doc(alias = "NSFindPanelSubstringMatchTypeFullWord")]
    pub const FullWord: Self = Self(2);
    #[doc(alias = "NSFindPanelSubstringMatchTypeEndsWith")]
    pub const EndsWith: Self = Self(3);
}

unsafe impl Encode for NSFindPanelSubstringMatchType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFindPanelSubstringMatchType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
