package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricOrganizationSpecs invokes the baas.DescribeFabricOrganizationSpecs API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizationspecs.html
func (client *Client) DescribeFabricOrganizationSpecs(request *DescribeFabricOrganizationSpecsRequest) (response *DescribeFabricOrganizationSpecsResponse, err error) {
	response = CreateDescribeFabricOrganizationSpecsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricOrganizationSpecsWithChan invokes the baas.DescribeFabricOrganizationSpecs API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizationspecs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrganizationSpecsWithChan(request *DescribeFabricOrganizationSpecsRequest) (<-chan *DescribeFabricOrganizationSpecsResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricOrganizationSpecsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricOrganizationSpecs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricOrganizationSpecsWithCallback invokes the baas.DescribeFabricOrganizationSpecs API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricorganizationspecs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricOrganizationSpecsWithCallback(request *DescribeFabricOrganizationSpecsRequest, callback func(response *DescribeFabricOrganizationSpecsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricOrganizationSpecsResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricOrganizationSpecs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricOrganizationSpecsRequest is the request struct for api DescribeFabricOrganizationSpecs
type DescribeFabricOrganizationSpecsRequest struct {
	*requests.RpcRequest
}

// DescribeFabricOrganizationSpecsResponse is the response struct for api DescribeFabricOrganizationSpecs
type DescribeFabricOrganizationSpecsResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Success   bool          `json:"Success" xml:"Success"`
	ErrorCode int           `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ClusterSpec `json:"Result" xml:"Result"`
}

// CreateDescribeFabricOrganizationSpecsRequest creates a request to invoke DescribeFabricOrganizationSpecs API
func CreateDescribeFabricOrganizationSpecsRequest() (request *DescribeFabricOrganizationSpecsRequest) {
	request = &DescribeFabricOrganizationSpecsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricOrganizationSpecs", "baas", "openAPI")
	return
}

// CreateDescribeFabricOrganizationSpecsResponse creates a response to parse from DescribeFabricOrganizationSpecs response
func CreateDescribeFabricOrganizationSpecsResponse() (response *DescribeFabricOrganizationSpecsResponse) {
	response = &DescribeFabricOrganizationSpecsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
