package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCustomerNumbers invokes the cloudcallcenter.ListCustomerNumbers API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listcustomernumbers.html
func (client *Client) ListCustomerNumbers(request *ListCustomerNumbersRequest) (response *ListCustomerNumbersResponse, err error) {
	response = CreateListCustomerNumbersResponse()
	err = client.DoAction(request, response)
	return
}

// ListCustomerNumbersWithChan invokes the cloudcallcenter.ListCustomerNumbers API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listcustomernumbers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListCustomerNumbersWithChan(request *ListCustomerNumbersRequest) (<-chan *ListCustomerNumbersResponse, <-chan error) {
	responseChan := make(chan *ListCustomerNumbersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCustomerNumbers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCustomerNumbersWithCallback invokes the cloudcallcenter.ListCustomerNumbers API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listcustomernumbers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListCustomerNumbersWithCallback(request *ListCustomerNumbersRequest, callback func(response *ListCustomerNumbersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCustomerNumbersResponse
		var err error
		defer close(result)
		response, err = client.ListCustomerNumbers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCustomerNumbersRequest is the request struct for api ListCustomerNumbers
type ListCustomerNumbersRequest struct {
	*requests.RpcRequest
	Provider string `position:"Query" name:"Provider"`
}

// ListCustomerNumbersResponse is the response struct for api ListCustomerNumbers
type ListCustomerNumbersResponse struct {
	*responses.BaseResponse
	RequestId      string                            `json:"RequestId" xml:"RequestId"`
	Success        bool                              `json:"Success" xml:"Success"`
	Code           string                            `json:"Code" xml:"Code"`
	Message        string                            `json:"Message" xml:"Message"`
	HttpStatusCode int                               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	PhoneNumbers   PhoneNumbersInListCustomerNumbers `json:"PhoneNumbers" xml:"PhoneNumbers"`
}

// CreateListCustomerNumbersRequest creates a request to invoke ListCustomerNumbers API
func CreateListCustomerNumbersRequest() (request *ListCustomerNumbersRequest) {
	request = &ListCustomerNumbersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListCustomerNumbers", "", "")
	request.Method = requests.POST
	return
}

// CreateListCustomerNumbersResponse creates a response to parse from ListCustomerNumbers response
func CreateListCustomerNumbersResponse() (response *ListCustomerNumbersResponse) {
	response = &ListCustomerNumbersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
